<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 8/26/14
 * Time: 4:59 PM
 */
$directorioPHPExcel = realpath(ZIKULA_PATH . DIRECTORY_SEPARATOR ."includes". DIRECTORY_SEPARATOR . "classes" . DIRECTORY_SEPARATOR . "PHPExcel");
require_once($directorioPHPExcel . DIRECTORY_SEPARATOR . "PHPExcel.php");
require_once($directorioPHPExcel .  DIRECTORY_SEPARATOR . "PHPExcel" .DIRECTORY_SEPARATOR . "Writer".DIRECTORY_SEPARATOR."Excel2007.php");
class Filehandler {
    public static $ARBOLES = "arbol";
    public static $CAPA_ESTAB_NIVEL_1_GENERAL = "establecimientos";
    public static $CAPA_ESTAB_NIVEL_1_ACTIVIDADPRINCIPAL = "establecimientos_actividad_principal";
    public static $CAPA_ESTAB_NIVEL_1_ACTIVIDADSECUNDARIA = "establecimientos_actividad_secundaria";
    public static $CAPA_ESTAB_NIVEL_1_RIESGO = "establecimientos_riesgo";
    public static $CAPA_ESTAB_NIVEL_2 = "establecimientos_produccion";
    public static $CAPA_ESTAB_NIVEL_3 = "establecimientos_categorizacion_produccion";
    public static $CAPA_ESTAB_NIVEL_4 = "establecimientos_bovinos_categorizados";
    public static $NIVEL1_VAL = 0;
    public static $NIVEL1P2_VAL = 11;
    public static $NIVEL2_VAL = 1;
    public static $NIVEL3_VAL = 2;
    public static $NIVEL4_VAL = 2;
    public static $BLOQUE_DETALLEPOBLACION = 'Det. Población';
    public static $BLOQUE_TOTALPOBLACION = 'Tot. Población';
    public static $BLOQUE_ESTABLECIMIENTO = 'Establecimiento';
    public static $BLOQUE_ESTABLECIMIENTOS_RESULTADOS = 'Establecimientos Resultados';
    public static $BLOQUE_PERSONAS = 'Personas';

    public $rutaarchivos ;
    public $rutaarchivosexcel ;
    public $archivoexcel  ;
    private $columna = 'A';
    private $fila = 2;
    private $hoja = 0;
    private $objPHPExcel = null;
    public function __construct(){
        $this->database =UtilsMap::getDBConnection();
        $this->rutaarchivos = realpath(ZIKULA_PATH . "/../archivos/");
        $this->rutaarchivosexcel = realpath(ZIKULA_PATH . "/../archivos/excel/");
    }

    public function generarExcelSenasa($codigo){
        $rutaarchivos = $this->rutaarchivos;
        $rutaarchivosexcel = $this->rutaarchivosexcel;
        $rawname = session_id() . time();
        $filebasename = $r = hash("md5", $rawname, false);
        $this->archivoexcel  = $filebasename;

        $fullfileexcel = $rutaarchivosexcel . DIRECTORY_SEPARATOR . $filebasename;

        $fullfilejson = $rutaarchivos . DIRECTORY_SEPARATOR . $codigo;
        $informacion = file_get_contents($fullfilejson);
        $data = json_decode($informacion, true);

        $archivofinal = $this->generarArchivoExcel(
            $data['tipo']
            , $data['establecimientos_lista']
            , $data['capaactual']
            , $data['rubroscount']
            ,$fullfileexcel
        );
        return $archivofinal;
    }
    public function obtenerArchivoExcelFisico($archivoexcel, $Titulo){
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setCreator("Addax Software");
        $objPHPExcel->getProperties()->setLastModifiedBy("Addax Software");
        $objPHPExcel->getProperties()->setTitle($Titulo);
        $objPHPExcel->getProperties()->setSubject($Titulo);
        $objPHPExcel->getProperties()->setDescription($Titulo);

        $objPHPExcel->setActiveSheetIndex($this->hoja);
        $this->objPHPExcel = $objPHPExcel;
        return $objPHPExcel;
    }
    public function generarArchivoExcel($tipo, $resultado, $capaactual, $rubroscount, $archivoexcel){
        $archivonombre =ucwords(  str_replace("_", ' ', $capaactual) );
        $objPHPExcel = $this->obtenerArchivoExcelFisico($archivoexcel, $archivonombre);

        $hojaactual = 0;

        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:
                //hoja de resultados normales, luego de categorizacion.
                $objPHPExcel->getActiveSheet()->setTitle("Resultados");

                foreach($resultado as $idestablecimiento => $seccionesestablecimiento){
                    $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio = 0,$objPHPExcel);

                    //break;
                }
                break;


            case EstablecimientosManager::$CONSULTA_FOCAL:
                foreach($resultado as $radio => $establecimientos){
                    ++$this->hoja;
                    $this->objPHPExcel->createSheet($this->hoja);
                    $this->objPHPExcel->setActiveSheetIndex($this->hoja);
                    $this->fila = 2;
                    $this->columna= 'A';
                    $objPHPExcel->getActiveSheet()->setTitle("Res. $radio Kms");
                    //cara radio es una hoja. Luego resultados de categorización.
                    foreach($establecimientos as $idestablecimiento => $seccionesestablecimiento){
                        $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio,$objPHPExcel );
                    }
                }
                break;
        }

        //print_r($rubroscount); die;
        $this->getCantidadesCategoria($tipo, $rubroscount);

        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $archivoexcel_final = $archivoexcel . '.xlsx';
        $objWriter->save($archivoexcel_final);
        //echo "Saving... [$archivoexcel] [$archivoexcel_final]"; die;
        return $archivoexcel_final;
    }

    public function establecimientoDespliegueSirea($datosestablecimiento, $idestab, $radio = 0, $objPHPExcel){
        try{


        //if($idestab == 25){ print_r($datosestablecimiento); die; }
        $objPHPExcel = $this->objPHPExcel;
        $totales = false; if($idestab == 0) $totales = true;
        //++$this->fila;++$this->fila;
        $codigoestablecimiento = @$datosestablecimiento['Establecimiento'][0]['codigo'];
        //++$this->fila;
        //$objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $codigoestablecimiento);

        ++$this->fila;
        $this->columna = 'A';

        foreach($datosestablecimiento as $bloque => $datosbloque){

            if(count($datosbloque) > 0){

                if(is_array( $datosbloque[0]) ){

                    if($bloque == self::$BLOQUE_ESTABLECIMIENTO){
                        //$array,$bloqueespecial = false, $omitirhead = false, $columnas = 2, $bloquetotales = false
                        $this->arrayToTable($datosbloque[0], $bloque == self::$BLOQUE_DETALLEPOBLACION , $omitirhead = false, $columnas = 2, $totales, $bloque);
                        ++$this->columna;
                    }else if($bloque == self::$BLOQUE_TOTALPOBLACION){
                        $htmltabla = '';
                        foreach($datosbloque as $datobloque_actual){
                            $htmltabla .= $this->arrayToTable($datobloque_actual, $bloque == self::$BLOQUE_DETALLEPOBLACION , $omitirhead = true, $columnas = 2, $bloquetotales = false, $bloqueactual = $bloque);

                        }
                        ++$this->columna;
                    }else{
                        $htmltabla = '';
                        foreach($datosbloque as $datobloque_actual){
                            $titulo = $datobloque_actual[0]['actividad'];
                            $htmltabla .= "<h4>$titulo</h4>";
                            $htmltabla .= $this->arrayToTable($datobloque_actual, $bloque == self::$BLOQUE_DETALLEPOBLACION , $omitirhead = false, $columnas = 2, $bloquetotales = false, $bloqueactual = $bloque);

                        }
                        ++$this->columna;
                    }

                }
            }


        }


        //echo $html; die;
        return '';

        }catch (Exception $ee){
            echo "ERROR [$ee]";
            echo '';
        }
    }
    public function arrayToTable($array,$bloqueespecial = false, $omitirhead = false, $columnas = 2, $bloquetotales = false, $bloqueactual = false){

        $omitir = Definiciones::$omitir;
        $retorno = '';
        if(!$omitirhead)
            $retorno = '<table width="100%"  >';

        $max_colunas = $columnas; // numero de colunas
        $j = 0;
        $contador = 0;
        if($bloquetotales){
            $omitir = array_merge($omitir, Definiciones::$omitirtotales);
        }
        foreach($array as $colname => $elemdata){
            if(in_array($colname, $omitir)) continue;

            //for ($i = 0, $j = 0; isset($array[$i]); $i++) {
            $tipo = 'odd';
            if($contador %2 == 0) $tipo = 'even';

            $valor = $elemdata;
            if($bloqueespecial){
                $colname = $elemdata['variable'];
                $valor = $elemdata['variable_valor'];
            }
            $this->readableBasicoTitulos($colname);
            //$retorno .= "    <td class='titulo'>$colname</td>";
            //$retorno .= "    <td>$valor</td>";
            //echo ( $this->columna.''.$this->fila . "<br />");

            if($bloqueactual== self::$BLOQUE_ESTABLECIMIENTO){
                $filauno = 1;
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$filauno, $colname);
                //++$this->columna;
            }else if($bloqueactual== self::$BLOQUE_ESTABLECIMIENTOS_RESULTADOS){
                $filauno = 1;
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$filauno, $colname);
            }else if($bloqueactual== self::$BLOQUE_PERSONAS){
                if( $colname == 'Hay'){
                    continue;
                }
                $tipopuesto = $array['tipo_puesto'];
                $filauno = 1;

                if($tipopuesto == 'Otro responsable'){
                    //Solo poner el header y el valor. El resto no se ocupa.
                    $hay = $array['hay'];
                    if($hay > 0){
                        $valor = "Si hay";
                    }else{
                        $valor = 'No hay';
                    }
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$filauno, $tipopuesto);
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $valor);
                    ++$this->columna;
                    return true;
                }else{
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$filauno, $tipopuesto . '-'.$colname);
                }


                if($colname == 'Tipo puesto')
                    continue;//Esta ya se puso en todos.


            }else if($bloqueactual== self::$BLOQUE_TOTALPOBLACION){
                //No agregar el nombre de columna. Esta implicito.
            }else{
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $colname);
                ++$this->columna;
            }


            //echo ( $this->columna.''.$this->fila . "<br />");
            $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $valor);
            ++$this->columna;
            //echo ( $this->columna.''.$this->fila . "<br />");

            //die;
            /*if (++$j >= $max_colunas) {
                ++$this->fila;
                $this->columna = 'A';
                $j = 0;
            }*/
            $contador++;
        }

        if ($j) {
            //todo en una sola fila.
            //$this->columna = 'A';
        }


        if($bloquetotales){
            $retorno .= $this->generarBloqueTotalesHtml($array);
        }
        return $retorno;
    }
    private function generarBloqueTotalesHtml($infoestablecimiento){
        $html = '';
        $establecimientos_tot_poblacion = @$infoestablecimiento[ EstablecimientosManager::$ESTABLECIMIENTOS_TOT_POBLACION];
        $establecimientos_det_poblacion = @$infoestablecimiento[ EstablecimientosManager::$ESTABLECIMIENTOS_DET_POBLACION];

        ++$this->fila;

        if(isset($establecimientos_tot_poblacion)){
            if(count($establecimientos_tot_poblacion)>0){
                $hilera = "Cantidad de establecimientos por Actividades Producción Primaria";
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                ++$this->fila;
                $hilera = "Incluye actividad principal y complementaria";
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                ++$this->fila;++$this->fila;

                $contador = 0;
                foreach($establecimientos_tot_poblacion as $tot_poblacion_actual=>$cantidad_establecimientos){
                    $hilera = 'Categoria';
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    ++$this->columna;
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $tot_poblacion_actual);
                    ++$this->columna;

                    $hilera = '# Establecimientos';
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    ++$this->columna;
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $cantidad_establecimientos);
                    ++$this->columna;

                    ++$this->fila;
                    $this->columna = 'A';

                }

            }
        }

        if(isset($establecimientos_det_poblacion)){
            if( count($establecimientos_det_poblacion) > 0){

                $hilera = "Cantidad de establecimientos por Detalle Actividades Producción Primaria";
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                ++$this->fila;
                $hilera = "Incluye actividad principal y secundaria";
                $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                ++$this->fila;++$this->fila;

                $contador = 0;
                foreach($establecimientos_det_poblacion as $det_poblacion_actual=>$cantidad_establecimientos){

                    $hilera = 'Categoria';
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    ++$this->columna;
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $tot_poblacion_actual);
                    ++$this->columna;

                    $hilera = '# Establecimientos';
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    ++$this->columna;
                    $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $cantidad_establecimientos);
                    ++$this->columna;

                    ++$this->fila;
                    $this->columna = 'A';
                    ++$contador;
                }
                $html .= "</table>";
            }
        }

        return $html;
    }
    public function readableBasicoTitulos(&$titulo){

        $diccionario = Definiciones::$diccionario;
        if(array_key_exists($titulo, $diccionario)){
            $titulo = $diccionario[$titulo];
        }else{
            $titulo = str_replace("_", " ", $titulo);
            $titulo = ucfirst($titulo);
        }
    }

    public function getCantidadesCategoria($tipo, $rubroscount, $tabbed = false){
        $html = "";
        //echo "TIP [$tipo]";
        //print_r($rubroscount) ; die;
        ++$this->hoja;
        $this->fila = 2;
        $this->columna= 'A';

        $this->objPHPExcel->createSheet($this->hoja);
        $this->objPHPExcel->setActiveSheetIndex($this->hoja);
        //echo $this->hoja; die;
        $this->objPHPExcel->getActiveSheet()->setTitle("Categorización Resultados");


        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:
                //$html_table = $this->arrayToTable($rubroscount, false, false, 3);;
                if($tabbed){
                    //$hilera = " Establecimientos Resultado";
                    //$this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    //++$this->fila;
                    $html_table = $this->arrayToTable($rubroscount, false, false, 3, $bloquetotales = false, $bloqueactual = self::$BLOQUE_ESTABLECIMIENTOS_RESULTADOS);;

                    //++$this->fila;
                    ++$this->columna;
                }else{

                    //$hilera = " Establecimientos Resultado";
                    //$this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                    //++$this->fila;

                    $html_table = $this->arrayToTable($rubroscount, false, false, 3, $bloquetotales = false, $bloqueactual = self::$BLOQUE_ESTABLECIMIENTOS_RESULTADOS);;

                    //++$this->fila;
                    ++$this->columna;
                }


                break;


            case EstablecimientosManager::$CONSULTA_FOCAL:
                foreach($rubroscount as $radio=> $rubroscount_actual){

                    if($tabbed){

                        $this->columna = 'A';
                        $hilera = "Categorización Establecimientos Resultado $radio Km".($radio == 1?'':'s')."";
                        $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                        ++$this->fila;

                        $html_table = $this->arrayToTable($rubroscount_actual, false, false, 3);
                        //++$this->fila;
                        ++$this->fila;

                    }else{
                        $this->columna = 'A';
                        $hilera = "Categorización Establecimientos Resultado $radio Km".($radio == 1?'':'s')."";
                        $this->objPHPExcel->getActiveSheet()->SetCellValue($this->columna.''.$this->fila, $hilera);
                        ++$this->fila;

                        $html_table = $this->arrayToTable($rubroscount_actual, false, false, 3);
                        ++$this->fila;
                        //++$this->columna;
                    }

                    //$this->arrayToTable($rubroscount_actual, false, false, 3);
                }
                break;

        }
        return $html;

    }

}
