<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 8/26/14
 * Time: 4:59 PM
 */

class Popuphandler {
    public static $ARBOLES = "arbol";
    public static $CAPA_ESTAB_NIVEL_1_GENERAL = "establecimientos";
    public static $CAPA_ESTAB_NIVEL_1_ACTIVIDADPRINCIPAL = "establecimientos_actividad_principal";
    public static $CAPA_ESTAB_NIVEL_1_ACTIVIDADSECUNDARIA = "establecimientos_actividad_secundaria";
    public static $CAPA_ESTAB_NIVEL_1_RIESGO = "establecimientos_riesgo";
    public static $CAPA_ESTAB_NIVEL_2 = "establecimientos_produccion";
    public static $CAPA_ESTAB_NIVEL_3 = "establecimientos_categorizacion_produccion";
    public static $CAPA_ESTAB_NIVEL_4 = "establecimientos_bovinos_categorizados";
    public static $NIVEL1_VAL = 0;
    public static $NIVEL1P2_VAL = 11;
    public static $NIVEL2_VAL = 1;
    public static $NIVEL3_VAL = 2;
    public static $NIVEL4_VAL = 2;
    public static $BLOQUE_DETALLEPOBLACION = 'Det. Población';
    public static $BLOQUE_TOTALPOBLACION = 'Tot. Población';
    public static $BLOQUE_ESTABLECIMIENTO = 'Establecimiento';
    public static $BLOQUE_PERSONAS = 'Personas';

    public function handlePopup($tipo){

        $params = @$_REQUEST["params"];

        switch($tipo){
            case $tipo == self::$ARBOLES:
                $this->popupArboles();
                break;
            default:
                if($params){
                    if(array_key_exists('QUERY_LAYERS', $params)){

                        $re = "/(establecimientos.*)$/";
                        $str = $params['QUERY_LAYERS'];

                        if(preg_match($re, $str, $matches) == 0)
                        {
                            $this->popupGenerico();
                        }else{
                            $this->popupSenasa($params);
                        }
                        //print_r($params); die;

                    }else{
                        $this->popupGenerico();
                    }
                }else{
                    $this->popupGenerico();
                    //$params = array('QUERY_LAYERS' => self::$CAPA_ESTAB_NIVEL_1_GENERAL);
                    //$this->popupSenasa($params);
                }


                break;
        }
    }

    public function popupArboles(){
        //hacer consultas o lo que sea.

        //ele
        $ele = @@$_REQUEST["ele"]; UtilsMap::validateAndCleanVar($ele, UtilsMap::$STRING);
        $time = @@$_REQUEST["time"]; UtilsMap::validateAndCleanVar($time, UtilsMap::$STRING);
        $name = @@$_REQUEST["name"]; UtilsMap::validateAndCleanVar($name, UtilsMap::$STRING);
        $FAMILIA = @@$_REQUEST["FAMILIA"]; UtilsMap::validateAndCleanVar($FAMILIA, UtilsMap::$STRING);
        $GENERO = @@$_REQUEST["GENERO"]; UtilsMap::validateAndCleanVar($GENERO, UtilsMap::$STRING);
        $ESPECIE = @@$_REQUEST["ESPECIE"]; UtilsMap::validateAndCleanVar($ESPECIE, UtilsMap::$STRING);
        $NOMBRE_CIE = @@$_REQUEST["NOMBRE_CIE"]; UtilsMap::validateAndCleanVar($NOMBRE_CIE, UtilsMap::$STRING);
        $NUM_ESPECI = @@$_REQUEST["NUM_ESPECI"]; UtilsMap::validateAndCleanVar($NUM_ESPECI, UtilsMap::$STRING);
        $NUM_GIRA = @@$_REQUEST["NUM_GIRA"]; UtilsMap::validateAndCleanVar($NUM_GIRA, UtilsMap::$STRING);
        $OBSERVACIO = @@$_REQUEST["OBSERVACIO"]; UtilsMap::validateAndCleanVar($OBSERVACIO, UtilsMap::$STRING);

        $fenologico = "-";

        $OBSERVACIO = trim($OBSERVACIO);
        $FAMILIA = trim($FAMILIA);
        $GENERO = trim($GENERO);
        $ESPECIE = trim($ESPECIE);
        $NOMBRE_CIE = trim($NOMBRE_CIE);
        if(empty($FAMILIA)) $FAMILIA = "-";
        if(empty($GENERO)) $GENERO = "-";
        if(empty($NOMBRE_CIE)) $NOMBRE_CIE = "-";
        if(empty($ESPECIE)) $ESPECIE = "-";

        if(empty($OBSERVACIO)){
            $OBSERVACIO = "No hay observaciones.";
        }

        $photos = new PhotoHandler();
        $listafotos = $photos->getlistafotos($NUM_ESPECI);
        $cantidadfotos = count($listafotos);
        if($cantidadfotos < 1 || !$listafotos){
            $htmlfotografias = "No hay fotografías";
        }else{
            $htmlinterno = "";
            foreach($listafotos as $key=>$foto){
                $htmlinterno .= <<<EOD
                    <div class='photoactual'>
                        <a href='/backend/backend.php?function=viewarbolphoto&codigo=$NUM_ESPECI&index=$key' target='_blank'>
                            <img src='/backend/backend.php?function=viewarbolphoto&codigo=$NUM_ESPECI&index=$key&thumbnail=1' alt='$NUM_ESPECI indx $key'/>
                        </a>
                    </div>
EOD;

            }

            $htmlfotografias = <<<EOD
                <div class='photosholdermain'>
                    <div class='photostitle'>
                        --Haga clic sobre cada foto para verla en pantalla completa--
                    </div>
                    <div class='photosholder'>
                        $htmlinterno
                    </div>
                </div>
EOD;

        }


        $html = <<<EOD
            <h2>Detalles avistamiento Árbol</h2>
            <div class="tablecont">
                <div class='holderl2'>
                    <p><span class='arbolsubtitle'>Fecha registro: </span>$time</p>
                    <table class="">
                        <tbody>
                            <tr class="even">
                                <td class="titulo">Familia</td>
                                <td>$FAMILIA</td>
                                <td class="titulo">Género</td>
                                <td>$GENERO</td>
                            </tr>
                            <tr class="odd">
                                <td class="titulo">Especie</td>
                                <td>$ESPECIE</td>
                                <td class="titulo">Nombre científico</td>
                                <td>$NOMBRE_CIE</td>
                            </tr>
                            <tr class="odd">
                                <td class="titulo">Dato ele.</td>
                                <td>$ele</td>
                                <td class="titulo">Núm. gira</td>
                                <td>$NUM_GIRA</td>
                            </tr>
                            <tr class="odd">
                                <td class="titulo">Estado fenológico</td>
                                <td>$fenologico</td>
                                <td class="titulo">Código especie</td>
                                <td>$NUM_ESPECI</td>
                            </tr>
                        </tbody>
                    </table>
                    <div class='observaciones'>
                        <fieldset>
                        <legend><span class='arbolsubtitle'>Observaciones:</span></legend>
                        <span>
                            $OBSERVACIO
                        </span>
                        </fieldset>
                    </div>
                     <div class='fotos'>
                        <fieldset>
                        <legend><span class='arbolsubtitle'>Fotografías:</span></legend>
                            $htmlfotografias
                        </fieldset>
                    </div>
                </div>
            </div>
EOD;

        echo $html; die;
    }

    public function popupGenerico(){
        $diccionario = Definiciones::$diccionario;

        //hacer consultas o lo que sea.

        //ele
        $layer = $_GET['layer'];
        $mapaactual = $_GET['mapaactual'];
        UtilsMap::validateAndCleanVar($layer, UtilsMap::$STRING);
        $datos = @@$_POST;
        //print_r($datos); die;
        $counter = 0;
        $rowshtml = "";
        $type = "even";
        $omitir = array(
            'ogr_fid'
            ,'IdContrato'
            ,'IdSolicitudRegistro'
        );
        foreach($datos as $key => $value){
            if(in_array($key, $omitir))
                continue;

            UtilsMap::validateAndCleanVar($value, UtilsMap::$STRING);
            if(is_array($value)){
                $value = implode(',', $value);
                $value = str_replace(',', ', ', $value);
                $value = "<span style='font-size: 10px;'>$value</span>";
            }
            if(is_string($value))
                $value = trim($value);

            $titulo_read = $key;
            if(array_key_exists($key, $diccionario)){
                $titulo_read = $diccionario[$key];
            }
            if(empty($value)) $value = "-";
            if($counter % 2 == 0){
                if($type == "even")
                    $type = "odd";
                else
                    $type = "even";

                $rowshtml .= '<tr class="'.$type.'">';
            }
            $rowshtml .= '<td class="titulo">'.$titulo_read.'</td>';
            $rowshtml .= '<td>'.$value.'</td>';
            if($counter % 2 != 0){
                $rowshtml .= '</tr>';
            }
            $counter++;

        }



        if($layer == "PSA"){
            $layer = $mapaactual;
        }
        $capa_read = $layer;
        if(array_key_exists($layer, $diccionario))
            $capa_read = $diccionario[$layer];
        else{
            $capa_read_partes = explode(':', $capa_read);
            $capa_read = $capa_read_partes[ count($capa_read_partes) - 1 ];
            $capa_read = str_replace('_', ' ',$capa_read);
            $capa_read = ucwords($capa_read);
        }




        $html = <<<EOD
            <h2>$capa_read</h2>
            <div class="tablecont">
                <div class='holderl2'>
                    <p>Datos de la consulta:</p>
                    <table class="">
                        <tbody>
                            $rowshtml
                        </tbody>
                    </table>

                </div>
            </div>
EOD;

        echo $html; die;
    }

    /*
     * $_REQUEST[
     *  id:82699
        codigo:201-127733
     * ]
     * params:
     * Array
        (
             [REQUEST] => GetFeatureInfo
            [EXCEPTIONS] => application/vnd.ogc.se_xml
            [BBOX] => -9854993.343812,846004.492971,-8893721.276232,1269771.377725
            [SERVICE] => WMS
            [INFO_FORMAT] => application/vnd.ogc.gml
            [QUERY_LAYERS] => establecimientos_bovinos_categorizados
            [FEATURE_COUNT] => 50
            [Layers] => establecimientos_bovinos_categorizados
            [WIDTH] => 1572
            [HEIGHT] => 693
            [format] => image/png
            [styles] =>
            [srs] => EPSG:900913
            [VIEWPARAMS] => valuno:6; //aveces no viene.
            [version] => 1.1.1
            [x] => 761
            [y] => 257
        )

     */
    function senasaDatosSecciones($idestablecimiento, $capa, $textual = false){

        $datosPopup = array();
        $establecimientosManager= new EstablecimientosManager();
        $indice = 0;
        if($textual){$indice = 'Establecimiento'; }
        $datosPopup[$indice] =$establecimientosManager->obtenerInfoEstablecimiento($idestablecimiento);
        $indice = self::$NIVEL1P2_VAL;
        if($textual){$indice = 'Personas'; }
        $datosPopup[$indice] =$establecimientosManager->obtenerInfoPersonasEstablecimiento($idestablecimiento);
        //print_r($datosPopup); die;
        switch($capa){
            case self::$CAPA_ESTAB_NIVEL_1_ACTIVIDADPRINCIPAL:
            case self::$CAPA_ESTAB_NIVEL_1_ACTIVIDADSECUNDARIA:
            case self::$CAPA_ESTAB_NIVEL_1_RIESGO:
            case self::$CAPA_ESTAB_NIVEL_1_GENERAL:
                //datos basicos unicamente.
                break;
            case self::$CAPA_ESTAB_NIVEL_2:
                $indice = 1;
                if($textual){$indice = 'Tot. Población'; }
                $datosPopup[$indice] = $establecimientosManager->obtenerInfoTotalesPoblacion($idestablecimiento);
                break;
            case self::$CAPA_ESTAB_NIVEL_3:
                $indice = 1; if($textual){$indice = 'Tot. Población'; }
                $datosPopup[$indice] = $establecimientosManager->obtenerInfoTotalesPoblacion($idestablecimiento);
                $indice2 = 2; if($textual){$indice2 = 'Det. Población'; }

                $datosPopup[$indice2] = array();
                if(is_array($datosPopup[$indice]))
                foreach($datosPopup[$indice] as $key => $infoPoblaciones){
                    $rubro = $infoPoblaciones['rubro_id'];
                    $datosPopup[$indice2][] = $establecimientosManager->obtenerInfoDetallesPoblacion($idestablecimiento, $rubro);
                }
                //print_r($datosPopup); die;

                break;

            case self::$CAPA_ESTAB_NIVEL_4:
                $indice = 1; if($textual){$indice = 'Tot. Población'; }
                $datosPopup[$indice] = $establecimientosManager->obtenerInfoTotalesPoblacion($idestablecimiento);
                $indice = 2; if($textual){$indice = 'Det. Población'; }
                $datosPopup[$indice][] = $establecimientosManager->obtenerInfoDetallesPoblacion($idestablecimiento, $establecimientosManager::$RUBRO_BOVINO_ID);

                break;


        }
        //print_r($datosPopup); die;
        return $datosPopup;
    }
    function datosSeccionToTable($datosseccion, $nivel = 1){

        $diccionario = Definiciones::$diccionario;

        $counter = 0;
        $rowshtml = "";
        $type = "even";
        $omitir = array(
            'id'
        ,'geometria'
        ,'ogr_fid'
        ,'IdContrato'
        ,'IdSolicitudRegistro'
        );
        switch($nivel){
            case self::$NIVEL1P2_VAL:
                foreach($datosseccion as $datobloque_actual){
                    $titulo = $datobloque_actual['tipo_puesto'];
                    $rowshtml .= "<h4>$titulo</h4>";
                    $rowshtml .= $this->arrayToTable($datobloque_actual);
                }
                break;
            case self::$NIVEL2_VAL:
                if(is_array($datosseccion)){
                    $html_subelementos = "";
                    foreach($datosseccion as $key => $value){

                        if($counter % 2 == 0){
                            if($type == "even")
                                $type = "odd";
                            else
                                $type = "even";

                            $html_subelementos .= '<tr class="'.$type.'">';
                        }
                        $html_subelementos .= '<td class="titulo">'.$value['categoria'].'</td>';
                        $html_subelementos .= '<td>'.$value['poblacion'].'</td>';
                        if($counter % 2 != 0){
                            $html_subelementos .= '</tr>';
                        }
                        $counter++;
                    }
                    $rowshtml .= "

                    <table class=''>
                        <tbody>
                            $html_subelementos
                        </tbody>
                    </table>";
                }


                break;
            case self::$NIVEL3_VAL:
            case self::$NIVEL4_VAL:
                //Estos vienen por grupos.
                foreach($datosseccion as $rubroindex => $datosrubro){

                    $titulo_actual = "";
                    if(true){
                        $titulo_actual = $datosrubro[0]['actividad'];
                    }
                    $html_subelementos = "";
                    if(!is_array($datosrubro)) continue;
                    if(!array_key_exists('variable', $datosrubro[0])) continue;
                    foreach($datosrubro as $key => $datorubro_actual ){
                        if($counter % 2 == 0){
                            if($type == "even")
                                $type = "odd";
                            else
                                $type = "even";

                            $html_subelementos .= '<tr class="'.$type.'">';
                        }
                        $html_subelementos .= '<td class="titulo">'.$datorubro_actual['variable'].'</td>';
                        $html_subelementos .= '<td>'.$datorubro_actual['variable_valor'].'</td>';
                        if($counter % 2 != 0){
                            $html_subelementos .= '</tr>';
                        }
                        $counter++;

                    }

                    $rowshtml .= "
                    <p class='rubro_title'>$titulo_actual</p>
                    <table class=''>
                        <tbody>
                            $html_subelementos
                        </tbody>
                    </table>";

                }
                break;
            case self::$NIVEL1_VAL:
                //este es un unico grupo de datos.
                $html_subelementos = "";
                foreach($datosseccion[0] as $key => $value){
                    if(in_array($key, $omitir))
                        continue;

                    UtilsMap::validateAndCleanVar($value, UtilsMap::$STRING);
                    $value = trim($value);
                    $titulo_read = $key;
                    if(array_key_exists($key, $diccionario)){
                        $titulo_read = $diccionario[$key];
                    }
                    if(empty($value)) $value = "-";
                    if($counter % 2 == 0){
                        if($type == "even")
                            $type = "odd";
                        else
                            $type = "even";

                        $html_subelementos .= '<tr class="'.$type.'">';
                    }
                    $html_subelementos .= '<td class="titulo">'.$titulo_read.'</td>';
                    $html_subelementos .= '<td>'.$value.'</td>';
                    if($counter % 2 != 0){
                        $html_subelementos .= '</tr>';
                    }
                    $counter++;

                }

                $rowshtml = "<table class=''>
                        <tbody>
                            $html_subelementos
                        </tbody>
                    </table>";
                break;
        }


        return $rowshtml;


    }
    public function popupSenasa($params){


        $layer = $params['QUERY_LAYERS'];
        $diccionario = Definiciones::$diccionario;

        //hacer consultas o lo que sea.

        //ele
        $id = $_REQUEST['id'];

        UtilsMap::validateAndCleanVar($id, UtilsMap::$INT);

        $datossecciones = $this->senasaDatosSecciones($id, $layer);
        //print_r($datossecciones); die;
        $tabslevels = "";
        $htmlsecciones = "";
        foreach($datossecciones as $tab => $datosseccion_actual){

            $htmlseccion = $this->datosSeccionToTable($datosseccion_actual, $tab);
            $titulotab = '';
            switch($tab){
                case self::$NIVEL1_VAL: $titulotab = 'Establecimiento'; break;
                case self::$NIVEL1P2_VAL: $titulotab = self::$BLOQUE_PERSONAS; break;
                case self::$NIVEL2_VAL: $titulotab = 'Tot. población'; break;
                case self::$NIVEL3_VAL: $titulotab = 'Det. población'; break;
                case self::$NIVEL4_VAL: $titulotab = 'Bovinos Cat.'; break;

            }

            $tabslevels .= '<li><a href="#tabs-'.($tab + 1).'">'.$titulotab.'</a></li>';
            $htmlsecciones .= '<div id="tabs-'.($tab + 1).'">'.$htmlseccion.'</div>';

        }

        //$datos = @@$_POST;
        //print_r($datos); die;



        $capa_read = $layer;
        if(array_key_exists($layer, $diccionario))
            $capa_read = $diccionario[$layer];

        $html = <<<EOD
            <h2>$capa_read</h2>
            <div class="tablecont">
                <div class='holderl2'>
                    <p>Datos de la consulta:</p>
                    <div id="tabspopup">
                        <ul>
                            $tabslevels
                        </ul>
                        $htmlsecciones
                    </div>
                </div>
            </div>
            <script type='text/javascript'>
                $( "#tabspopup" ).tabs();
            </script>
EOD;

        echo $html; die;
    }
    public function getFiltrosSirea($tipo, $resultado){
        $html = "";
        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:
                //Solo combo de codigo establecimientos.
                $htmlcombo = "<select id='filtro-estab-resultados-geografica-senasa' name='filtro-estab-resultados-geografica-senasa' onchange='javascript: filtrarResultadosEstablecimiento();' > ";
                $htmlcombo.= "<option value=''>Todos</option>";
                foreach($resultado as $idestablecimiento => $datosestablecimiento){
                    $codigoestablecimiento = @$datosestablecimiento['Establecimiento'][0]['codigo'];
                    $htmlcombo.= "<option value='$idestablecimiento'>$codigoestablecimiento</option>";
                }
                $htmlcombo.= "</select>";
                $html .= "<label for='filtro-estab-resultados-geografica-senasa'>Código Establecimiento</label>" . $htmlcombo;
                break;

            case EstablecimientosManager::$CONSULTA_FOCAL:


                $htmlcombo = "<select id='filtro-estab-resultados-geografica-senasa' name='filtro-estab-resultados-geografica-senasa' onchange='javascript: filtrarResultadosEstablecimiento();' > ";

                $htmlcombo.= "<option value=''>Todos</option>";
                foreach($resultado as $radio => $establecimientos){
                    $htmlcombo.= "<optgroup label='Radio $radio Kms'>";
                    $htmlcombo.= "<option value='$radio".'_'."0'>Todos en ($radio Kms)</option>";
                    foreach($establecimientos as $idestablecimiento => $datosestablecimiento){
                        $codigoestablecimiento = @$datosestablecimiento['Establecimiento'][0]['codigo'];
                        $htmlcombo.= "<option value='$radio".'_'."$idestablecimiento'>$codigoestablecimiento ($radio Kms)</option>";
                    }
                    $htmlcombo.= "</optgroup>";
                }
                $htmlcombo.= "</select>";

                $html .= "<label for='filtro-estab-resultados-geografica-senasa'>Código Establecimiento</label>" . $htmlcombo;

                break;
        }
        return $html;
    }
    public function getCantidadesCategoria($tipo, $rubroscount, $tabbed = false){
        $html = "";
        //echo "TIP [$tipo]";
        //print_r($rubroscount) ; die;
        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:
                $html_table = $this->arrayToTable($rubroscount, false, false, 3);;
                if($tabbed){
                    $html .= "<h3>Categorización Establecimientos Resultado</h3>";
                    $html .= "<div class='resultados-geografica-categorizacion-cantidad'>". $html_table . "</div>";
                }else{
                    $html .= "<p>Categorización Establecimientos Resultado</p>";
                    $html .= $html_table;
                }


                break;


            case EstablecimientosManager::$CONSULTA_FOCAL:
                foreach($rubroscount as $radio=> $rubroscount_actual){
                    $html_table = $this->arrayToTable($rubroscount_actual, false, false, 3);
                    if($tabbed){
                        $html .= "<h3>Categorización Establecimientos Resultado $radio Km".($radio == 1?'':'s')."</h3>";
                        $html .= '<div  class="resultados-geografica-categorizacion-cantidad">'.$html_table.'</div>';
                    }else{
                        $html .= "<p>Categorización Establecimientos Resultado $radio Km".($radio == 1?'':'s')."</p>";
                        $html .= $html_table;
                    }

                    //$this->arrayToTable($rubroscount_actual, false, false, 3);
                }
                break;

        }
        return $html;

    }
    public function displayConsultaGeograficaSenasaTotales($tipo, $totales, $capaactual, $rubroscount, $archivo_totales_actual){
       // print_r($totales); die;



        $resultado = $totales;//todo: rename.
        //print_r($rubroscount); die;
        $htmlcategoriascantidad = $this->getCantidadesCategoria($tipo, $rubroscount, true);
        //$cantidad = count($resultado);$cantidad--;

        $cantidad = $totales[ EstablecimientosManager::$ID_TOTALES ][ self::$BLOQUE_ESTABLECIMIENTO ][0][EstablecimientosManager::$CANTIDAD_ESTABLECIMIENTOS_TOTAL];

        $htmlfiltros = '';
        $htmlcantidad = '';
        if($tipo != EstablecimientosManager::$CONSULTA_FOCAL){
            $htmlcantidad = "<p>$cantidad resultado".($cantidad>1?"s":'')."</p>";
        }else{
            $cantidadgeneral = 0;
            $htmlcantidad .= "<p>";
            foreach($resultado as $radio => $establecimientos){
                $cantidad = count($establecimientos);$cantidad--;//omitir el establecimiento 0.
                $cantidadgeneral+= $cantidad;
                $htmlcantidad .= "$cantidad resultado".($cantidad!=1?"s":'')." $radio Km".($radio!=1?"s":'')."<br />";
            }
            $htmlcantidad .= "<b>General: $cantidad resultado".$cantidad>1?"s":''."</b></p>";
        }
        /*
         * <div id='resultados-geografica-resumen-cantidad'>$htmlcantidad</div>
            <hr />

         * <div id='resultados-geografica-resumen-cantidad'>$htmlcantidad</div>
         * <div id='resultados-geografica-categorizacion-cantidad'>$htmlcategoriascantidad</div>
         */

        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:

            $htmlestablecimientos = "
    <div id='resultados-consulta' class='ui-tabs ui-widget ui-widget-content ui-corner-all'>
        <ul>
            <li><a href='#tabs-r1'>Resultados Consulta</a></li>
            <li><a href='#tabs-r2'>Categorización resultados</a></li>
            <li><a href='#tabs-r3'>Exportar Resultados</a></li>
        </ul>
        <div class='' id='tabs-r1'>

            <hr />
            <div id='filtros'>
                $htmlfiltros
            </div>

            <p>Resultados</p>
            <div id='resultados-geografica-senasa'>


            ";

                //este maneja un único nivel (no hay radios).
                $stylesforce = $blankhtml = "";

                if($cantidad == 0){
                    $stylesforce = "style='height: 15px !important;'";
                    $blankhtml = "<p style='text-align: center;'>-Sin resultados-</p>";
                }else{


                }

                foreach($resultado as $idestablecimiento => $seccionesestablecimiento){
                    $htmlestablecimientos .= $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio = 0);
                    //break;
                }
                $htmlestablecimientos .= $blankhtml;


            $htmlestablecimientos .="

            </div>
                <div class='botones'>
                    <a href='/zf_Central/Index/verdetalles/codigo/$archivo_totales_actual' target='_blank' >Ver detalles</a>
                </div>
            </div>
        <div class='' id='tabs-r2'>
            <p>Categorización resultados (Actividad)</p>
            <div id='resultados-geografica-categorizacion-cantidad'>$htmlcategoriascantidad</div>
        </div>
        <div class='' id='tabs-r3'>
            <div class='botones'>
                <a href='/zf_Central/Index/descargararchivoexcel/codigo/$archivo_totales_actual' target='_blank' >Descargar archivo excel</a>
            </div>
        </div>

    </div>";
                break;

            case EstablecimientosManager::$CONSULTA_FOCAL:
                $htmltabsindex = "";
                $counter = 10;
                foreach($resultado as $radio => $establecimientos){
                    ++$counter;
                    $htmltabsindex
                        .= "<li><a href='#tabs-r$counter'>Resultados $radio Km</a></li>";
                }
                $htmlestablecimientos = "
    <div id='resultados-consulta' class='ui-tabs ui-widget ui-widget-content ui-corner-all'>

        <ul>
            $htmltabsindex
            <li><a href='#tabs-r2'>Categorización resultados</a></li>
            <li><a href='#tabs-r3'>Exportar Resultados</a></li>
        </ul>



            ";


                //este maneja varios niveles (radios) su numero esta en kilometros.
                $counter = 10;
                foreach($resultado as $radio => $establecimientos){
                    $counter++;
                    $stylesforce = $blankhtml = "";
                    if(count($establecimientos) == 0){
                        $stylesforce = "style='height: 32px !important;'";
                        $blankhtml = "<p style='text-align: center;'>-Sin resultados-</p>";
                    }
                    $htmlestablecimientos
                        .= "

                            <div id='tabs-r$counter' class='radios-holder'>
                                <h3>Radio $radio km</h3>
                                <p>Resultados</p>

                                <div class='resultados-geografica-senasa-radios' $stylesforce>
                    ";
                    foreach($establecimientos as $idestablecimiento => $seccionesestablecimiento){
                        $htmlestablecimientos .= $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio );
                        $htmlestablecimientos .= "
                                    <div class='botones'>
                                        <a href='/zf_Central/Index/verdetalles/codigo/$archivo_totales_actual' target='_blank' >Ver detalles</a>
                                    </div>
                        ";
                    }
                    $htmlestablecimientos
                        .= "            $blankhtml
                                </div>
                            </div>
                        ";


                }
                $htmlestablecimientos .="

                            <div class='' id='tabs-r2'>
                                <p>Categorización resultados (Rubros)</p>
                                <div id='resultados-geografica-categorizacion-cantidad'>$htmlcategoriascantidad</div>
                            </div>
                            <div class='' id='tabs-r3'>
                                <div class='botones'>
                                    <a href='/zf_Central/Index/descargararchivoexcel/codigo/$archivo_totales_actual' target='_blank' >Descargar archivo excel</a>
                                </div>
                            </div>

                        </div>";

                break;

        }

        return $htmlestablecimientos;
    }
    public function displayConsultaGeograficaSenasa($tipo, $resultado, $capaactual, $rubroscount, $archivo_totales_actual){
        //print_r($rubroscount); die;
        $htmlcategoriascantidad = $this->getCantidadesCategoria($tipo, $rubroscount);
        $cantidad = count($resultado);$cantidad--;
        $htmlfiltros = $this->getFiltrosSirea($tipo, $resultado);
        $htmlcantidad = '';
        if($tipo != EstablecimientosManager::$CONSULTA_FOCAL){
            $htmlcantidad = "<p>$cantidad resultado".($cantidad>1?"s":'')."</p>";
        }else{
            $cantidadgeneral = 0;
            $htmlcantidad .= "<p>";
            foreach($resultado as $radio => $establecimientos){
                $cantidad = count($establecimientos);$cantidad--;//omitir el establecimiento 0.
                $cantidadgeneral+= $cantidad;
                $htmlcantidad .= "$cantidad resultado".($cantidad!=1?"s":'')." $radio Km".($radio!=1?"s":'')."<br />";
            }
            $htmlcantidad .= "<b>General: $cantidad resultado".$cantidad>1?"s":''."</b></p>";
        }
        $htmlestablecimientos = "
    <div id='resultados-consulta' class='ui-tabs ui-widget ui-widget-content ui-corner-all'>
        <ul>
            <li><a href='#tabs-r1'>Resultados Consulta</a></li>
            <li><a href='#tabs-r2'>Exportar Resultados</a></li>
        </ul>
        <div class='' id='tabs-r1'>
            <div id='resultados-geografica-resumen-cantidad'>$htmlcantidad</div>
            <div id='resultados-geografica-categorizacion-cantidad'>$htmlcategoriascantidad</div>


            <hr />
            <div id='filtros'>
                $htmlfiltros
            </div>
            <div id='resultados-geografica-senasa'> ";
        switch($tipo){

            case EstablecimientosManager::$CONSULTA_POLIGONO:
            case EstablecimientosManager::$CONSULTA_RECTANGULO:
            case EstablecimientosManager::$CONSULTA_ZONA:
                //este maneja un único nivel (no hay radios).
                $stylesforce = $blankhtml = "";

                if($cantidad == 0){
                    $stylesforce = "style='height: 15px !important;'";
                    $blankhtml = "<p style='text-align: center;'>-Sin resultados-</p>";
                }else{


                }

                foreach($resultado as $idestablecimiento => $seccionesestablecimiento){
                    $htmlestablecimientos .= $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio = 0);
                    //break;
                }
                $htmlestablecimientos .= $blankhtml;
                break;

            case EstablecimientosManager::$CONSULTA_FOCAL:
                //este maneja varios niveles (radios) su numero esta en kilometros.
                foreach($resultado as $radio => $establecimientos){
                    $stylesforce = $blankhtml = "";
                    if(count($establecimientos) == 0){
                        $stylesforce = "style='height: 32px !important;'";
                        $blankhtml = "<p style='text-align: center;'>-Sin resultados-</p>";
                    }
                    $htmlestablecimientos
                    .= "<div id='radios-$radio' class='radios-holder'>
                            <h3>Radio $radio km</h3>
                            <div>
                            <div class='resultados-geografica-senasa-radios' $stylesforce>
                    ";
                    foreach($establecimientos as $idestablecimiento => $seccionesestablecimiento){
                        $htmlestablecimientos .= $this->establecimientoDespliegueSirea($seccionesestablecimiento, $idestablecimiento, $radio );
                    }
                    $htmlestablecimientos
                .= "            $blankhtml
                            </div>
                            </div>
                        </div>";
                }
                break;

        }
        $htmlestablecimientos .="
            </div>
        </div>
        <div class='' id='tabs-r2'>
            <div class='botones'>
                <a href='/zf_Central/Index/descargararchivoexcel/codigo/$archivo_totales_actual' target='_blank' >Descargar archivo excel</a>
            </div>
        </div>
    </div>";
        return $htmlestablecimientos;
    }

    public function establecimientoDespliegueSirea($datosestablecimiento, $idestab, $radio = 0){
        //if($idestab == 25){ print_r($datosestablecimiento); die; }
        $totales = false; if($idestab == 0) $totales = true;
        $codigoestablecimiento = @$datosestablecimiento['Establecimiento'][0]['codigo'];
        $html = "

                <h3 class='estab-holder-header estab-holder-header-$radio estab-holder-header-$radio-$idestab'>$codigoestablecimiento</h3>
                <div class='estab-holder-holder estab-holder-holder-$radio estab-holder-holder-$radio-$idestab'>
        ";

        $html .= "
                    <div class='datosestablecimiento '  id='estab-holder-$radio-$idestab'> ";
        $tabslevels = "";$contador = 1;
        foreach($datosestablecimiento as $bloque => $datosbloque){
            if(count($datosbloque) > 0){
                $tabslevels .= '<li><a href="#tabs-'.$idestab.'-'.($contador).'">'.$bloque.'</a></li>';
            }
            $contador++;
        }
        $html.= "<ul>$tabslevels</ul>";
        $contador = 1;

        foreach($datosestablecimiento as $bloque => $datosbloque){
            if(count($datosbloque) > 0){
                if(is_array( $datosbloque[0]) ){
                    if($bloque == self::$BLOQUE_ESTABLECIMIENTO){
                        //$array,$bloqueespecial = false, $omitirhead = false, $columnas = 2, $bloquetotales = false
                        $htmltabla = $this->arrayToTable($datosbloque[0], $bloque == self::$BLOQUE_DETALLEPOBLACION , $omitirhead = false, $columnas = 2, $totales);
                        $html .= "

                        <div class='ws_PopUpInfoArea ' id='tabs-$idestab-$contador'>
                            $htmltabla
                        </div>";
                    }else if($bloque == self::$BLOQUE_TOTALPOBLACION){
                        $htmltabla = '';
                        foreach($datosbloque as $datobloque_actual){
                            $htmltabla .= $this->arrayToTable($datobloque_actual, $bloque == self::$BLOQUE_DETALLEPOBLACION , $omitirhead = true);

                        }
                        $html .= "

                        <div class='ws_PopUpInfoArea ' id='tabs-$idestab-$contador'>
                            <table width='100%'  >
                            $htmltabla
                            </table>
                        </div>";
                    }else{
                        $htmltabla = '';
                        foreach($datosbloque as $datobloque_actual){
                            $titulo = $datobloque_actual[0]['actividad'];
                            $htmltabla .= "<h4>$titulo</h4>";
                            $besp = false;
                            if($bloque == self::$BLOQUE_DETALLEPOBLACION || substr($bloque, 0, strlen("Det")) === "Det"){
                                $besp = true;
                            }
                            //echo "[$bloque] [$besp]";
                            //print_r($datobloque_actual);
                            //die;
                            $htmltabla .= $this->arrayToTable($datobloque_actual, $besp , $omitirhead = false);

                        }
                        $html .= "

                        <div class='ws_PopUpInfoArea ' id='tabs-$idestab-$contador'>
                            $htmltabla
                        </div>";
                    }

                }
            }
            $contador++;

        }

        $html .= "
                    </div>
                 </div>

        ";
        //echo $html; die;
        return $html;
    }
    public function arrayToTable($array,$bloqueespecial = false, $omitirhead = false, $columnas = 2, $bloquetotales = false){
        $omitir = Definiciones::$omitir;

        $retorno = '';
        if(!$omitirhead)
        $retorno = '<table width="100%"  >';

        $max_colunas = $columnas; // numero de colunas
        $j = 0;
        $contador = 0;
        if($bloquetotales){
            $omitir = array_merge($omitir, Definiciones::$omitirtotales);
        }

        foreach($array as $colname => $elemdata){
            if(!$bloqueespecial)
            if(in_array($colname, $omitir)) continue;

        //for ($i = 0, $j = 0; isset($array[$i]); $i++) {
            $tipo = 'odd';
            if($contador %2 == 0) $tipo = 'even';
            if ($j == 0) $retorno .= "  <tr  class='".$tipo."'>";
            $valor = $elemdata;
            if($bloqueespecial){
                //echo " besp ";
                $colname = $elemdata['variable'];
                $valor = $elemdata['variable_valor'];
            }
            $this->readableBasicoTitulos($colname);
            $retorno .= "    <td class='titulo'>$colname</td>";
            $retorno .= "    <td>$valor</td>";
            if (++$j >= $max_colunas) {
                $retorno .="  </tr>";
                $j = 0;
            }
            $contador++;
        }

        if ($j) {
            while ($j++ < $max_colunas) {
                $retorno .= "    <td></td>";
            }
            $retorno .= "  </tr>";
        }
        if(!$omitirhead)
        $retorno .= "</table>";

        if($bloquetotales){
            $retorno .= $this->generarBloqueTotalesHtml($array);
        }
        return $retorno;
    }
    private function generarBloqueTotalesHtml($infoestablecimiento){
        $html = '';
        $establecimientos_tot_poblacion = @$infoestablecimiento[ EstablecimientosManager::$ESTABLECIMIENTOS_TOT_POBLACION];
        $establecimientos_det_poblacion = @$infoestablecimiento[ EstablecimientosManager::$ESTABLECIMIENTOS_DET_POBLACION];
        if(isset($establecimientos_tot_poblacion)){
        if(count($establecimientos_tot_poblacion)>0){

            $html .= "
                <h3>Cantidad de establecimientos por Actividades Producción Primaria</h3>
                <p class='texto-extrainfo'>Incluye actividad principal y complementaria</p>
                    <table>";
            $contador = 0;
            foreach($establecimientos_tot_poblacion as $tot_poblacion_actual=>$cantidad_establecimientos){
                $tipo = 'odd';
                if($contador %2 == 0) $tipo = 'even';
                $html .= "  <tr  class='".$tipo."'>";
                $html .= "    <td class='titulo'>Categoria</td>";
                $html .= "    <td>$tot_poblacion_actual</td>";
                $html .= "    <td class='titulo'># Establecimientos</td>";
                $html .= "    <td>$cantidad_establecimientos</td>";
                $html .= "  </tr>";
                ++$contador;
            }
            $html .= "</table>";
        }
        }

        if(isset($establecimientos_det_poblacion)){
        if( count($establecimientos_det_poblacion) > 0){
            $html .= "
                <h3>Cantidad de establecimientos por Subactividades Producción Primaria</h3>
                <p class='texto-extrainfo'>Incluye actividad principal y secundaria</p>
                    <table>";
            $contador = 0;
            foreach($establecimientos_det_poblacion as $det_poblacion_actual=>$cantidad_establecimientos){
                $tipo = 'odd';
                if($contador %2 == 0) $tipo = 'even';
                $html .= "  <tr  class='".$tipo."'>";
                $html .= "    <td class='titulo'>Categoria</td>";
                $html .= "    <td>$det_poblacion_actual</td>";
                $html .= "    <td class='titulo'># Establecimientos</td>";
                $html .= "    <td>$cantidad_establecimientos</td>";
                $html .= "  </tr>";
                ++$contador;
            }
            $html .= "</table>";
        }
        }

        return $html;
    }
    public function readableBasicoTitulos(&$titulo){

        $diccionario = Definiciones::$diccionario;
        if(array_key_exists($titulo, $diccionario)){
            $titulo = $diccionario[$titulo];
        }else{
            $titulo = str_replace("_", " ", $titulo);
            $titulo = ucfirst($titulo);
        }
    }
}
