<?php
/**
 * @source
 * @author Addax Software
 * @package VisorMedicionesCalidad
 */


/**
 * Utils Clase de utiler?as comunes.
 *
 * @source
 * @author Addax Software
 */
class UtilsMap {


    /**
     * Escribe en el archivo de infofile, el mensaje con un resultado recibido.
     *
     * @param string $result Valor de resultado (SUCCESS|SUCCESSWITHERRORS|ERROR)
     * @param string $message Mensaje detalles
     * @param string $fullfilename Archivo a escribir
     * @return void
     */
    public static function escribirInfoFile($result, $message, $fullfilename){
        $infofiledata['result'] = $result;
        $infofiledata['message'] = $message;
        $nombresueltoext = basename($fullfilename);

        //Escribir arhcivo de info.
        $archivotxt = json_encode($infofiledata);
        $archivotxt = mb_convert_encoding($archivotxt, 'UTF-8', "auto");
        $withoutExt = preg_replace("/\\.[^.\\s]{3,4}$/", "", $nombresueltoext);
        echo ("ESCRIBIENDO ARCHIVO:: ". PATH_FINALIZED_INFO_FILES . $withoutExt . INFOFILEEXTENSION . ":: [$archivotxt]\n\n" );
        file_put_contents ( PATH_FINALIZED_INFO_FILES . $withoutExt . INFOFILEEXTENSION, $archivotxt);
    }

    /**
     * Retorna el tiempo en milisegundos.
     *
     * @return string
     */
    public static function getMicroTime(){
        $mtime = microtime();
        $mtime = explode(" ",$mtime);
        $mtime = $mtime[1] + $mtime[0];
        return $mtime;
    }

    /**
     * Retorna un objeto cbSQLConnect de conexi?n a la base de datos.
     *
     * @uses cbSQLConnect
     * @return cbSQLConnect cbSQLConnect  Objeto cbSQLConnect de conexi?n
     */
    public static function getDBConnection(cbSQLConnect $database = null){
        if(!defined (BDTOUSE)){
            if(!defined('BDTOUSE') )define('BDTOUSE', "MYSQL");
        }

        $database = null;
        switch(BDTOUSE){
            case MYSQL:

                $databaseSetup = new cbSQLConnectConfig( cbSQLConnectVar::DB_MYSQL, DB_SERVER, DB_PORT, DB_DATABASE, DB_USERNAME,DB_PASSWORD, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8'"));  // Setup Class
                $database = new cbSQLConnect($databaseSetup, cbSQLConnectVar::FETCH_ASSOC);

                break;
            case MSSQL:

                $databaseSetup = new cbSQLConnectConfig( cbSQLConnectVar::DB_MSSQL, DB_SERVER, DB_PORT, DB_DATABASE, DB_USERNAME,DB_PASSWORD, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES 'utf8'"));  // Setup Class
                $database = new cbSQLConnect($databaseSetup, cbSQLConnectVar::FETCH_ASSOC);
                break;
        }

        return $database;
    }
    public static $INT = "int";
    public static $STRING = "string";
    public static $DATE = "date";
    public static $DATETIME = "datetime";
    public static $FLOAT = "float";

    public static function validateAndCleanVar(&$variable, $tipo = "int"){

        switch($tipo){
            case self::$INT:
                filter_var($variable, FILTER_SANITIZE_NUMBER_INT);
                break;
            case self::$STRING:
                filter_var($variable, FILTER_SANITIZE_STRING);
                break;
            case self::$FLOAT:
                filter_var($variable, FILTER_SANITIZE_NUMBER_FLOAT);
                break;
            case self::$DATE:
            case self::$DATETIME:
                if (($timestamp = strtotime($variable)) === false) {
                    $variable = false;
                }
                break;
        }
    }
    public static function handleLogin(){
        //si no esta logueado, lo envia hacia /login.php. Si ya esta logueado devuelve true.

    }

} 