/* Copyright (c) 2006-2011 by OpenLayers Contributors (see authors.txt for 
 * full list of contributors). Published under the Clear BSD license.  
 * See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * Class: OpenLayers.Control.SelectLocation
 * The SelectLocation control handles map browsing with mouse events (dragging,
 *     double-clicking, and scrolling the wheel).  Create a new SelectLocation 
 *     control with the <OpenLayers.Control.SelectLocation> control.  
 * 
 *     Note that this control is added to the map by default (if no controls 
 *     array is sent in the options object to the <OpenLayers.Map> 
 *     constructor).
 * 
 * Inherits:
 *  - <OpenLayers.Control>
 */
OpenLayers.Control.SelectLocation = OpenLayers.Class(OpenLayers.Control, {

	layer: null,
	url: null,
	popup: null,
	w: 200,
	h: 300,
	popupClassDefault: OpenLayers.Popup.Selected,
	popupClass: null,
    /**
     * Constructor: OpenLayers.Control.SelectLocation
     * Create a new SelectLocation control
     * 
     * Parameters:
     * options - {Object} An optional object whose properties will be set on
     *                    the control
     */
    initialize: function(options)
    {
		if(typeof (options) != "undefined")
		{
			if(typeof(options["layer"]) != "undefined")
			{
				this.layer = options["layer"];
			}
			if(typeof(options["url"]) != "undefined")
			{
				this.url = options["url"];
			}
			if(typeof(options["size"]) != "undefined")
			{
				this.w = options["w"];
				this.h = options["h"];
			}
		}
        this.handlers = {};
        OpenLayers.Control.prototype.initialize.apply(this, arguments);
    },

    /**
     * Method: destroy
     * The destroy method is used to perform any clean up before the control
     * is dereferenced.  Typically this is where event listeners are removed
     * to prevent memory leaks.
     */
    destroy: function() {
        this.deactivate();
        OpenLayers.Control.prototype.destroy.apply(this,arguments);
    },
    
    /**
     * Method: activate
     */
    activate: function() {
        this.handlers.click.activate();
        return OpenLayers.Control.prototype.activate.apply(this,arguments);
    },

    /**
     * Method: deactivate
     */
    deactivate: function() {
        this.handlers.click.deactivate();
        /*if(this.popup != null)
        {
            try
            {
	            this.map.removePopup(this.popup);
	            this.popup.destroy();
	            this.popup = null;
            }
            catch(e){}
        }*/
        return OpenLayers.Control.prototype.deactivate.apply(this,arguments);
    },
    
    /**
     * Method: draw
     */
    draw: function() {
        // disable right mouse context menu for support of right click events

        var clickCallbacks = { 
            'click': this.defaultClick,
            'dblclick': this.defaultClick, 
            'dblrightclick': this.defaultClick 
        };
        var clickOptions = {
            'single': true, 
            'stopSingle': true
        };
        this.handlers.click = new OpenLayers.Handler.Click(
            this, clickCallbacks, clickOptions
        );
    },

    /**
     * Method: defaultClick
     *
     * Parameters:
     * e - {Event}
     */
    defaultClick: function (e)
    {
    	if(this.popup != null)
    	{
            try
            {
	            this.map.removePopup(this.popup);
	            this.popup.destroy();
	            this.popup = null;
            }
            catch(errrrr){}
    	}
    	var latlon = this.map.getLonLatFromPixel(e.xy);
    	if(typeof(jQuery) == "undefined" || typeof(this.layer) == "undefined" || this.layer == null || typeof(this.url) == "undefined" || this.url == null)
    	{
    		return;
    	}
    	var options = { "layer": this.layer, "lat": latlon.lat, "lon": latlon.lon, "scale": this.map.scales[this.map.zoom] };
    	
    	if(this.popupClass == null)
    	{
    		this.popupClass = this.popupClassDefault;
    	}
    	
		this.popup = new this.popupClass("selectable_popup"
			, latlon
			, new OpenLayers.Size(100, 70)
			, "<img src=\"/library/openlayer/img/wating.gif\" width=\"50\" />"
			, true);
		this.map.addPopup(this.popup);
		this.popup.maxSize = new OpenLayers.Size(this.w, this.h);
    	
    	var selectlocation = this;
    	var popup = this.popup;
    	$.post(this.url, options
			, function(data)
			{
				if(popup != selectlocation.popup)
				{
					return;
				}
    			try
    			{
					if(data.result == "0")
					{
						popup.setContent(data.values);
					}
					else
					{
						popup.setContentHTML("<p class='nothingFound'> Ubicación no encontrada</p>");
						popup.updateSize();
					}
    			}
    			catch(e){}
			}
			, "json")
    		.error(function()
    		{
				if(popup != selectlocation.popup)
				{
					return;
				}
    			try
    			{
					popup.setContentHTML("<p class='nothingFound'> Ha ocurrido un error con la respuesta del servidor</p>");
					popup.updateSize();
    			}
    			catch(e){}
    		});
    },
    
    
    

    CLASS_NAME: "OpenLayers.Control.SelectLocation"
});
