/* Copyright (c) 2006-2011 by OpenLayers Contributors (see authors.txt for 
 * full list of contributors). Published under the Clear BSD license.  
 * See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * @requires OpenLayers/BaseTypes/Class.js
 */


/**
 * Class: OpenLayers.Popup.Selected
 * A popup is a small div that can opened and closed on the map.
 * Typically opened in response to clicking on a marker.  
 * See <OpenLayers.Marker>.  Popup's don't require their own
 * layer and are added the the map using the <OpenLayers.Map.addPopup>
 * method.
 *
 * Example:
 * (code)
 * popup = new OpenLayers.Popup.Selected("chicken", 
 *                    new OpenLayers.LonLat(5,40),
 *                    new OpenLayers.Size(200,200),
 *                    "example popup",
 *                    true);
 *       
 * map.addPopup(popup);
 * (end)
 */
var overridecapa = null;
OpenLayers.Popup.Selected.Bosques = OpenLayers.Class(OpenLayers.Popup.Selected, {
	

    /** 
    * Constructor: OpenLayers.Popup
    * Create a popup.
    * 
    * Parameters: 
    * id - {String} a unqiue identifier for this popup.  If null is passed
    *               an identifier will be automatically generated. 
    * lonlat - {<OpenLayers.LonLat>}  The position on the map the popup will
    *                                 be shown.
    * contentSize - {<OpenLayers.Size>} The size of the content.
    * contentHTML - {String}          An HTML string to display inside the   
    *                                 popup.
    * closeBox - {Boolean}            Whether to display a close box inside
    *                                 the popup.
    * closeBoxCallback - {Function}   Function to be called on closeBox click.
    */
    initialize:function(id, lonlat, minSize, contentHTML, closeBox)
    {
        OpenLayers.Popup.Selected.prototype.initialize.apply(this, arguments);
    },

	setContent: function(data, params)
	{

        var currlayeract = $('.capaconsulta:checked').val()
        if(overridecapa)
            currlayeract = overridecapa;
        overridecapa = null;
        //console.log("BOSQUES!!!");
        //console.log(data);
        //return true;
        var html = "";
        var id = OpenLayers.Util.createUniqueID("Content_BOSQUES_");
        var hassomething = false;
        $.each( data, function( key, value ) {
            hassomething = true;
        });
        //if(data != 'undefined' && data && data != "" ){
        if(hassomething ){
            //todo: obtener informacion adicional. Consulta sql!
            mapActual = mapasActuales[0];
            var url = "/backend/backend.php?function=getpopup&tipo=senasa&layer="+currlayeract+"&mapaactual="+mapActual;
            var objeto = this;
            data.params = (params);
            $.post(url, data, function(resultado){
                //var html = "<div class='ws_PopUpInfoArea onlytd' id=\""+id+"\" style=\"width: 390px; border-collapse: collapse; border-width: 0px;\">";
                var html = "<div class='ws_PopUpInfoArea onlytd' id=\""+id+"\" style=\"width: 100%; border-collapse: collapse; border-width: 0px;\">";
                html += resultado;
                html += "</div>";

                //MOSTRAR CONTENIDO.
                /*OpenLayers.Popup.prototype.setContentHTML.apply(objeto, [html]);
                var height = Math.min(400, $("#"+id).height()+20);
                objeto.size = new OpenLayers.Size(352, height);
                objeto.minSize = new OpenLayers.Size(352, height);
                objeto.updateSize();
                if(data.params){
                    $( ".ws_PopUpInfoArea #tabspopup" ).tabs();
                }*/

                $( ".dialog3_body" ).html(html);
                //$( ".dialog3_body" ).dialog( "height", "disabled" );
                $( "#dialog3" ).dialog( "open" );
                if(data.params){
                    $( "div#dialog3 .ws_PopUpInfoArea #tabspopup" ).tabs();
                }

            })

            return true;
            this.minSize = new OpenLayers.Size(100, 300);

            html =

                    "<div class='ws_PopUpInfoArea onlytd' id=\""+id+"\" style=\"width: 390px; border-collapse: collapse; border-width: 0px;\">";
            html += "	<h2>Detalles avistamiento Árbol</h2>";

            html += "	<div class='tablecont'><center>"
                +"<p class='stampreg'></p>"
                +"<table class=\"\">";

            var counter = 0;
            var type = "even";
            $.each( data, function( key, value ) {
                alert( key + ": " + value );
                if(counter % 2 == 0){
                    type = "odd";
                    html += "		<tr class='"+type+"' >";
                }
                var traduccion = globals["diccionary"][key];
                if(!traduccion) traduccion = key;
                html += "			<td class='titulo' >"+traduccion+"</td>";
                html += "			<td>"+value+"</td>";
                if(counter % 2 != 0){
                    html += "		</tr>";
                }
                counter++;
            });

            /*
            html += "		<tr class='even' >";
            html += "			<td class='titulo' >Familia</td>";
            html += "			<td>"+data["FAMILIA"]+"</td>";
            html += "			<td class='titulo' >Género</td>";
            html += "			<td>"+data["GENERO"]+"</td>";

            html += "		</tr>";
            html += "		<tr class='odd' >";
            html += "			<td class='titulo' >Especie</td>";
            html += "			<td>"+data["ESPECIE"]+"</td>";
            html += "			<td class='titulo' >Nombre científico</td>";
            html += "			<td>"+data["NOMBRE_CIE"]+"</td>";
            html += "		</tr>";

            html += "		<tr class='odd' >";
            html += "			<td class='titulo' colspan='2' >Estado Fenologico</td>";
            html += "			<td colspan='2'>"+data["NUM_ESPECI"]+"</td>";
            html += "		</tr>";

            */
            html += "	</table></center></div>";

            html += "</div>";


        }else{
            html =

                "<div class='ws_PopUpInfoArea onlytd' id=\""+id+"\" style=\"width: 390px; border-collapse: collapse; border-width: 0px;\">";
            html += "	<h2>Consulta</h2>";

            html += "	<div class='tablecont nodata'>No se obtuvo informacion.</div>";



        }
        //jaguilar. Manejo de popup mejorado.
        $( ".dialog3_body" ).html(html);
        //$( ".dialog3_body" ).dialog( "height", "disabled" );
        $( "#dialog3" ).dialog( "open" );
        return true;

        OpenLayers.Popup.prototype.setContentHTML.apply(this, [html]);
        var height = Math.min(400, $("#"+id).height()+20);
        this.size = new OpenLayers.Size(352, height);
        this.minSize = new OpenLayers.Size(352, height);
        this.updateSize();


	},

    CLASS_NAME: "OpenLayers.Popup.Selected.Gruposorganizados"
});
