<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 11/24/15
 * Time: 11:12 AM
 */

class CulturaHelper {
    public static function cleanString($text) {
        $utf8 = array(
            '/[áàâãªä]/u'   =>   'a',
            '/[ÁÀÂÃÄ]/u'    =>   'A',
            '/[ÍÌÎÏ]/u'     =>   'I',
            '/[íìîï]/u'     =>   'i',
            '/[éèêë]/u'     =>   'e',
            '/[ÉÈÊË]/u'     =>   'E',
            '/[óòôõºö]/u'   =>   'o',
            '/[ÓÒÔÕÖ]/u'    =>   'O',
            '/[úùûü]/u'     =>   'u',
            '/[ÚÙÛÜ]/u'     =>   'U',
            '/ç/'           =>   'c',
            '/Ç/'           =>   'C',
            '/ñ/'           =>   'n',
            '/Ñ/'           =>   'N',
            '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
            '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
            '/[“”«»„]/u'    =>   ' ', // Double quote
            '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
        );
        return preg_replace(array_keys($utf8), array_values($utf8), $text);
    }

    public static function crearHtmlSelectorFichas($datafichas, $capasiniciales){
        $contadornivel1 = 0;
        $html = "
        <div id='accordion-fichas-holder'>
        <div id='accordion-fichas'>";

        foreach($datafichas[MapHandler::$NIVELESCAPA] as $nivel1 => $capasnivel2){
            //cada nivel1 es un contenedor.
            $contadornivel1++;
            $contadornivel2 = 0;
            //$nivel1 = self::cleanString($nivel1);
            $nivel1 = str_replace(' ', '', $nivel1);
            $nivel1 = strtolower($nivel1);

            $nivel1readable = str_replace(' ', '', $nivel1);
            $nivel1readable = strtolower($nivel1readable);
            $nivel1titulo = "Capa";
            foreach($capasnivel2 as $nivel2=> $capasnivel3){
                $infocapa = $datafichas[MapHandler::$INFOCAPA][$capasnivel3[0]];
                $nivel1titulo = $infocapa['nivel1despliegue'];
            }
            $htmlnivel1 = "
            <h3>$nivel1titulo</h3>
            <div>
            <div class='fichas-nivel1 fichas-cultura $nivel1 c$contadornivel1' id='nivel-$nivel1readable'>
                <div class='controles-contenido'>
                    <ul>
            ";

            foreach($capasnivel2 as $nivel2=> $capasnivel3){
                //aca ya vienen la lista de capas.

                if(count(@$capasnivel3[0])<= 0) continue;//No hay capas que trabajar. Ver si esto se debe hacer.
                $incluirnivel2 = true;
                if(count($capasnivel3) == 1){
                    $incluirnivel2 = false;
                }
                $infocapa = $datafichas[MapHandler::$INFOCAPA][$capasnivel3[0]];
                //print_r($infocapa); die;
                $nivel2readable = $infocapa['nivel2despliegue'];
                $nivel2inner = $infocapa['nivel2'];
                if($incluirnivel2){
                    $contadornivel2++;
                    $htmlnivel1 .= "
                        <li><a href='#'>$nivel2readable</a>

                        <span class='checkboxlayers-holder ojo-nivel2'>
                            <input id='selecting__$nivel2inner' name='selecting__$nivel2inner' value='$nivel2inner' usee='$nivel2inner' group='$nivel2inner' class='checkboxlayers2 group-$nivel2inner' type='checkbox' title='Activar/desactivar la capa: $nivel2readable' />
                            <label class='layer_name_desc ojo-nivel2-padre' for='selecting__$nivel2inner' id='' />
                        </span>
                            <ul>
                ";
                }

                foreach($capasnivel3 as $indice=>$capafichaactual){
                    $infocapa = $datafichas[MapHandler::$INFOCAPA][$capafichaactual];
                    $idcapa =$infocapa['id'];$nombregrupo = "ficha-$idcapa";
                    $nombrecapadespliegue =$infocapa['nombredespliegue'];
                    $nombrews =$infocapa['nombrews'];
                    $nombrecapalayer =$infocapa['nombrecapa'];
                    $capaactualWS = $nombrews . ":".$nombrecapalayer;
                    $inicialhtml = '';
                    if(in_array($capaactualWS, $capasiniciales) ){
                        $inicialhtml = "checked='checked'";
                    }
                    $urlleyenda = "/be/wms?request=GetLegendGraphic&format=image%2Fpng&width=10&height=10&TRANSPARENT=TRUE&legend_options=forceLabels:off;dpi:180&scale=144448&layer=".$nombrecapalayer;
                    $htmlnivel1 .="
                                <li class='snit_layer' data-icon='check' data-theme='a' data-iconpos='left'>
                                    <span class='checkboxlayers-holder'>

                                        <input id='selecting__$nombregrupo' name='selecting__$nombregrupo' value='$nombregrupo' usee='$nombregrupo' group='$nombregrupo' class='checkboxlayers group-$nombregrupo' type='checkbox' title='Activar/desactivar la capa: $nombrecapadespliegue' $inicialhtml />
                                        <label class='layer_name_desc' for='selecting__$nombregrupo' id='lbl_selecting__$nombregrupo' />

                                            <span class='checkboxlayers-txt-span'><img class='leyenda-ficha' src='$urlleyenda' /> $nombrecapadespliegue</span>
                                            <span class='delete-layer' id='delete__$nombregrupo'></span>
                                        </label>
                                    </span>
                                </li>

                    ";
                }
                if($incluirnivel2){
                    $htmlnivel1 .= "
                            </ul>
                        </li>
                ";
                }


            }
            $htmlnivel1 .= "
                    </ul>
                </div>

            </div>
            </div>
                ";
            $html .= $htmlnivel1;
        }


        $html .= "

        </div>
        </div>";
        //echo $html; die;
        return $html;
    }

    public static function crearHtmlSelectorFichasInec($capasinec){
        $contadornivel1 = 0;
        $html = "";

        $html = "
            <div class='fichas-nivel1 inec cin1' id='nivel-inec'>
                <div class='controles-titulo'>
                    <span class='controles-icon capas'></span>
                    Inec
                </div>
                <div class='controles-contenido'>
                    <ul>
            ";

        foreach($capasinec[MapHandler::$CAPA] as $indice => $capaactual){
            $infocapa = $capasinec[MapHandler::$INFOCAPA][$capaactual];
            $idcapa =$infocapa['id'];$nombregrupo = "inec-$idcapa";
            $nombrecapadespliegue =$infocapa['nombredespliegue'];
            $nombrecapalayer =$infocapa['nombrecapa'];
            $urlleyenda =$infocapa['legend_url'];
            $urlleyenda =$urlleyenda."&LAYER=".$nombrecapalayer;
            $html .="
                        <li class='snit_layer' data-icon='check' data-theme='a' data-iconpos='left'>
                            <span class='checkboxlayers-holder'>

                                <input id='selecting__$nombregrupo' name='selecting__$nombregrupo' value='$nombregrupo' usee='$nombregrupo' group='$nombregrupo' class='checkboxlayers group-$nombregrupo' type='checkbox' title='Activar/desactivar la capa: $nombrecapadespliegue' />
                                <label class='layer_name_desc' for='selecting__$nombregrupo' id='lbl_selecting__$nombregrupo'>

                                    <span class='checkboxlayers-txt-span'><img class='leyenda-ficha' src='$urlleyenda' /> $nombrecapadespliegue</span>
                                    <span class='delete-layer' id='delete__$nombregrupo'></span>
                                </label>
                            </span>
                        </li>

            ";




        }
        $html .= "
                    </ul>
                </div>

            </div>
                ";



        return $html;
    }
} 