<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 4/18/16
 * Time: 3:58 PM
 */



function mergedatoshoras($anno = false, $mes= false, $dia= false, $hora= false){


    $datospuntosJSON = <<<EOD
    {"1":["PUNTO0","-85.63714165","11.10782003"],"2":["PUNTO1","-85.61884022","11.10791901"],"3":["PUNTO2","-85.60053862","11.10801687"],"4":["PUNTO3","-85.58223685","11.10811362"],"5":["PUNTO4","-85.56393491","11.10820925"],"6":["PUNTO5","-85.5456328","11.10830378"],"7":["PUNTO6","-85.67364104","11.08954405"],"8":["PUNTO7","-85.65534109","11.08964508"],"9":["PUNTO8","-85.63704096","11.08974499"],"10":["PUNTO9","-85.61874066","11.0898438"],"11":["PUNTO10","-85.60044018","11.0899415"],"12":["PUNTO11","-85.58213953","11.09003809"],"13":["PUNTO12","-85.56383872","11.09013356"],"14":["PUNTO13","-85.54553774","11.09022793"],"15":["PUNTO14","-85.52723659","11.09032119"],"16":["PUNTO15","-85.50893528","11.09041334"],"17":["PUNTO16","-85.49063381","11.09050438"],"18":["PUNTO17","-85.67353828","11.07146932"],"19":["PUNTO18","-85.65523945","11.07157018"],"20":["PUNTO19","-85.63694045","11.07166993"],"21":["PUNTO20","-85.61864126","11.07176857"],"22":["PUNTO21","-85.60034191","11.07186611"],"23":["PUNTO22","-85.58204239","11.07196253"],"24":["PUNTO23","-85.5637427","11.07205785"],"25":["PUNTO24","-85.54544284","11.07215206"],"26":["PUNTO25","-85.52714281","11.07224517"],"27":["PUNTO26","-85.50884263","11.07233716"],"28":["PUNTO27","-85.49054228","11.07242805"],"29":["PUNTO28","-85.47224178","11.07251783"],"30":["PUNTO29","-85.69173324","11.05329278"],"31":["PUNTO30","-85.6734357","11.05339457"],"32":["PUNTO31","-85.65513799","11.05349526"],"33":["PUNTO32","-85.63684011","11.05359484"],"34":["PUNTO33","-85.61854205","11.05369332"],"35":["PUNTO34","-85.60024381","11.05379069"],"36":["PUNTO35","-85.58194541","11.05388696"],"37":["PUNTO36","-85.56364684","11.05398212"],"38":["PUNTO37","-85.5453481","11.05407617"],"39":["PUNTO38","-85.5270492","11.05416912"],"40":["PUNTO39","-85.50875013","11.05426096"],"41":["PUNTO40","-85.49045091","11.05435169"],"42":["PUNTO41","-85.47215152","11.05444132"],"43":["PUNTO42","-85.45385198","11.05452985"],"44":["PUNTO43","-85.728222","11.03501161"],"45":["PUNTO44","-85.70992595","11.03511545"],"46":["PUNTO45","-85.69162972","11.03521817"],"47":["PUNTO46","-85.6733333","11.0353198"],"48":["PUNTO47","-85.65503671","11.03542032"],"49":["PUNTO48","-85.63673994","11.03551974"],"50":["PUNTO49","-85.618443","11.03561805"],"51":["PUNTO50","-85.60014589","11.03571526"],"52":["PUNTO51","-85.5818486","11.03581136"],"53":["PUNTO52","-85.56355115","11.03590636"],"54":["PUNTO53","-85.54525353","11.03600026"],"55":["PUNTO54","-85.52695575","11.03609305"],"56":["PUNTO55","-85.5086578","11.03618474"],"57":["PUNTO56","-85.49035969","11.03627532"],"58":["PUNTO57","-85.47206143","11.0363648"],"59":["PUNTO58","-85.45376301","11.03645317"],"60":["PUNTO59","-85.43546443","11.03654044"],"61":["PUNTO60","-85.74641118","11.01683258"],"62":["PUNTO61","-85.72811643","11.01693734"],"63":["PUNTO62","-85.70982149","11.01704099"],"64":["PUNTO63","-85.69152638","11.01714355"],"65":["PUNTO64","-85.67323108","11.017245"],"66":["PUNTO65","-85.6549356","11.01734535"],"67":["PUNTO66","-85.63663995","11.0174446"],"68":["PUNTO67","-85.61834413","11.01754275"],"69":["PUNTO68","-85.60004813","11.0176398"],"70":["PUNTO69","-85.58175196","11.01773574"],"71":["PUNTO70","-85.56345563","11.01783058"],"72":["PUNTO71","-85.54515912","11.01792432"],"73":["PUNTO72","-85.52686246","11.01801696"],"74":["PUNTO73","-85.50856563","11.01810849"],"75":["PUNTO74","-85.49026864","11.01819892"],"76":["PUNTO75","-85.47197149","11.01828825"],"77":["PUNTO76","-85.45367419","11.01837647"],"78":["PUNTO77","-85.43537673","11.0184636"],"79":["PUNTO78","-85.87435484","10.99799557"],"80":["PUNTO79","-85.85606254","10.99810785"],"81":["PUNTO80","-85.83777004","10.99821903"],"82":["PUNTO81","-85.81947735","10.99832912"],"83":["PUNTO82","-85.80118447","10.9984381"],"84":["PUNTO83","-85.74630468","10.99875845"],"85":["PUNTO84","-85.72801104","10.99886303"],"86":["PUNTO85","-85.70971722","10.99896652"],"87":["PUNTO86","-85.69142322","10.9990689"],"88":["PUNTO87","-85.67312903","10.99917018"],"89":["PUNTO88","-85.65483467","10.99927037"],"90":["PUNTO89","-85.63654014","10.99936945"],"91":["PUNTO90","-85.61824543","10.99946743"],"92":["PUNTO91","-85.59995054","10.99956432"],"93":["PUNTO92","-85.58165549","10.9996601"],"94":["PUNTO93","-85.56336027","10.99975478"],"95":["PUNTO94","-85.54506488","10.99984836"],"96":["PUNTO95","-85.52676933","10.99994084"],"97":["PUNTO96","-85.50847361","11.00003222"],"98":["PUNTO97","-85.49017774","11.0001225"],"99":["PUNTO98","-85.47188171","11.00021168"],"100":["PUNTO99","-85.45358552","11.00029976"],"101":["PUNTO100","-85.43528917","11.00038673"],"102":["PUNTO101","-85.89253172","10.97980951"],"103":["PUNTO102","-85.87424073","10.9799227"],"104":["PUNTO103","-85.85594955","10.9800348"],"105":["PUNTO104","-85.83765817","10.98014579"],"106":["PUNTO105","-85.81936659","10.98025569"],"107":["PUNTO106","-85.80107482","10.98036449"],"108":["PUNTO107","-85.78278285","10.98047219"],"109":["PUNTO108","-85.7644907","10.9805788"],"110":["PUNTO109","-85.74619836","10.9806843"],"111":["PUNTO110","-85.72790584","10.98078871"],"112":["PUNTO111","-85.70961313","10.98089202"],"113":["PUNTO112","-85.69132024","10.98099423"],"114":["PUNTO113","-85.67302717","10.98109534"],"115":["PUNTO114","-85.65473392","10.98119536"],"116":["PUNTO115","-85.63644049","10.98129428"],"117":["PUNTO116","-85.6181469","10.98139209"],"118":["PUNTO117","-85.59985313","10.98148881"],"119":["PUNTO118","-85.58155919","10.98158443"],"120":["PUNTO119","-85.56326508","10.98167896"],"121":["PUNTO120","-85.5449708","10.98177238"],"122":["PUNTO121","-85.52667636","10.9818647"],"123":["PUNTO122","-85.50838176","10.98195593"],"124":["PUNTO123","-85.490087","10.98204606"],"125":["PUNTO124","-85.47179208","10.98213509"],"126":["PUNTO125","-85.453497","10.98222301"],"127":["PUNTO126","-85.43520177","10.98230984"],"128":["PUNTO127","-85.92899585","10.96150753"],"129":["PUNTO128","-85.91070638","10.96162272"],"130":["PUNTO129","-85.89241671","10.96173682"],"131":["PUNTO130","-85.87412683","10.96184982"],"132":["PUNTO131","-85.85583676","10.96196172"],"133":["PUNTO132","-85.83754648","10.96207253"],"134":["PUNTO133","-85.81925602","10.96218224"],"135":["PUNTO134","-85.80096535","10.96229086"],"136":["PUNTO135","-85.7826745","10.96239838"],"137":["PUNTO136","-85.76438346","10.9625048"],"138":["PUNTO137","-85.74609223","10.96261013"],"139":["PUNTO138","-85.72780082","10.96271436"],"140":["PUNTO139","-85.70950922","10.9628175"],"141":["PUNTO140","-85.69121744","10.96291954"],"142":["PUNTO141","-85.67292548","10.96302048"],"143":["PUNTO142","-85.65463334","10.96312033"],"144":["PUNTO143","-85.63634103","10.96321908"],"145":["PUNTO144","-85.61804854","10.96331673"],"146":["PUNTO145","-85.59975588","10.96341329"],"147":["PUNTO146","-85.58146305","10.96350875"],"148":["PUNTO147","-85.56317005","10.96360311"],"149":["PUNTO148","-85.54487689","10.96369638"],"150":["PUNTO149","-85.52658356","10.96378854"],"151":["PUNTO150","-85.50829007","10.96387962"],"152":["PUNTO151","-85.48999642","10.96396959"],"153":["PUNTO152","-85.47170261","10.96405847"],"154":["PUNTO153","-85.45340865","10.96414625"],"155":["PUNTO154","-85.43511453","10.96423294"],"156":["PUNTO155","-85.96545494","10.94320192"],"157":["PUNTO156","-85.94716698","10.9433191"],"158":["PUNTO157","-85.92887882","10.9434352"],"159":["PUNTO158","-85.91059046","10.94355019"],"160":["PUNTO159","-85.89230189","10.9436641"],"161":["PUNTO160","-85.87401313","10.94377691"],"162":["PUNTO161","-85.85572416","10.94388862"],"163":["PUNTO162","-85.837435","10.94399925"],"164":["PUNTO163","-85.81914564","10.94410877"],"165":["PUNTO164","-85.80085608","10.94421721"],"166":["PUNTO165","-85.78256634","10.94432455"],"167":["PUNTO166","-85.76427641","10.94443079"],"168":["PUNTO167","-85.74598628","10.94453594"],"169":["PUNTO168","-85.72769598","10.94464"],"170":["PUNTO169","-85.70940549","10.94474296"],"171":["PUNTO170","-85.69111482","10.94484483"],"172":["PUNTO171","-85.67282397","10.9449456"],"173":["PUNTO172","-85.65453294","10.94504527"],"174":["PUNTO173","-85.63624173","10.94514386"],"175":["PUNTO174","-85.61795035","10.94524135"],"176":["PUNTO175","-85.5996588","10.94533774"],"177":["PUNTO176","-85.58136708","10.94543304"],"178":["PUNTO177","-85.56307519","10.94552724"],"179":["PUNTO178","-85.54478314","10.94562035"],"180":["PUNTO179","-85.52649092","10.94571236"],"181":["PUNTO180","-85.50819854","10.94580328"],"182":["PUNTO181","-85.489906","10.9458931"],"183":["PUNTO182","-85.4716133","10.94598183"],"184":["PUNTO183","-85.45332044","10.94606947"],"185":["PUNTO184","-85.43502743","10.946156"],"186":["PUNTO185","-85.98362254","10.92501188"],"187":["PUNTO186","-85.9653359","10.92512996"],"188":["PUNTO187","-85.94704905","10.92524695"],"189":["PUNTO188","-85.928762","10.92536284"],"190":["PUNTO189","-85.91047474","10.92547765"],"191":["PUNTO190","-85.89218728","10.92559136"],"192":["PUNTO191","-85.87389962","10.92570398"],"193":["PUNTO192","-85.85561176","10.9258155"],"194":["PUNTO193","-85.8373237","10.92592594"],"195":["PUNTO194","-85.81903545","10.92603528"],"196":["PUNTO195","-85.800747","10.92614353"],"197":["PUNTO196","-85.78245837","10.92625069"],"198":["PUNTO197","-85.76416954","10.92635675"],"199":["PUNTO198","-85.74588052","10.92646173"],"200":["PUNTO199","-85.72759132","10.92656561"],"201":["PUNTO200","-85.70930194","10.92666839"],"202":["PUNTO201","-85.69101238","10.92677009"],"203":["PUNTO202","-85.67272263","10.92687069"],"204":["PUNTO203","-85.65443271","10.9269702"],"205":["PUNTO204","-85.63614261","10.92706862"],"206":["PUNTO205","-85.61785234","10.92716594"],"207":["PUNTO206","-85.5995619","10.92726217"],"208":["PUNTO207","-85.58127128","10.92735731"],"209":["PUNTO208","-85.5629805","10.92745135"],"210":["PUNTO209","-85.54468955","10.9275443"],"211":["PUNTO210","-85.52639844","10.92763616"],"212":["PUNTO211","-85.50810717","10.92772692"],"213":["PUNTO212","-85.48981573","10.9278166"],"214":["PUNTO213","-85.47152414","10.92790517"],"215":["PUNTO214","-85.45323239","10.92799266"],"216":["PUNTO215","-85.43494049","10.92807905"],"217":["PUNTO216","-85.41664843","10.92816435"],"218":["PUNTO217","-85.98350261","10.9069401"],"219":["PUNTO218","-85.96521708","10.90705798"],"220":["PUNTO219","-85.94693133","10.90717477"],"221":["PUNTO220","-85.92864538","10.90729047"],"222":["PUNTO221","-85.91035923","10.90740507"],"223":["PUNTO222","-85.89207287","10.90751859"],"224":["PUNTO223","-85.87378632","10.90763102"],"225":["PUNTO224","-85.85549956","10.90774236"],"226":["PUNTO225","-85.83721261","10.90785261"],"227":["PUNTO226","-85.81892546","10.90796177"],"228":["PUNTO227","-85.80063811","10.90806983"],"229":["PUNTO228","-85.78235058","10.90817681"],"230":["PUNTO229","-85.76406286","10.90828269"],"231":["PUNTO230","-85.74577495","10.90838749"],"232":["PUNTO231","-85.72748685","10.90849119"],"233":["PUNTO232","-85.70919858","10.90859381"],"234":["PUNTO233","-85.69091012","10.90869533"],"235":["PUNTO234","-85.67262148","10.90879576"],"236":["PUNTO235","-85.65433266","10.9088951"],"237":["PUNTO236","-85.63604367","10.90899335"],"238":["PUNTO237","-85.6177545","10.90909051"],"239":["PUNTO238","-85.59946516","10.90918658"],"240":["PUNTO239","-85.58117565","10.90928155"],"241":["PUNTO240","-85.56288597","10.90937544"],"242":["PUNTO241","-85.54459613","10.90946823"],"243":["PUNTO242","-85.52630613","10.90955993"],"244":["PUNTO243","-85.50801596","10.90965055"],"245":["PUNTO244","-85.48972563","10.90974006"],"246":["PUNTO245","-85.47143514","10.90982849"],"247":["PUNTO246","-85.4531445","10.90991583"],"248":["PUNTO247","-85.4348537","10.91000208"],"249":["PUNTO248","-85.41656275","10.91008723"],"250":["PUNTO249","-85.98338289","10.88886829"],"251":["PUNTO250","-85.96509846","10.88898597"],"252":["PUNTO251","-85.94681382","10.88910256"],"253":["PUNTO252","-85.92852897","10.88921807"],"254":["PUNTO253","-85.91024392","10.88933248"],"255":["PUNTO254","-85.89195866","10.88944581"],"256":["PUNTO255","-85.87367321","10.88955805"],"257":["PUNTO256","-85.85538755","10.8896692"],"258":["PUNTO257","-85.8371017","10.88977926"],"259":["PUNTO258","-85.81881566","10.88988823"],"260":["PUNTO259","-85.80052942","10.88999611"],"261":["PUNTO260","-85.78224299","10.89010291"],"262":["PUNTO261","-85.76395637","10.89020861"],"263":["PUNTO262","-85.74566956","10.89031323"],"264":["PUNTO263","-85.72738257","10.89041676"],"265":["PUNTO264","-85.70909539","10.8905192"],"266":["PUNTO265","-85.69080803","10.89062055"],"267":["PUNTO266","-85.6725205","10.89072081"],"268":["PUNTO267","-85.65423278","10.89081998"],"269":["PUNTO268","-85.63594489","10.89091806"],"270":["PUNTO269","-85.61765683","10.89101506"],"271":["PUNTO270","-85.59936859","10.89111096"],"272":["PUNTO271","-85.58108019","10.89120578"],"273":["PUNTO272","-85.56279161","10.8912995"],"274":["PUNTO273","-85.54450287","10.89139214"],"275":["PUNTO274","-85.52621397","10.89148369"],"276":["PUNTO275","-85.50792491","10.89157414"],"277":["PUNTO276","-85.48963568","10.89166351"],"278":["PUNTO277","-85.4713463","10.89175179"],"279":["PUNTO278","-85.45305676","10.89183898"],"280":["PUNTO279","-85.43476706","10.89192508"],"281":["PUNTO280","-85.41647722","10.89201009"],"282":["PUNTO281","-85.98326338","10.87079647"],"283":["PUNTO282","-85.96498005","10.87091395"],"284":["PUNTO283","-85.94669651","10.87103034"],"285":["PUNTO284","-85.92841276","10.87114565"],"286":["PUNTO285","-85.91012881","10.87125987"],"287":["PUNTO286","-85.89184466","10.871373"],"288":["PUNTO287","-85.8735603","10.87148505"],"289":["PUNTO288","-85.85527575","10.87159601"],"290":["PUNTO289","-85.836991","10.87170588"],"291":["PUNTO290","-85.81870605","10.87181467"],"292":["PUNTO291","-85.80042091","10.87192237"],"293":["PUNTO292","-85.78213558","10.87202898"],"294":["PUNTO293","-85.76385006","10.87213451"],"295":["PUNTO294","-85.74556436","10.87223895"],"296":["PUNTO295","-85.72727846","10.8723423"],"297":["PUNTO296","-85.70899239","10.87244457"],"298":["PUNTO297","-85.69070613","10.87254574"],"299":["PUNTO298","-85.6724197","10.87264584"],"300":["PUNTO299","-85.65413308","10.87274484"],"301":["PUNTO300","-85.63584629","10.87284276"],"302":["PUNTO301","-85.61755933","10.87293958"],"303":["PUNTO302","-85.5992722","10.87303533"],"304":["PUNTO303","-85.58098489","10.87312998"],"305":["PUNTO304","-85.56269742","10.87322355"],"306":["PUNTO305","-85.54440978","10.87331603"],"307":["PUNTO306","-85.52612198","10.87340742"],"308":["PUNTO307","-85.50783402","10.87349772"],"309":["PUNTO308","-85.48954589","10.87358694"],"310":["PUNTO309","-85.47125761","10.87367506"],"311":["PUNTO310","-85.45296917","10.87376211"],"312":["PUNTO311","-85.43468058","10.87384806"],"313":["PUNTO312","-85.41639183","10.87393292"],"314":["PUNTO313","-85.98314408","10.85272462"],"315":["PUNTO314","-85.96486185","10.8528419"],"316":["PUNTO315","-85.94657941","10.85295809"],"317":["PUNTO316","-85.92829676","10.8530732"],"318":["PUNTO317","-85.9100139","10.85318723"],"319":["PUNTO318","-85.89173085","10.85330017"],"320":["PUNTO319","-85.87344759","10.85341203"],"321":["PUNTO320","-85.85516414","10.8535228"],"322":["PUNTO321","-85.83688048","10.85363249"],"323":["PUNTO322","-85.81859664","10.85374109"],"324":["PUNTO323","-85.8003126","10.8538486"],"325":["PUNTO324","-85.78202836","10.85395504"],"326":["PUNTO325","-85.76374394","10.85406038"],"327":["PUNTO326","-85.74545934","10.85416465"],"328":["PUNTO327","-85.72717454","10.85426782"],"329":["PUNTO328","-85.70888957","10.85436991"],"330":["PUNTO329","-85.69060441","10.85447092"],"331":["PUNTO330","-85.67231907","10.85457084"],"332":["PUNTO331","-85.65403356","10.85466967"],"333":["PUNTO332","-85.63574787","10.85476742"],"334":["PUNTO333","-85.617462","10.85486409"],"335":["PUNTO334","-85.59917597","10.85495967"],"336":["PUNTO335","-85.58088976","10.85505416"],"337":["PUNTO336","-85.56260339","10.85514757"],"338":["PUNTO337","-85.54431685","10.85523989"],"339":["PUNTO338","-85.52603015","10.85533113"],"340":["PUNTO339","-85.50774328","10.85542128"],"341":["PUNTO340","-85.48945626","10.85551034"],"342":["PUNTO341","-85.47116908","10.85559832"],"343":["PUNTO342","-85.45288174","10.85568521"],"344":["PUNTO343","-85.43459425","10.85577102"],"345":["PUNTO344","-85.4163066","10.85585574"],"346":["PUNTO345","-85.9098992","10.83511457"],"347":["PUNTO346","-85.89161724","10.83522732"],"348":["PUNTO347","-85.87333508","10.83533898"],"349":["PUNTO348","-85.85505272","10.83544957"],"350":["PUNTO349","-85.83677017","10.83555907"],"351":["PUNTO350","-85.81848742","10.83566748"],"352":["PUNTO351","-85.80020447","10.83577482"],"353":["PUNTO352","-85.78192134","10.83588107"],"354":["PUNTO353","-85.76363801","10.83598624"],"355":["PUNTO354","-85.7453545","10.83609032"],"356":["PUNTO355","-85.72707081","10.83619332"],"357":["PUNTO356","-85.70878693","10.83629524"],"358":["PUNTO357","-85.69050287","10.83639607"],"359":["PUNTO358","-85.67221863","10.83649582"],"360":["PUNTO359","-85.65393421","10.83659449"],"361":["PUNTO360","-85.63564962","10.83669207"],"362":["PUNTO361","-85.61736485","10.83678857"],"363":["PUNTO362","-85.59907991","10.83688399"],"364":["PUNTO363","-85.5807948","10.83697832"],"365":["PUNTO364","-85.56250953","10.83707157"],"366":["PUNTO365","-85.54422409","10.83716373"],"367":["PUNTO366","-85.52593848","10.83725481"],"368":["PUNTO367","-85.50765271","10.83734481"],"369":["PUNTO368","-85.48936679","10.83743372"],"370":["PUNTO369","-85.4710807","10.83752155"],"371":["PUNTO370","-85.45279446","10.83760829"],"372":["PUNTO371","-85.43450806","10.83769395"],"373":["PUNTO372","-85.89150384","10.81715444"],"374":["PUNTO373","-85.87322277","10.81726592"],"375":["PUNTO374","-85.8549415","10.81737631"],"376":["PUNTO375","-85.83666004","10.81748563"],"377":["PUNTO376","-85.81837839","10.81759386"],"378":["PUNTO377","-85.80009654","10.81770101"],"379":["PUNTO378","-85.7818145","10.81780708"],"380":["PUNTO379","-85.76353227","10.81791206"],"381":["PUNTO380","-85.74524985","10.81801597"],"382":["PUNTO381","-85.72696725","10.8181188"],"383":["PUNTO382","-85.70868447","10.81822054"],"384":["PUNTO383","-85.6904015","10.8183212"],"385":["PUNTO384","-85.67211836","10.81842078"],"386":["PUNTO385","-85.65383504","10.81851928"],"387":["PUNTO386","-85.63555154","10.8186167"],"388":["PUNTO387","-85.61726787","10.81871303"],"389":["PUNTO388","-85.59898402","10.81880828"],"390":["PUNTO389","-85.58070001","10.81890245"],"391":["PUNTO390","-85.56241583","10.81899554"],"392":["PUNTO391","-85.54413148","10.81908755"],"393":["PUNTO392","-85.52584698","10.81917848"],"394":["PUNTO393","-85.5075623","10.81926832"],"395":["PUNTO394","-85.48927747","10.81935708"],"396":["PUNTO395","-85.83655012","10.79941216"],"397":["PUNTO396","-85.81826955","10.79952021"],"398":["PUNTO397","-85.7999888","10.79962718"],"399":["PUNTO398","-85.78170785","10.79973306"],"400":["PUNTO399","-85.76342671","10.79983787"],"401":["PUNTO400","-85.74514539","10.7999416"],"402":["PUNTO401","-85.72686388","10.80004425"],"403":["PUNTO402","-85.70858219","10.80014582"],"404":["PUNTO403","-85.69030032","10.80024631"],"405":["PUNTO404","-85.67201827","10.80034572"],"406":["PUNTO405","-85.65373604","10.80044405"],"407":["PUNTO406","-85.63545363","10.8005413"],"408":["PUNTO407","-85.61717105","10.80063747"],"409":["PUNTO408","-85.59888831","10.80073256"],"410":["PUNTO409","-85.58060539","10.80082657"],"411":["PUNTO410","-85.5623223","10.8009195"],"412":["PUNTO411","-85.54403905","10.80101135"],"413":["PUNTO412","-85.52575563","10.80110212"],"414":["PUNTO413","-85.50747205","10.80119181"],"415":["PUNTO414","-85.48918831","10.80128042"],"416":["PUNTO415","-85.47090442","10.80136795"],"417":["PUNTO416","-85.83644038","10.78133868"],"418":["PUNTO417","-85.81816091","10.78144654"],"419":["PUNTO418","-85.79988125","10.78155332"],"420":["PUNTO419","-85.78160139","10.78165903"],"421":["PUNTO420","-85.76332134","10.78176366"],"422":["PUNTO421","-85.74504111","10.78186721"],"423":["PUNTO422","-85.72676069","10.78196968"],"424":["PUNTO423","-85.70848009","10.78207108"],"425":["PUNTO424","-85.69019931","10.7821714"],"426":["PUNTO425","-85.67191835","10.78227064"],"427":["PUNTO426","-85.65363721","10.7823688"],"428":["PUNTO427","-85.6353559","10.78246588"],"429":["PUNTO428","-85.61707441","10.78256189"],"430":["PUNTO429","-85.59879276","10.78265681"],"431":["PUNTO430","-85.58051093","10.78275066"],"432":["PUNTO431","-85.56222893","10.78284343"],"433":["PUNTO432","-85.54394677","10.78293513"],"434":["PUNTO433","-85.52566445","10.78302574"],"435":["PUNTO434","-85.50738196","10.78311527"],"436":["PUNTO435","-85.48909932","10.78320373"],"437":["PUNTO436","-85.47081651","10.78329111"],"438":["PUNTO437","-85.79977388","10.76347945"],"439":["PUNTO438","-85.78149512","10.76358497"],"440":["PUNTO439","-85.76321616","10.76368942"],"441":["PUNTO440","-85.74493702","10.76379279"],"442":["PUNTO441","-85.72665769","10.76389509"],"443":["PUNTO442","-85.70837818","10.76399631"],"444":["PUNTO443","-85.69009849","10.76409646"],"445":["PUNTO444","-85.67181862","10.76419553"],"446":["PUNTO445","-85.65353857","10.76429352"],"447":["PUNTO446","-85.63525834","10.76439044"],"448":["PUNTO447","-85.61697795","10.76448628"],"449":["PUNTO448","-85.59869738","10.76458104"],"450":["PUNTO449","-85.58041664","10.76467473"],"451":["PUNTO450","-85.56213573","10.76476734"],"452":["PUNTO451","-85.54385466","10.76485888"],"453":["PUNTO452","-85.52557343","10.76494934"],"454":["PUNTO453","-85.50729203","10.76503872"],"455":["PUNTO454","-85.48901047","10.76512703"],"456":["PUNTO455","-85.47072876","10.76521425"],"457":["PUNTO456","-85.70827645","10.74592153"],"458":["PUNTO457","-85.68999784","10.7460215"],"459":["PUNTO458","-85.67171906","10.7461204"],"460":["PUNTO459","-85.6534401","10.74621823"],"461":["PUNTO460","-85.63516096","10.74631498"],"462":["PUNTO461","-85.61688165","10.74641065"],"463":["PUNTO462","-85.59860217","10.74650525"],"464":["PUNTO463","-85.58032252","10.74659878"],"465":["PUNTO464","-85.5620427","10.74669123"],"466":["PUNTO465","-85.54376272","10.74678261"],"467":["PUNTO466","-85.52548257","10.74687292"],"468":["PUNTO467","-85.50720226","10.74696214"],"469":["PUNTO468","-85.48892179","10.7470503"],"470":["PUNTO469","-85.47064116","10.74713738"],"471":["PUNTO470","-85.70817489","10.72784672"],"472":["PUNTO471","-85.68989737","10.72794652"],"473":["PUNTO472","-85.67161967","10.72804525"],"474":["PUNTO473","-85.6533418","10.72814291"],"475":["PUNTO474","-85.63506375","10.72823949"],"476":["PUNTO475","-85.61678552","10.728335"],"477":["PUNTO476","-85.59850713","10.72842944"],"478":["PUNTO477","-85.58022856","10.72852281"],"479":["PUNTO478","-85.56194983","10.7286151"],"480":["PUNTO479","-85.54367093","10.72870632"],"481":["PUNTO480","-85.52539187","10.72879647"],"482":["PUNTO481","-85.50711265","10.72888555"],"483":["PUNTO482","-85.48883327","10.72897355"],"484":["PUNTO483","-85.47055373","10.72906048"],"485":["PUNTO484","-85.70807352","10.70977189"],"486":["PUNTO485","-85.68979708","10.70987152"],"487":["PUNTO486","-85.67152047","10.70997008"],"488":["PUNTO487","-85.65324368","10.71006757"],"489":["PUNTO488","-85.63496671","10.71016399"],"490":["PUNTO489","-85.61668957","10.71025933"],"491":["PUNTO490","-85.59841226","10.71035361"],"492":["PUNTO491","-85.58013478","10.71044681"],"493":["PUNTO492","-85.56185713","10.71053895"],"494":["PUNTO493","-85.54357931","10.71063001"],"495":["PUNTO494","-85.52530134","10.71072"],"496":["PUNTO495","-85.5070232","10.71080893"],"497":["PUNTO496","-85.4887449","10.71089678"],"498":["PUNTO497","-85.47046644","10.71098356"],"499":["PUNTO498","-85.68969697","10.6917965"],"500":["PUNTO499","-85.67142144","10.69189489"],"501":["PUNTO500","-85.65314573","10.69199221"],"502":["PUNTO501","-85.63486984","10.69208846"],"503":["PUNTO502","-85.61659379","10.69218364"],"504":["PUNTO503","-85.59831756","10.69227775"],"505":["PUNTO504","-85.58004116","10.6923708"],"506":["PUNTO505","-85.56176459","10.69246277"],"507":["PUNTO506","-85.54348786","10.69255368"],"508":["PUNTO507","-85.52521096","10.69264352"],"509":["PUNTO508","-85.50693391","10.69273228"],"510":["PUNTO509","-85.48865669","10.69281998"],"511":["PUNTO510","-85.47037931","10.69290661"],"512":["PUNTO511","-85.67132259","10.67381967"],"513":["PUNTO512","-85.65304796","10.67391682"],"514":["PUNTO513","-85.63477315","10.67401291"],"515":["PUNTO514","-85.61649817","10.67410792"],"516":["PUNTO515","-85.59822302","10.67420188"],"517":["PUNTO516","-85.5799477","10.67429476"],"518":["PUNTO517","-85.56167222","10.67438658"],"519":["PUNTO518","-85.54339657","10.67447732"],"520":["PUNTO519","-85.52512075","10.67456701"],"521":["PUNTO520","-85.50684477","10.67465562"],"522":["PUNTO521","-85.48856864","10.67474317"],"523":["PUNTO522","-85.65295036","10.65584142"],"524":["PUNTO523","-85.63467663","10.65593734"],"525":["PUNTO524","-85.61640273","10.65603219"],"526":["PUNTO525","-85.59812866","10.65612598"],"527":["PUNTO526","-85.57985442","10.6562187"],"528":["PUNTO527","-85.56158001","10.65631036"],"529":["PUNTO528","-85.54330544","10.65640095"],"530":["PUNTO529","-85.5250307","10.65649048"],"531":["PUNTO530","-85.5067558","10.65657894"],"532":["PUNTO531","-85.48848074","10.65666633"],"533":["PUNTO532","-85.63458029","10.63786174"],"534":["PUNTO533","-85.61630746","10.63795643"],"535":["PUNTO534","-85.59803447","10.63805006"],"536":["PUNTO535","-85.5797613","10.63814262"],"537":["PUNTO536","-85.56148797","10.63823412"],"538":["PUNTO537","-85.54321447","10.63832455"],"539":["PUNTO538","-85.52494081","10.63841392"],"540":["PUNTO539","-85.50666699","10.63850223"]}
EOD;

    $datospuntosJSON = trim($datospuntosJSON);
    $datospuntos =json_decode($datospuntosJSON, true);

    $columnastonames = array(
        'A2' =>'PUNTO'
        ,'B2' =>'X'
        ,'C2' =>'Y'
        ,'D2' =>'LLUV_9_12'
        ,'E2' =>'LLUV_12_3'
        ,'F2' =>'LLUV_3_6'
        ,'G2' =>'TEMP_9_12'
        ,'H2' =>'TEMP_12_3'
        ,'I2' =>'TEMP_3_6'
        ,'J2' =>'HUM_9_12'
        ,'K2' =>'HUM_12_3'
        ,'L2' =>'HUM_3_6'
        ,'M2' =>'VU_9_12'
        ,'N2' =>'VU_12_3'
        ,'O2' =>'VU_3_6'
        ,'P2' =>'VV_9_12'
        ,'Q2' =>'VV_12_3'
        ,'R2' =>'VV_3_6'
        ,'S2' =>'VMAG_9_12'
        ,'T2' =>'VMAG_12_3'
        ,'U2' =>'VMAG_3_6'
        ,'V2' =>'VDIR_9_12'
        ,'W2' =>'VDIR_12_3'
        ,'X2' =>'VDIR_3_6'
        ,'Y2' =>'VANG_9_12'
        ,'Z2' =>'VANG_12_3'
        ,'AA2' =>'VANG_3_6'

    );
    $arregloDatos = array();

    foreach($datospuntos as $datopuntoactual){
        $arregloDatos[$datopuntoactual[0]] = array('coord-x'=>$datopuntoactual[1],'coord-y'=>$datopuntoactual[2]);
    }
    //print_r($arregloDatos);
    //die;

    $listaarchivos = array(
        'http://sarapiqui.imn.ac.cr/modelo/ACG/humedad.txt',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/humedad.csv',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/lluvia.txt',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/lluvia.csv',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/vientoU.txt',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/vientoU.csv',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/vientoV.txt',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/vientoV.csv',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/temperatura.txt',
        'http://sarapiqui.imn.ac.cr/modelo/ACG/temperatura.csv'
    );

    if(!$anno)
        $anno = date("Y");
    if(!$mes)
        $mes = date("m");
    if(!$dia)
        $dia = date("d");
    if(!$hora)
        $hora = date("H");
    //$hora = 12;
    if($hora > 12)
        $hora = 12;
    $hora = $hora . '00';

    $directoriodescargas = dirname(__FILE__) . DIRECTORY_SEPARATOR .'datosdescarga'. DIRECTORY_SEPARATOR ;
    $directoriocsvmerge = dirname(__FILE__) . DIRECTORY_SEPARATOR .'csvmerge';


    $directoriodestino = $directoriodescargas . $anno . DIRECTORY_SEPARATOR . $mes . DIRECTORY_SEPARATOR . $dia . DIRECTORY_SEPARATOR . $hora;
    //echo $directoriodestino; die;
    $archivosCSV = glob($directoriodestino."/*.csv");

    print_r($archivosCSV);
    //die;
    /*$cantidadpuntos = 539;
    $arregloDatos = array();
    for($iterador = 0; $iterador < $cantidadpuntos; $iterador++){
        $arregloDatos['PUNTO'.$iterador] = array();
    }*/

    $archivosatrabajarENORDEN = array(
        'lluvia.csv'
            => array('D2' =>'LLUV_9_12','E2' => 'LLUV_12_3','F2' => 'LLUV_3_6')
        ,'temperatura.csv'
            => array('G2' =>'TEMP_9_12','H2' => 'TEMP_12_3','I2' => 'TEMP_3_6')
        ,'humedad.csv'
            => array('J2' =>'HUM_9_12','K2' => 'HUM_12_3','L2' => 'HUM_3_6')
        ,'vientoU.csv'
            => array('M2' =>'VU_9_12','N2' => 'VU_12_3','O2' => 'VU_3_6')
        ,'vientoV.csv'
            => array('P2' =>'VV_9_12','Q2' => 'VV_12_3','R2' => 'VV_3_6')

    );

    foreach($archivosatrabajarENORDEN as $archivoactual => $dataarchivo){
        //leer el archivo actual, y registrar los datos del punto en el arregloDatos.
        $csv = array_map('str_getcsv', file($directoriodestino.DIRECTORY_SEPARATOR.$archivoactual));
        //print_r($csv); die;
        foreach($csv as $datoArchivo){
            $nombrepunto = trim($datoArchivo[0]);
            $indice = 0;
            foreach($dataarchivo as $columna => $columnanombre){
                $indice++;//Empezar en 1.
                //Solo estas columnas se leen.
                $arregloDatos[$nombrepunto][$columna] = $datoArchivo[$indice] + 0;
            }
        }
        //print_r($arregloDatos); die;
        //$arregloDatos[]
    }
    //echo ("\nTodos los datos unidos: [". print_r($arregloDatos, true) . "]\n");

    //Calcular las columnas adicionales.
    foreach($arregloDatos as $nombrepunto=>$datospunto){

        //$nombrepunto = 'PUNTO0';
        //$datospunto = $arregloDatos[$nombrepunto];

        //s: =+RAIZ(POTENCIA(M2,2)+POTENCIA(P2,2))
        $arregloDatos[$nombrepunto]['S2'] = sqrt ( pow ($datospunto['M2'], 2) + pow ($datospunto['P2'], 2) );
        //t: =+RAIZ(POTENCIA(N2,2)+POTENCIA(Q2,2))
        $arregloDatos[$nombrepunto]['T2'] = sqrt ( pow ($datospunto['N2'], 2) + pow ($datospunto['Q2'], 2) );
        //U: =+RAIZ(POTENCIA(O2,2)+POTENCIA(R2,2))
        $arregloDatos[$nombrepunto]['U2'] = sqrt ( pow ($datospunto['O2'], 2) + pow ($datospunto['R2'], 2) );

        //Hay que calcular Y,Z,AA antes que V,W,X porque depende de ellas.

        //Y=+GRADOS(ATAN(M2/P2))
        $arregloDatos[$nombrepunto]['Y2'] = 0;
        $arregloDatos[$nombrepunto]['Y2'] = rad2deg( atan($datospunto['M2']/$datospunto['P2']) );

        //Z=+GRADOS(ATAN(N2/Q2))
        $arregloDatos[$nombrepunto]['Z2'] = 0;
        $arregloDatos[$nombrepunto]['Z2'] = rad2deg( atan($datospunto['N2']/$datospunto['Q2']) );

        //AA=+GRADOS(ATAN(O2/R2))
        $arregloDatos[$nombrepunto]['AA2'] = 0;
        $arregloDatos[$nombrepunto]['AA2'] = rad2deg( atan($datospunto['O2']/$datospunto['R2']) );

        //V: =+SI(M2=0,SI(P2>0,180,360),SI(P2=0,SI(M2>0,270,90),SI(P2>0,180+Y2,SI(M2<0,Y2,360+Y2))))
        /*


         */
        $valor = 0;
        if($arregloDatos[$nombrepunto]['M2'] == 0){
            if($arregloDatos[$nombrepunto]['P2'] > 0){
                $valor = 180;
            }else{
                $valor = 360;
            }
        }else{
            if($arregloDatos[$nombrepunto]['P2'] == 0){
                if($arregloDatos[$nombrepunto]['M2'] > 0){
                    $valor = 270;
                }else{
                    $valor = 90;
                }
            }else{
                if($arregloDatos[$nombrepunto]['P2'] > 0){
                    $valor = 180 + $arregloDatos[$nombrepunto]['Y2'];
                }else{
                    if($arregloDatos[$nombrepunto]['M2'] < 0){
                        $valor = $arregloDatos[$nombrepunto]['Y2'];
                    }else{
                        $valor = 360+$arregloDatos[$nombrepunto]['Y2'];
                    }
                }
            }
        }
        //echo ("Valor de V2: $valor"); die;
        $arregloDatos[$nombrepunto]['V2'] = $valor;

        //W: =+SI(N2=0,SI(Q2>0,180,360),SI(Q2=0,SI(N2>0,270,90),SI(Q2>0,180+Z2,SI(N2<0,Z2,360+Z2))))
        $valor = 0;
        if($arregloDatos[$nombrepunto]['N2'] == 0){
            if($arregloDatos[$nombrepunto]['Q2'] > 0){
                $valor = 180;
            }else{
                $valor = 360;
            }
        }else{
            if($arregloDatos[$nombrepunto]['Q2'] == 0){
                if($arregloDatos[$nombrepunto]['N2'] > 0){
                    $valor = 270;
                }else{
                    $valor = 90;
                }
            }else{
                if($arregloDatos[$nombrepunto]['Q2'] > 0){
                    $valor = 180 + $arregloDatos[$nombrepunto]['Z2'];
                }else{
                    if($arregloDatos[$nombrepunto]['N2'] < 0){
                        $valor = $arregloDatos[$nombrepunto]['Z2'];
                    }else{
                        $valor = 360+$arregloDatos[$nombrepunto]['Z2'];
                    }
                }
            }
        }
        $arregloDatos[$nombrepunto]['W2'] = $valor;

        //X=+SI(O2=0,SI(R2>0,180,360),SI(R2=0,SI(O2>0,270,90),SI(R2>0,180+AA2,SI(O2<0,AA2,360+AA2))))

        $valor = 0;
        if($arregloDatos[$nombrepunto]['O2'] == 0){
            if($arregloDatos[$nombrepunto]['R2'] > 0){
                $valor = 180;
            }else{
                $valor = 360;
            }
        }else{
            if($arregloDatos[$nombrepunto]['R2'] == 0){
                if($arregloDatos[$nombrepunto]['O2'] > 0){
                    $valor = 270;
                }else{
                    $valor = 90;
                }
            }else{
                if($arregloDatos[$nombrepunto]['R2'] > 0){
                    $valor = 180 + $arregloDatos[$nombrepunto]['AA2'];
                }else{
                    if($arregloDatos[$nombrepunto]['O2'] < 0){
                        $valor = $arregloDatos[$nombrepunto]['AA2'];
                    }else{
                        $valor = 360+$arregloDatos[$nombrepunto]['AA2'];
                    }
                }
            }
        }
        $arregloDatos[$nombrepunto]['X2'] = $valor;

        //print_r($arregloDatos[$nombrepunto]);// die;

    }
    //echo ("Datos finales calculados: ".print_r($arregloDatos, true));
    $archivocsvunido = $directoriocsvmerge . DIRECTORY_SEPARATOR . 'MD'.$anno . $mes. $dia.$hora . '.csv' ;
    $fp = fopen($archivocsvunido, 'w');

    fputcsv($fp, $columnastonames);


    foreach($arregloDatos as $nombrepunto =>$datospunto){
        //$columnastonames
        $columnaslistas = array();
        foreach($columnastonames as $nombrecolumna => $nombrefinal){
            switch($nombrecolumna){
                case 'A2':
                    $columnaslistas[$nombrefinal] = $nombrepunto;
                    break;
                case 'B2':
                    $columnaslistas[$nombrefinal] = $datospunto['coord-x'];
                    break;
                case 'C2':
                    $columnaslistas[$nombrefinal] = $datospunto['coord-y'];
                    break;
                default:
                    $columnaslistas[$nombrefinal] = $datospunto[$nombrecolumna];
            }
        }
        fputcsv($fp, $columnaslistas);

    }

    fclose($fp);
}
//Unir los datos horas de la hora actual!.
mergedatoshoras();

/*
 * El siguiente codigo es para generar los csv unidos de todos los subdirectorios que haya.
 *
$directoriobuscar = '/var/www/addax.cc/sinac/incendios/datosprediccion/datosdescarga';


function getDirContents($dir, &$results = array()){
    $files = scandir($dir);

    foreach($files as $key => $value){
        $path = realpath($dir.DIRECTORY_SEPARATOR.$value);
        if(!is_dir($path)) {
            //$results[] = $path;
        } else if($value != "." && $value != "..") {
            getDirContents($path, $results);
            $results[] = $path;
        }
    }

    return $results;
}

$directoriosdescargas = (getDirContents($directoriobuscar));
//print_r($directoriosdescargas); die;
array_reverse($directoriosdescargas);
foreach ($directoriosdescargas as $directoriodescarga_actual) {
    $directoriodescarga_actual_raw = $directoriodescarga_actual;
    $directoriodescarga_actual = str_replace('/var/www/addax.cc/sinac/incendios/datosprediccion/datosdescarga/', '', $directoriodescarga_actual);
    $directoriodescarga_actual_partes = split('/',$directoriodescarga_actual);
    if(count($directoriodescarga_actual_partes) == 4){//anno/mes/dia/hora00
        $anno = $directoriodescarga_actual_partes[0];
        $mes= $directoriodescarga_actual_partes[1];
        $dia= $directoriodescarga_actual_partes[2];
        $hora= $directoriodescarga_actual_partes[3];
        echo ( "\n\nDATOS DE DIRECTORIO [$directoriodescarga_actual_raw] ($anno, $mes, $dia, $hora)\n");
        mergedatoshoras($anno, $mes, $dia, $hora);
    }
}
*/