/*
 * Decompiled with CFR 0.152.
 */
package org.dojo.moxie;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.dojo.moxie.Document;
import org.dojo.moxie.MoxieException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Documents {
    private static Connection con;
    private static PreparedStatement listSQL;
    private static PreparedStatement findByFileNameSQL;
    private static PreparedStatement findByIDSQL;
    private static PreparedStatement newItemSQL;
    private static PreparedStatement deleteItemSQL;
    private static PreparedStatement updateItemSQL;

    public static synchronized void initialize(String string, String string2, String string3, String string4) throws MoxieException {
        try {
            Class.forName(string4).newInstance();
            con = DriverManager.getConnection(string, string2, string3);
            Documents.createDb();
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized List<Document> list() throws MoxieException {
        try {
            if (listSQL == null) {
                listSQL = con.prepareStatement("SELECT * FROM DOCUMENTS");
            }
            ArrayList<Document> arrayList = new ArrayList<Document>();
            ResultSet resultSet = listSQL.executeQuery();
            while (resultSet.next()) {
                Document document = Documents.fromResultSet(resultSet);
                arrayList.add(document);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized Document findByFileName(String string) throws MoxieException {
        try {
            if (findByFileNameSQL == null) {
                findByFileNameSQL = con.prepareStatement("SELECT * FROM DOCUMENTS WHERE file_name=?");
            }
            findByFileNameSQL.setString(1, string);
            ResultSet resultSet = findByFileNameSQL.executeQuery();
            if (!resultSet.next()) {
                return null;
            }
            Document document = Documents.fromResultSet(resultSet);
            return document;
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized Document findByID(int n) throws MoxieException {
        try {
            if (findByIDSQL == null) {
                findByIDSQL = con.prepareStatement("SELECT * FROM DOCUMENTS WHERE ID=?");
            }
            findByIDSQL.setInt(1, n);
            ResultSet resultSet = findByIDSQL.executeQuery();
            if (!resultSet.next()) {
                return null;
            }
            Document document = Documents.fromResultSet(resultSet);
            return document;
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized Document newItem(Document document) throws MoxieException {
        try {
            if (newItemSQL == null) {
                newItemSQL = con.prepareStatement("INSERT INTO DOCUMENTS (file_name, created_on, last_updated, content) VALUES (?, ?, ?, ?)");
            }
            if (Documents.exists(document.getFileName())) {
                throw new MoxieException("The document '" + document.getFileName() + "' already exists");
            }
            newItemSQL.setString(1, document.getFileName());
            Timestamp timestamp = new Timestamp(document.getCreatedOn());
            Timestamp timestamp2 = new Timestamp(document.getLastUpdated());
            newItemSQL.setTimestamp(2, timestamp);
            newItemSQL.setTimestamp(3, timestamp2);
            newItemSQL.setString(4, document.getContent());
            newItemSQL.executeUpdate();
            Document document2 = Documents.findByFileName(document.getFileName());
            document2.setOrigId(document.getId());
            return document2;
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized void deleteItem(Document document) throws MoxieException {
        Documents.deleteItem(document.getId());
    }

    public static synchronized void deleteItem(int n) throws MoxieException {
        try {
            if (deleteItemSQL == null) {
                deleteItemSQL = con.prepareStatement("DELETE FROM DOCUMENTS WHERE ID = ?");
            }
            deleteItemSQL.setInt(1, n);
            deleteItemSQL.executeUpdate();
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized void updateItem(Document document) throws MoxieException {
        try {
            if (updateItemSQL == null) {
                updateItemSQL = con.prepareStatement("UPDATE DOCUMENTS SET file_name = ?, created_on = ?, last_updated = ?, content = ? WHERE id = ?");
            }
            if (!Documents.exists(document.getId())) {
                return;
            }
            Document document2 = Documents.findByFileName(document.getFileName());
            if (document2 != null && document2.getFileName().equals(document.getFileName()) && document2.getId() != null && document.getId() != null && !document2.getId().equals(document.getId())) {
                throw new MoxieException("A different document with the file name '" + document.getFileName() + "' already exists");
            }
            updateItemSQL.setString(1, document.getFileName());
            Timestamp timestamp = new Timestamp(document.getCreatedOn());
            Timestamp timestamp2 = new Timestamp(document.getLastUpdated());
            updateItemSQL.setTimestamp(2, timestamp);
            updateItemSQL.setTimestamp(3, timestamp2);
            updateItemSQL.setString(4, document.getContent());
            updateItemSQL.setInt(5, document.getId());
            updateItemSQL.executeUpdate();
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    public static synchronized boolean exists(String string) throws MoxieException {
        Document document = Documents.findByFileName(string);
        return document != null;
    }

    public static synchronized boolean exists(int n) throws MoxieException {
        Document document = Documents.findByID(n);
        return document != null;
    }

    private static Document fromResultSet(ResultSet resultSet) throws MoxieException {
        try {
            int n = resultSet.getInt("id");
            String string = resultSet.getString("file_name");
            String string2 = resultSet.getString("content");
            long l = resultSet.getTimestamp("created_on").getTime();
            long l2 = resultSet.getTimestamp("last_updated").getTime();
            Document document = new Document(n, string, l, l2, string2);
            return document;
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    private static void createDb() throws MoxieException {
        try {
            Statement statement = con.createStatement();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, "DOCUMENTS", null);
            boolean bl = false;
            if (resultSet.next()) {
                bl = true;
            }
            if (bl) {
                return;
            }
            statement.execute("CREATE TABLE DOCUMENTS (id               INT GENERATED BY DEFAULT AS IDENTITY NOT NULL, file_name        VARCHAR(255) NOT NULL, created_on       TIMESTAMP NOT NULL, last_updated     TIMESTAMP NOT NULL, content          CLOB(500K) NOT NULL, PRIMARY KEY(id), UNIQUE(file_name) )");
            statement.execute("INSERT INTO DOCUMENTS (file_name, created_on, last_updated, content) VALUES ('message', CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'Watson, come quickly!')");
            statement.execute("INSERT INTO DOCUMENTS (file_name, created_on, last_updated, content) VALUES ('message2', CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'Hello World!')");
            statement.execute("INSERT INTO DOCUMENTS (file_name, created_on, last_updated, content) VALUES ('message3', CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'Goodbye World!')");
            statement.execute("INSERT INTO DOCUMENTS (file_name, created_on, last_updated, content) VALUES ('message4', CURRENT TIMESTAMP, CURRENT TIMESTAMP, 'Brad Neuberg was here')");
        }
        catch (Exception exception) {
            throw new MoxieException(exception);
        }
    }

    static {
        listSQL = null;
        findByFileNameSQL = null;
        findByIDSQL = null;
        newItemSQL = null;
        deleteItemSQL = null;
        updateItemSQL = null;
    }
}

