/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.util.JSONDynaClass;
import net.sf.json.util.JSONUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class JSONDynaBean
implements DynaBean,
Serializable {
    private static final long serialVersionUID = -8287401671998903440L;
    protected JSONDynaClass dynaClass;
    protected Map dynaValues = new HashMap();
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public boolean contains(String name, String key) {
        DynaProperty dynaProperty;
        Class type;
        if (!(class$java$util$Map == null ? (class$java$util$Map = JSONDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type = (dynaProperty = this.getDynaProperty(name)).getType())) {
            throw new JSONException("Non-Mapped property name: " + name + " key: " + key);
        }
        Object value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        return ((Map)value).containsKey(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONDynaBean)) {
            return false;
        }
        JSONDynaBean other = (JSONDynaBean)obj;
        EqualsBuilder builder = new EqualsBuilder().append((Object)this.dynaClass, (Object)other.dynaClass);
        DynaProperty[] props = this.dynaClass.getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty prop = props[i];
            builder.append(this.dynaValues.get(prop.getName()), this.dynaValues.get(prop.getName()));
        }
        return builder.isEquals();
    }

    public Object get(String name) {
        Object value = this.dynaValues.get(name);
        if (value != null) {
            return value;
        }
        Class type = this.getDynaProperty(name).getType();
        if (!type.isPrimitive()) {
            return value;
        }
        return JSONUtils.getMorpherRegistry().morph(type, value);
    }

    public Object get(String name, int index) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!type.isArray() && !(class$java$util$List == null ? (class$java$util$List = JSONDynaBean.class$("java.util.List")) : class$java$util$List).isAssignableFrom(type)) {
            throw new JSONException("Non-Indexed property name: " + name + " index: " + index);
        }
        Object value = this.dynaValues.get(name);
        if (value.getClass().isArray()) {
            value = Array.get(value, index);
        } else if (value instanceof List) {
            value = ((List)value).get(index);
        }
        return value;
    }

    public Object get(String name, String key) {
        DynaProperty dynaProperty;
        Class type;
        if (!(class$java$util$Map == null ? (class$java$util$Map = JSONDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type = (dynaProperty = this.getDynaProperty(name)).getType())) {
            throw new JSONException("Non-Mapped property name: " + name + " key: " + key);
        }
        Object value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        return ((Map)value).get(key);
    }

    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.dynaClass);
        DynaProperty[] props = this.dynaClass.getDynaProperties();
        for (int i = 0; i < props.length; ++i) {
            DynaProperty prop = props[i];
            builder.append(this.dynaValues.get(prop.getName()));
        }
        return builder.toHashCode();
    }

    public void remove(String name, String key) {
        DynaProperty dynaProperty;
        Class type;
        if (!(class$java$util$Map == null ? (class$java$util$Map = JSONDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type = (dynaProperty = this.getDynaProperty(name)).getType())) {
            throw new JSONException("Non-Mapped property name: " + name + " key: " + key);
        }
        Object value = this.dynaValues.get(name);
        if (value == null) {
            value = new HashMap();
            this.dynaValues.put(name, value);
        }
        ((Map)value).remove(key);
    }

    public void set(String name, int index, Object value) {
        DynaProperty dynaProperty = this.getDynaProperty(name);
        Class type = dynaProperty.getType();
        if (!type.isArray() && !(class$java$util$List == null ? (class$java$util$List = JSONDynaBean.class$("java.util.List")) : class$java$util$List).isAssignableFrom(type)) {
            throw new JSONException("Non-Indexed property name: " + name + " index: " + index);
        }
        Object prop = this.dynaValues.get(name);
        if (prop == null) {
            prop = (class$java$util$List == null ? (class$java$util$List = JSONDynaBean.class$("java.util.List")) : class$java$util$List).isAssignableFrom(type) ? new ArrayList() : Array.newInstance(type.getComponentType(), index + 1);
            this.dynaValues.put(name, prop);
        }
        if (prop.getClass().isArray()) {
            if (index >= Array.getLength(prop)) {
                Object tmp = Array.newInstance(type.getComponentType(), index + 1);
                System.arraycopy(prop, 0, tmp, 0, Array.getLength(prop));
                prop = tmp;
                this.dynaValues.put(name, tmp);
            }
            Array.set(prop, index, value);
        } else if (prop instanceof List) {
            List l = (List)prop;
            if (index >= l.size()) {
                for (int i = l.size(); i <= index + 1; ++i) {
                    l.add(null);
                }
            }
            ((List)prop).set(index, value);
        }
    }

    public void set(String name, Object value) {
        DynaProperty property = this.getDynaProperty(name);
        if (value == null || !this.isDynaAssignable(property.getType(), value.getClass())) {
            value = JSONUtils.getMorpherRegistry().morph(property.getType(), value);
        }
        this.dynaValues.put(name, value);
    }

    public void set(String name, String key, Object value) {
        DynaProperty dynaProperty;
        Class type;
        if (!(class$java$util$Map == null ? (class$java$util$Map = JSONDynaBean.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type = (dynaProperty = this.getDynaProperty(name)).getType())) {
            throw new JSONException("Non-Mapped property name: " + name + " key: " + key);
        }
        Object prop = this.dynaValues.get(name);
        if (prop == null) {
            prop = new HashMap();
            this.dynaValues.put(name, prop);
        }
        ((Map)prop).put(key, value);
    }

    public synchronized void setDynaBeanClass(JSONDynaClass dynaClass) {
        if (this.dynaClass == null) {
            this.dynaClass = dynaClass;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append((Object)this.dynaValues).toString();
    }

    protected DynaProperty getDynaProperty(String name) {
        DynaProperty property = this.getDynaClass().getDynaProperty(name);
        if (property == null) {
            throw new JSONException("Unspecified property for " + name);
        }
        return property;
    }

    protected boolean isDynaAssignable(Class dest, Class src) {
        boolean assignable = dest.isAssignableFrom(src);
        if (assignable) {
            return true;
        }
        boolean bl = dest == Boolean.TYPE && src == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONDynaBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (assignable = assignable);
        boolean bl2 = dest == Byte.TYPE && src == (class$java$lang$Byte == null ? (class$java$lang$Byte = JSONDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte) ? true : (assignable = assignable);
        boolean bl3 = dest == Character.TYPE && src == (class$java$lang$Character == null ? (class$java$lang$Character = JSONDynaBean.class$("java.lang.Character")) : class$java$lang$Character) ? true : (assignable = assignable);
        boolean bl4 = dest == Short.TYPE && src == (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short) ? true : (assignable = assignable);
        boolean bl5 = dest == Integer.TYPE && src == (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer) ? true : (assignable = assignable);
        boolean bl6 = dest == Long.TYPE && src == (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long) ? true : (assignable = assignable);
        boolean bl7 = dest == Float.TYPE && src == (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float) ? true : (assignable = assignable);
        boolean bl8 = dest == Double.TYPE && src == (class$java$lang$Double == null ? (class$java$lang$Double = JSONDynaBean.class$("java.lang.Double")) : class$java$lang$Double) ? true : (assignable = assignable);
        if (src == Double.TYPE || (class$java$lang$Double == null ? (class$java$lang$Double = JSONDynaBean.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(src)) {
            boolean bl9 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) || this.isFloat(dest) ? true : assignable;
        }
        if (src == Float.TYPE || (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(src)) {
            boolean bl10 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) || this.isLong(dest) ? true : assignable;
        }
        if (src == Long.TYPE || (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(src)) {
            boolean bl11 = assignable = this.isByte(dest) || this.isShort(dest) || this.isInteger(dest) ? true : assignable;
        }
        if (src == Integer.TYPE || (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(src)) {
            boolean bl12 = assignable = this.isByte(dest) || this.isShort(dest) ? true : assignable;
        }
        if (src == Short.TYPE || (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(src)) {
            assignable = this.isByte(dest) ? true : assignable;
        }
        return assignable;
    }

    private boolean isByte(Class clazz) {
        return (class$java$lang$Byte == null ? (class$java$lang$Byte = JSONDynaBean.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || clazz == Byte.TYPE;
    }

    private boolean isFloat(Class clazz) {
        return (class$java$lang$Float == null ? (class$java$lang$Float = JSONDynaBean.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || clazz == Float.TYPE;
    }

    private boolean isInteger(Class clazz) {
        return (class$java$lang$Integer == null ? (class$java$lang$Integer = JSONDynaBean.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || clazz == Integer.TYPE;
    }

    private boolean isLong(Class clazz) {
        return (class$java$lang$Long == null ? (class$java$lang$Long = JSONDynaBean.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || clazz == Long.TYPE;
    }

    private boolean isShort(Class clazz) {
        return (class$java$lang$Short == null ? (class$java$lang$Short = JSONDynaBean.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || clazz == Short.TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

