<?php
// ======================================================================
// RuPhoto by Addax (C) 2007.
// Todos los derechos estan reservados por Addax.
// ======================================================================

/** =====================================================================
 * Módulo: RuPhoto application
 * 
 * Función de Smarty para construir urls de postnuke
 *
 * Ejemplo: <!--[websigadminlinks start="[" end="]" seperator="|" class="pn-menuitem-title"]-->
 *
 * @package      Addax_Modules
 * @subpackage   RuPhoto
 * @author       Addax Software Development, S.A.
 * @param        array       $params      Arreglo que contiente todos los parametros de la función:
 *                                        $start    Cadena de inicio
 *                                        $end      Cadena de finalización
 *                                        $seperator Separador de los links
 *                                        $class    Clase CSS
 * @param        object      &$smarty     Referencia al objeto Smarty
 * @return       string      Código HTML de despliegue.
 *
 * ======================================================================
 */ 
function smarty_function_zendurl($params, &$smarty) 
{
     extract($params);
	unset($params['module']);
	unset($params['type']);
	unset($params['func']);
	unset($params['ssl']);
	unset($params['assign']);
	unset($params['controller']);

    if (!isset($module)) {
        $smarty->trigger_error('pnmodurl: attribute module required');
        return false;
    }

    if (!isset($type)) {
        $type = 'user';
    }

    if (!isset($func)) {
        $func = 'index';
    }
	
	if (!isset($controller)) {
        $controller = 'Index';
    }

    $ssl = (isset($ssl) && is_bool($ssl)) ? $ssl : NULL;

    
	//$result = pnZendPopupURL($module, 'Index', $func, $params, $ssl);
	$result = pnZendPopupURL($module, $controller, $func, $params, $ssl);
    if (isset($assign)) {
        $smarty->assign($assign, $result);
    } else {
        return pnVarPrepForDisplay($result);
    }

}
?>