<?php


/**
 * @see Zend_Controller_Action_Helper_Abstract
 */
require_once 'Zend/Controller/Action/Helper/Abstract.php';

/**
 * Addax Crud for tables
 */
class Addax_Controller_Action_Helper_AddaxCRUD extends Zend_Controller_Action_Helper_Abstract
{
    /**
     * @var Zend_Controller_Plugin_ActionStack
     */
    protected $_addaxcrud;

    /**
     * Constructor
     *
     * Register action stack plugin
     * 
     * @return void
     */
    public function __construct()
    {
        Zend_Loader::loadClass('AddaxCRUD');
    }
	
	/**
     * Preparea an object for table crud
     */
	public function prepareTable($tablename, $table_desc="dummy", $table_desc_plural ="")
	{
		$this->_addaxcrud = new AddaxCRUD($tablename, $table_desc, $table_desc_plural);
		$this->_addaxcrud->setModule(ZF_MODULE);
				
		$view = Zend_Controller_Action_HelperBroker::getStaticHelper('viewRenderer')->view;
		$this->_addaxcrud->setView($view);
		$this->_addaxcrud->setTemplatePath(ZIKULA_PATH . '/includes/classes/addax/crud/crud/templates/');
		return $this->_addaxcrud;
	}


    /**
     * Perform helper when called as $this->_helper->AddaxCRUD() from an action controller
     */
    public function direct($tablename, $table_desc="dummy", $table_desc_plural ="")
    {
        return $this->prepareTable($tablename, $table_desc, $table_desc_plural);
    }
}
