<?php
require_once 'Zend/View/Interface.php'; 
 
/**
 * Adapter class
 */ 
class Addax_View_Adapter_H2O implements Zend_View_Interface 
{ 
    /**
     * Default value of directories and files
     */ 
    const CLASS_FILE_NAME      = 'h2o.php';
 
    /**
     * Error Messages
     */ 
    const INVALID_DIR    = 'Invalid directory specified.'; 
    const INVALID_NAME   = 'Invalid name specified.'; 
    const UNWRITABLE_DIR = 'Unwritable directory specified.'; 
    const NOUSES_CACHE   = 'No uses cache.'; 
 
    /**
     * Smarty instance
     *
     * @var Smarty
     */ 
    protected $_h2oContext; 
 
    /**
     * Clear Cache just before rendering
     *
     * @var boolean 
     */ 
    protected $_clearCache; 
 
    /**
     * ---------------------------------------
     * At first, implement methods extended from Zend_View_Interface
     * ---------------------------------------
     */ 
 
    /**
     * Instatiation
     *
     * @param string $workPath Template, compiled template and cache
     * directory exist under the directory if specified.
     * The directories also can be specified with setWorkPath() or
     * setScriptPath() after instanciation.
     * If you want to customize position of directories, you should use
     * setTemplatePath, setCompilePath and setCachePath instead of
     * specifing with the instanciation or setWorkPath or setScriptPath.
     * @param string $smartyDir absolute directory that the Smarty is
     * installed. It is required if the Smarty class does not exist on
     * the include_path.
     * @param integer $cacheMode false (disabled), apc  or file
     *
     * @param array $optparam option parameters.
     *
     * @return void
     * @throws Addax_View_Adapter_Exception
     * @see http://www.smarty.net/
     */
    public function __construct($workPath = null, $cachePath = null ,$h2oDir = null, $cacheMode = false, $optparam = array()) 
    { 
        if ($h2oDir !== null) 
        { 
            $h2oClassPath = $h2oDir . DIRECTORY_SEPARATOR . self::CLASS_FILE_NAME; 
            if (is_file($h2oClassPath) === false) 
            { 
                require_once 'Addax/View/Adapter/Exception.php'; 
                throw new Addax_View_Adapter_Exception('H2O is not installed.'); 
            } 
        } else { 
            $h2oClassPath = self::CLASS_FILE_NAME; 
        }
		$this->_clearCache = false;
        require_once $h2oClassPath; 
        $this->_h2oContext = new H2o_AddaxContext; 
 
        if ($cacheMode !== 0) 
        { 
            $this->_h2oContext->setCacheMode($cacheMode); 
        } 
 
        if ($workPath !== null) 
        { 
            $this->_h2oContext->setSearchPath($workPath); 
        } 
 
        if ($optparam !== array()) 
        { 
            $this->_h2oContext->setOptions($optparam); 
        }
    }
	
	/**
     * Return the Smarty instance
     *
     * @return Smarty
     */ 
    public function getEngine() 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    }
	
	/**
     * Set parent of the path to work path.
     * As a result, set the path to template path.
     *
     * @param string $path template path.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setScriptPath($path) 
    { 
        $workPath = dirname($path); 
        if ($workPath === '.') 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::INVALID_DIR); 
        } 
 
        $this->_h2oContext->setSearchPath($workPath); 
    } 
 
    /**
     * Retrieve the current template path
     *
     * @return array
     */ 
    public function getScriptPaths() 
    {
		error_log(__METHOD__ . "::getSearchPath=" . $this->_h2oContext->getSearchPath());
        return array($this->_h2oContext->getSearchPath());
    }
	
	/**
     * Set parent of the path to work path.
     * As a result, set the path to template path.
     *
     * @param string $path
     * @param string $prefix
     * @return void
     */ 
    public function setBasePath($path, $prefix = 'Zend_View') 
    { 
        $this->setScriptPath($path); 
    } 
 
    /**
     * Add path
     *
     * @param string $path
     * @param string $prefix
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function addBasePath($path, $prefix = 'Zend_View') 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
        throw new Addax_View_Adapter_Exception('Can not add path. Path='.$path); 
    } 
 
    /**
     * Assign a variable to the template
     *
     * @param string $key variable name.
     * @param mixed $val variable value.
     * @return void
     */ 
    public function __set($key, $val) 
    { 
        $this->_h2oContext->set($key, $val); 
    } 
 
    /**
     * Allows testing with empty() and isset() to work
     *
     * @param string $key variable name.
     * @return boolean
     */ 
    public function __isset($key) 
    { 
        return $this->_h2oContext->isDefined($key); 
    } 
 
    /**
     * Allows unset() on object properties to work
     *
     * @param string $key variable name.
     * @return void
     */ 
    public function __unset($key) 
    {
        return $this->_h2oContext->__unset($key); 
    } 
 
    /**
     * Assign variables to the template
     *
     * Allows setting a specific key to the specified value, OR passing an array
     * of key => value pairs to set en masse.
     *
     * @see __set()
     * @param string|array $spec The assignment strategy to use (key or array of key
     * => value pairs)
     * @param mixed $value (Optional) If assigning a named variable, use this
     * as the value.
     * @return void
     */ 
    public function assign($spec, $value = null) 
    { 
        if (is_array($spec)) 
        {
			foreach($spec as $key=>$val)
			{
				$this->_h2oContext->set($key, $val);
			}
            return; 
        } 
 
 
        $this->_h2oContext->set($spec, $value); 
    } 
 
    /**
     * Clear all assigned variables
     *
     * @return void
     */ 
    public function clearVars() 
    { 
        return $this->_h2oContext->clearScopes(); 
    } 
 
    /**
     * Processes a template and display.
     *
     * @see output($name)
     * @param string $name template to process.
     * @return void.
     */ 
    public function render($name) 
    { 
        echo $this->output($name);
    } 
 
    /**
     * Processes a template and returns the output string.
     *
     * @see render($name)
     * @param string $name template to process.
     * @return string
     */ 
    public function output($name) 
    { 
        $h2o = new H2o($name, $this->_h2oContext->getOptions());
		$h2o->set($this->_h2oContext);
		$output = $h2o->render();
		
		return $output;
    } 
 
    /**
     * ---------------------------------------
     * At seconde, implement methods as like Zend_View_Abstract
     * ---------------------------------------
     */ 
 
    /**
     * Retrieve a variable from the template
     *
     * @param string $key variable name.
     * @return mixed $val variable value.
     */ 
    public function &__get($key) 
    { 
        return $this->_h2oContext->get($key); 
    } 
 
    /**
     * Retrieve variables from the template
     *
     * @return array
     */ 
    public function getVars() 
    { 
        return $this->_h2oContext->getScopes(); 
    } 
 
    /**
     * ---------------------------------------
     * At last, implement own methods of this class
     * ---------------------------------------
     */ 
 
    /**
     * Set work path
     *
     * @param string $path work path. Directories exist
     *  under the path.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setWorkPath($path) 
    { 
        if (is_dir($path) === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::INVALID_DIR); 
        } 
        $this->_h2oContext->setSearchPath($path); 
    } 
 
    /**
     * Retrieve the work path
     *
     * @return string
     */ 
    public function getWorkPath() 
    { 
        return $this->_h2oContext->getSearchPath();
    }
 
    /**
     * Retrieve the current template path
     *
     * @return string
     */ 
    public function getScriptPath() 
    { 
        return $this->_h2oContext->getSearchPath();
    } 
 
    /**
     * Set the path to the template path
     *
     * @param string $path template path.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setTemplatePath($path) 
    { 
        return $this->_h2oContext->setSearchPath($path);
    } 
 
    /**
     * Retrieve the current template path
     *
     * @return string
     */ 
    public function getTemplatePath() 
    { 
        return $this->_h2oContext->getSearchPath();
    }
	
	/**
     * Set the path to the compiled template path
     *
     * @param string $path compiled template path.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setCompilePath($path) 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    } 
 
    /**
     * Retrieve the current compiled template path
     *
     * @return string
     */ 
    public function getCompilePath() 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    } 
 
    /**
     * Set the path to the cache path
     *
     * @param string $path cache path.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setCachePath($path) 
    { 
        if (is_dir($path) === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::INVALID_DIR); 
        } 
 
        if (is_writable($path) === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::UNWRITABLE_DIR); 
        } 
 
        $this->_h2oContext->setCacheDir($path); 
    } 
 
    /**
     * Retrieve the current cache path
     *
     * @return string
     */ 
    public function getCachePath() 
    { 
        return $this->_h2oContext->getCacheDir();
    }
	
	    /**
     * Set the path to the configuration path
     *
     * @param string $path configuration path
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setConfigPath($path) 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    } 
 
    /**
     * Retrieve the current configuration path
     *
     * @return string
     */ 
    public function getConfigPath() 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    } 
 
    /**
     * Set the mode to the cache mode
     *
     * @param string $mode cache mode.
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setCacheMode($mode) 
    { 
        if (in_array($mode, array(false, 'apc', 'file')) === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Invalid cache mode specified.'); 
        } else {
            $this->_h2oContext->setCacheMode($mode);
        } 
    } 
 
    /**
     * Retrieve the cache mode
     *
     * @return string
     * @throws Addax_View_Adapter_Exception
     */ 
    public function getCacheMode() 
    {
        return $this->_h2oContext->getCacheMode($mode);; 
    } 
 
    /**
     * Set the properties of Smarty
     *
     * @param array $properties properties of Smarty (name => value)
     * @return void
     */ 
    public function setProperties($properties = array()) 
    {
		$this->_h2oContext->setOptions($properties);
    } 
 
    /**
     * Set the value to property of Smarty
     *
     * @param string $key property name
     * @param mixed $value property value
     * @return void
     * @throws Addax_View_Adapter_Exception
     */ 
    public function setProperty($key, $value) 
    { 
		$this->_h2oContext->setOption($key, $value);
    } 
 
    /**
     * Retrieve the properties of Smarty
     *
     * @return array
     */ 
    public function getProperties() 
    { 
        return $this->_h2oContext->getOptions();
    } 
 
    /**
     * Retrieve the property of Smarty
     *
     * @param string $key property name
     * @return string|array
     * @throws Addax_View_Adapter_Exception
     */ 
    public function getProperty($key) 
    { 
		$result = $this->_h2oContext->getOption($key);
        if($result === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::INVALID_NAME); 
        } 
        return $result; 
    } 
 
    /**
     * Retrieve whether or not the template is cached
     *
     * @param string $name template name
     * @return string|false
     */ 
    public function isCached($name) 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    }
 
	/**
     * Clear compiled template
     *
     * @param string $name template name
     * @param string $time expiration time (second)
     * @return boolean
     */ 
    public function clearCompiledTemplate($name = null, $time = null) 
    { 
        require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception('Not implemented yet'); 
    } 
	
    /**
     * Clear cached template
     *
     * @param string $name template name
     * @param string $time expiration time (second)
     * @return boolean
     */ 
    public function clearCachedTemplate() 
    { 
        if ($this->_h2oContext->getCacheMode() === false) 
        { 
            require_once 'Addax/View/Adapter/Exception.php'; 
            throw new Addax_View_Adapter_Exception(self::NOUSES_CACHE); 
        } 
		$this->_clearCache = true;
    } 
} 
?>
