<?php
/**
 * @source
 * @author Addax Software
 * @package VisorMedicionesCalidad
 * @uses cbSQLConnect.class
 * @uses cbSQLConnect.class
 * @uses Utils
 * @uses Utils
 */

require_once('CyberMySQLPDO/cbSQLConnect.class.php');

require_once('UtilsMap.php');
/**
 * BDHelper Clase que realiza operaciones comunes de base de datos para el visor de graficos y gauge.
 *
 * @source
 * @author Addax Software
 */
class BDHelper {
    /**
     * @var object Objeto de conexión a la base de datos.
     */
    private $database;
    /**
     * @var string Nombre base de la tabla de medición a utilizar
     */
    private $tablamedicionBASE;
    /**
     * @var string nombre de la tabla medicióna utilizar.
     */
    private $tablamedicion;

    /**
     * Constructor de la clase.
     *
     * @uses self::$database
     * @uses self::$tablamedicionBASE
     * @uses self::$tablamedicion
     * @uses Utils::getDBConnection()
     * @return void
     */
    public function __construct() {


        $this->database =UtilsMap::getDBConnection();


    }
    /**
     * Destructor de la clase.
     *
     * @uses self::$database
     * @return void
     */
    function __destruct() {

        $this->database = null;unset($this->database);
    }


    public function getActividades(){


        $sqlconsulta = <<<EOD

            SELECT
                id, rubro_id, nombre, nombre_combo

            FROM  sem_actividad
            WHERE habilitado = 1
            ORDER BY codigo
EOD;
//echo $sqlconsulta; die;
        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results;
        }else{
            return false;
        }
    }

    public function getRiesgos(){


        $sqlconsulta = <<<EOD

            SELECT
                id, nombre

            FROM  sem_categoria_riesgo
EOD;
//echo $sqlconsulta; die;
        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results;
        }else{
            return false;
        }
    }

    public function getRubros(){


        $sqlconsulta = <<<EOD

        SELECT
            r.id, r.codigo, r.clase_id, r.nombre

        FROM  sem_rubros r
            INNER JOIN sem_clase c ON c.id = r.clase_id
            INNER JOIN sem_tipo t ON t.id = c.tipo_id

        WHERE r.habilitado = 1
            AND t.codigo = 1
EOD;
//echo $sqlconsulta; die;
        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results;
        }else{
            return false;
        }
    }

    public function getCategoriasBovinos(){


        $sqlconsulta = <<<EOD

            SELECT
                id, nombre, nombredespliegue

            FROM  sem_categoria_bovinos
EOD;
//echo $sqlconsulta; die;
        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results;
        }else{
            return false;
        }
    }

    public function getPresetsEnfermedades(){


        $sqlconsulta = <<<EOD

            SELECT
                id, nombre, valores

            FROM   sem_presets_enfermedades
            WHERE habilitado = 1
EOD;
//echo $sqlconsulta; die;
        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results;
        }else{
            return false;
        }
    }
}