<?php
/**
 *
 * @author Addax Software
 * @see CurlHandler
 * @uses CurlHandler
 */

/**
 * CurlHandler Clase CurlHandler que ejecuta operaciones de CURL (llamados html, post, get, etc)
 *
 * CurlHandler Clase CurlHandler que ejecuta operaciones de CURL (llamados html, post, get, etc)
 *
 * @source
 * @author Addax Software
 */
class CurlHandler
{

    //Funcion especifica para manejo de geonetworks. POST implica intentear agregar algo. Workspace, Store, Layer, etc.
    /*
     * Ejemplo de postdata
     * Crear un Workspace: <workspace><name>test_ws</name></workspace>
     */

    /**
     * Realiza una petici�n en modo POST hacia un url
     *
     * @param string $url URL al cual hacer el llamado POST
     * @param string $postdata Hilera con los datos a enviar al URL
     * @param string $header Hilera con encabezados opcionales
     *
     * @return bool true en caso de �xito, false en caso de error.
     */
    public static function Post($url, $postdata, $header = null){
        $logfh = fopen(CURLLOGS, 'w');
        $ch = curl_init($url);

        // Optional settings for debugging
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //option to return string
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_STDERR, $logfh); // logs curl messages

        //Required POST request settings
        curl_setopt($ch, CURLOPT_POST, True);
        $passwordStr = GEOSERVERUSER .":".GEOSERVERPASS; // replace with your username:password

        curl_setopt($ch, CURLOPT_USERPWD, $passwordStr);

        //POST data
        if(empty($header) ){
            $header =    array("Content-type: application/xml");
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $xmlStr = $postdata;
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlStr);

        //POST return code
        $successCode = 201;

        $buffer = curl_exec($ch); // Execute the curl request

        $resultado = false;
        // Check for errors and process results
        $info = curl_getinfo($ch);
        if ($info['http_code'] != $successCode) {
            $resultado = false;

            $msgStr = "# Unsuccessful cURL request to ";
            $msgStr .= $url." [". $info['http_code']. "]\n";
            error_log( $msgStr);
        } else {
            $resultado = true;
            $msgStr = "# Successful cURL request to ".$url."\n";
            error_log( $msgStr);
        }
        error_log( $buffer."\n");

        curl_close($ch); // free resources if curl handle will not be reused
        fclose($logfh);
        return $resultado;
    }

    /**
     * Realiza una petici�n en modo PUT hacia un url
     *
     * @param string $url URL al cual hacer el llamado PUT
     * @param string $postdata Hilera con los datos a enviar al URL
     * @param string $header Hilera con encabezados opcionales
     *
     * @return bool true en caso de �xito, false en caso de error.
     */
    public static function Put($url, $postdata, $header = null){
        $logfh = fopen(CURLLOGS, 'w');
        $ch = curl_init($url);

        // Optional settings for debugging
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //option to return string
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_STDERR, $logfh); // logs curl messages

        //Required POST request settings
        //curl_setopt($ch, CURLOPT_PUT, True);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        $passwordStr = GEOSERVERUSER .":".GEOSERVERPASS; // replace with your username:password
        curl_setopt($ch, CURLOPT_USERPWD, $passwordStr);

        //POST data
        if(empty($header) ){
            $header =    array("Content-type: application/xml");
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $xmlStr = $postdata;
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlStr);

        //POST return code
        $successCode = 201;

        $buffer = curl_exec($ch); // Execute the curl request

        $resultado = false;
        // Check for errors and process results
        $info = curl_getinfo($ch);
        if ($info['http_code'] != $successCode) {
            $resultado = false;

            $msgStr = "# Unsuccessful cURL request to ";
            $msgStr .= $url." [". $info['http_code']. "]\n";
            error_log( $msgStr);
        } else {
            $resultado = true;
            $msgStr = "# Successful cURL request to ".$url."\n";
            error_log( $msgStr);
        }
        error_log( $buffer."\n");

        curl_close($ch); // free resources if curl handle will not be reused
        fclose($logfh);
        return $resultado;
    }


    /**
     * Realiza una petici�n en modo GET hacia un url
     *
     * @param string $url URL al cual hacer el llamado GET
     *
     * @return string resultado de la operaci�n GET
     */
    public static function Get($url){
        $logfh = fopen(CURLLOGS, 'w');
        $ch = curl_init($url);

        // Optional settings for debugging
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //option to return string
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_STDERR, $logfh); // logs curl messages


        // Required GET request settings
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        //@curl_setopt($ch, CURLOPT_GET, True); // CURLOPT_GET is True by default

        //GET data
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Accept: application/xml"));

        //GET return code
        $successCode = 200;

        $passwordStr = GEOSERVERUSER .":".GEOSERVERPASS; // replace with your username:password
        curl_setopt($ch, CURLOPT_USERPWD, $passwordStr);



        $buffer = curl_exec($ch); // Execute the curl request

        $resultado = false;
        // Check for errors and process results
        $info = curl_getinfo($ch);
        if ($info['http_code'] != $successCode) {
            $resultado = false;

            $msgStr = "# Unsuccessful cURL request to ";
            $msgStr .= $url." [". $info['http_code']. "]\n";
            error_log( $msgStr);
        } else {
            $resultado = true;
            $msgStr = "# Successful cURL request to ".$url."\n";
            error_log( $msgStr);
        }
        error_log( $buffer."\n");

        curl_close($ch); // free resources if curl handle will not be reused
        fclose($logfh);

        return $buffer;
    }

    /**
     * Realiza una petici�n en modo GET hacia un url sin encabezados.
     *
     * @param string $url URL al cual hacer el llamado GET
     *
     * @return string resultado de la operaci�n GET
     */
    public static function RawGet($url){
        // create curl resource
        $ch = curl_init();
        // set url
        curl_setopt($ch, CURLOPT_URL, $url);
        //return the transfer as a string
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // $output contains the output string
        $output = curl_exec($ch);
        // close curl resource to free up system resources
        curl_close($ch);
        return $output;

    }



    public static $SIREA = 'SIREA';
    public static $TGRUPAL = 'TGRUPAL';

    function hacerLlamadoCurl($funcion,$_postdata = null, $sistema = 'SIREA'){
        $config = Zend_Registry::get('config');
        //$mdkey = MDKEY_CORFOGA;
        $mdkey =  $config->rutas->mdkey;
        //$rutasirea = RUTASERVIDOR_SIREA;
        //$rutatgrupal = RUTASERVIDOR_TGRUPAL;
        $rutasirea =  $config->rutas->servidorsirea;
        $rutatgrupal =  $config->rutas->servidortgrupal;

        $RUTASERVIDOR = $rutasirea;
        $subruta = 'zf_Conexion';
        if($sistema == self::$SIREA){
            $RUTASERVIDOR = $rutasirea;
            $subruta = 'zf_Conexion';
        }else{
            $RUTASERVIDOR = $rutatgrupal;
            $subruta = 'zf_Trazabilidad';
        }
        $url = $RUTASERVIDOR.$subruta."/Popup/".$funcion;
        $referer = $RUTASERVIDOR;
        $postdata = '';
        if(isset($_postdata)){
            $postdata = $_postdata."&key=".$mdkey;
        }
        error_log("Llamado CURL [$funcion] $sistema");
        $result = $this->postFormData($url, $postdata, $referer, null);
        //echo("LO OBTENIDO: [$result]");
        //echo $url; die;
        //echo $result; die;
        //echo ( "URL [$url] data: [$postdata]"); die;
        $result = $this->remove_utf8_bom($result);
        $result = $this->remove_utf8_bom($result);
        $result = $this->remove_utf8_bom($result);
        //error_log ("LO OBTENIDO: [$result] sin BOM");
        /*if($result[0]!="[" && $result[0]!="{"){
            $pos_1 = strpos($result,"[");
            $pos_2 = strpos($result,"{");
            if($pos_1 <= $pos_2){
                $result = substr($result,$pos_1);
            }else{
                $result = substr($result,$pos_2);
            }

        }*/


        //$result = substr($result,strpos($result,"["));
        //echo ("LO OBTENIDO: [". print_r($result, true));die;
        //$result = utf8_decode ($result);
        $datos = json_decode($result, true);

        //error_log ("LO OBTENIDO: [". print_r($datos, true));
        //echo ("LO OBTENIDO: [". print_r($datos, true));die;

        return $datos;
    }
    function remove_utf8_bom($text)
    {
        $bom = pack('H*','EFBBBF');
        $text = preg_replace("/^$bom/", '', $text);
        return $text;
    }


    function postFormData($url, $postData, $referer, $cookieFile=null) {
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt ($ch, CURLOPT_USERAGENT, AGENTE);
        curl_setopt ($ch, CURLOPT_TIMEOUT, 60000);
        curl_setopt ($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_REFERER, $referer);
        curl_setopt ($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt ($ch, CURLOPT_POST, true);
        curl_setopt( $ch, CURLOPT_ENCODING, "UTF-8" );
        if($cookieFile != null){
            curl_setopt ($ch, CURLOPT_COOKIEJAR, $cookieFile);
            curl_setopt ($ch, CURLOPT_COOKIEFILE, $cookieFile);
        }
        $result = curl_exec ($ch);
        curl_close($ch);
        return $result;
    }
}
