<?php


class cbSQLConnectConfig extends PDO 
{	
	 	protected $actualStatement;
		
		protected static $qs;
		protected static $user;
		protected static $pwd;
		protected static $options; 
		protected static $fetchMode;
	 	protected static $driverDB;
		
		public function __construct($driver, $host, $port = 3306, $database, $user, $pwd, $options = array()){
			
			cbSQLConnectConfig::$qs =  $this->ConnectionStringGenerator($driver, $host, $port, $database);
			cbSQLConnectConfig::$user = $user;
			cbSQLConnectConfig::$pwd = $pwd;
			cbSQLConnectConfig::$options = $options;
			
			
			parent::__construct(cbSQLConnectConfig::$qs, cbSQLConnectConfig::$user, cbSQLConnectConfig::$pwd, cbSQLConnectConfig::$options);
			
			
		}
		
		public static function CreatePDOInstance(){
			
			
			
			return new PDO( cbSQLConnectConfig::$qs,  cbSQLConnectConfig::$user,  cbSQLConnectConfig::$pwd,  cbSQLConnectConfig::$options);
			
		}
		
		protected function getConnectionString(){
			return $this->qs;
		}
		
		public function getTable(){
			
		
			preg_match("/dbname=([aA-zZ0-9]+)/", $this->qs, $mt);
			
			return $mt[1];
		
		}
		
		private  function ConnectionStringGenerator($driver, $host, $port, $database){
			
			switch( (int) $driver){
			
			 case cbSQLConnectVar::DB_MYSQL:
			 cbSQLConnectConfig::$driverDB = "mysql";
			 break;
			 
			 case cbSQLConnectVar::DB_POSTGRE:
                 cbSQLConnectConfig::$driverDB = "psgre";
                 break;
            case cbSQLConnectVar::DB_MSSQL:
                 cbSQLConnectConfig::$driverDB = "sqlsrv";
                break;
			 default:
			 cbSQLConnectConfig::$driverDB = "mysql";
			 break;
			 
			}
			
			/*
			 * host-ip: 10.4.2.50
                host-name: mssqlhost.mydomain.org
                mssql-server-name: foo-sql
                mssql-instance-name: MSSQLSERVER
                database-name: mydb
			 * $dbh = new PDO("sqlsrv:Server=foo-sql,1433;Database=mydb", $user , $pass);
			 *
			 *on Linux ppc64 / PHP 5.1.2 / freetds-0.64 works well this way:


                // ...
                $dbh = new PDO("dblib:host=$hostdb;dbname=$dbname", $usr, $psw);
                // ...

			 * $dbh = new PDO("dblib:host=$hostdb;dbname=$dbname", $usr, $psw);
			 */
            if($driver == cbSQLConnectVar::DB_MSSQL){
                $connectionstring = sprintf("sqlsrv:Server=$host,$port;Database=$database;MultipleActiveResultSets=false");
            }else{
                $connectionstring = sprintf("%s:host=%s;port=%d;dbname=%s", cbSQLConnectConfig::$driverDB, $host, $port, $database);
            }

			
			return $connectionstring;
			
			
		}

	
}




?>