<?php
/**
 *
 * @author Addax Software
 * @see CSVImporter
 * @see MedicionDatosPreparator
 * @uses CSVImporter
 * @uses MedicionDatosPreparator
 */

/**
 * DBFHandler Clase DBFHandler obtiene informacin de un archivo DBF
 *
 * DBFHandler obtiene informacin de un archivo DBF
 *
 * @source
 * @author Addax Software
 */
class DBFHandler {


    /**
     * Obtiene los datos registrados en un archivo dbf que recibe.
     *
     * @param string $dbfname Archivo DBF al cual se le lee la informacin.
     * @return array Arreglo con las filas de los registros.
     */
    public static function obtenerFilasDBF($dbfname) {
        $filas = array();
        try{


            $fdbf = fopen($dbfname,'r');
            $fields = array();
            $buf = fread($fdbf,32);
            $header=unpack( "VRecordCount/vFirstRecord/vRecordLength", substr($buf,4,8));
            //echo 'Header: '.json_encode($header).'<br/>';
            $goon = true;
            $unpackString='';
            while ($goon && !feof($fdbf)) { // read fields:
                $buf = fread($fdbf,32);
                if (substr($buf,0,1)==chr(13)) {$goon=false;} // end of field list
                else {
                    $field=unpack( "a11fieldname/A1fieldtype/Voffset/Cfieldlen/Cfielddec", substr($buf,0,18));
                    //echo 'Field: '.json_encode($field).'<br/>';
                    $unpackString.="A$field[fieldlen]$field[fieldname]/";
                    array_push($fields, $field);
                }
            }
            fseek($fdbf, $header['FirstRecord']+1); // move back to the start of the first record (after the field definitions)
            for ($i=1; $i<=$header['RecordCount']; $i++) {
                $buf = fread($fdbf,$header['RecordLength']);
                $record=unpack($unpackString,$buf);
                $filas[] = ($record);

            } //raw record
            fclose($fdbf);
        }catch(Exception $ee){

        }
        return $filas;
    }


}