<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 3/23/15
 * Time: 10:05 AM
 */
function seems_utf8($str)
{
    $length = strlen($str);
    for ($i=0; $i < $length; $i++) {
        $c = ord($str[$i]);
        if ($c < 0x80) $n = 0; # 0bbbbbbb
        elseif (($c & 0xE0) == 0xC0) $n=1; # 110bbbbb
        elseif (($c & 0xF0) == 0xE0) $n=2; # 1110bbbb
        elseif (($c & 0xF8) == 0xF0) $n=3; # 11110bbb
        elseif (($c & 0xFC) == 0xF8) $n=4; # 111110bb
        elseif (($c & 0xFE) == 0xFC) $n=5; # 1111110b
        else return false; # Does not match any model
        for ($j=0; $j<$n; $j++) { # n bytes matching 10bbbbbb follow ?
            if ((++$i == $length) || ((ord($str[$i]) & 0xC0) != 0x80))
                return false;
        }
    }
    return true;
}
function remove_accents($string) {
    if ( !preg_match('/[\x80-\xff]/', $string) )
        return $string;

    if (seems_utf8($string)) {
        $chars = array(
            // Decompositions for Latin-1 Supplement
            chr(195).chr(128) => 'A', chr(195).chr(129) => 'A',
            chr(195).chr(130) => 'A', chr(195).chr(131) => 'A',
            chr(195).chr(132) => 'A', chr(195).chr(133) => 'A',
            chr(195).chr(135) => 'C', chr(195).chr(136) => 'E',
            chr(195).chr(137) => 'E', chr(195).chr(138) => 'E',
            chr(195).chr(139) => 'E', chr(195).chr(140) => 'I',
            chr(195).chr(141) => 'I', chr(195).chr(142) => 'I',
            chr(195).chr(143) => 'I', chr(195).chr(145) => 'N',
            chr(195).chr(146) => 'O', chr(195).chr(147) => 'O',
            chr(195).chr(148) => 'O', chr(195).chr(149) => 'O',
            chr(195).chr(150) => 'O', chr(195).chr(153) => 'U',
            chr(195).chr(154) => 'U', chr(195).chr(155) => 'U',
            chr(195).chr(156) => 'U', chr(195).chr(157) => 'Y',
            chr(195).chr(159) => 's', chr(195).chr(160) => 'a',
            chr(195).chr(161) => 'a', chr(195).chr(162) => 'a',
            chr(195).chr(163) => 'a', chr(195).chr(164) => 'a',
            chr(195).chr(165) => 'a', chr(195).chr(167) => 'c',
            chr(195).chr(168) => 'e', chr(195).chr(169) => 'e',
            chr(195).chr(170) => 'e', chr(195).chr(171) => 'e',
            chr(195).chr(172) => 'i', chr(195).chr(173) => 'i',
            chr(195).chr(174) => 'i', chr(195).chr(175) => 'i',
            chr(195).chr(177) => 'n', chr(195).chr(178) => 'o',
            chr(195).chr(179) => 'o', chr(195).chr(180) => 'o',
            chr(195).chr(181) => 'o', chr(195).chr(182) => 'o',
            chr(195).chr(182) => 'o', chr(195).chr(185) => 'u',
            chr(195).chr(186) => 'u', chr(195).chr(187) => 'u',
            chr(195).chr(188) => 'u', chr(195).chr(189) => 'y',
            chr(195).chr(191) => 'y',
            // Decompositions for Latin Extended-A
            chr(196).chr(128) => 'A', chr(196).chr(129) => 'a',
            chr(196).chr(130) => 'A', chr(196).chr(131) => 'a',
            chr(196).chr(132) => 'A', chr(196).chr(133) => 'a',
            chr(196).chr(134) => 'C', chr(196).chr(135) => 'c',
            chr(196).chr(136) => 'C', chr(196).chr(137) => 'c',
            chr(196).chr(138) => 'C', chr(196).chr(139) => 'c',
            chr(196).chr(140) => 'C', chr(196).chr(141) => 'c',
            chr(196).chr(142) => 'D', chr(196).chr(143) => 'd',
            chr(196).chr(144) => 'D', chr(196).chr(145) => 'd',
            chr(196).chr(146) => 'E', chr(196).chr(147) => 'e',
            chr(196).chr(148) => 'E', chr(196).chr(149) => 'e',
            chr(196).chr(150) => 'E', chr(196).chr(151) => 'e',
            chr(196).chr(152) => 'E', chr(196).chr(153) => 'e',
            chr(196).chr(154) => 'E', chr(196).chr(155) => 'e',
            chr(196).chr(156) => 'G', chr(196).chr(157) => 'g',
            chr(196).chr(158) => 'G', chr(196).chr(159) => 'g',
            chr(196).chr(160) => 'G', chr(196).chr(161) => 'g',
            chr(196).chr(162) => 'G', chr(196).chr(163) => 'g',
            chr(196).chr(164) => 'H', chr(196).chr(165) => 'h',
            chr(196).chr(166) => 'H', chr(196).chr(167) => 'h',
            chr(196).chr(168) => 'I', chr(196).chr(169) => 'i',
            chr(196).chr(170) => 'I', chr(196).chr(171) => 'i',
            chr(196).chr(172) => 'I', chr(196).chr(173) => 'i',
            chr(196).chr(174) => 'I', chr(196).chr(175) => 'i',
            chr(196).chr(176) => 'I', chr(196).chr(177) => 'i',
            chr(196).chr(178) => 'IJ',chr(196).chr(179) => 'ij',
            chr(196).chr(180) => 'J', chr(196).chr(181) => 'j',
            chr(196).chr(182) => 'K', chr(196).chr(183) => 'k',
            chr(196).chr(184) => 'k', chr(196).chr(185) => 'L',
            chr(196).chr(186) => 'l', chr(196).chr(187) => 'L',
            chr(196).chr(188) => 'l', chr(196).chr(189) => 'L',
            chr(196).chr(190) => 'l', chr(196).chr(191) => 'L',
            chr(197).chr(128) => 'l', chr(197).chr(129) => 'L',
            chr(197).chr(130) => 'l', chr(197).chr(131) => 'N',
            chr(197).chr(132) => 'n', chr(197).chr(133) => 'N',
            chr(197).chr(134) => 'n', chr(197).chr(135) => 'N',
            chr(197).chr(136) => 'n', chr(197).chr(137) => 'N',
            chr(197).chr(138) => 'n', chr(197).chr(139) => 'N',
            chr(197).chr(140) => 'O', chr(197).chr(141) => 'o',
            chr(197).chr(142) => 'O', chr(197).chr(143) => 'o',
            chr(197).chr(144) => 'O', chr(197).chr(145) => 'o',
            chr(197).chr(146) => 'OE',chr(197).chr(147) => 'oe',
            chr(197).chr(148) => 'R',chr(197).chr(149) => 'r',
            chr(197).chr(150) => 'R',chr(197).chr(151) => 'r',
            chr(197).chr(152) => 'R',chr(197).chr(153) => 'r',
            chr(197).chr(154) => 'S',chr(197).chr(155) => 's',
            chr(197).chr(156) => 'S',chr(197).chr(157) => 's',
            chr(197).chr(158) => 'S',chr(197).chr(159) => 's',
            chr(197).chr(160) => 'S', chr(197).chr(161) => 's',
            chr(197).chr(162) => 'T', chr(197).chr(163) => 't',
            chr(197).chr(164) => 'T', chr(197).chr(165) => 't',
            chr(197).chr(166) => 'T', chr(197).chr(167) => 't',
            chr(197).chr(168) => 'U', chr(197).chr(169) => 'u',
            chr(197).chr(170) => 'U', chr(197).chr(171) => 'u',
            chr(197).chr(172) => 'U', chr(197).chr(173) => 'u',
            chr(197).chr(174) => 'U', chr(197).chr(175) => 'u',
            chr(197).chr(176) => 'U', chr(197).chr(177) => 'u',
            chr(197).chr(178) => 'U', chr(197).chr(179) => 'u',
            chr(197).chr(180) => 'W', chr(197).chr(181) => 'w',
            chr(197).chr(182) => 'Y', chr(197).chr(183) => 'y',
            chr(197).chr(184) => 'Y', chr(197).chr(185) => 'Z',
            chr(197).chr(186) => 'z', chr(197).chr(187) => 'Z',
            chr(197).chr(188) => 'z', chr(197).chr(189) => 'Z',
            chr(197).chr(190) => 'z', chr(197).chr(191) => 's',
            // Euro Sign
            chr(226).chr(130).chr(172) => 'E',
            // GBP (Pound) Sign
            chr(194).chr(163) => '');

        $string = strtr($string, $chars);
    } else {
        // Assume ISO-8859-1 if not UTF-8
        $chars['in'] = chr(128).chr(131).chr(138).chr(142).chr(154).chr(158)
            .chr(159).chr(162).chr(165).chr(181).chr(192).chr(193).chr(194)
            .chr(195).chr(196).chr(197).chr(199).chr(200).chr(201).chr(202)
            .chr(203).chr(204).chr(205).chr(206).chr(207).chr(209).chr(210)
            .chr(211).chr(212).chr(213).chr(214).chr(216).chr(217).chr(218)
            .chr(219).chr(220).chr(221).chr(224).chr(225).chr(226).chr(227)
            .chr(228).chr(229).chr(231).chr(232).chr(233).chr(234).chr(235)
            .chr(236).chr(237).chr(238).chr(239).chr(241).chr(242).chr(243)
            .chr(244).chr(245).chr(246).chr(248).chr(249).chr(250).chr(251)
            .chr(252).chr(253).chr(255);

        $chars['out'] = "EfSZszYcYuAAAAAACEEEEIIIINOOOOOOUUUUYaaaaaaceeeeiiiinoooooouuuuyy";

        $string = strtr($string, $chars['in'], $chars['out']);
        $double_chars['in'] = array(chr(140), chr(156), chr(198), chr(208), chr(222), chr(223), chr(230), chr(240), chr(254));
        $double_chars['out'] = array('OE', 'oe', 'AE', 'DH', 'TH', 'ss', 'ae', 'dh', 'th');
        $string = str_replace($double_chars['in'], $double_chars['out'], $string);
    }

    return $string;
}

class DataProcessorCultura {

    public static $HISTORICO_CORTEANUAL = 'cortesanno';
    public static $HISTORICO_ACTIVOSANUAL = 'activosanno';
    public static $URL_TODOS = 'http://dev-sicultura.gotpantheon.com/api/fichas/todos';
    public static $URL_FICHA = 'http://dev-sicultura.gotpantheon.com/api/ficha/';
    public static $WS_CULTURA = 'Cultura';
    public static $STORE_CULTURA = 'Cultura';

    public static $CRBOUNDINGBOX = array(
'minx' =>307192.73816646065
,'maxx' =>653148.3818874996
,'miny' =>918371.0526256651
,'maxy' =>1238311.4951200902
,'crs' =>"EPSG:5367"


);

public static $CRBOUNDINGBOX_WGS84 = array(
'minx' =>-87.14733163636207
,'maxx' =>5.4984164817046866
,'miny' =>-82.54513296247748
,'maxy' =>11.224108378357286
,'crs' =>"EPSG:4326"


);
    private $conn = false;//Conexion a la bd doctrine raw (PDO)
    public function __construct(){
        Zend_Loader::loadClass('GeonetworksHandler');
        Zend_Loader::loadClass('CurlHandler');
        Zend_Loader::loadClass('GeoserverWrapper');


        $this->config = Zend_Registry::get('config');
        $this->_temporaryRepository = $this->config->repository->temporaryrepository;
        $this->_ChunksPath = $this->config->repository->chunks->path;

        $this->directorio_temporales = $this->config->repository->temporaryrepository;
        $this->directorio_temporales2 = $this->config->repository->temporaryrepository2;
        $this->datadirfonafifo = $this->config->repository->datadirfonafifo;
        $this->contratoshistoricos = $this->config->repository->contratoshistoricos;
        $this->contratoshistoricospublicos = $this->config->repository->contratoshistoricospublicos;
        $this->prioridadespublicos = $this->config->repository->prioridadespublicos;
        $this->ogrdirectory = "";//En linux no se necesita.

        $this->db_host = $this->config->db->config->host;
        $this->db_database = $this->config->db->config->database;
        $this->db_uid = $this->config->db->config->username;
        $this->db_pass = $this->config->db->config->password;


        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();
        $this->conn = $conn;
    }


    public function importarFichasCultura(){
        //Obtiene la lista de fichas. Se importan y actualizan las que haya. Se obtiene la lista de tipos y se crean las capas segun esto.
        //Revisar si funciona replace into.
        //$this->conn->exec("TRUNCATE TABLE  `cu_fichas`");

        $curlh = new CurlHandler();
        $datosfichasstr = $curlh->RawGet(self::$URL_TODOS);
        $datosfichasstr = trim($datosfichasstr);
        //echo ( "Datos Fichas STR [$datosfichasstr]");
        $datosfichas = json_decode($datosfichasstr, true);
        //print_r($datosfichas); //die;
        echo ("Procesando ".count($datosfichas). " TIPOS\n");
        $tipocounter = 0;$cantidadfichastotal = 0;
        foreach($datosfichas as $tipo => $fichas){
            $cantidadfichastotal += count($fichas);
        }
        $tipocounter = 0;$fichacountertotal = 0;
        foreach($datosfichas as $tipo => $fichas){
            $tipocounter++;
            echo ("TIPO $tipocounter [$tipo]\n");
            //$fichas = array(0 => array('nid' => 6517) );
            $fichacounter =0;
            $cantidadfichas = count($fichas);
            foreach($fichas as $ficha_actual){
                $fichacounter++;
                $fichacountertotal++;
                echo ("Ficha $fichacounter de $cantidadfichas En total la $fichacountertotal de $cantidadfichastotal\n");
                print_r($ficha_actual);
                $nid = $ficha_actual['nid'];
                $datosfichaactualstr = $curlh->RawGet(self::$URL_FICHA . $nid);
                $datosfichaactualstr = trim($datosfichaactualstr);
                echo $datosfichaactualstr . " ANTES \n";
                //$datosfichaactualstr = iconv("UTF-8",'iso-8859-1' ,$datosfichaactualstr);

                $datosfichaactual = json_decode($datosfichaactualstr, true);
                if(! is_array($datosfichaactual)){
                    $error = $this->getLastJsonError();
                    echo ("ERROR DECODIFICANDO JSON [$error] nid[$nid]");
                    continue;
                }else{
                    foreach($datosfichaactual as $key => $value){
                        if(is_string($value)){
                            $value = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
                                return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
                            }, $value);
                            $value = str_replace("'", '', $value);
                            $datosfichaactual[$key] = $value;
                        }
                        if(is_array($value)){
                            foreach($value as $key2=>$value2){
                                if(is_string($value2)){
                                    $value2 = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
                                        return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
                                    }, $value2);
                                    $value2 = str_replace("'", '', $value2);
                                    $datosfichaactual[$key][$key2] = $value2;
                                }
                            }
                        }
                    }

                    echo $datosfichaactualstr . "\n";

                }
                echo ("Datos ficha [". print_r($datosfichaactual, true));
                $this->registrarFicha($datosfichaactual);

                die;
            }
        }

        //refrescar las geometrías.
        $sql = "TRUNCATE TABLE cu_ficha_geometria; ";
        $this->conn->exec($sql);
        $sql = "INSERT INTO cu_ficha_geometria (ficha_id, nid,geometria)
SELECT id, nid, GeomFromText(CONCAT('POINT(',longitud,' ',latitud,')')  , 2) FROM `cu_fichas` WHERE latitud IS NOT NULL AND longitud IS NOT NULL;";
        $this->conn->exec($sql);

    }
    public function getLastJsonError(){
        switch (json_last_error()) {
            case JSON_ERROR_NONE:
                return ' - No errors';
                break;
            case JSON_ERROR_DEPTH:
                return ' - Maximum stack depth exceeded';
                break;
            case JSON_ERROR_STATE_MISMATCH:
                return ' - Underflow or the modes mismatch';
                break;
            case JSON_ERROR_CTRL_CHAR:
                return ' - Unexpected control character found';
                break;
            case JSON_ERROR_SYNTAX:
                return ' - Syntax error, malformed JSON';
                break;
            case JSON_ERROR_UTF8:
                return ' - Malformed UTF-8 characters, possibly incorrectly encoded';
                break;
            default:
                return ' - Unknown error';
                break;
        }
    }
    public function registrarFicha($datosfichaactual){
        $nid = $datosfichaactual['nid'];
        $tipo = $datosfichaactual['tipo'];
        $categorias = $datosfichaactual['categorias'];
        $categorias_array = explode(',', $categorias);
        echo ( "CATEWGORIAS [". print_r($categorias_array, true));
        $infoficha = $this->getFicha($nid, $onlyid=true );
        $sql = "";
        $tipoid = $this->getTipoId($tipo);

        $fotosstr = $datosfichaactual['fotos'];
        $fotos = json_encode($fotosstr);
        $datoscontacto = $datosfichaactual[datos_contacto];
        $datosubicacion= $datosfichaactual[ubicacion];
        if(empty($datosubicacion[latitud]))
            $datosubicacion[latitud] = 'NULL';
        if(empty($datosubicacion[longitud]))
            $datosubicacion[longitud] = 'NULL';

        if(!$infoficha ){
        //if(true ){
            //Insertar

            $sql = <<<EOD
            REPLACE INTO cu_fichas
                (id, nid, title, status, changed, url, tipo, categorias, tipo_id, tel_oficina, tel_habitacion, fax, tel_movil, sitio_web, email, email_alt, apartado_postal, provincia, canton, distrito, direccion, latitud, longitud, fotos, fecha_update)
            VALUES
                (NULL
                ,$datosfichaactual[nid]
                ,'$datosfichaactual[title]'
                ,$datosfichaactual[status]
                ,'$datosfichaactual[changed]'
                ,'$datosfichaactual[url]'
                ,'$datosfichaactual[tipo]'
                ,'$datosfichaactual[categorias]'
                ,$tipoid
                ,'$datoscontacto[tel_oficina]'
                ,'$datoscontacto[tel_habitacion]'
                ,'$datoscontacto[fax]'
                ,'$datoscontacto[tel_movil]'
                ,'$datoscontacto[sitio_web]'
                ,'$datoscontacto[email]'
                ,'$datoscontacto[email_alt]'
                ,'$datoscontacto[apartado_postal]'
                ,'$datosubicacion[provincia]'
                ,'$datosubicacion[canton]'
                ,'$datosubicacion[distrito]'
                ,'$datosubicacion[direccion]'
                ,$datosubicacion[latitud]
                ,$datosubicacion[longitud]
                ,'$fotos'

                ,NOW()
                )
EOD;


        }else{
            //modificiar
            $sql = <<<EOD
            UPDATE cu_fichas
            SET
                title = '$datosfichaactual[title]'
                ,status = $datosfichaactual[status]
            WHERE nid = $datosfichaactual[nid]
                (id, nid, title, status, changed, url, tipo, categorias, tipo_id, tel_oficina, tel_habitacion, fax, tel_movil, sitio_web, email, email_alt, apartado_postal, provincia, canton, distrito, direccion, latitud, longitud, fotos, fecha_update)
            VALUES
                (NULL
                ,$datosfichaactual[nid]
                ,'$datosfichaactual[title]'
                ,$datosfichaactual[status]
                ,'$datosfichaactual[changed]'
                ,'$datosfichaactual[url]'
                ,'$datosfichaactual[tipo]'
                ,'$datosfichaactual[categorias]'
                ,$tipoid
                ,'$datoscontacto[tel_oficina]'
                ,'$datoscontacto[tel_habitacion]'
                ,'$datoscontacto[fax]'
                ,'$datoscontacto[tel_movil]'
                ,'$datoscontacto[sitio_web]'
                ,'$datoscontacto[email]'
                ,'$datoscontacto[email_alt]'
                ,'$datoscontacto[apartado_postal]'
                ,'$datosubicacion[provincia]'
                ,'$datosubicacion[canton]'
                ,'$datosubicacion[distrito]'
                ,'$datosubicacion[direccion]'
                ,$datosubicacion[latitud]
                ,$datosubicacion[longitud]
                ,'$fotos'

                ,NOW()
                )
EOD;

        }
        echo ( $sql);
        $affected = $this->conn->exec($sql);
        $infoficha = $this->getFicha($nid, $onlyid=true );
        $idficha = $infoficha['id'];
        foreach($categorias_array as $categoria_actual){
            $categoriaid = $this->getCategoriaId($tipo, $categoria_actual, $tipoid);

            $sqlactual = "REPLACE INTO cu_ficha_categoria VALUES ($idficha, $categoriaid);";
            $affected = $this->conn->exec($sqlactual);
        }

    }
    public function getFicha($nid, $onlyid = false){
        $select = " * ";
        if($onlyid)
            $select = " id, nid ";

        $sql = "SELECT $select FROM cu_fichas WHERE nid = $nid";
        $datos= $this->conn->fetchAll($sql);
        error_log($sql);
        if(count($datos) < 1){
            return false;
        }else{
            return $datos[0];
        }
    }
    public function getTipoId($tipo){
        $tipoid = false;

        $sql = "SELECT * FROM cu_tipo WHERE nombre = '$tipo' ";
        error_log($sql);
        $datos= $this->conn->fetchAll($sql);
        if(count($datos) < 1){
            $sql = "INSERT INTO cu_tipo VALUES(NULL, '$tipo');";
            error_log($sql);
            $this->conn->exec($sql);
            $sql = "SELECT * FROM cu_tipo WHERE nombre = '$tipo' ";
            error_log($sql);
            $datos= $this->conn->fetchAll($sql);
            return $datos[0]['id'];
        }else{
            return $datos[0]['id'];
        }

        return $tipoid;
    }
    function test(){
        $geohandler = new GeonetworksHandler();
        //print_r($geohandler->getWorkspacesList());die;
        $color ='#'. random_color();
        $color ='#'. random_color();
        echo $geohandler->createStyle('estiloprueba', $color, '#000001');

    }


    public function cleanString($text) {
        $utf8 = array(
            '/[áàâãªä]/u'   =>   'a',
            '/[ÁÀÂÃÄ]/u'    =>   'A',
            '/[ÍÌÎÏ]/u'     =>   'I',
            '/[íìîï]/u'     =>   'i',
            '/[éèêë]/u'     =>   'e',
            '/[ÉÈÊË]/u'     =>   'E',
            '/[óòôõºö]/u'   =>   'o',
            '/[ÓÒÔÕÖ]/u'    =>   'O',
            '/[úùûü]/u'     =>   'u',
            '/[ÚÙÛÜ]/u'     =>   'U',
            '/ç/'           =>   'c',
            '/Ç/'           =>   'C',
            '/ñ/'           =>   'n',
            '/Ñ/'           =>   'N',
            '/–/'           =>   '-', // UTF-8 hyphen to "normal" hyphen
            '/[’‘‹›‚]/u'    =>   ' ', // Literally a single quote
            '/[“”«»„]/u'    =>   ' ', // Double quote
            '/ /'           =>   ' ', // nonbreaking space (equiv. to 0x160)
        );
        return preg_replace(array_keys($utf8), array_values($utf8), $text);
    }
    public function getCategoriaId($tipo, $categoria, $tipoid = false){
        if(!$tipoid){
            $tipoid = $this->getTipoId($tipo);
        }
        $sql = "SELECT * FROM cu_categoria WHERE nombre = '$categoria' AND cu_tipo_id = $tipoid ";
        error_log($sql);
        $datos= $this->conn->fetchAll($sql);
        if(count($datos) < 1){
            $sql = "INSERT INTO cu_categoria VALUES(NULL, $tipoid, '$categoria');";
            error_log($sql);
            $this->conn->exec($sql);
            $sql = "SELECT * FROM cu_categoria WHERE nombre = '$categoria' AND cu_tipo_id = $tipoid ";
            $datos= $this->conn->fetchAll($sql);
            error_log($sql);
            return $datos[0]['id'];
        }else{
            return $datos[0]['id'];
        }

    }



    public function actualizarEstilosCapasCultura(){
        //Debe haber una capa por cada categoria.
        //Obtener las capas que se deben publicar que no hayan sido publicadas.
        $geohandler = new GeonetworksHandler();
        $sql= "
        SELECT
            cat.id
            ,cat.cu_tipo_id
            ,cat.nombre as nombrecategoria
            ,tipo.nombre as tipo
            ,capfic.nombrecapa as nombrecapa
        FROM
            cu_categoria cat
            LEFT JOIN cu_capas_fichas capfic ON capfic.categoria_id = cat.id
            LEFT JOIN cu_tipo tipo ON tipo.id = cat.cu_tipo_id
        WHERE capfic.id IS NOT NULL
        ";
        $capasSinPublicar= $this->conn->fetchAll($sql);
        foreach($capasSinPublicar as $key=> $capasinpublicar_actual){
            //Publicar la capa.
            //crear estilo
            //asignarle el estilo
            $nombrecapa  = $capasinpublicar_actual['nombrecapa'];
            $nombrecategoria  = $capasinpublicar_actual['nombrecategoria'];
            $nombretipo  = $capasinpublicar_actual['tipo'];
            $idcategoria  = $capasinpublicar_actual['id'];



            //crear estilo.

            $color ='#'. random_color();
            $color ='#'. random_color();
            $resultado = $geohandler->createStyle($nombrecapa, $color, '#000001');

        }
    }
    public function publicarCapasCultura(){
        //Debe haber una capa por cada categoria.
        //Obtener las capas que se deben publicar que no hayan sido publicadas.
        $geohandler = new GeonetworksHandler();
        $sql= "
        SELECT
            cat.id
            ,cat.cu_tipo_id
            ,cat.nombre as nombrecategoria
            ,tipo.nombre as tipo
        FROM
            cu_categoria cat
            LEFT JOIN cu_capas_fichas capfic ON capfic.categoria_id = cat.id
            LEFT JOIN cu_tipo tipo ON tipo.id = cat.cu_tipo_id
        WHERE capfic.id IS NULL
        ";
        $capasSinPublicar= $this->conn->fetchAll($sql);
        foreach($capasSinPublicar as $key=> $capasinpublicar_actual){
            //Publicar la capa.
            //crear estilo
            //asignarle el estilo
            $nombrecategoria  = $capasinpublicar_actual['nombrecategoria'];
            $nombretipo  = $capasinpublicar_actual['tipo'];
            $idcategoria  = $capasinpublicar_actual['id'];

            //echo "[$nombrecategoria]\n";
            $nombresincaracteres = $this->cleanString($nombrecategoria);
            //$nombresincaracteres = iconv('iso-8859-1' ,"UTF-8", $nombresincaracteres);



            $nombresincaracteres = $nombretipo . '_'.$nombresincaracteres;
            $nombresincaracteres = str_replace(' ', '_', $nombresincaracteres);
            $nombresincaracteres = str_replace('(', '-', $nombresincaracteres);
            $nombresincaracteres = str_replace(')', '-', $nombresincaracteres);
            $nombresincaracteres = str_replace('--', '-', $nombresincaracteres);
            $nombresincaracteres = str_replace('-_', '_', $nombresincaracteres);
            $nombresincaracteres = str_replace('-', '_', $nombresincaracteres);
            $nombresincaracteres = str_replace('.', '', $nombresincaracteres);
            $nombresincaracteres = strtolower ($nombresincaracteres);

            //echo "[$nombresincaracteres]\n"; continue;
            $sqlCapa= <<<EOD
SELECT
	fic.id
	,fic.nid
	,fic.title
	,fic.url
	,fic.provincia
	,fic.canton
	,fic.distrito
	,fic.direccion
	,fic.latitud
	,fic.longitud
	,fic.fotos
	,ficgeo.geometria
	,cat.nombre as nombrecategoria
	,tip.nombredespliegue as nombretipo

FROM
	cu_fichas fic
	INNER JOIN cu_ficha_categoria ficcate ON ficcate.ficha_id = fic.id
	INNER JOIN cu_ficha_geometria ficgeo ON ficgeo.ficha_id = fic.id
	INNER JOIN cu_categoria cat ON ficcate.categoria_id = cat.id
	INNER JOIN cu_tipo tip ON tip.id = fic.tipo_id


WHERE ficcate.categoria_id = $capasinpublicar_actual[id]
EOD;

            //crear estilo.

            $color ='#'. random_color();
            $color ='#'. random_color();
            $resultado = $geohandler->createStyle($nombresincaracteres, $color, '#000001');
            //error_log("Creando styl $nombresincaracteres [$resultado]");



            $workspace = self::$WS_CULTURA;
            $datastore = self::$STORE_CULTURA;
            $layer =$nombresincaracteres;//contratos_poligonos_todos_2015
            $description = $layer;
            $declaredSRS = PROYECCION_WGS84;
            $metadatalinks = array();
            $defaultStyle = $nombresincaracteres;
            $nativeBoundingBox = self::$CRBOUNDINGBOX_WGS84;
            $latLonBoundingBox = false;
            $viewsql = $sqlCapa;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description \n");
            //echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");

            $viewparametersxml = "";
            $viewextradata = array('srid' => 2, 'geometryfield' => 'geometria');
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql ,$viewparametersxml, $viewextradata);
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                //error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");

                $sqlInsert = "INSERT INTO cu_capas_fichas (nombredespliegue, nombrews, nombrecapa, nombretabla, orden, visibleinicio, categoria_id, url) VALUES
('$nombrecategoria', '$workspace', '$layer', 'cu_fichas', $key, 0, $idcategoria, '/be/wms?REQUEST=GetMap'); ";
                $insercion = $this->conn->exec($sqlInsert);
                error_log("Insercion $insercion [$sqlInsert]");
                echo("Insercion $insercion [$sqlInsert]");
            }else{
                //error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }
            //die;

        }
    }
    public function capas_geodatosConQuery_do(){
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();

        $sqlEjecucion = <<<EOD
        SELECT
            id
            ,nombredespliegue
            ,nombrews
            ,nombrecapa
            ,nombretabla
            ,tipogeometria
            FROM su_geodatos

EOD;
        $capasgeodatos = $conn->fetchAssoc($sqlEjecucion);

        foreach($capasgeodatos as $capaactual){
            $id_capa = $capaactual['id'];
            $nombrews = $capaactual['nombrews'];
            $nombrecapa = $capaactual['nombrecapa'];
            $nombretabla = $capaactual['nombretabla'];
            $nombrecapa_query = $capaactual['nombrecapa'] . "_q";
            $sql = <<<EOD
            SELECT
                geo.OGR_FID
                ,geo.SHAPE
                ,geo.fecha as ultima_actualizacion
                ,s.nombre
                ,s.cod_expediente

            FROM
                su_solicitudes_PMB s
                INNER JOIN $nombretabla geo ON s.id = geo.solicitud_pmb_id AND geo.ultimaversion = 1 AND geo.su_geodatos_id = $id_capa
            WHERE s.id = %sol%


EOD;

            $geohandler = new GeonetworksHandler();

            $workspace = $nombrews;
            $datastore = $nombrews;
            $layer =$nombrecapa_query;//contratos_poligonos_todos_2015
            $description = $layer;
            $declaredSRS = PROYECCION_CRTM05;
            $metadatalinks = array();
            $defaultStyle = $nombrecapa;
            $nativeBoundingBox = self::$CRBOUNDINGBOX;
            $latLonBoundingBox = false;
            $viewsql = $sql;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");

            $viewparametersxml = "
            <parameter>
              <name>sol</name>
              <defaultValue>15</defaultValue>
              <regexpValidator>^[\d]+$</regexpValidator>
            </parameter>
            ";
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql ,$viewparametersxml);
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }
        }




    }

    public function capas_geodatosSinQuery_do(){
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();

        $sqlEjecucion = <<<EOD
        SELECT
            id
            ,nombredespliegue
            ,nombrews
            ,nombrecapa
            ,nombretabla
            ,tipogeometria
            FROM su_geodatos

EOD;
        $capasgeodatos = $conn->fetchAssoc($sqlEjecucion);

        foreach($capasgeodatos as $capaactual){
            $id_capa = $capaactual['id'];
            $nombrews = $capaactual['nombrews'];
            $nombrecapa = $capaactual['nombrecapa'];
            $nombretabla = $capaactual['nombretabla'];
            $nombrecapa_query = $capaactual['nombrecapa'];
            $sql = <<<EOD
            SELECT
                geo.OGR_FID
                ,geo.SHAPE
                ,geo.fecha as ultima_actualizacion
                ,s.nombre
                ,s.cod_expediente

            FROM
                su_solicitudes_PMB s
                INNER JOIN $nombretabla geo ON s.id = geo.solicitud_pmb_id AND geo.ultimaversion = 1 AND geo.su_geodatos_id = $id_capa

EOD;

            $geohandler = new GeonetworksHandler();

            $workspace = $nombrews;
            $datastore = $nombrews;
            $layer =$nombrecapa_query;//contratos_poligonos_todos_2015
            $description = $layer;
            $declaredSRS = PROYECCION_CRTM05;
            $metadatalinks = array();
            $defaultStyle = $nombrecapa;
            $nativeBoundingBox = self::$CRBOUNDINGBOX;
            $latLonBoundingBox = false;
            $viewsql = $sql;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");

            $viewparametersxml = "
            <parameter>
              <name>sol</name>
              <defaultValue>15</defaultValue>
              <regexpValidator>^[\d]+$</regexpValidator>
            </parameter>
            ";
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql);
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }
        }




    }

    public function registrarMapaCargable($capas, $extent = NULL){
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();
        $nombre = session_id () . time();
        $nombre= md5($nombre);
        $capas = json_encode($capas);
        if(!$extent)
            $extent = 'NULL';
        else
            $extent= "'".json_encode($extent)."'";
        $sqlEjecucion = <<<EOD
        INSERT INTO cu_mapas_guardados
        (nombre, capas, interno, fecha_creacion, extent, icono)
        VALUES
        (
            '$nombre', '$capas', 0, CURRENT_TIMESTAMP,$extent, NULL
        )

EOD;
        $resultado = $conn->exec($sqlEjecucion);
        $ultimoid = $conn->lastInsertId();
        if($resultado)
            return $ultimoid;
        else
            return false;
    }


} 