<?php
/**
 *
 * @author Addax Software
 * @see CurlHandler
 * @see GeoserverWrapper
 * @uses CurlHandler
 * @uses GeoserverWrapper
 */
function random_color_part() {
    return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT);
}

function random_color() {
    return random_color_part() . random_color_part() . random_color_part();
}

require_once(dirname(__FILE__)."/CurlHandler.php");
require_once(dirname(__FILE__)."/GeoserverWrapper.php");
/**
 * Clase GeonetworksHandler que centraliza operaciones comunes necesarias para las varias acciones que requieren información desde el servidor de mapas.
 * Esta clase maneja los llamados hacia el manejador de API GeoserverWrapper que publica IBM.
 */
class GeonetworksHandler
{
    /**
     * @var object La clase GeoserverWrapper que realiza los llamados finales al geoserver.
     */
    private $geoserver;
    private $geoserverurl;
    public static $SLD_PUNTOBASICO = '<?xml version="1.0" encoding="UTF-8"?>
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:ogc="http://www.opengis.net/ogc" xmlns:gml="http://www.opengis.net/gml" version="1.0.0">
  <sld:NamedLayer>
    <sld:Name>%%TITLE%%</sld:Name>
    <sld:UserStyle>
      <sld:Name>%%TITLE%%</sld:Name>
      <sld:Title>%%TITLE%%</sld:Title>
      <sld:FeatureTypeStyle>
        <sld:Name>%%TITLE%%</sld:Name>
        <sld:Rule>
            <sld:Name></sld:Name>
            <sld:MinScaleDenominator>144447</sld:MinScaleDenominator>
              <sld:PointSymbolizer>
                <sld:Graphic>
                  <sld:Mark>
                    <sld:WellKnownName>circle</sld:WellKnownName>
                    <sld:Fill>
                      <sld:CssParameter name="fill">%%FILL%%</sld:CssParameter>
                      <sld:CssParameter name="fill-opacity">0.7</sld:CssParameter>
                    </sld:Fill>
                    <sld:Stroke>
                      <sld:CssParameter name="stroke">%%STROKEL%%</sld:CssParameter>
                      <sld:CssParameter name="stroke-width">1</sld:CssParameter>
                    </sld:Stroke>
                  </sld:Mark>
                  <sld:Size>7</sld:Size>
                </sld:Graphic>
              </sld:PointSymbolizer>
        </sld:Rule>
        <sld:Rule>
            <sld:Name></sld:Name>
            <sld:MinScaleDenominator>1</sld:MinScaleDenominator>
            <sld:MaxScaleDenominator>144447</sld:MaxScaleDenominator>
              <sld:PointSymbolizer>
                <sld:Graphic>
                  <sld:Mark>
                    <sld:WellKnownName>circle</sld:WellKnownName>
                    <sld:Fill>
                      <sld:CssParameter name="fill">%%FILL%%</sld:CssParameter>
                      <sld:CssParameter name="fill-opacity">0.7</sld:CssParameter>
                    </sld:Fill>
                    <sld:Stroke>
                      <sld:CssParameter name="stroke">%%STROKEL%%</sld:CssParameter>
                      <sld:CssParameter name="stroke-width">1</sld:CssParameter>
                    </sld:Stroke>
                  </sld:Mark>
                  <sld:Size>13</sld:Size>
                </sld:Graphic>
              </sld:PointSymbolizer>
        </sld:Rule>
      </sld:FeatureTypeStyle>
    </sld:UserStyle>
  </sld:NamedLayer>
</sld:StyledLayerDescriptor>';
    /**
     * Constructor de la clase
     *
     * @uses self::$geoserver
     * @return void
     */
    public function GeonetworksHandler($geoserverurl = false){
        $this->geoserverurl = GEOSERVERSERVICEURL;
        if($geoserverurl){
            $this->geoserverurl = $geoserverurl;
        }
        //echo "Connecting to geoserver at " . GEOSERVERSERVICEURL . "\n";
        $this->geoserver = new GeoserverWrapper($this->geoserverurl, GEOSERVERUSER, GEOSERVERPASS);
    }

    /**
     * Agrega un workspace al Geoserver, siempre y cuando no exista en la lista de workspace actuales.
     *
     * @param string $workspacename El nombre del workspace a incluir en el Geoserver.
     * @uses self::$geoserver
     * @uses self::getWorkspacesList()
     * @uses GeoserverWrapper::createWorkspace()
     * @return bool true en caso de éxito o que ya exista, false en caso de error a la hora de crearlo.
     */
    public function addWorkspace($workspacename){
        //verificar si existe. Si no existe, tons se crea.
        $listaactual = $this->getWorkspacesList();
        if( in_array($workspacename, $listaactual)){
            //Ya existe.
            echo ("Workspace ya existe. $workspacename");
            return true;
        }else{
            $result = $this->geoserver->createWorkspace($workspacename);
            return $result;
        }
    }

    /**
     * Obtiene la lista de workspace actuales en el Geoserver.
     *
     * @uses self::$geoserver
     * @uses GeoserverWrapper::listWorkspaces()
     * @return array Un arreglo con la lita de los nombre de los workspace que hay actualmente en el Geoserver.
     */
    public function getWorkspacesList(){

        $list = $this->geoserver->listWorkspaces();
        //print_r($list); die;
        $listafinal = array();
        foreach ($list['workspaces']['workspace'] as $ws) {
            $listafinal[] = $ws['name'];
        }

        return $listafinal;
    }

    /**
     * Agrega todos los shapes que hayan en el directorio storagelistlocation con el nombre de storage storagelistname, para el workspace.
     * En caso que ya exista el storagelist, se agregan los layers que no hubieren antes. Si ya existía no pasa anda. Se agregan los nuevos unicamente.
     *
     * @param string $storagelistname Nombre que va a llevar la lista de Storage. Por ejemplo, poligonos
     * @param string $workspace Nombre del workspace donde debe quedar la lista de Storage. Por ejemplo: MC_Calidad
     * @param string $storagelistlocation Ruta del directorio donde se ubicarán los archivos de mapas.
     * @uses self::$geoserver
     * @uses GeoserverWrapper::createShpDirDataStore()
     * @return bool true si se agrega o ya existe la lista. false si se dió un error.
     */
    public function addStorageList($storagelistname, $workspace, $storagelistlocation){
        //$this->addWorkspace($workspace);
        $list = $this->getStorageList($workspace);
        if(in_array($storagelistname, $list)  ){
            //ya existe el storagelist!
            return true;
        }else{
            //Agregar el storagelist.
            return $this->geoserver->createShpDirDataStore($storagelistname, $workspace, $storagelistlocation);
        }

    }

    /**
     * Obtiene la lista de almacenes de datos (Storage lists) que tenga un workspace.
     * Por ejemplo, serían los directorios donde se guardan los archivos de capas de cobertura para el workspace (operador) claro.
     *
     * @param string $workspacename Nombre del workspace al cual consultarle la lista de almacenes de datos.
     * @uses self::$geoserver
     * @uses GeoserverWrapper::listDatastores()
     * @return array La lista de los nombres de los almacenes de datos que tenga actualmente asociados un workspace.
     */
    public function getStorageList($workspacename = null){
        $list = $this->geoserver->listDatastores($workspacename);
        $listafinal = array();

        if($list['dataStores'])
            if($list['dataStores']['dataStore'])
                foreach ($list['dataStores']['dataStore'] as $ws) {
                    $listafinal[] = $ws['name'];
                }
        return $listafinal;
    }

    /**
     * A la hora de crearse una capa, le actualiza su estilo de manera que si existe ya una regla de estilos con
     * el mismo nombre base que la capa (por ejemplo, cobertura_dentroedificios sería el nombre base para la capa kolbi_3g_cobertura_dentroedificios_2014_02_20_11_44_01)
     *
     * @param string $workspace Nombre del workspace al cual debe pertenecer la capa.
     * @param string $layer Nombre de la capa a la cual se le debe asignar un estilo.
     * @param array $stilos Arreglo con los nombres de los estilos que hay actualmente en el Geoserver.
     *
     * @uses self::getLayerInfo()
     * @uses CurlHandler::Put()
     * @return void No tiene retorno ya que es un llamado opcional, y que si no se logra aplicar no tiene mayor peso en el proceso.
     */
    public function updateLayer($workspace, $layer, $stilos ){

        $url = $this->geoserverurl . "rest/layers/$workspace".":$layer";
        $linfo = $this->getLayerInfo($layer);
        $nombresupuesto = $linfo["indicador"].CARACTER_SEPARADOR_COMPONENTES_CAPA . $linfo["subarchivo"];
        $nombresupuesto = strtolower($nombresupuesto);
        $pos = array_search($nombresupuesto, $stilos);

        if($pos !== false) {

            $stilosdata = "<layer><defaultStyle><name>$pos</name></defaultStyle><enabled>true</enabled></layer>";
            //$url .= "/".$pos;
        }

        $result = CurlHandler::Put($url, $stilosdata);
        echo ("ADD addGroupList: [$url] ($stilosdata):: $result ");

    }

    public function updateLayerStyle($workspace, $layer, $estilo ){

        $url = $this->geoserverurl . "rest/layers/$workspace".":$layer";

        $stilosdata = "<layer><defaultStyle><name>$estilo</name></defaultStyle><enabled>true</enabled></layer>";

        $result = CurlHandler::Put($url, $stilosdata);
        error_log ("Update style:: [$url] ($stilosdata):: $result ");

    }


    /**
     * Retorna la lista de capas, agrupadas por su workspace.
     *
     * @uses self::getWorkspacesList()
     * @uses self::getStorageList()
     * @uses GeoserverWrapper::listLayers()
     * @return array Arreglo bi-dimensional con llave principal siendo el nombre del workspace donde están las capas.
     */
    public function getLayersList($checkonthisws = false){
        $wslist = $this->getWorkspacesList();
        $storeslist = array();
        $layerlist = array();
        foreach($wslist as $currworkspace){
            $currstoragelist = $this->getStorageList($currworkspace);
            $storeslist = array_merge($currstoragelist, $storeslist);
            $layerlist[$currworkspace] = array();
            foreach ($currstoragelist as $currentstorage) {
                $currentlayerlist = $this->geoserver->listLayers($currworkspace, $currentstorage);
                $listafinal = array();
                foreach ($currentlayerlist['featureTypes']['featureType'] as $layyeractual) {
                    $fulllayer = $currworkspace . ":" . $layyeractual["name"];
					$usarinfo = false;
					if($checkonthisws !== false){
						if(is_array($checkonthisws) ){
							if(in_array($currworkspace, $checkonthisws) ){
								$usarinfo = true;
							}
						}
					}
					if($usarinfo){
						$info = $this->getlayerinfo_geoserver($layyeractual["name"], $currworkspace, $currentstorage);
						//error_log("Info de la capa [$fulllayer]::[" . ($info["enabled"])."]");
						error_log("Info de la capa [$fulllayer]::[" . ($info["enabled"])."]");
						if($info["enabled"]){
							$listafinal[] = $layyeractual['name'];
						}
					}else{
						//echo ("No check on this\n");
						$listafinal[] = $layyeractual['name'];//No importa si esta habilitada o no. Se incluyen igual.
					}


                }
                $layerlist[$currworkspace] = array_merge($layerlist[$currworkspace], $listafinal);
            }

        }
		//echo ("Layer list usar: " . print_r($layerlist, true) ."\n");
        return $layerlist;
    }
    public function getlayerinfo_geoserver($layername, $worskpace = null, $store=null){
        $layername_parts = explode(":", $layername);

        if(count($layername_parts) > 1){
            $layername = $layername_parts[1];//sin el WS.
        }
		if($worskpace == null){
			$worskpace = WS_DEFECTO;
		}if($store == null){
			$store = WS_DEFECTO;
		}
        $lista = array();
        //WS_DEFECTO
        //http://cursoestudiante1.addax.cc/be/rest/workspaces/curso/datastores/curso/featuretypes/Fallas_ebridge_2014_03_25.json

        $url = $this->geoserverurl ."rest/workspaces/".$worskpace."/datastores/".$store."/featuretypes/$layername.json";
        //echo $url;die;
        //error_log("Loading layer info: [$layername] from url[$url]\n");
        $respuesta = CurlHandler::Get($url);
        $respuesta = utf8_encode( $respuesta);
        $respuestadecode = json_decode($respuesta, true);
        if(empty($respuestadecode)){
            return false;
        }
        if(!array_key_exists("featureType", $respuestadecode)){
            return false;
        }
        return $respuestadecode['featureType'];

    }

    /**
     * Obtiene y retorna la información de la capa que recibe por parámetro.
     *
     * @param string $layer Nombre de la capa a la cual obtenerle su información.
     * @return array Arreglo con la información que se pudo obtener a partir del nombre de la capa.
     */
    private function getLayerInfo($layer){
        $retorno = array();
        $partes = explode(CARACTER_SEPARADOR_COMPONENTES_CAPA, $layer);
        $retorno["operador"] = $partes[POSICION_SEPARADOR_OPERADOR];
        $retorno["red"] = $partes[POSICION_SEPARADOR_RED];
        $retorno["indicador"] = $partes[POSICION_SEPARADOR_INDICADOR];
        $retorno["subarchivo"] = $partes[POSICION_SEPARADOR_SUBARCHIVO];
        return $retorno;
    }

    /**
     * Agrega una capa, ubicada en el datastore de un workspace determinado.
     *
     * @param string $workspace Nombre del workspace al cual debe pertenecer la capa.
     * @param string $layer Nombre de la capa que se debe agregar y que ya debe existir en el datastore.
     * @param string $datastore Nombre del datastore del workspace, donde se encuentra ubicada físicamente la capa.
     *
     * @uses self::$geoserver
     * @uses GeoserverWrapper::createLayer()
     * @return bool true si se creó exitosamente la capa, false en caso contrario.
     */
    /*public function addLayer($workspace, $layer, $datastore){
        return $this->geoserver->createLayer($layer, $workspace, $datastore);

    }*/
	public function addLayer($workspace, $layer, $datastore, $description = '', $declaredSRS = false, $metadatalinks = array(), $defaultStyle =false, $title = false){
        return $this->geoserver->createLayer($layer, $workspace, $datastore, $description , $declaredSRS ,$metadatalinks, $defaultStyle , $title);

    }public function addSqlLayer($workspace, $layer, $datastore, $description = '', $declaredSRS = false, $metadatalinks = array(), $defaultStyle =false,$nativeBoundingBox = false, $latLonBoundingBox = false, $viewsql = "", $viewparametersxml = "", $viewextradata = false){
        return $this->geoserver->createSQLLayer($layer, $workspace, $datastore, $description , $declaredSRS ,$metadatalinks, $defaultStyle,$nativeBoundingBox,$latLonBoundingBox,$viewsql , $viewparametersxml, $viewextradata );

    }
    public function setStyleToLayer($layerName, $workspaceName, $styleName){
        return $this->geoserver->addStyleToLayer($layerName, $workspaceName, $styleName);
    }

    public function deleteLayer($layerName, $workspaceName, $datastoreName){
        return $this->geoserver->deleteLayer($layerName, $workspaceName, $datastoreName);
    }

    /**
     * Agrega un grupo de capas donde se agrupan capas de diversas mediciones
     * por ejemplo, cobertura tiene 4 niveles: dentroedificios, dentrovehiculos, exteriores, fueradecobertura. Estos 4 se agrupan en un grupo de cobertura para su facilidad de despliegue.
     *
     * @param string $workspace Nombre del workspace al cual debe pertenecer la capa.
     * @param string $groupname Nombres que deberá tener el grupo. Porejemplo kolbi_3g_cobertura_2013_05_17_13_39_47
     * @param array $layers Nombres de las capas que se debe agregar al grupo.
     * @param array $stilos arreglo opcional, con los estilos disponibles para buscar su posible asignación a la capa dentro del grupo.
     *
     * @uses CurlHandler::Post()
     * @return bool true
     */
    public function addGroupList($workspace, $groupname, $layers, $stilos = null){
        $stilosdata = "";
        if($stilos){
            $stilosdata = "<styles>";
        }
        $xmldata = "<layerGroup><name>$groupname</name><workspace>$workspace</workspace><layers>";
        foreach($layers as $layer){
            $xmldata .= "<layer>$layer</layer>";

            if($stilos){
                $linfo = $this->getLayerInfo($layer);
                $nombresupuesto = $linfo["indicador"].CARACTER_SEPARADOR_COMPONENTES_CAPA . $linfo["subarchivo"];
                $nombresupuesto = strtolower($nombresupuesto);
                $pos = array_search($nombresupuesto, $stilos);
                if($pos !== false) {

                    $stilosdata .= "<style>$pos</style>";
                }
            }
        }
        if($stilos){
            $stilosdata .= "</styles>";
        }
        $xmldata .= "</layers>$stilosdata</layerGroup>";
        $url = $this->geoserverurl . GEOSERVER_LAYERGROUP_URI ;

        $result = CurlHandler::Post($url, $xmldata);
        //echo ("ADD addGroupList: [$url] ($xmldata):: $result ");
        return true;

    }

    /**
     * Obtiene la lista de grupos de capas que tiene un workspace
     *
     * @param string $workspace Nombre del workspace al cual pertenecen las capas.
     *
     * @uses CurlHandler::Get()
     * @return array La lista con los nombres de los grupos de capas que se encontraron en el workspace.
     */
    public function getGroupList($workspace){

        $lista = array();
        $url = $this->geoserverurl .GEOSERVER_WORKSPACES_URI . $workspace . "/layergroups/";
        $respuesta = CurlHandler::Get($url);
        $xml = simplexml_load_string($respuesta);
        //print_r($respuesta);
        foreach($xml as $aa){
            $lista[] = $aa->name . "";
        }
        return $lista;


    }

    /**
     * Obtiene información de un grupo de capas, que pertenezca a un workspace.
     *
     * @param string $workspace Nombre del workspace al cual pertenece el grupo de capas.
     * @param string $layergroupname Nombre del grupo de capas al cual se le quiere obtner información.
     *
     * @uses CurlHandler::Get()
     * @return array El detalle de las capas y límites del grupo de capas.
     */
    public function getLayerGroupInfo($workspace, $layergroupname){

        $url = $this->geoserverurl .GEOSERVER_WORKSPACES_URI . $workspace . "/layergroups/$layergroupname";
        //echo (" URL $url \n");
        $respuesta = CurlHandler::Get($url);
        //echo (" RES[ $respuesta] \n"); die;
        $xml = simplexml_load_string($respuesta);
        $capas = array();
        if($xml->layers){
            //version 2.2.x
            foreach($xml->layers->layer as $layer ){
                //echo " cAPA¿ : " . print_r($layer, true) . "\n";
                $capas[] =  $layer->name . "";
            }
        }else if($xml->publishables){
            //version 2.3.x
            foreach($xml->publishables->published as $layer ){
                //echo " cAPA¿ : " . print_r($layer, true) . "\n";
                $capas[] =  $layer->name . "";
            }
        }
        $bounds = (array)$xml->bounds;
        $retorno = array('capas' => $capas, 'bounds' => $bounds);

        return $retorno;
    }

    /**
     * Obtiene el detalle xml de la información de una capa, desde el Geoserver.
     *
     * @param string $workspace Nombre del workspace al cual pertenece la capa
     * @param string $layername Nombre de la capa que se le requiere información
     *
     * @uses CurlHandler::Get()
     * @return object objeto SimpleXml con la información de la capa.
     */
    public function getLayerXMLInfo($workspace, $layername){

        $url = $this->geoserverurl ."rest/layers/$layername";
        $respuesta = CurlHandler::Get($url);
        //echo $respuesta;
        $xml = simplexml_load_string($respuesta);
        return $xml;
    }

    /**
     * Obtiene la lista de los estilos disponibles en el Geoserver.
     *
     * @param string $workspace Opcional. Nombre del workspace al cual pertenezcan los estilos.
     *
     * @uses CurlHandler::Get()
     * @return array Areglo con los nombres de los estilos. La llave es el nombre original, y el valor es el nombre en minusculas para estandarizacion.
     */
    public function getStyles($workspace = null){
        $url = "";
        $lista = array();
        if($workspace){
            $url = $this->geoserverurl .GEOSERVER_WORKSPACES_URI . $workspace . "/styles/";
        }else{
            $url = $this->geoserverurl . GEOSERVER_STYLES_URI;
        }
        $result = CurlHandler::Get($url);
        $xml = simplexml_load_string($result);
        //print_r($respuesta);
        foreach($xml as $aa){
            //echo ("   " . print_r($aa, true). "\n" );
            $lista[$aa->name . ""] = strtolower($aa->name . "");
        }

        return $lista;
    }


    public function createStyle($nombre, $fill, $stroke ){
        $url = $this->geoserverurl . "rest/styles/";
        $xml = "<style><name>$nombre</name><filename>".$nombre.".sld</filename></style>";
        $result = CurlHandler::Post($url, $xml, array('Content-type: text/xml'));
        //error_log ("ADD STYLE: [$url] ($xml):: [$result] ");


        $url = $this->geoserverurl . "rest/styles/".$nombre;

        $sld = self::$SLD_PUNTOBASICO;
        $sld = str_replace('%%TITLE%%', $nombre, $sld);
        $sld = str_replace('%%TITLE%%', $nombre, $sld);
        $sld = str_replace('%%FILL%%', $fill, $sld);
        $sld = str_replace('%%STROKEL%%', $stroke, $sld);

        $result = CurlHandler::Put($url, $sld, array("Content-type: application/vnd.ogc.sld+xml"));
        //error_log ("ADD STYLE: [$url] ($sld):: [$result] ");
        return $result;
    }
}
