<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 5/13/15
 * Time: 11:59 AM
 */

class SolicitudesHandler {
    public function __construct() {

        require_once('UtilsMap.php');
        $this->database =UtilsMap::getDBConnection();


    }
    public function solicitudInfo($idsolicitud){

        $sqlconsulta = <<<EOD

            SELECT

            asText(Envelope(sp.SHAPE)) as extent

            ,s.nombre
            ,s.area_de_conservacion
            ,s.subregion
            ,s.provincia
            ,s.canton
            ,s.distrito
            ,s.cod_expediente
            ,s.anno as anio
            ,est.nombre as estado
        FROM
            su_solicitudes_PMB s
            INNER JOIN su_estados_de_solicitud est ON est.id = s.estado_id
            INNER JOIN su_capa_solicitudes_poligonos sp ON sp.solicitud_pmb_id = s.id AND sp.ultimaversion = 1
        WHERE s.id = $idsolicitud

EOD;

        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return $results[0];
        }else{
            return false;
        }

    }

    public function hayGeodatos($idsolicitud){

        $sqlconsulta = <<<EOD
            SELECT
                (
                    COUNT(geo1.OGR_FID)
                    +COUNT(geo2.OGR_FID)
                    +COUNT(geo3.OGR_FID)
                ) as hayalgo
            FROM su_solicitudes_PMB s
                LEFT JOIN su_geodatos_polygon geo1 ON s.id = geo1.solicitud_pmb_id AND geo1.ultimaversion = 1
                LEFT JOIN su_geodatos_point geo2 ON s.id = geo2.solicitud_pmb_id AND geo2.ultimaversion = 1
                LEFT JOIN su_geodatos_line geo3 ON s.id = geo3.solicitud_pmb_id AND geo3.ultimaversion = 1
            WHERE s.id = $idsolicitud
            LIMIT 1;
EOD;

        $results = $this->database->Query($sqlconsulta, array());
        if(count($results) > 0){
            return ($results[0]['hayalgo'] > 0);//si hay algun dato, entonces hay algun geodato.
        }else{
            return false;
        }

    }
} 