<?php
class H2o_AddaxContext extends H2o_Context
{
	function setCacheDir($CachePath)
	{
		$this->options['cache_dir'] = $CachePath;
	}
	
	function getCacheDir()
	{
		return $this->getOption('cache_dir');
	}
	
	function setSearchPath($SearchPath)
	{
		$this->options['searchpath'] = $SearchPath;
	}
	
	function getSearchPath()
	{
		error_log(__METHOD__ . "::SearchPath=" . $this->getOption('searchpath'));
		return $this->getOption('searchpath');
	}
	
	function setOptions($Options)
	{
		foreach($Options as $option=>$val)
		{
			$this->setOption($option, $val);
		}
	}
	
	function getOptions()
	{
		return $this->options;
	}
	
	function setOption($key, $value)
	{
		switch($key)
		{
		case 'loader':
        case 'cache':
        case 'cache_prefix':
        case 'cache_ttl':
        case 'searchpath':
        case 'autoescape':
        case 'BLOCK_START':
        case 'BLOCK_END':
        case 'VARIABLE_START':
        case 'VARIABLE_END':
        case 'COMMENT_START':
        case 'COMMENT_END':
        case 'TRIM_TAGS':
			$this->options[$key] = $value;
			
			return true;
		break;
		default:
			return false;
		break;
		}
	}
	
	function getOption($key)
	{
		if(isset($this->options[$key]))
		{
			return $this->options[$key];
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * @param $MOde could be: file, false, apc
	 */
	function setCacheMode($Mode)
	{
		switch($Mode)
		{
		case false:
		case 'apc':
		case 'file':
			$this->options['cache'] = $Mode;
			
			return true;
		break;
		default:
			return false;
		break;
		}
	}
	
	function getCacheMode()
	{
		return $this->getOption('cache');
	}
	
	function __unset($key)
	{
		unset($this->scopes[$key]);
	}
	
	function clearScopes()
	{
		$this->scopes = array();
	}
	
	function getScopes()
	{
		return $this->scopes;
	}
}
?>