<?php

function pnzfSetZFPath()
{
	// Define path to zikula root directory
	defined('ZIKULA_PATH')
		|| define('ZIKULA_PATH', realpath(dirname('./')));
}

function pnInitZend()
{
	pnzfSetZFPath();

	$module = FormUtil::getPassedValue('module', null, 'GETPOST');
	$type   = FormUtil::getPassedValue('type', 'user', 'GETPOST');
	$func   = FormUtil::getPassedValue('func', 'user', 'GETPOST');
	
	pnzfSetZFEnvironment($module);
	
	return true;
}

function pnzfSetZFEnvironment($Module)
{
	
	// Define path to application directory
	defined('APPLICATION_PATH')
		|| define('APPLICATION_PATH', realpath(ZIKULA_PATH . "/modules/$Module/zend/application"));
		
	$renderer = pnModGetVar($Module, 'renderer');
		
	switch($renderer)
	{
	case 'smarty':
		set_include_path(realpath(ZIKULA_PATH . "/includes/classes/Smarty") . PATH_SEPARATOR . get_include_path());
	break;
	case 'h2o':
		$h2o_version = pnModGetVar($Module, 'h2oversion');
		if(!$h2o_version || empty($h2o_version))
		{
			$h2o_path = realpath(ZIKULA_PATH . "/includes/classes/h2o/h2o");
		}
		else
		{
			$h2o_path = realpath(ZIKULA_PATH . "/includes/classes/h2o/$h2o_version");
		}
		
	set_include_path(realpath(APPLICATION_PATH . '/../library') . PATH_SEPARATOR . $h2o_path . PATH_SEPARATOR . get_include_path());
	break;
	default:
	case 'zend':
	break;
	}
	
	// Define application environment
	defined('APPLICATION_ENV')
		|| define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'production'));
		
	$zend_version = pnModGetVar($Module, 'zfversion');
	if(!$zend_version || empty($zend_version))
	{
		$zend_path = realpath(ZIKULA_PATH . "/includes/classes/ZendFramework/Zend");
	}
	else
	{
		$zend_path = realpath(ZIKULA_PATH . "/includes/classes/ZendFramework/$zend_version");
	}
	set_include_path(realpath(APPLICATION_PATH . '/../library') . PATH_SEPARATOR . $zend_path . PATH_SEPARATOR . get_include_path());
	
	//Set models path.
	set_include_path(realpath(APPLICATION_PATH . "/models") . PATH_SEPARATOR . get_include_path());
	
	
	
	
	return true;
}

function pnzfGetRendererBootstrapTag($Module)
{
	error_log("get Render bootstrap");
	$renderer = pnModGetVar($Module, 'renderer');
	$result = '';
	switch($renderer)
	{
	case 'smarty':
		$result = 'Smarty';
	break;
	case 'h2o':
		$result = 'H2O';
	break;
	default:
	case 'zend':
	break;
	}
	
	return $result;
}
function pnzfGetDBControllerBootstrapTag($Module)
{
	error_log(__METHOD__. "get pnzfGetDBControllerBootstrapTag bootstrap");
	$controller = pnModGetVar($Module, 'dbController');
	$result = '';
	switch($controller)
	{
	case 'doctrine':
		$result = 'Doctrine';
	break;
	default:
		$result = 'Doctrine';
	
	}
	
	return $result;
}

?>