/* Copyright (c) 2006-2011 by OpenLayers Contributors (see authors.txt for 
 * full list of contributors). Published under the Clear BSD license.  
 * See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * @requires OpenLayers/Control/Panel.js
 * @requires OpenLayers/Control/Navigation.js
 * @requires OpenLayers/Control/DrawFeature.js
 * @requires OpenLayers/Handler/Point.js
 * @requires OpenLayers/Handler/Path.js
 * @requires OpenLayers/Handler/Polygon.js
 */

/**
 * Class: OpenLayers.Control.EditingToolbar
 * The EditingToolbar is a panel of 4 controls to draw polygons, lines,
 * points, or to navigate the map by panning. By default it appears in the
 * upper right corner of the map.
 *
 * Inherits from:
 *  - <OpenLayers.Control.Panel>
 */
var callbackcambiocontrol = null;
OpenLayers.Control.AddaxToolbar = OpenLayers.Class(
    OpenLayers.Control.Panel, {

        persist: true,
        immediate: false,
        drawControls: null,
        measureControls: null,
        displayPopup: null,
        selectlocation: null,
        navigationControl: null,

        /**
         * Constructor: OpenLayers.Control.EditingToolbar
         * Create an editing toolbar for a given layer.
         *
         * Parameters:
         * layer - {<OpenLayers.Layer.Vector>}
         * options - {Object}
         */
        initialize: function(layer, options) {
            OpenLayers.Control.Panel.prototype.initialize.apply(this, [options]);

            this.navigationControl = new OpenLayers.Control.Navigation();

            this.addControls(
                [ this.navigationControl ]
            );

            var url = null, w = null, h = null;

            if(typeof (options) != "undefined")
            {
                if(typeof (options["persist"]) != "undefined")
                {
                    this.persist = options["persist"];
                }
                if(typeof (options["immediate"]) != "undefined")
                {
                    this.immediate = options["immediate"];
                }
                if(typeof (options["url"]) != "undefined")
                {
                    url = options["url"];
                }
                if(typeof (options["w"]) != "undefined")
                {
                    w = options["w"];
                }
                if(typeof (options["h"]) != "undefined")
                {
                    h = options["h"];
                }
            }

            var sketchSymbolizers = {
                "Point": {
                    pointRadius: 4,
                    graphicName: "square",
                    fillColor: "white",
                    fillOpacity: 1,
                    strokeWidth: 1,
                    strokeOpacity: 1,
                    strokeColor: "#333333"
                }
                , "Line": {
                    strokeWidth: 2,
                    strokeOpacity: 1,
                    strokeColor: "#666666",
                    strokeDashstyle: "dash"
                }
                , "Polygon": {
                    strokeWidth: 2,
                    strokeOpacity: 1,
                    strokeColor: "#666666",
                    fillColor: "white",
                    fillOpacity: 0.3
                }
            };
            var style = new OpenLayers.Style();
            style.addRules([new OpenLayers.Rule({symbolizer: sketchSymbolizers})]);
            var styleMap = new OpenLayers.StyleMap({"default": style});

            this.drawControls = {
                "point": new OpenLayers.Control.DrawFeature(layer, OpenLayers.Handler.Point, {'displayClass': 'olControlDrawFeaturePoint'})
                , "path": new OpenLayers.Control.DrawFeature(layer, OpenLayers.Handler.Path, {'displayClass': 'olControlDrawFeaturePath'})
                , "polygon": new OpenLayers.Control.DrawFeature(layer, OpenLayers.Handler.Polygon, {'displayClass': 'olControlDrawFeaturePolygon'})
            };

            this.measureControls = {
                "path": new OpenLayers.Control.Measure(
                    OpenLayers.Handler.Path, {
                        "persist": this.persist
                        , "immediate": this.immediate
                        , "handlerOptions": {
                            layerOptions: {styleMap: styleMap}
                        }
                        , "displayClass": "olControlMeasurePath"
                    }
                )
                , "polygon": new OpenLayers.Control.Measure(
                    OpenLayers.Handler.Polygon, {
                        "persist": this.persist
                        , "immediate": this.immediate
                        , "handlerOptions": {
                            layerOptions: {styleMap: styleMap}
                        }
                        , "displayClass": "olControlMeasurePolygon"
                    }
                )
            }

            this.selectlocation = new OpenLayers.Control.SelectLocation({"displayClass": "olControlSelectLocation"});
            if(url != null)
            {
                this.selectlocation.url = url;
            }
            if(w != null)
            {
                this.selectlocation.w = w;
            }
            if(h != null)
            {
                this.selectlocation.h = h;
            }

            this.measureControls.path.events.on({
                "measure": this.handleMeasurements,
                "measurepartial": this.handleMeasurements
            });
            this.measureControls.polygon.events.on({
                "measure": this.handleMeasurements,
                "measurepartial": this.handleMeasurements
            });

            this.addControls([
                /*this.drawControls.point
                , this.drawControls.path
                , this.drawControls.polygon
                ,*/ this.measureControls.path
                , this.measureControls.polygon
                , this.selectlocation
            ]);
        },

        /**
         * Method: draw
         * calls the default draw, and then activates mouse defaults.
         *
         * Returns:
         * {DOMElement}
         */
        draw: function() {
            var div = OpenLayers.Control.Panel.prototype.draw.apply(this, arguments);
            if (this.defaultControl === null) {
                this.defaultControl = this.controls[0];
            }
            return div;
        },

        handleMeasurements: function(event)
        {
            var geometry = event.geometry;
            var units = event.units;
            var order = event.order;
            var measure = event.measure;
            var out = "";
            var components = null, x = null, y = null;
            if(order == 1)
            {
                component = event.geometry.components;
                out += measure.toFixed(3) + " " + units;
            }
            else
            {
                component = event.geometry.components[0].components;
                out += measure.toFixed(3) + " " + units + "<sup>2</" + "sup>";
            }
            if(this.displayPopup != null)
            {
                this.displayPopup.destroy();
                this.displayPopup = null;
            }
            if(component.length > 2)
            {
                x = component[component.length - 2].x;
                y = component[component.length - 2].y;
            }
            else
            {
                x = component[0].x;
                y = component[0].y;
            }
            this.displayPopup = new OpenLayers.Popup.OnMouse(
                "measure"
                , new OpenLayers.LonLat(x, y)
                , new OpenLayers.Size(110,18)
                , out);
            this.map.addPopup(this.displayPopup);
        },


        activateControl: function (control)
        {
            if(this.displayPopup != null)
            {
                this.map.removePopup(this.displayPopup);
                this.displayPopup.destroy();
                this.displayPopup = null;
            }
            for(i in this.map.popups)
            {
                if(this.map.popups[i].id == "measure")
                {
                    this.map.removePopup(this.map.popups[i]);
                }
            }
            if(control != this.navigationControl && control != this.selectlocation)
            {
                if(this.selectlocation.popup != null)
                {
                    try
                    {
                        this.map.removePopup(this.selectlocation.popup);
                        this.selectlocation.popup.destroy();
                        this.selectlocation.popup = null;
                    }
                    catch(e){}
                }
            }
            OpenLayers.Control.Panel.prototype.activateControl.apply(this, [control]);
            if( typeof callbackcambiocontrol == 'function' ){

                callbackcambiocontrol(control);
            }
        },

        CLASS_NAME: "OpenLayers.Control.AddaxToolbar"
    });
