/* Copyright (c) 2006-2011 by OpenLayers Contributors (see authors.txt for 
 * full list of contributors). Published under the Clear BSD license.  
 * See http://svn.openlayers.org/trunk/openlayers/license.txt for the
 * full text of the license. */

/**
 * @requires OpenLayers/BaseTypes/Class.js
 */


/**
 * Class: OpenLayers.Popup.Selected
 * A popup is a small div that can opened and closed on the map.
 * Typically opened in response to clicking on a marker.  
 * See <OpenLayers.Marker>.  Popup's don't require their own
 * layer and are added the the map using the <OpenLayers.Map.addPopup>
 * method.
 *
 * Example:
 * (code)
 * popup = new OpenLayers.Popup.Selected("chicken", 
 *                    new OpenLayers.LonLat(5,40),
 *                    new OpenLayers.Size(200,200),
 *                    "example popup",
 *                    true);
 *       
 * map.addPopup(popup);
 * (end)
 */
OpenLayers.Popup.Selected = OpenLayers.Class(OpenLayers.Popup, {
	
    /** 
     * Property: displayClass
     * {String} The CSS class of the popup.
     */
    displayClass: "olPopupSelected",

    /** 
     * Property: contentDisplayClass
     * {String} The CSS class of the popup content div.
     */
    contentDisplayClass: "olPopupSelectedContent",

    /** 
    * Constructor: OpenLayers.Popup
    * Create a popup.
    * 
    * Parameters: 
    * id - {String} a unqiue identifier for this popup.  If null is passed
    *               an identifier will be automatically generated. 
    * lonlat - {<OpenLayers.LonLat>}  The position on the map the popup will
    *                                 be shown.
    * contentSize - {<OpenLayers.Size>} The size of the content.
    * contentHTML - {String}          An HTML string to display inside the   
    *                                 popup.
    * closeBox - {Boolean}            Whether to display a close box inside
    *                                 the popup.
    * closeBoxCallback - {Function}   Function to be called on closeBox click.
    */
    initialize:function(id, lonlat, minSize, contentHTML, closeBox)
    {
        var newArguments = [
            id, lonlat, minSize, contentHTML, closeBox
        ];
        this.minSize = minSize;
        OpenLayers.Popup.prototype.initialize.apply(this, newArguments);
        
    },

	setContent: function(data)
	{
		id = OpenLayers.Util.createUniqueID("Content_");
		var html = "<table id=\""+id+"\" style=\"width: 390px; border-collapse: collapse; border-width: 0px;\">";
		var count = 0;
		for(i in data)
		{
			if(count++ % 2 == 0)
			{
				html += "<tr style=\"border-width: 0px; background-color: #79A9CF; \">";
			}
			else
			{
				html += "<tr style=\"border-width: 0px; \">";
			}
			html += "<td style=\"width: 120px;\">"+i+"</td>";
			html += "<td style=\"width: 260px;\">"+data[i]+"</td>";
			html += "</tr>";
		}
		html += "</table>";
        OpenLayers.Popup.prototype.setContentHTML.apply(this, [html]);
		this.size = new OpenLayers.Size(402, $("#"+id).height()+20);
		this.minSize = new OpenLayers.Size(402, $("#"+id).height()+20);
		this.updateSize();
	},

    CLASS_NAME: "OpenLayers.Popup.Selected"
});
