<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 3/23/15
 * Time: 10:05 AM
 */

class CapasBatchProcessor {

    public static $HISTORICO_CORTEANUAL = 'cortesanno';
    public static $HISTORICO_ACTIVOSANUAL = 'activosanno';

    public static $FIRMADOS_ACTIVOS = 'activo';
    public static $FIRMADOS_INACTIVOS = 'inactivo';
    public static $FIRMADOS_TODOS = 'todos';

    public static $SOLICITUDESANUAL_ACEPTADOS = 'aceptados';
    public static $SOLICITUDESANUAL_OTROS = 'estados';
    public static $CRBOUNDINGBOX = array(
'minx' =>307192.73816646065
,'maxx' =>653148.3818874996
,'miny' =>918371.0526256651
,'maxy' =>1238311.4951200902
,'crs' =>"EPSG:5367"


);
    public function __construct(){
        Zend_Loader::loadClass('GeonetworksHandler');
        Zend_Loader::loadClass('CurlHandler');
        Zend_Loader::loadClass('GeoserverWrapper');

        $this->config = Zend_Registry::get('config');
        $this->_temporaryRepository = $this->config->repository->temporaryrepository;
        $this->_ChunksPath = $this->config->repository->chunks->path;

        $this->directorio_temporales = $this->config->repository->temporaryrepository;
        $this->directorio_temporales2 = $this->config->repository->temporaryrepository2;
        $this->datadirfonafifo = $this->config->repository->datadirfonafifo;
        $this->contratoshistoricos = $this->config->repository->contratoshistoricos;
        $this->contratoshistoricospublicos = $this->config->repository->contratoshistoricospublicos;
        $this->prioridadespublicos = $this->config->repository->prioridadespublicos;
        $this->ogrdirectory = $this->config->repository->ogrdirectory;
        $this->db_host = $this->config->geopsa->db->host;
        $this->db_database = $this->config->geopsa->db->database;
        $this->db_database_sisus = $this->config->geopsa->db->databasesisus;
        $this->db_uid = $this->config->geopsa->db->uid;
        $this->db_pass = $this->config->geopsa->db->pass;

        /*
         * geopsa.contratoshistoricos.ws = 'Contratos'
geopsa.contratoshistoricos.store = 'ContratosHistorico'

         */
        $this->contratoshistoricos_ws = $this->config->geopsa->contratoshistoricos->ws;
        $this->contratoshistoricos_store = $this->config->geopsa->contratoshistoricos->store;
        $this->contratoshistoricos_style= $this->config->geopsa->contratoshistoricos->style;

        $this->solicitudesanual_ws = $this->config->geopsa->solicitudesanual->ws;
        $this->solicitudesanual_store = $this->config->geopsa->solicitudesanual->store;
        $this->solicitudesanual_style= $this->config->geopsa->solicitudesanual->style;

        $this->contratosfirmados_ws = $this->config->geopsa->contratosfirmados->ws;
        $this->contratosfirmados_store = $this->config->geopsa->contratosfirmados->store;

        $this->contratosfirmados_style= $this->config->geopsa->contratosfirmados->style;


        $this->prioridadespublicas_ws = $this->config->geopsa->prioridadespublicas->ws;
        $this->prioridadespublicas_store = $this->config->geopsa->prioridadespublicas->store;

        $this->cargarConfigCapas();
        //repository.datadirhistorico
        $this->datadirhistorico = $this->config->repository->datadirhistorico;
        error_log("Config capas: " . print_r($this->capas_prioridad, true)); //die;

    }
    private function cargarConfigCapas(){
        $this->capas_prioridad = array();
        if(!$this->config->geopsa->capas){
            return false;
        }
        //geopsa.capas.lista
        $listacapas = $this->config->geopsa->capas->lista;
        $ws = $this->config->geopsa->capas->prioridades->ws;
        $store = $this->config->geopsa->capas->prioridades->store;
        $ws_historico = $this->config->geopsa->capas->prioridadeshistorico->ws;
        $store_historico = $this->config->geopsa->capas->prioridadeshistorico->store;
        foreach($listacapas as $capaactual){
            //geopsa.capas.prioridades.capa_prioridades_areassilvestresprotegidas.id
            $idactual = $this->config->geopsa->capas->prioridades->{$capaactual}->id;
            $tabla = $this->config->geopsa->capas->prioridades->{$capaactual}->tabla;
            $capa = $this->config->geopsa->capas->prioridades->{$capaactual}->capa;
            $estilo = $this->config->geopsa->capas->prioridades->{$capaactual}->estilo;
            if($idactual && $tabla && $capa){
                $this->capas_prioridad[$capa] = array('tabla' => $tabla, 'capa' => $capa, 'id' => $idactual
                ,'estilo' => $estilo
                ,'ws' => $ws, 'store' => $store
                ,'ws_historico' => $ws_historico, 'store_historico' => $store_historico

                );
            }
        }

    }

    public function cierreHistoricoAnual($anno = false){
        //Ejecuta el cierre historicoanual para activos y del anno.
        $this->cierreHistoricoAnualDo(self::$HISTORICO_CORTEANUAL, $anno);
        $this->cierreHistoricoAnualDo(self::$HISTORICO_ACTIVOSANUAL,$anno);

    }
    public function cierreHistoricoAnualDo($activos = false, $anno = false){
        //activos o los del anno nada mas.
        $nombre = '';
        if(!$anno)
            $anno = date("Y");

        $where = "";$separador = " AND ";
        if($activos == self::$HISTORICO_ACTIVOSANUAL){
            $where .= " $separador ( (solicitudes.AnioSolicitud + 4) >= $anno )";//la solicitud tiene 4 años o menos, esta activa.
            $nombre = self::$HISTORICO_ACTIVOSANUAL;
        }
        if($activos == self::$HISTORICO_CORTEANUAL){
            $where .= " $separador ( solicitudes.AnioSolicitud = year(getdate()) )";//Solicitud tiene que ser de este anno.
            $nombre = self::$HISTORICO_CORTEANUAL;
        }
        $sqlejecutar = <<<EDO
            SELECT
              capa.ogr_geometry, capa.IdContrato
              , contratos.NumeroContrato as numerocontrato
              , contratos.NumeroSolicitudIngreso as numerosolicitud
              , contratos.NumeroSolicitudIngreso as Contrato
              , contratos.Modalidad as modalidad
              , contratos.MontoContrato as montocontrato
              , contratos.EstadoContrato as estadocontrato
              , contratos.OficinaRegional as oficinaregional
              , contratos.NombreCliente as Beneficiar
              , contratos.ArbolesPSA as ARB_PSA
              , contratos.HectareaPSA as HAS_PSA
              ,solicitudes.AnioSolicitud as annosolicitud
              ,solicitudes.OficinaRegional as oficina
              ,solicitudes.CodigoOficina as codigooficina
    FROM         GEOPSA_CAPAS_CONTRATOS_POLIGONOS capa
                   INNER JOIN GeoContratos contratos ON contratos.NumeroContrato = capa.IdContrato
                   INNER JOIN GeoSolicitudes solicitudes ON solicitudes.idSolicitudIngreso = contratos.idSolicitudIngreso
    WHERE     (UltimaVersion = 1 )
                $where
EDO;
        $sqlejecutar = str_replace("\n", " ", $sqlejecutar);
        $sqlejecutar = str_replace("\r", " ", $sqlejecutar);
        $sqlejecutar = str_replace("\t", " ", $sqlejecutar);

        $capaentityname = "contratoshistoricos_".$nombre."_".$anno;
        $archivoshpactual = $this->contratoshistoricos . DIRECTORY_SEPARATOR . $capaentityname . ".shp";
        echo ("Creando capa [$archivoshpactual]\n");
        $comando =
            //' && '.
            $this->ogrdirectory.DIRECTORY_SEPARATOR
            .'ogr2ogr.exe -overwrite -a_srs "EPSG:5367" -skipfailures -sql '
            //.' -nln '."$capaentityname".' '
            .' "'.$sqlejecutar.'" '.
            ' -f "ESRI Shapefile" "'.$archivoshpactual
            .'" "MSSQL:server='.$this->db_host.';database='.$this->db_database_sisus.';uid='.$this->db_uid.';pwd='.$this->db_pass.'" 2>&1';
        error_log("Ejecutando comando  1: [$comando]");
        echo("Ejecutando comando  1: [$comando]");
        $resultadoarr = array();
        $resultadoint = 0;

        //$comando = '"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr.exe" -overwrite -a_srs "EPSG:5367" -nln "capastemp_1426125364" -f MSSQLSpatial "MSSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\ORegionales\regionales_regionales_20150310_1328.shp"  2>&1';

        $resultado = exec($comando, $resultadoarr, $resultadoint);
        error_log(" Resultados [$resultadoint] [$resultado] ". print_r($resultadoarr, true));
        echo(" Resultados [$resultadoint] [$resultado] ". print_r($resultadoarr, true));
        if($resultadoint == 0){
            //Copiar a servidor privado y publicar la capa.

            $geohandler = new GeonetworksHandler();
            $ws = $this->contratoshistoricos_ws;
            $store = $this->contratoshistoricos_store;
            $estilo = $this->contratoshistoricos_style;
            $layername = $capaentityname;

            //Borrar si ya existe, primero.
            $geohandler->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
            $retornoaddlayer = $geohandler->addLayer($ws, $layername, $store, "", PROYECCION_CRTM05, array(), $estilo);
            $retornosetstye = $geohandler->updateLayerStyle($ws, $layername, $estilo );

            //Copiar los archivos hacia el directorio publico.


        }

    }
    function recurse_copy($src,$dst) {
        $dir = opendir($src);
        @mkdir($dst);
        while(false !== ( $file = readdir($dir)) ) {
            if (( $file != '.' ) && ( $file != '..' )) {
                if ( is_dir($src . '/' . $file) ) {
                    recurse_copy($src . '/' . $file,$dst . '/' . $file);
                }
                else {
                    copy($src . '/' . $file,$dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }
    public function actualizarVisorPublico($anno = false){
        //Copiar y publicar capas de Contratos, Prioridades.

        $this->actualizarPrioridades($anno);
        $this->actualizarContratosHistoricos($anno);

    }
    public function actualizarPrioridades($anno = false){
        $geohandlerpublico = new GeonetworksHandler(GEOSERVERPUBLICSERVICEURL);

        $this->datadirhistorico; //directorio de prioridades historico.
        $this->prioridadespublicos;

        $ws = $this->prioridadespublicas_ws;
        $store = $this->prioridadespublicas_store;


        $prioridadeshistoricos = glob ( $this->datadirhistorico . DIRECTORY_SEPARATOR . "*.shp");
        $prioridades_porfecha = array();
        foreach($prioridadeshistoricos as $key=> $prioridadeshistorico_actual){
            $infoarchivo = pathinfo($prioridadeshistorico_actual);
            $nombresinextension = $infoarchivo['filename'];

            $partes = explode('_', $nombresinextension);
            $horamin = array_pop ( $partes );
            $annomesdia = array_pop ( $partes );
            $capaname = implode('_',$partes);

            if(!is_array($prioridades_porfecha[$capaname])){
                $prioridades_porfecha[$capaname] = array();
            }
            $prioridades_porfecha[$capaname][$annomesdia.$horamin] = $prioridadeshistorico_actual;
        }
        error_log("Prioridadesporfecha:[". print_r($prioridades_porfecha, true));
        foreach ($prioridades_porfecha as $capaname => $prioridadeshistorico_actual) {
            ksort($prioridades_porfecha[$capaname]);//ordena de menor a mayor.
            //Solo se copia/inserta la mas reciente.
            $capamasreciente = array_pop($prioridades_porfecha[$capaname]);//el ultimo seria el mas reciente. mayor.
            error_log("Capa mas reciente: [$capamasreciente]");
            $infoarchivo = pathinfo($capamasreciente);
            $nombresinextension = $infoarchivo['filename'];
            $nombrearchivoconextension = $infoarchivo['basename'];
            //Copiarlo y luego publicarlo.
            $archivoscopiar = glob($this->datadirhistorico . DIRECTORY_SEPARATOR .$nombresinextension.".*");//todos los archivos de la capa.
            error_log("Copiar los de ".$this->datadirhistorico . DIRECTORY_SEPARATOR .$nombresinextension.".*");
            foreach($archivoscopiar as $archivocopiar_actual){
                $infoarchivo_destino = pathinfo($capamasreciente);
                copy($archivocopiar_actual,$this->prioridadespublicos . DIRECTORY_SEPARATOR .$infoarchivo_destino['basename']);

            }
            //Publicar la capa.
            //$this->capas_prioridad[$capa]

            //$estilo = $this->contratoshistoricos_style;
            $infocapa = $this->capas_prioridad[$capaname];
            $estilo = $infocapa['estilo'];
            $title = $capaname;
            $layername = $nombresinextension;

            //Borrar si ya existe, primero.
            $geohandlerpublico->deleteLayer($title, $ws, $store);//Se elimina y se reagrega la capa.
            $geohandlerpublico->deleteLayer($title, $ws, $store);//Se elimina y se reagrega la capa.
            error_log("Agregando capa $ws, $layername, $store \n");
            echo("Agregando capa $ws, $layername, $store \n");

            $retornoaddlayer = $geohandlerpublico->addLayer($ws, $layername, $store, "", PROYECCION_CRTM05, array(), $estilo, $title);
            $retornosetstye = $geohandlerpublico->updateLayerStyle($ws, $layername, $estilo );
            if(empty($retornoaddlayer)){
                error_log("Agregando capa SQL resutltado exito [".print_r($retornoaddlayer, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($retornoaddlayer, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($retornoaddlayer, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($retornoaddlayer, true)."]\n");
            }


        }

    }
    public function actualizarContratosHistoricos($anno = false){
        $geohandlerpublico = new GeonetworksHandler(GEOSERVERPUBLICSERVICEURL);
        //Copiar historicos publicos.
        $this->contratoshistoricos;//de aca se copia todohacia el directorio del visor publico.
        $this->recurse_copy($this->contratoshistoricos,$this->contratoshistoricospublicos);

        $ws = $this->contratoshistoricos_ws;
        $store = $this->contratoshistoricos_store;
        $estilo = $this->contratoshistoricos_style;

        $contratoshistoricos = glob ( $this->contratoshistoricospublicos . DIRECTORY_SEPARATOR . "*.shp");
        error_log("Lista de contratos historicos: [". print_r($contratoshistoricos, true));
        echo("Lista de contratos historicos: [". print_r($contratoshistoricos, true)."\n");
        foreach($contratoshistoricos as $key=> $contratohistorico_actual){
            $infoarchivo = pathinfo($contratohistorico_actual);
            $nombresinextension = $infoarchivo['filename'];
            //Publicar en el geoserver publico.
            //$geohandlerpublico

            $layername = $nombresinextension;

            //Borrar si ya existe, primero.
            $geohandlerpublico->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
            $geohandlerpublico->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
            error_log("Agregando capa $ws, $layername, $store \n");
            echo("Agregando capa $ws, $layername, $store \n");

            $retornoaddlayer = $geohandlerpublico->addLayer($ws, $layername, $store, "", PROYECCION_CRTM05, array(), $estilo);
            $retornosetstye = $geohandlerpublico->updateLayerStyle($ws, $layername, $estilo );
            if(empty($retornoaddlayer)){
                error_log("Agregando capa SQL resutltado exito [".print_r($retornoaddlayer, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($retornoaddlayer, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($retornoaddlayer, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($retornoaddlayer, true)."]\n");
            }

        }
    }
    public function firmadosAnnoActual($anno = false){
        //Estas son capas de vista a la BD.
        $this->firmadosAnnoActualDo(self::$FIRMADOS_ACTIVOS, $anno);
        $this->firmadosAnnoActualDo(self::$FIRMADOS_INACTIVOS,$anno);
        $this->firmadosAnnoActualDo(self::$FIRMADOS_TODOS,$anno);
    }
    /*
     *
        $sql = <<<EOD
            SELECT geop.*
            FROM capas_contratos_poligonos geop
                INNER JOIN psa_GeoContratos contr ON contr.IdContrato = geop.IdContrato
            WHERE
                contr.anio = 2015
EOD;

        $geohandler = new GeonetworksHandler();

        $workspace = "Contratos";
        $datastore = "Contratos";
        $layer = "contratos_todos_2015";
        $description = "";
        $declaredSRS = PROYECCION_CRTM05;
        $metadatalinks = array();
        $defaultStyle = "psa2011";
        $nativeBoundingBox = array(
            'minx' =>307192.73816646065
        ,'maxx' =>653148.3818874996
        ,'miny' =>918371.0526256651
        ,'maxy' =>1238311.4951200902
        ,'crs' =>"EPSG:5367"


        );
        $latLonBoundingBox = false;
        $viewsql = $sql;
        $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql );

     */
    public function firmadosAnnoActualDo($estado = false, $anno = false){
        //Contratos:contratos_poligonos_todos_2015
        //activos o los del anno nada mas.
        $nombre = '';
        if(!$anno)
            $anno = date("Y");

        $where = "";$separador = " AND ";

        switch($estado){
            case self::$FIRMADOS_ACTIVOS:
                $where.= $separador. " contratos.EstadoContrato = 'a' ";
                $nombre = self::$FIRMADOS_ACTIVOS;
                break;
            case self::$FIRMADOS_INACTIVOS:
                $where.= $separador. " contratos.EstadoContrato = 'i' ";
                $nombre = self::$FIRMADOS_INACTIVOS;
                break;
            case self::$FIRMADOS_TODOS:
                $where.= "";
                $nombre = self::$FIRMADOS_TODOS;
                break;

        }

        $sql = <<<EOD
            SELECT
          capa.ogr_geometry, capa.IdContrato
          , contratos.NumeroContrato as numerocontrato
          , contratos.NumeroSolicitudIngreso as numerosolicitud
          , contratos.NumeroSolicitudIngreso as Contrato
          , contratos.Modalidad as modalidad
          , contratos.MontoContrato as montocontrato
          , contratos.EstadoContrato as estadocontrato
          , contratos.OficinaRegional as oficinaregional
          , contratos.NombreCliente as Beneficiar
          , contratos.ArbolesPSA as ARB_PSA
          , contratos.HectareaPSA as HAS_PSA
          ,solicitudes.AnioSolicitud as annosolicitud
          ,solicitudes.OficinaRegional as oficina
          ,solicitudes.CodigoOficina as codigooficina
FROM         GEOPSA_CAPAS_CONTRATOS_POLIGONOS capa
               INNER JOIN GeoContratos contratos ON contratos.NumeroContrato = capa.IdContrato
               INNER JOIN GeoSolicitudes solicitudes ON solicitudes.idSolicitudIngreso = contratos.idSolicitudIngreso
WHERE     (UltimaVersion = 1 ) AND solicitudes.AnioSolicitud = $anno
        $where

EOD;

        $geohandler = new GeonetworksHandler();

        $workspace = $this->contratosfirmados_ws;
        $datastore = $this->contratosfirmados_store;
        $layer = "contratos_poligonos_".$nombre."_" . $anno;//contratos_poligonos_todos_2015
        $description = $layer;
        $declaredSRS = PROYECCION_CRTM05;
        $metadatalinks = array();
        $defaultStyle = $this->contratosfirmados_style;
        $nativeBoundingBox = self::$CRBOUNDINGBOX;
        $latLonBoundingBox = false;
        $viewsql = $sql;

        $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
        $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
        error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
        echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");
        $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql );
        $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

        if(empty($result)){
            error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
        }else{
            error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
        }

    }

    public function agregarCapasOficinasRegionales($cantidad = 12){

        for($numoficina = 1; $numoficina <= $cantidad; $numoficina++){

            $sql = <<<EOD
            SELECT     capa.ogr_geometry
		  ,capa.IdSolicitud
          ,solicitudes.idSolicitudIngreso
          ,solicitudes.NumeroSolicitudIngreso as numerosolicitud
          ,solicitudes.NumeroFolio as finca
          ,solicitudes.idEstadoSolicitudIngreso as codigoestado
          ,solicitudes.nombreModalidad as modalidad
          ,solicitudes.SubModalidad as submodalidad
          ,solicitudes.AnioSolicitud as annosolicitud
          ,solicitudes.OficinaRegional as oficina
          ,solicitudes.CodigoOficina as codigooficina
FROM         GEOPSA_CAPAS_SOLICITUDES_POLIGONOS capa
               INNER JOIN GEOPSA_GEOSOLICITUDES gepsasolicitudes ON gepsasolicitudes.idsolicitud = capa.IdSolicitud
               INNER JOIN GeoSolicitudes solicitudes ON gepsasolicitudes.idsolicitudingreso = solicitudes.idSolicitudIngreso AND gepsasolicitudes.idfinca = solicitudes.idFinca
WHERE     (capa.UltimaVersion = 1 AND solicitudes.idEstadoSolicitudIngreso &lt;= 140 AND solicitudes.CodigoOficina = $numoficina )


EOD;

            $geohandler = new GeonetworksHandler();


            $workspace = $this->solicitudesanual_ws;
            $datastore = $this->solicitudesanual_store;
            $layer = "solicitudes_poligonos_".$numoficina;//solicitudes_poligonos_8
            $description = $layer;
            $declaredSRS = PROYECCION_CRTM05;
            $metadatalinks = array();
            $defaultStyle = $this->solicitudesanual_style;
            $nativeBoundingBox = self::$CRBOUNDINGBOX;
            $latLonBoundingBox = false;
            $viewsql = $sql;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql );
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }

        }


    }

    public function solicitudesAnual($anno = false){
        //estas capas son vistas a la BD.
        $this->solicitudesAnualDo(self::$SOLICITUDESANUAL_ACEPTADOS,$anno);
        $this->solicitudesAnualDo(self::$SOLICITUDESANUAL_OTROS,$anno);
    }
    public function solicitudesAnualDo($estado = false, $anno = false){

        //Solicitudes:solicitudes_poligonos_estados_2015
        //activos o los del anno nada mas.
        $nombre = '';
        if(!$anno)
            $anno = date("Y");

        $where = "";$separador = " AND ";

        switch($estado){
            /*
             * >= se traduce como: &gt;=
             */
            case self::$SOLICITUDESANUAL_ACEPTADOS:
                $where.= $separador. " solicitudes.idEstadoSolicitudIngreso &gt; 140 ";
                $nombre = self::$SOLICITUDESANUAL_ACEPTADOS;
                break;
            case self::$SOLICITUDESANUAL_OTROS:
                $where.= $separador. " solicitudes.idEstadoSolicitudIngreso &lt; 150 ";
                $nombre = self::$SOLICITUDESANUAL_OTROS;
                break;


        }

        $sql = <<<EOD
            SELECT     capa.ogr_geometry
            ,capa.IdSolicitud
          ,solicitudes.idSolicitudIngreso
          ,solicitudes.NumeroSolicitudIngreso as numerosolicitud
          ,solicitudes.NumeroFolio as finca
          ,solicitudes.idEstadoSolicitudIngreso as codigoestado
          ,solicitudes.nombreModalidad as modalidad
          ,solicitudes.SubModalidad as submodalidad
          ,solicitudes.AnioSolicitud as annosolicitud
          ,solicitudes.OficinaRegional as oficina
          ,solicitudes.CodigoOficina as codigooficina
FROM         GEOPSA_CAPAS_SOLICITUDES_POLIGONOS capa
               INNER JOIN GEOPSA_GEOSOLICITUDES gepsasolicitudes ON gepsasolicitudes.idsolicitud = capa.IdSolicitud
               INNER JOIN GeoSolicitudes solicitudes ON gepsasolicitudes.idsolicitudingreso = solicitudes.idSolicitudIngreso AND gepsasolicitudes.idfinca = solicitudes.idFinca

WHERE     (UltimaVersion = 1 ) AND solicitudes.AnioSolicitud = $anno
        $where

EOD;

        $sql = str_replace("\n", " ", $sql);
        $sql = str_replace("\r", " ", $sql);
        $sql = str_replace("\t", " ", $sql);
        $sql = str_replace("  ", " ", $sql);

        $geohandler = new GeonetworksHandler();

        $workspace = $this->solicitudesanual_ws;
        $datastore = $this->solicitudesanual_store;
        $layer = "solicitudes_poligonos_".$nombre."_" . $anno;//solicitudes_poligonos_estados_2015
        $description = $layer;
        $declaredSRS = PROYECCION_CRTM05;
        $metadatalinks = array();
        $defaultStyle = $this->solicitudesanual_style;
        $nativeBoundingBox = self::$CRBOUNDINGBOX;
        $latLonBoundingBox = false;
        $viewsql = $sql;

        $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
        $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
        error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
        echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");
        $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql );
        $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );
        if(empty($result)){
            error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
        }else{
            error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
        }



    }




    public function capas_geodatosConQuery_do(){
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();

        $sqlEjecucion = <<<EOD
        SELECT
            id
            ,nombredespliegue
            ,nombrews
            ,nombrecapa
            ,nombretabla
            ,tipogeometria
            FROM su_geodatos

EOD;
        $capasgeodatos = $conn->fetchAssoc($sqlEjecucion);

        foreach($capasgeodatos as $capaactual){
            $id_capa = $capaactual['id'];
            $nombrews = $capaactual['nombrews'];
            $nombrecapa = $capaactual['nombrecapa'];
            $nombretabla = $capaactual['nombretabla'];
            $nombrecapa_query = $capaactual['nombrecapa'] . "_q";
            $sql = <<<EOD
            SELECT
                geo.OGR_FID
                ,geo.SHAPE
                ,geo.fecha as ultima_actualizacion
                ,s.nombre
                ,s.cod_expediente

            FROM
                su_solicitudes_PMB s
                INNER JOIN $nombretabla geo ON s.id = geo.solicitud_pmb_id AND geo.ultimaversion = 1 AND geo.su_geodatos_id = $id_capa
            WHERE s.id = %sol%


EOD;

            $geohandler = new GeonetworksHandler();

            $workspace = $nombrews;
            $datastore = $nombrews;
            $layer =$nombrecapa_query;//contratos_poligonos_todos_2015
            $description = $layer;
            $declaredSRS = PROYECCION_CRTM05;
            $metadatalinks = array();
            $defaultStyle = $nombrecapa;
            $nativeBoundingBox = self::$CRBOUNDINGBOX;
            $latLonBoundingBox = false;
            $viewsql = $sql;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");

            $viewparametersxml = "
            <parameter>
              <name>sol</name>
              <defaultValue>15</defaultValue>
              <regexpValidator>^[\d]+$</regexpValidator>
            </parameter>
            ";
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql ,$viewparametersxml);
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }
        }




    }

    public function capas_geodatosSinQuery_do(){
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();

        $sqlEjecucion = <<<EOD
        SELECT
            id
            ,nombredespliegue
            ,nombrews
            ,nombrecapa
            ,nombretabla
            ,tipogeometria
            FROM su_geodatos

EOD;
        $capasgeodatos = $conn->fetchAssoc($sqlEjecucion);

        foreach($capasgeodatos as $capaactual){
            $id_capa = $capaactual['id'];
            $nombrews = $capaactual['nombrews'];
            $nombrecapa = $capaactual['nombrecapa'];
            $nombretabla = $capaactual['nombretabla'];
            $nombrecapa_query = $capaactual['nombrecapa'];
            $sql = <<<EOD
            SELECT
                geo.OGR_FID
                ,geo.SHAPE
                ,geo.fecha as ultima_actualizacion
                ,s.nombre
                ,s.cod_expediente

            FROM
                su_solicitudes_PMB s
                INNER JOIN $nombretabla geo ON s.id = geo.solicitud_pmb_id AND geo.ultimaversion = 1 AND geo.su_geodatos_id = $id_capa

EOD;

            $geohandler = new GeonetworksHandler();

            $workspace = $nombrews;
            $datastore = $nombrews;
            $layer =$nombrecapa_query;//contratos_poligonos_todos_2015
            $description = $layer;
            $declaredSRS = PROYECCION_CRTM05;
            $metadatalinks = array();
            $defaultStyle = $nombrecapa;
            $nativeBoundingBox = self::$CRBOUNDINGBOX;
            $latLonBoundingBox = false;
            $viewsql = $sql;

            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            $geohandler->deleteLayer($layer, $workspace, $datastore);//Se elimina y se reagrega la capa.
            error_log("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]");
            echo("Agregando capa SQL: $workspace, $layer, $datastore, $description [$viewsql]\n");

            $viewparametersxml = "
            <parameter>
              <name>sol</name>
              <defaultValue>15</defaultValue>
              <regexpValidator>^[\d]+$</regexpValidator>
            </parameter>
            ";
            $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql);
            $retornosetstye = $geohandler->updateLayerStyle($workspace, $layer, $defaultStyle );

            if(empty($result)){
                error_log("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado exito [".print_r($result, true)."]\n");
            }else{
                error_log("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
                echo("Agregando capa SQL resutltado problema: [".print_r($result, true)."]\n");
            }
        }




    }
} 