<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 9/2/14
 * Time: 5:49 PM
 */

class PhotoHandler {

    public function mostrarfoto($codigo, $thumbnail = false,$indice =0){
        $listafotos = $this->getlistafotos($codigo);
        if(!$listafotos)
            $this->mostrarfotoNA();

        $fotoactual = $listafotos[$indice];
        $infoarchivo = pathinfo($fotoactual);
        $extension = $infoarchivo['extension'];
        //echo $fotoactual; die;
        if(!empty($thumbnail ) && $thumbnail !== 0 ){
            $this->getThumbnail($fotoactual, $extension);
        }else{
            $this->getFull($fotoactual, $extension);
        }
    }
    public function getlistafotos($codigo){
        $codigopadded = str_pad($codigo, 6, "0", STR_PAD_LEFT);
        $rutaposiblefotos = DIRECTORIO_FOTOS . $codigopadded . DIRECTORY_SEPARATOR . "*";
        $archivosfotos = glob($rutaposiblefotos);
        usort($archivosfotos, create_function('$a,$b', 'return filemtime($a) - filemtime($b);'));
        $cantidadfotos = count($archivosfotos);
        if($cantidadfotos < 1){
            return false;
        }else{

            return $archivosfotos;
        }

    }

    private function getFull($file, $file_extension){

        $this->printPhoto($file);

    }
    private function mostrarfotoNA(){
        $foto = DIRECTORIO_FOTOS . "na.png";

        $this->printPhoto($foto);
    }
    private function printPhoto($file){
        $infoarchivo = pathinfo($file);
        $extension = $infoarchivo['extension'];
        $content_type = "image/jpg";
        switch(strtolower($extension)) {
            case "gif": $content_type="image/gif"; break;
            case "png": $content_type="image/png"; break;
            case "bmp": $content_type="image/bmp"; break;
            case "jpeg":
            case "jpg": $content_type="image/jpg"; break;

            default: $content_type="image/png"; break;

        }


        header('Content-Type:'.$content_type);
        header('Content-Length: ' . filesize($file));
        readfile($file);
        die;
    }
    private function getThumbnail($file, $file_extension){
        $unival = time() . session_id();
        $filename = DIRECTORIO_FOTOS_TMP.$unival . ".jpg";
        @mkdir(DIRECTORIO_FOTOS_TMP, 0774, true);
        $this->make_thumb($file, $filename, 60);
        $this->printPhoto($filename);

    }

    function make_thumb($src, $dest, $desired_width) {
        /* read the source image */
        $source_image = imagecreatefromjpeg($src);
        $width = imagesx($source_image);
        $height = imagesy($source_image);

        /* find the “desired height” of this thumbnail, relative to the desired width  */
        $desired_height = floor($height * ($desired_width / $width));

        /* create a new, “virtual” image */
        $virtual_image = imagecreatetruecolor($desired_width, $desired_height);

        /* copy source image at a resized size */
        imagecopyresampled($virtual_image, $source_image, 0, 0, 0, 0, $desired_width, $desired_height, $width, $height);

        /* create the physical thumbnail image to its destination */
        imagejpeg($virtual_image, $dest);
    }

} 