<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 3/11/15
 * Time: 1:59 PM
 */
/*
 *
 * "C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -skipfailures -nln "capa_prioridades_vaciosdeconservacion" -f MySQL "MYSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\PrioridadesPSA\prioridades_vaciosdeconservacion_20150310_1328.shp"
 *
 */
/*
 * sqlserver to SHPFile
 *

"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -skipfailures  -f "ESRI Shapefile" "E:\Fonafifo\data_dir_publico\data_fonafifo\Contratos\contratosaprobados.shp" "MYSQL:server=.\SQLEXPRESS2014;database=geopsa;uid=geopsa2;pwd=kd91ks91a;tables=vista_capas_contratos_poligonos"

 *
 */
class ShpManager {
    private $directorio_temporales;
    private $mensajeerror;

    public static $GEOMETRY = "Geometry";
    public static $FEATURECOUNT = "Feature Count";
    public static $EXTENT = "Extent";
    public static $LAYERNAME = "Layer name";
    public static $POLYGON = "Polygon";
    public static $MULTIPOLYGON = "MULTIPOLYGON";
    public static $POINT = "Point";
    public static $LINE = "Line";

    public static $OPCIONES_NUEVAVERSION = "nueva";
    public static $OPCIONES_CORRECCION = "correccion";

    public static $CAPACONTRATOSPOLIGONOS = "[SISUS].[dbo].[GEOPSA_CAPAS_CONTRATOS_POLIGONOS]";
    public static $CAPACONTRATOSPUNTOS = "[SISUS].[dbo].[GEOPSA_CAPAS_CONTRATOS_PUNTOS]";
    public static $CAPASOLICITUDESPOLIGONOS = "[SISUS].[dbo].[GEOPSA_CAPAS_SOLICITUDES_POLIGONOS]";

    public static $RECURSOHIDRICO = 1;
    public static $RESERVASINDIGENAS = 2;
    public static $CORREDORESBIOLOGICOS = 3;
    public static $AREASSILVESTRESPROTEGIDAS = 4;
    public static $VACIOSDECONSERVACION = 5;
    public static $INDICEDEDESARROLLO = 6;
    public static $CONTRATOSPSAANTERIORES = 8;
    public static $PROCURADURIA = 9;

    public static $POLIGONOSOLICITUD = 'su_capa_solicitudes_poligonos';
    public static $GEODATOSLINE = 'su_geodatos_line';
    public static $GEODATOSPOINT = 'su_geodatos_point';
    public static $GEODATOSPOLYGON = 'su_geodatos_polygon';

    public static $GEODATOS_ARBOLESCENSADOS = 'capa_geodatos_arbolescensados';
    public static $GEODATOS_PUNTOSGPS = 'capa_geodatos_puntosgps';
    public static $GEODATOS_PARCELASINVENTARIO = 'capa_geodatos_parcelasinventario';
    public static $GEODATOS_CARRILES = 'capa_geodatos_carriles';
    public static $GEODATOS_QUEBRADAS = 'capa_geodatos_quebradas';
    public static $GEODATOS_AREASPROTECCION = 'capa_geodatos_areasproteccion';
    public static $GEODATOS_CURVASNIVEL = 'capa_geodatos_curvasnivel';
    public static $GEODATOS_LIMITESBOSQUE = 'capa_geodatos_limitesbosque';
    public static $GEODATOS_ESTRATIFICACION = 'capa_geodatos_estratificacion';
    public static $GEODATOS_ACCESOFINCA = 'capa_geodatos_accesofinca';
    public static $GEODATOS_PATIOS = 'capa_geodatos_patios';
    public static $GEODATOS_NACIENTES = 'capa_geodatos_nacientes';
    public static $GEODATOS_TROCHAS = 'capa_geodatos_trochas';
    public static $GEODATOS_LINDEROS = 'capa_geodatos_linderos';
    public static $GEODATOS_USOSUELO = 'capa_geodatos_usosuelo';
    public static $GEODATOS_UBICACIONINFRAESTRUCTURA = 'capa_geodatos_ubicacioninfraestructura';


    public static $EXTENT_CR = array('xMin' => 283582.51,'yMin'=>889283.65,'xMax'=> 658921.83,'yMax'=>1241133.19);
    public static $EXTENT_CR_LINE = array(283582.51,889283.65,658921.83,1241133.19);

    private $db_host;
    private $db_database;
    private $db_uid;
    private $db_pass;
    private $capas_prioridad;
    public function __construct(){

        $this->config = Zend_Registry::get('config');
        $this->_temporaryRepository = $this->config->repository->temporaryrepository;
        $this->_ChunksPath = $this->config->repository->chunks->path;

        $this->directorio_temporales = $this->config->repository->temporaryrepository;
        $this->directorio_temporales2 = $this->config->repository->temporaryrepository2;
        $this->datadirfonafifo = $this->config->repository->datadirfonafifo;
        $this->ogrdirectory = $this->config->repository->ogrdirectory;
        $this->ogrdirectory = "";//En linux no es necesrio.
        $this->db_host = $this->config->geopsa->db->host;
        $this->db_database = $this->config->geopsa->db->database;
        $this->db_uid = $this->config->geopsa->db->uid;
        $this->db_pass = $this->config->geopsa->db->pass;



        $this->cargarConfigCapas();
        //repository.datadirhistorico
        $this->datadirhistorico = $this->config->repository->datadirhistorico;
        error_log("Config capas: " . print_r($this->capas_prioridad, true)); //die;

        require_once('MapHandler.php');
        $maphandler = new MapHandler();//inicializar includes de clases.
        $this->database =UtilsMap::getDBConnection();
        //geopsa.db.host
    }
    private function cargarConfigCapas(){
        $this->capas_prioridad = array();
        if(!$this->config->geopsa->capas){
            return false;
        }
        //geopsa.capas.lista
        $listacapas = $this->config->geopsa->capas->lista;
        $ws = $this->config->geopsa->capas->prioridades->ws;
        $store = $this->config->geopsa->capas->prioridades->store;
        $ws_historico = $this->config->geopsa->capas->prioridadeshistorico->ws;
        $store_historico = $this->config->geopsa->capas->prioridadeshistorico->store;
        foreach($listacapas as $capaactual){
            //geopsa.capas.prioridades.capa_prioridades_areassilvestresprotegidas.id
            $idactual = $this->config->geopsa->capas->prioridades->{$capaactual}->id;
            $tabla = $this->config->geopsa->capas->prioridades->{$capaactual}->tabla;
            $capa = $this->config->geopsa->capas->prioridades->{$capaactual}->capa;
            $estilo = $this->config->geopsa->capas->prioridades->{$capaactual}->estilo;
            if($idactual && $tabla && $capa){
                $this->capas_prioridad[$idactual] = array('tabla' => $tabla, 'capa' => $capa, 'id' => $idactual
                        ,'estilo' => $estilo
                        ,'ws' => $ws, 'store' => $store
                        ,'ws_historico' => $ws_historico, 'store_historico' => $store_historico

                );
            }
        }

    }
    public function probarCapaView(){
        Zend_Loader::loadClass('GeonetworksHandler');
        Zend_Loader::loadClass('CurlHandler');
        Zend_Loader::loadClass('GeoserverWrapper');

        $sql = <<<EOD
            SELECT geop.*
            FROM capas_contratos_poligonos geop
                INNER JOIN psa_GeoContratos contr ON contr.IdContrato = geop.IdContrato
            WHERE
                contr.anio = 2015
EOD;

        $geohandler = new GeonetworksHandler();

        $workspace = "Contratos";
        $datastore = "Contratos";
        $layer = "contratos_todos_2015";
        $description = "";
        $declaredSRS = PROYECCION_CRTM05;
        $metadatalinks = array();
        $defaultStyle = "psa2011";
        $nativeBoundingBox = array(
            'minx' =>307192.73816646065
        ,'maxx' =>653148.3818874996
        ,'miny' =>918371.0526256651
        ,'maxy' =>1238311.4951200902
        ,'crs' =>"EPSG:5367"


        );
        $latLonBoundingBox = false;
        $viewsql = $sql;
        $result = $geohandler->addSqlLayer($workspace, $layer, $datastore, $description , $declaredSRS , $metadatalinks, $defaultStyle,$nativeBoundingBox , $latLonBoundingBox, $viewsql );

        return $result;
    }
    public function agregarShpPrioridades($tipocapa, $tipovector){
        Zend_Loader::loadClass('GeonetworksHandler');
        Zend_Loader::loadClass('CurlHandler');
        Zend_Loader::loadClass('GeoserverWrapper');

        $result = $this->recibirArchivo($tipovector, false);
        if($result['success']){
            //Procesar archivo y agregarlo a la bd para luego incluirlo en las capas disponibles.
            switch($tipocapa){
                case self::$RECURSOHIDRICO:
                case self::$RESERVASINDIGENAS:
                case self::$CORREDORESBIOLOGICOS:
                case self::$AREASSILVESTRESPROTEGIDAS:
                case self::$VACIOSDECONSERVACION:
                case self::$INDICEDEDESARROLLO:
                case self::$PROCURADURIA:
                    $result = $this->agregarShpPrioridadABaseDatos( $tipocapa, $result['destname']);

                    break;

            }

        }else{
            //error. retornarlo.
        }
        return $result;

    }
    private function obtenerInfoCapa( $tipocapa){

    }
    private function agregarShpFincaABaseDatos($tipocapa, $archivozip){

    }
    private function agregarShpPrioridadABaseDatos($tipocapa, $directorioshp){
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        error_reporting(E_ALL);
        ini_set('display_errors', '1');

        //registrarlo en una tabla temporal, luego copiar los datos geograficos ligandolos al contrato/solicitud.
        $retornofinal = array();
        $doctrinemanager = Doctrine_Manager::getInstance();
        $conn = $doctrinemanager->getCurrentConnection();
        //$conn->beginTransaction();
        try{


            $infocapa = @$this->capas_prioridad[$tipocapa];
            if(empty($infocapa)){
                //no hay info de esta capa!!.
                $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa. No se definio en el sistema. " );
                //$conn->rollback();
            }
            $tablacapa = $infocapa['tabla'];//la tabla que hay que actualizar!
            $tablacapa_basica = $infocapa['tabla'];//la tabla que hay que actualizar!
            //$tablacapa = "[geopsa].[dbo].[$tablacapa]";
            //$tablacapa = "[geopsa].[dbo].[$tablacapa]";
            $directorio_de_archivos = $this->directorio_temporales . DIRECTORY_SEPARATOR . $directorioshp;
            $busqueda = $directorio_de_archivos . DIRECTORY_SEPARATOR."*.shp";
            $archivosshp = glob($busqueda);
            error_log("Ejecutando comando: [$directorio_de_archivos]($busqueda) [".print_r($archivosshp, true)."]");
            $archivoshpactual = array_values($archivosshp);
            $archivoshpactual = $archivoshpactual[0];
            $infoshp = $this->getShpInfo($archivoshpactual);

            $capatemporal = $tablacapa;
            //$capatemporal = "capastemp_". time();
            $comandogdal = "echo %GDAL_DATA%";
            error_log("Ejecutando comando  1: [$comandogdal]");
            $resultadoarr = array();
            $resultadoint = 0;

            //$comando = '"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -nln "capastemp_1426125364" -f MySQL "MYSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\ORegionales\regionales_regionales_20150310_1328.shp"  2>&1';

            //$resultado = exec($comando, $resultadoarr, $resultadoint);
            //error_log(" Resultados [$resultadoint] [$resultado] ". print_r($resultadoarr, true));


            $comando =
                //' && '.
                $this->ogrdirectory.DIRECTORY_SEPARATOR
                .'ogr2ogr -overwrite -a_srs "EPSG:5367" -t_srs "EPSG:5367" -skipfailures -nln "'
                .$capatemporal.'" -f MySQL "MYSQL:'.$this->db_database.',host='.$this->db_host.',user='.$this->db_uid.',password='.$this->db_pass.',port=3306" "'
                .$archivoshpactual.'" 2>&1';
            error_log("Ejecutando comando  1: [$comando]");
            $resultadoarr = array();
            $resultadoint = 0;

            //$comando = '"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -nln "capastemp_1426125364" -f MySQL "MYSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\ORegionales\regionales_regionales_20150310_1328.shp"  2>&1';

            $resultado = exec($comando, $resultadoarr, $resultadoint);
            error_log(" Resultados [$resultadoint] [$resultado] ". print_r($resultadoarr, true));

            //$retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] );
            if($resultadoint == 0){//respuesta exitosa es 0.

                $retornofinal = array('success' => true,"error" => "Se agrego correctamente la capa: ".$infoshp[self::$LAYERNAME] );
                //todo: reiniciar la capa presentada enel servidor de mapas.
                //todo: agregar la capa al historico.
                //Agregar la capa actualizada en el servidor.
                $infocapa['tabla'];
                $layername = $infocapa['capa'];
                $ws = $infocapa['ws'];
                $store = $infocapa['store'];
                $estilo = $infocapa['estilo'];

                $geohandler = new GeonetworksHandler();
                error_log("Deleting layer: [$layername, $ws, $store]");
                $geohandler->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
                $geohandler->deleteLayer($layername, $ws, $store);//Se elimina y se reagrega la capa.
                error_log("ADDING layer: [$ws, $layername, $store " .PROYECCION_CRTM05);
                $retornoaddlayer = $geohandler->addLayer($ws, $layername, $store, "", PROYECCION_CRTM05, array(), $estilo);

                $retornosetstye = $geohandler->updateLayerStyle($ws, $layername, $estilo );
                error_log("ADDING layer results: [".print_r($retornoaddlayer, true)."");
                error_log("STYLING layer results: [".print_r($retornosetstye, true)."");
                //$geohandler->createLayer($layername, $ws, $store, "", PROYECCION_CRTM05, array());//Se reagrega para que se actualicen los campos.


                //agregar la capa al historico.
                $capahistorico_layername = $tablacapa_basica . date("_Ymd_Hi");
                $capahistoricofile = $this->datadirhistorico .DIRECTORY_SEPARATOR .$capahistorico_layername . ".shp";
                $comando =
                    //' && '.
                    $this->ogrdirectory.DIRECTORY_SEPARATOR
                    .'ogr2ogr -overwrite -skipfailures -a_srs "EPSG:5367" -t_srs "EPSG:5367" -f "ESRI Shapefile" "'.$capahistoricofile.'"  "'.$archivoshpactual.'" 2>&1';
                error_log("Ejecutando comando  1: [$comando]");
                $resultadoarr = array();
                $resultadoint = 0;

                //$comando = '"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -nln "capastemp_1426125364" -f MySQL "MYSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\ORegionales\regionales_regionales_20150310_1328.shp"  2>&1';

                $resultado = exec($comando, $resultadoarr, $resultadoint);
                error_log(" Resultados  [$resultadoint] [$resultado] ". print_r($resultadoarr, true));
                if($resultadoint == 0){//respuesta exitosa es 0.
                    //Agregarlo a las capas del WS de historico!
                    $ws_historico = $infocapa['ws_historico'];
                    $store_historico = $infocapa['store_historico'];
                    $retornoaddlayer = $geohandler->addLayer($ws_historico, $capahistorico_layername, $store_historico, "", PROYECCION_CRTM05, array(), $estilo);
                    $retornosetstye = $geohandler->updateLayerStyle($ws_historico, $capahistorico_layername, $estilo );
                    $retornofinal = array('success' => true,"error" => "Capa ".$infoshp[self::$LAYERNAME]. " procesada y registrada en historico correctamente." );
                }else{
                    $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando el historico de la capa. Sin embargo la capa se actualizó en el sistema. (ER:202)".$infoshp[self::$LAYERNAME] );
                }

            }else{//Dio error la ejecucion.
                $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] );
            }

            //$conn->commit();
        }catch (Exception $ee){
            error_log("Error fatal agregando capa $ee");
            $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] );
            //$conn->rollback();
        }




        return $retornofinal;

    }
    public function agregarShpABasedatos($optionscorreccion, $tipo, $idreferencia1, $idreferencia2,$capadestino, $directorioshp){
        //$idreferencia1 = idsolicitud
        //$idreferencia2 = idgeometria

        //registrarlo en una tabla temporal, luego copiar los datos geograficos ligandolos al contrato/solicitud.
        $retornofinal = array();
        $doctrinemanager = Doctrine_Manager::getInstance();
        //$conn2 = $doctrinemanager->getConnection($nombreconexion);
        $conn = $doctrinemanager->getCurrentConnection();
        $conn->beginTransaction();
        try{


            //$directorio_de_archivos = $this->directorio_temporales . DIRECTORY_SEPARATOR . $directorioshp;
            $directorio_de_archivos = $directorioshp;
            $busqueda = $directorio_de_archivos . DIRECTORY_SEPARATOR."*.shp";
            $archivosshp = glob($busqueda);
            error_log("Ejecutando comando: [$directorio_de_archivos]($busqueda) [".print_r($archivosshp, true)."]");
            $archivoshpactual = array_values($archivosshp);
            $archivoshpactual = $archivoshpactual[0];
            $infoshp = $this->getShpInfo($archivoshpactual);

            $capatemporal = "capastemp_". time();
            $capatemporalQueries = "$capatemporal";

            $comando =
                //' && '.
                /*$this->ogrdirectory.DIRECTORY_SEPARATOR
                .*/'ogr2ogr -overwrite -a_srs "EPSG:5367" -t_srs "EPSG:5367" -skipfailures -nln "'
                .$capatemporal.'" -f MySQL "MYSQL:'.$this->db_database.',host='.$this->db_host.',user='.$this->db_uid.',password='.$this->db_pass.',port=3306" "'
                .$archivoshpactual.'" 2>&1';
            error_log("Ejecutando comando  1: [$comando]");
            $resultadoarr = array();
            $resultadoint = 0;

            //$comando = '"C:\Fonafifo\fwtools\tools\gdal-ogr\ogr2ogr" -overwrite -a_srs "EPSG:5367" -nln "capastemp_1426125364" -f MySQL "MYSQL:server=.\SQLEXPRESS2012;database=geopsa;uid=geopsa2;pwd=kd91ks91a" "E:\Fonafifo\data_dir2\data_fonafifo\ORegionales\regionales_regionales_20150310_1328.shp"  2>&1';

            $resultado = exec($comando, $resultadoarr, $resultadoint);

            $camposdeinsert = "SHAPE, solicitud_pmb_id, su_geodatos_id";
            $camposdeinsertkey = "solicitud_pmb_id";
            $camposdeselect = " $idreferencia2 ";
            $extrawhereversion = " AND su_geodatos_id = $idreferencia2 ";
            if($capadestino == self::$POLIGONOSOLICITUD){
                $camposdeinsert = "SHAPE, solicitud_pmb_id , fecha";
                $camposdeinsertkey = "solicitud_pmb_id";
                $camposdeselect = " CURRENT_TIMESTAMP ";
                $extrawhereversion = "";
            }
            //$resultado = shell_exec($comando);
            error_log("Resultados [$resultadoint] [$resultado][". print_r($resultadoarr, true));
            if($resultadoint == 0){//respuesta exitosa es 0.
                //Importar la capa cargada en base de datos hacia la tabla de capas.
                $sqlEjecucion = "";
                switch($optionscorreccion){
                    default://Se trata de una correccion. Caerle encima a la version actual?
                    case self::$OPCIONES_CORRECCION://Se trata de una correccion. Caerle encima a la version actual?
                    case self::$OPCIONES_NUEVAVERSION:
                        //Segun se maneja, todos siempre debe ser una version por no perder datos. Asi que por ahora se maneja con version cualquiera de los 2 casos.
                        $sqlEjecucion = <<<EOD
                            SELECT IFNULL(MAX(Version), 0) as version
                            FROM $capadestino
                            WHERE $camposdeinsertkey = $idreferencia1 $extrawhereversion ;
EOD;
                        $versionesinfo = $conn->fetchAssoc($sqlEjecucion);
                        $versionultima = $versionesinfo[0]['version'];
                        $versionultima++;
                        //Actualizar los valores de ultima version.
                        $sqlEjecucion = <<<EOD
                            UPDATE $capadestino
                            SET UltimaVersion = 0
                            WHERE $camposdeinsertkey = $idreferencia1 $extrawhereversion ;


EOD;
                        /*
                         * UPDATE $capadestino
                            SET UltimaVersion = 1
                            WHERE ogr_fid = (SELECT MAX(ogr_fid) FROM $capadestino d2 WHERE d2.$camposdeinsertkey = $idreferencia1 );
                         */

                        error_log("Ejecutando p2 $sqlEjecucion");
                        $resultadoejecucion = $conn->exec($sqlEjecucion);
                        error_log("Resultado ejecucion p2 [".print_r($resultadoejecucion, true)."]");

                        $sqlEjecucion = <<<EOD
                        INSERT INTO $capadestino ($camposdeinsert , UltimaVersion, Version)
                        SELECT SHAPE, $idreferencia1, $camposdeselect , 1, $versionultima
                        FROM $capatemporalQueries
                        ;
EOD;

                        error_log("Ejecutando $sqlEjecucion");
                        $resultadoejecucion = $conn->exec($sqlEjecucion);
                        error_log("Resultado ejecucion [".print_r($resultadoejecucion, true)."]");
                        $idgeometria = 0;
                        if($resultadoejecucion){
                            $sqlEjecucion = <<<EOD
                            SELECT IFNULL(ogr_fid, 0) as ultimoid
                            FROM $capadestino
                            WHERE $camposdeinsertkey = $idreferencia1 $extrawhereversion AND UltimaVersion = 1;
EOD;
                            error_log("SQL [$sqlEjecucion]");

                            $versionesinfo = $conn->fetchAssoc($sqlEjecucion);
                            error_log(print_r($versionesinfo, true));
                            $idgeometria = $versionesinfo[0]['ultimoid'];
                        }
                        //DROP TABLE
                        $sqlEjecucion = <<<EOD
                        DROP TABLE $capatemporalQueries ;
EOD;

                        error_log("Ejecutando $sqlEjecucion");
                        $resultadoejecucion2 = $conn->exec($sqlEjecucion);
                        error_log("Resultado ejecucion [".print_r($resultadoejecucion2, true)."]");

                        if($resultadoejecucion){
                            $retornofinal = array('success' => true,"error" => "Capa procesada correctamente", 'idgeom' => $idgeometria );
                        }else{
                            $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] ."." );
                        }


                        break;


                }


            }else{//Dio error la ejecucion.
                $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] );
            }

            $conn->commit();
        }catch (Exception $ee){
            error_log("Error fatal agregando capa $ee");
            $retornofinal = array('success' => false,"error" => "Se presentó un problema procesando la capa ".$infoshp[self::$LAYERNAME] );
            $conn->rollback();
        }




        return $retornofinal;

    }
    public function recibirArchivo($tiposhp = "Polygon", $revisarextent = true)
    {


        $method = $_SERVER["REQUEST_METHOD"];

        $tempfilepath = tempnam($this->directorio_temporales, "ZSP");//sys_get_temp_dir(), "PDF");

        $tempfilepathinfo = pathinfo($tempfilepath);
        $tempfilename = $tempfilepathinfo['filename'];
        $tempfileext = @$tempfilepathinfo['extension'];
        $tempfileext = ($tempfileext == '') ? $tempfileext : '.' . $tempfileext;
        $tempname = $tempfilename . $tempfileext;
        $upload_result = array();
        if ($method != "POST") //html5 ajax //@todo averiguar como se veria si fuera de ajax
        {
            error_log("NO POST ACCESS");
            // i.e. do HTML5 streaming upload
            $pathinfo = pathinfo($_GET['qqfile']);
            $filename = $pathinfo['filename'];
            $ext = @$pathinfo['extension'];
            $ext = ($ext == '') ? $ext : '.' . $ext;
            $uploadname = $filename . $ext;
            $input = fopen('php://input', 'r');
            $temp = fopen($tempfilepath, 'w');
            $realsize = stream_copy_to_stream($input, $temp); // write stream to temp file
            @chmod($tempfilepath, 0644);
            fclose($input);
            if ($realsize != (int)$_SERVER['CONTENT_LENGTH'])
            {
                $results = array('error' => 'Could not save upload file.');
            }
            else
            {
                $upload_result = array('success' => true,
                    "uploadName" => $uploadname,
                    "pdf_id" => 10);
            }
        }
        elseif ($method == "POST")
        {
            error_log("POST ACCESS");
            // else do regular POST upload (i.e. for old non-HTML5 browsers)
            $size = $_FILES['qqfile']['size'];
            if ($size == 0)
            {
                return array('error' => 'File is empty.');
            }
            $pathinfo = pathinfo($_FILES['qqfile']['name']);
            $filename = $pathinfo['filename'];
            $ext = @$pathinfo['extension'];
            $ext = ($ext == '') ? $ext : '.' . $ext;
            $uploadname = $filename . $ext;
            $md5 = md5_file($tempfilepath);
            if (!move_uploaded_file($_FILES['qqfile']['tmp_name'], $tempfilepath))
            {
                $temponame = pathinfo($tempfilepath);
                $temponame = $temponame['filename'];
                $upload_result = array('error' => 'Could not save upload file.',
                    "uploadName" => $uploadname,
                    "size" => $size,
                    "md5" => $md5,
                    "tempname" => $temponame);
            }
            else
            {
                @chmod($tempfilepath, 0777);
                $temponame = pathinfo($tempfilepath);
                $temponame = $temponame['filename'];
                $upload_result = array('success' => true,
                    "uploadName" => $uploadname,
                    "size" => $size,
                    "md5" => $md5,
                    "tempname" => $temponame
                    );
            }
        }
        if($upload_result["success"]){
            $filename = $tempfilepath;
            $destino = tempnam($this->directorio_temporales, "UNZ");
            //$destino = $this->directorio_temporales . DIRECTORY_SEPARATOR . "UNZ" . time();
            error_log("Destino full[$destino]");
            unlink($destino);
            $tempfilepathinfo = pathinfo($destino);
            $destino = $tempfilepathinfo['dirname'] .  DIRECTORY_SEPARATOR . $tempfilepathinfo['filename'];
            //mkdir ($destino);
            $descomprimebien = $this->descomprimirZip($tempfilepath, $destino);
            //$upload_result['tempname'] = $tempfilepathinfo['filename'];
            $upload_result['destname'] = $tempfilepathinfo['filename'];
            if($descomprimebien){
                $shpsvalidos = $this->validarZipShps($destino, $tiposhp, $revisarextent);
                if(!$shpsvalidos){
                    $upload_result['error'] = $this->mensajeerror;
                }
                $upload_result['shpsvalidos'] = $shpsvalidos;
                $upload_result['success'] = $shpsvalidos;
            }else{
                $upload_result['success'] = false;
                $upload_result['error'] = "Error descomprimiendo archivo .zip";
            }
        }else{

        }
        if(!$upload_result['success'] || $upload_result['error']){
            //todo: limpiar los archivos temporales.
        }
        return $upload_result;

    }
    public function getShpInfo($filename){
        //$this->ogrdirectory
        $resultado = array();
        $comando = "ogrinfo -geom=SUMMARY -al $filename";
        error_log("SHP INFO: $comando, [".print_r($resultado, true)."]");
        exec($comando, $resultado);
        $infoshape = array(
            self::$GEOMETRY => null
            ,self::$FEATURECOUNT => null
            ,self::$EXTENT => null
            ,self::$LAYERNAME => null
        );
        foreach ($resultado as $linea) {
            $linea = trim($linea);

            if (strpos($linea, self::$GEOMETRY) !== false) {
                $infoshape[self::$GEOMETRY] = $this->infolinedata($linea);
            }
            if (strpos($linea, self::$FEATURECOUNT) !== false) {
                $infoshape[self::$FEATURECOUNT] = 1*$this->infolinedata($linea);//numerico.
            }
            if (strpos($linea, self::$EXTENT) !== false) {
                $infoshape[self::$EXTENT] = $this->infolinedata($linea);
            }
            if (strpos($linea, self::$LAYERNAME) !== false) {
                $infoshape[self::$LAYERNAME] = $this->infolinedata($linea);
            }
        }
        return $infoshape;

    }
    private function infolinedata($line){
        $lineparts = explode(":", $line);
        return trim($lineparts[1]);
    }
    public function descomprimirZip($filename, $destino){
        $zip = new ZipArchive;
        $res = $zip->open($filename );
        if ($res === TRUE) {
            $zip->extractTo($destino);
            $zip->close();
            return true;
        } else {
            error_log("Error abriendo zip [$res]");
            return false;
        }


    }
    public function validarZipShps($directoriovalidacion, $tiposhp, $revisarextent = true){
        //Solo debe venir un unico shp!
        //debe haber al menos un archivo shp, y un dbf, prj, shx para cada shp.
        $valido = true;
        $archivosshp = glob($directoriovalidacion . DIRECTORY_SEPARATOR."*.shp");
        $cantidadarchivosshp = count($archivosshp);
        if($cantidadarchivosshp == 0 ){
            $this->mensajeerror = "Debe incluirse un archivo de shp en el comprimido.";
            $valido = false;
        }
        elseif($cantidadarchivosshp > 1){
            $this->mensajeerror = "El archivo incluye más de un archivo shp en el comprimido. Debe incluirse un único polígono por archivo.";
            $valido = false;
        }
        if($valido)
            foreach ($archivosshp as $archivoshp_actual) {
                $infoshp = $this->getShpInfo($archivoshp_actual);
                error_log("Infoshp ". print_r($infoshp, true) );
                //$tiposhp
                //$tiposhp
                $tipogeometria_correcta = false;
                $tipogeometria = $infoshp[self::$GEOMETRY];

                switch($tipogeometria){
                    case $tiposhp:

                        $tipogeometria_correcta = true;
                        break;
                    case self::$MULTIPOLYGON:
                        if($tiposhp == self::$POLYGON){
                            $tipogeometria_correcta = true;
                        }
                        break;
                }
                if(!$tipogeometria_correcta){
                //if(] != $tiposhp){
                    $this->mensajeerror = "El tipo de shp esperado es incorrecto. Debe ser geometría de tipo [$tiposhp].";
                    $valido = false;
                }
                if($valido){
                    $archivoshp_actual_parts = pathinfo($archivoshp_actual);
                    $nombrecapa = $archivoshp_actual_parts['filename'];
                    $dbf = count( glob($directoriovalidacion . DIRECTORY_SEPARATOR."$nombrecapa.dbf")) > 0;
                    $prj = count( glob($directoriovalidacion . DIRECTORY_SEPARATOR."$nombrecapa.prj")) > 0;
                    $shx = count( glob($directoriovalidacion . DIRECTORY_SEPARATOR."$nombrecapa.shx")) > 0;
                    if($dbf && $prj && $shx){
                    //if($dbf && $shx){
                        $valido = true;
                    }else{
                        $this->mensajeerror = "Archivos incluidos incorrectos. Verifique que incluye los archivos necesarios. Un archivo shp, dbf, prj y shx";
                        $valido = false;
                    }
                }
                if($valido){
                //if($valido && $revisarextent){
                    //Revision del extent dentro del de Costa Rica.
                    $infoshp = $this->getShpInfo($archivoshp_actual);
                    $extentarchivo = $infoshp[self::$EXTENT];

                    $extentarchivo = str_replace('(', '', $extentarchivo);
                    $extentarchivo = str_replace(')', '', $extentarchivo);
                    $extentpartes = explode("-", $extentarchivo);
                    $minimos = explode(',', $extentpartes[0]);//0 es x, 1 es y
                    $maximos = explode(',', $extentpartes[1]);//0 es x, 1 es y

                    error_log("Extent VS de CR! $extentarchivo VS ". print_r(self::$EXTENT_CR_LINE, true) );

                    if(
                        $minimos[0] < (self::$EXTENT_CR['xMin'] - 1 )
                        || $minimos[0] > ( self::$EXTENT_CR['xMax'] + 1 )

                        ||$maximos[0] < ( self::$EXTENT_CR['xMin'] - 1)
                        || $maximos[0] > ( self::$EXTENT_CR['xMax'] + 1)

                        ||$minimos[1] < ( self::$EXTENT_CR['yMin'] - 1)
                        || $minimos[1] > ( self::$EXTENT_CR['yMax'] + 1)

                        ||$maximos[1] < (self::$EXTENT_CR['yMin'] - 1)
                        || $maximos[1] > (self::$EXTENT_CR['yMax'] + 1)
                    ){
                        error_log("Extent fuera de CR! $extentarchivo VS ". print_r(self::$EXTENT_CR_LINE, true) );
                        error_log("Extent fuera de CR! infoshp ". print_r($infoshp, true) );
                        //el extent del shp se sale del de CR.
                        //$this->mensajeerror = "El shapefile incluído está fuera del extent de Costa Rica.";
                        $valido = false;
                    }


                }

            }
        return $valido;
    }
    public function validarShapes($directorio, $shpfilename){
        //Descomprimir
    }
    public function obtenerTipoGeometriaCapa($nombrecapadefinida){
        $tipogeometria = false;
        switch($nombrecapadefinida){
            case self::$POLIGONOSOLICITUD:
            case self::$GEODATOS_PARCELASINVENTARIO:
            case self::$GEODATOS_AREASPROTECCION:
            case self::$GEODATOS_CURVASNIVEL:
            case self::$GEODATOS_LIMITESBOSQUE:
            case self::$GEODATOS_ESTRATIFICACION:
            case self::$GEODATOS_PATIOS:
            case self::$GEODATOS_NACIENTES:
                $tipogeometria = self::$POLYGON;
                break;

            case self::$GEODATOS_ARBOLESCENSADOS:
            case self::$GEODATOS_PUNTOSGPS:
            case self::$GEODATOS_UBICACIONINFRAESTRUCTURA:
            case self::$GEODATOS_ACCESOFINCA:
                $tipogeometria = self::$POINT;
                break;
            case self::$GEODATOS_CARRILES:
            case self::$GEODATOS_QUEBRADAS:
            case self::$GEODATOS_TROCHAS:
            case self::$GEODATOS_LINDEROS:
                $tipogeometria = self::$LINE;
                break;

        }
        return $tipogeometria;
    }
/*
 * Valida sobreposiciones de una solicitud. Retorna false si no hay, o array si si hay con la informacion de las capas involucradas.
 * Ejemplo de respuesta: false | array ( 'result' => true, MapHandler::$CAPA => ('capa1' => array(MapHandler::$NOMBREDESPLIEGUE => 'Capa nombre bonito' ) ) )
 *
 * @param int $idsolicitud el id de la solicitud a validar sobreposiciones.
 * @return mixed false | array ( 'result' => true, MapHandler::$CAPA => ('capa1' => array(MapHandler::$NOMBREDESPLIEGUE => 'Capa nombre bonito' ) ) )
 */
    public function validarSobreposicionesSolicitud($idsolicitud){
        //Obtener lista de capas de sobreposiciones.
        $sqlconsulta = <<<EOD
            SELECT nombredespliegue, nombrews, nombrecapa, nombretabla
            FROM su_capas
            WHERE escapasobreposiciones = 1
EOD;

        $listacapassobreposiciones = $this->database->Query($sqlconsulta, array());
        $capassobreposiciones = array();

        $select_str = $joins_str = '';$separador = '';
        foreach($listacapassobreposiciones as $key=>$capasobreposiciones_actual){
            $alias = "cap".$key;
            $tablaactual = $capasobreposiciones_actual['nombretabla'];
            $capassobreposiciones[  ] = $tablaactual;

            $select_str .=$separador."IF($alias.SHAPE IS NOT NULL, 1, 0) as $tablaactual ";
            $joins_str .= " LEFT JOIN $tablaactual $alias ON ST_Intersects($alias.SHAPE ,tmp.SHAPE) = 1 ";

            $separador = ',';
        }


        $sqlconsulta = <<<EOD
            SELECT
                 $select_str
            FROM
                 su_capa_solicitudes_poligonos tmp
                 $joins_str

            WHERE tmp.solicitud_pmb_id  = $idsolicitud AND tmp.ultimaversion = 1

EOD;
        error_log( "Consulta intersect [$sqlconsulta]");
        $results = $this->database->Query($sqlconsulta, array());
        $retorno = false;
        if(count($results) <= 0){
            $retorno = false;
        }else{
            $results[0];
            $capasconsobreposicion = array();
            $sobreposiciones = false;
            foreach($listacapassobreposiciones as $capasobreposiciones_actual){
                $capaactual = $capasobreposiciones_actual['nombretabla'];
                $nombredespliegue = $capasobreposiciones_actual['nombredespliegue'];

                $sobreposicion = $results[0][$capaactual];
                if($sobreposicion > 0){
                    $capasconsobreposicion[] =$nombredespliegue;
                    $sobreposiciones = true;
                }
            }
            if($sobreposiciones)
                $retorno = array(
                    'result' => true, MapHandler::$CAPA => $capasconsobreposicion
                );

        }
        error_log("Resultado sobreposiciones " . print_r($retorno, true));
        return $retorno;
    }
    /*
 * Valida el archivo shp subido.
 * Ejemplo de respuesta: array('result' => false, 'message' => 'El extent está fuera de CR.' ) | array('result' => true, 'message' => 'Validcion correcta.' )
 *
 * @param string $archivozip ruta completa del archivo zip a revisar.
 * @param string $tipoarchivosubido nombre del tipo de archivo. Opciones ejemplo: ShpManager::$POLIGONOSOLICITUD, ShpManager::$GEODATOS_ARBOLESCENSADOS, ShpManager::$GEODATOS_PUNTOSGPS, ShpManager::$GEODATOS_PARCELASINVENTARIO , etc.
 *
 * @return array array('result' => false, 'message' => 'El extent está fuera de CR.' ) | array('result' => true, 'message' => 'Validcion correcta.' )
 */
    public function verificarShpSubido($archivozip, $tipoarchivosubido){
        $upload_result = array();
        $tipogeometria = $this->obtenerTipoGeometriaCapa($tipoarchivosubido);

        $destino = tempnam($this->directorio_temporales, "UNZ");
        error_log("Destino full[$destino]");
        unlink($destino);
        $tempfilepathinfo = pathinfo($destino);
        $destino = $tempfilepathinfo['dirname'] .  DIRECTORY_SEPARATOR . $tempfilepathinfo['filename'];
        $descomprimebien = $this->descomprimirZip($archivozip, $destino);
        $upload_result['destname'] = $destino;
        if($descomprimebien){
            $shpsvalidos = $this->validarZipShps($destino, $tipogeometria, $revisarextent=true);
            if(!$shpsvalidos){
                $upload_result['message'] = $this->mensajeerror;
            }
            $upload_result['shpsvalidos'] = $shpsvalidos;
            $upload_result['result'] = $shpsvalidos;
        }else{
            $upload_result['result'] = false;
            $upload_result['message'] = "Error descomprimiendo archivo .zip";
        }
        return $upload_result;
    }

    /*
 * Valida el archivo shp subido, y lo asocia a la solicitud según el tipo de archivo que se trate.
 * Ejemplo de respuesta: array('result' => false, 'message' => 'El extent está fuera de CR.' ) | array('result' => true, 'message' => 'Validcion correcta.' )
 *
 * @param int $idsolicitud el id de la solicitud a validar sobreposiciones.
 * @param string $archivozip ruta completa del archivo zip a revisar.
 * @param string $tipoarchivosubido nombre del tipo de archivo. Opciones ejemplo: ShpManager::$POLIGONOSOLICITUD, ShpManager::$GEODATOS_ARBOLESCENSADOS, ShpManager::$GEODATOS_PUNTOSGPS, ShpManager::$GEODATOS_PARCELASINVENTARIO , etc.
 *
 * @return array array('result' => false, 'message' => 'El extent está fuera de CR.' ) | array('result' => true, 'message' => 'Validcion correcta.' )
 */
    public function asociarShpSubidoSolicitud($idsolicitud, $archivozip, $tipoarchivosubido){
        $retorno = array('result' => false,'message' => '');
        $tipogeometria = $this->obtenerTipoGeometriaCapa($tipoarchivosubido);
        $resultadoverificacion = $this->verificarShpSubido($archivozip, $tipoarchivosubido);
        if($resultadoverificacion['result']){
            $destinodescomprimido = $resultadoverificacion['destname'];
            $tablaGeometrias = null;
            $idgeometria = null;
            $incluirinfoasolicitud = false;
            if($tipoarchivosubido == self::$POLIGONOSOLICITUD){
                $tablaGeometrias = $tipoarchivosubido;
                $idgeometria = null;
                $incluirinfoasolicitud = true;
            }else{//van hacia geodatos.
                //obtener la tabla donde van. Depende del tipo de geomtria.
                $tablaGeometrias = $this->tipoDeGeometriaToTable($tipogeometria);
                $infogeometria = $this->obtenerInfoGeometria($tipogeometria);
                $idgeometria = $infogeometria['id'];

            }

            $resultadoShpInsert = $this->agregarShpABasedatos(false, $tipogeometria, $idsolicitud, $idgeometria,$tablaGeometrias, $destinodescomprimido);
            //$retornofinal = array('success' => true,"error" => "Capa procesada correctamente", 'idgeom' => $idgeometria );
            if($resultadoShpInsert['success'] && $incluirinfoasolicitud){
                //Incluir informacion de la solicitud. AC, Subregion, etc.
                $this->actualizarInformacionSolicitud($idsolicitud);
            }
            if($resultadoShpInsert['success']){
                $retorno['result'] = true;
                $retorno['idgeom'] = $resultadoShpInsert['idgeom'];
                $retorno['message'] = $resultadoShpInsert['error'];
            }else{
                $retorno['result'] = false;
                $retorno['message'] = $resultadoShpInsert['error'];
            }
        }else{
            $retorno['message'] = $resultadoverificacion['message'];
        }
        return $retorno;
    }
    //Recibe id solicitud, y le actualiza AC, Subregion, etc consultando su SHP en la bd contra las capas de AC, Subregion, etc.
    public function actualizarInformacionSolicitud($idsolicitud){
        $sqlconsulta = <<<EOD
            SELECT
                sp.solicitud_pmb_id
                ,ac.siglas as ac
                ,ac_id.id as ac_id
                ,sub.codigo as sub
                ,sub_id.id as sub_id
                ,prov.id as prov
                ,canto.id as cant
                ,dist.id as dist

            FROM su_capa_solicitudes_poligonos sp
            LEFT JOIN  capa_sobrepuestas_areasconservacion ac ON ST_Contains(ac.SHAPE ,sp.SHAPE)
            LEFT JOIN   area_conservacion ac_id ON ac_id.siglas = ac.siglas
            LEFT JOIN  capa_sobrepuestas_subregionconservacion sub ON ST_Contains(sub.SHAPE ,sp.SHAPE)
            LEFT JOIN  subregion_conservacion sub_id ON sub_id.codigo = sub.codigo
            LEFT JOIN  capa_sobrepuestas_provincia prov ON ST_Contains(prov.SHAPE ,sp.SHAPE)
            LEFT JOIN  capa_sobrepuestas_canton canto ON ST_Contains(canto.SHAPE ,sp.SHAPE)
            LEFT JOIN  capa_sobrepuestas_distrito dist ON ST_Contains(dist.SHAPE ,sp.SHAPE)
            WHERE solicitud_pmb_id =$idsolicitud
            AND ultimaversion =1
EOD;

        error_log("Ejecutando $sqlconsulta");
        $results = $this->database->Query($sqlconsulta, array());
        $retorno = false;
        if(count($results) <= 0){
            $retorno = false;
        }else{

            $datosSolicitud = $results[0];
            $ac_id = $datosSolicitud['ac_id'];
            $sub_id = $datosSolicitud['sub_id'];
            $prov = $datosSolicitud['prov'];
            $cant = $datosSolicitud['cant'];
            $dist = $datosSolicitud['dist'];

            $pdo_instance = cbSQLConnectConfig::CreatePDOInstance();
            $pdo_instance->beginTransaction();

            try{
                $sqlconsulta_update = <<<EOD
                UPDATE su_solicitudes_PMB SET
                    area_de_conservacion = $ac_id
                    ,subregion = $sub_id
                    ,provincia = $prov
                    ,canton = $cant
                    ,distrito = $dist
                WHERE id = $idsolicitud
EOD;

                error_log("Ejecutando UPDATE $sqlconsulta_update");
                $pdo_instance->exec($sqlconsulta_update);

                $pdo_instance->commit();

            }catch (Exception $ee){
                $pdo_instance->rollBack();

            }



        }
        return $retorno;
    }
    private function obtenerInfoGeometria($tipogeometria){


        $sqlconsulta = <<<EOD
            SELECT id, nombredespliegue, nombrews, nombrecapa, nombretabla, tipogeometria
            FROM  su_geodatos
            WHERE nombrecapa = '$tipogeometria'
EOD;

        $results = $this->database->Query($sqlconsulta, array());
        $retorno = false;
        if(count($results) <= 0){
            $retorno = false;
        }else{

            $retorno = $results[0];

        }
        return $retorno;

    }
    private function tipoDeGeometriaToTable($tipogeometria){
        $retorno = false;
        switch($tipogeometria){
            case self::$POLYGON:
                $retorno = self::$GEODATOSPOLYGON;
                break;
            case self::$POINT:
                $retorno = self::$GEODATOSPOINT;
                break;
            case self::$LINE:
                $retorno = self::$GEODATOSLINE;
                break;
        }
        return $retorno;
    }
} 