<?php

class DoctrineConnector{

	protected $_table_name;	
	protected $_table;	
	protected $_columns = array();
	protected $_columns_types = array();
	protected $_enum_columns_values = array();
	protected $_primary_key_columns = array();
	protected $_foreign_keys_columns = array();	
	
	/**
	 * Constructor
	 * @param string Doctrine Table Name
	 */
	public function __construct($tablename)
    {
		//Crea la tabla
		try
		{
			$this->_table_name = $tablename;
			$this->_table = Doctrine_Core::getTable($tablename);
			error_log("ooooooooooooooooo $this->_table_name");
			
			//Define las columnas y quienes son llave primarias
			$colnames = $this->_table->getColumnNames();
			$coldefs = $this->_table->getColumns();
			//echo var_export($coldefs,true);
			foreach ($colnames as $id => $colname)
			{
				$this->_columns[$colname] = $coldefs[$id];						
				if ($coldefs[$colname][primary])
				{
					$this->_primary_key_columns[] = $colname;
				}			
				$this->_columns_types[$colname] =  $coldefs[$colname][type];
				if ($coldefs[$colname][type] == "enum")
				{
					$this->_enum_columns_values[$colname] = $coldefs[$colname][values];
				}
			}
			
			//Define las columnas la info de las llave foraneas
			$relations = $this->_table->getRelations();			
			foreach ($relations as $name => $relation) 
			{
				//echo "relacion $name: <br/>";
				//echo var_export($relation,true);
				//Si la relacion es de fk desde el campo
				if ($relation->getType() == 0) //TODO estudiar bien como se trabajan estos tipos
				{
					$this->_foreign_keys_columns[$relation->getLocal()] = array('foreign_table' =>  $relation->getClass(), 'local_field' => $relation->getLocal(), 'foreign_field' => $relation->getForeign(), 'type'=> $relation->getType());				
				}
			}			
			//echo var_export($this->_foreign_keys_columns,true);
			//echo var_export($this->_columns_types,true);
		}
		catch(Exception $e)
		{
			echo ("Exception DoctrineConnector::__construct [$e]");
		}			
    }
	
	public function getColumns()
	{
		return $this->_columns;
	}
	
	public function getColumnNames()
	{
		return array_keys($this->_columns);
	}
	
	public function getColumnTypes()
	{
		return $this->_columns_types;
	}
	
	public function getEnumColumnsValues()
	{
		return $this->_enum_columns_values;
	}
	
	public function getPrimaryKeyColumns()
	{
		return $this->_primary_key_columns;
	}
	
	public function getColumnsNumber()
	{
		return count($this->_columns);
	}
	
	public function getForeignKeyColumns()
	{	
		return $this->_foreign_keys_columns;
	}
	
	public function findAll()
	{
		$rs = $this->_table->findAll();
		return $rs->toArray();		
	}
	
	public function getRows($where = null, $orderby = null, $limit = null , $offset = null)
	{
		$q = $this->_table->createQuery('t');
		
		if ($where != null)
			$q->where($where);
		
		if ($orderby != null)
			$q->orderBy($orderby);
		
		if ($limit != null)
			$q->limit($limit);
			
		if ($offset != null)
			//$pager = new Doctrine_Pager($q,)
			$q->offset($offset);
		$rs = $q->execute();		

		return $rs->toArray();	
		
		//TODO? $this->sorted_table = true;
	}
	
	public function getRowsCount($where = null)
	{
		//TODO execute sql con count
		$rs = $this->getRows($where);
		return count($rs);
	}
	
	public function deleteRow($rowId)
	{
		$row = $this->_table->find($rowId);
		if($row !== false) 
		{
			//TODO revisar relaciones!
			$row->delete();
		}
	}
	
	public function insertRow($data)
	{	
	
		error_log("en addaxcrud!!!!!! doctrineconnector data ".print_r($data,true));
		
		error_log("en addaxcrud!!!!!! el table_name es ".print_r($this->_table_name,true));
		$newRow = new $this->_table_name();
		error_log("en addaxcrud!!!!!! el type es ".print_r($newRow,true));
		foreach ($data as $field => $value)
		{
			error_log("en addaxcrud!!!!!! foreach field ".var_export($field,true));
			if (in_array($field, $this->getColumnNames()))
			{
				$newRow->$field = $value;
			}
			error_log("en addaxcrud!!!!!! foreach sale field ".var_export($field,true));
		}
		error_log("en addaxcrud!!!!!! desp del foreach");
		error_log("en addaxcrud!!!!!! doctrineconnector newRow ".print_r($newRow,true));
		$newRow->save();
	}
	
	public function updateRow($rowId, $field, $newValue)
	{
		$row = $this->_table->find($rowId);
		$row->$field = $newValue;
		$row->save();
	}	
	
	//Que tipo de relacion es?
	public function getForeignValues($field, $display_field)
	{
		try
		{
			$relationdef = $this->_foreign_keys_columns[$field];
			
			$q = Doctrine_Query::create()
				->select($relationdef['foreign_field'].",$display_field")
				->from($relationdef['foreign_table'])
				->orderBy($relationdef['foreign_field']);
			$rs = $q->execute();		
			
			$records = $rs->toArray();	
			
			$foreign_values = array();
			foreach ($records as $record)
			{
				$foreign_values[$record[$relationdef['foreign_field']]] = $record[$display_field];
			}
			return $foreign_values;
		}
		catch(Exception $e)
		{
			echo ("Exception DoctrineConnector::getForeignValues [$e]");
		}	
	}
	
	public function setValidValuesforField()
	{
	}
	
}//class
?>