<?php

/************************************************************************/
/* ajaxCRUD.class.php	v3.8                                            */
/* ===========================                                          */
/* Copyright (c) 2008 by Loud Canvas Media (arts@loudcanvas.com)        */
/* http://www.loudcanvas.com                                            */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// ::Use::
// Create an ajaxCRUD object.
// $table = new ajaxCRUD(name of item, table name, primary key);
// Example:
// $tblFAQ = new ajaxCRUD("FAQ", "tblFAQ", "pkFAQID");
// $tblFAQ->showTable();
//
// Note: !! Your table must have AUTO_INCREMENT enabled for the primary key !!
// Note: !! Your version of mySQL must support string->INT conversion (thus "1" = 1) and "" is a NULL value !!
require_once 'DoctrineConnector.php';

class AddaxCRUD
{
    var $ajaxcrud_root;
    var $ajax_file;    
    
    var $doActionOnShowTable; //boolean var. When true and showTable() is called, doAction() is also called. turn off when you want to only have a table show in certain conditions but CRUD operations can take place on the table "behind the scenes"

    var $item_plural;
	var $item;
	
	var $db_main_field;
    var $row_count;

    var $cellspacing;    

    var $filtered_table = false; //the table is by default unfiltered (eg no 'where clause' on it)    

    //defines if the class allows you to edit all fields
    var $ajax_editing = true;

    //the fields to be inputted when adding a new entry (90% time will be all fields). can be changed via the omitAddField method
    var $add_fields = array();

    var $on_add_specify_primary_key = false;
   

    //array containing values for a button next to the "go back" button at the bottom. [0] = value [1] = url [2] = extra tags/javascript
    var $bottom_button = array();

    ################################################
    #
    # The following are parallel arrays to help in the definition of a defined db relationship
    #
    ################################################

    //values will be the name(s) of the foreign key(s) for a category table
	var $db_table_fk_array = array();		

    //values will be the name(s) of the category table(s)
	var $category_table_array = array();

    //values will be the name(s) of the field to return in the category table(s)
	var $category_field_array = array();

    //values will be the (optional) name of the field to sort by in the category table(s)
    var $category_sort_field_array = array();

    //for dropdown (to make an empty box). (format: array[field] = true/false)
    var $category_required = array();

	//@ADDAX@ Limit relationship values with a where clause
	var $category_where_array = array();


    //values to be set to a particular field when a new row is added. the array is set as $field_name => $add_value
    var $add_values = array();

    //destination folder to be set for a particular field that allows uploading of files. the array is set as $field_name => $destination_folder
    var $file_uploads = array();
    var $file_upload_info = array(); //array[$field_name][destination_folder] and array[$field_name][relative_folder]
    var $filename_append_field = "";

    //array dictating that "dropdown" fields do not show dropdown (but text editor) on edit (format: array[field] = true/false);
    //used in defineAllowableValues function
    var $field_no_dropdown = array();

    var $onAddExecuteCallBackFunction;
    var $onFileUploadExecuteCallBackFunction;
    var $onDeleteFileExecuteCallBackFunction;

    //(if true) put a checkbox before each row
    var $showCheckbox = false;

    var $sort_direction; //used when sorting the table via ajax

    ################################################
    #
    # displayAs array is for linking a particular field to the name that displays for that field
    #
    ################################################

    //the indexes will be the name of the field. the value is the displayed text
    var $displayAs_array = array();

    //height of the textarea for certain fields. the index is the field and the value is the height
    var $textarea_height = array();
	

	protected $_dbConnector;
	protected $_view;
	protected $_table_name;		
	protected $_table_pk_array = array(); //values will be the name(s) of the primary key for the category table(s)
	protected $_table_fk_array = array(); //values will be the name(s) of the foreign key(s) for a category table	
    protected $_table_columns = array(); //all fields in the table	
	protected $_field_datatype = array(); //field datatypes $field_datatype[field] = datatype
	protected $_enums_values = array(); //enum fields values
	
	protected $_module; 
	protected $_controller = "Crud"; //El Controlador por defecto es CrudController
	protected $_oldtemplatepath;
	
    protected $_uneditable_fields = array();//the fields which are displayed, but not editable	
	protected $_display_fields = array(); //the fields to be displayed	    
    protected $_allowed_values = array(); // allowable values for a field. the key is the name of the field
	protected $_fk_fields = array(); //arreglo donde van los campos habilitados como fk con su campo de despliegue por cada relacin
	protected $_display_filter_fields = array();
    protected $_delete = true; //allow delete of fields | boolean variable set to true by default
	protected $_add = true; //adding is ok	
    protected $_ajax_add = true; //defines if the add function uses ajax. Default true
	protected $_add_form_top = false; //the add form (by default) is below the table. use displayAddFormTop() to bring it to the top	
	protected $_checkbox = array(); // "on" and "off" values for a checkbox. the key is the name of the field 
	protected $_row_button = array(); //array with value being the url for the buttom to go to (passing the id) [0] = value [1] = url
	protected $_ajaxFilter_fields = array(); //array of fields that can be are filtered by ajax (creates a textbox at the top of the table)
    protected $_ajaxFilterBoxSize = array(); //array (sub fieldname) holding size of the input box
    protected $_format_field_with_function = array(); //array holding the (user-defined) function to format a field with on display (format: array[field] = function_name); used in formatFieldWithFunction function

	
	protected $_sql_order_by = array(); //por si se quiere tener ms de un campo de ordenamiento
    protected $_sql_where_clauses = array(); //array for IF there is more than one where clause	
	protected $_limit = null; // limit of rows to display on one page. Defaults NULL.
	
	protected $_showPaging = false; //Show paging. Defaults false.
	protected $_current_page = 1; // pgina a mostrar cuando esta activado show paging.
	protected $_page_parameter_name = "page"; // nombre del parametro para enviar el numero de pagina. Por defecto es page.
	
	protected $_table_title;
	protected $_table_filters_subtitle = null;
	protected $_css_file;
    protected $_css = true; //indicates a css spredsheet WILL be used	
    protected $_border = 0; //table border - default is off: 0
	
	/**
	 * Constructor
	 * @param string Doctrine Table Name
	 */
	public function __construct($tablename, $table_desc="dummy", $table_desc_plural ="")
    {        
		//TODO pendiente hacer esto configurable segun el tipo de conector a la bd
		$this->_dbConnector = new DoctrineConnector($tablename);		
		$this->_table_name = $tablename;
		//TODO $this->prepareAddaxCRUD($table_desc, $table_desc_plural,"/includes/classes/addax/crud/crud/");
		$this->prepareAddaxCRUD($table_desc, $table_desc_plural,"/javascript/addax/");
		
		//echo "<br/>AddaxCRUD__construct ".(var_export($_SESSION,true));
    }	
	
	// Constructor
    function prepareAddaxCRUD($item, $item_plural, $ajaxcrud_root = "") 
	{

        //global variable - for allowing multiple ajaxCRUD tables on one page
        global $num_ajaxCRUD_tables_instantiated;
        if ($num_ajaxCRUD_tables_instantiated === "") $num_ajaxCRUD_tables_instantiated = 0;

        //$this->showCheckbox     = false;
        $this->ajaxcrud_root    = $ajaxcrud_root;
        $this->ajax_file        = pnZendPopupURL($this->_module, $this->_controller, 'crud'); 

		$this->item 			= $item;		
		$this->item_plural		= (empty($item_plural)?$item . "s":$item_plural);
		$this->_table_title	 = $this->item_plural;

		$this->_table_columns 	= $this->_dbConnector->getColumnNames();
		$this->_table_pk_array	= $this->_dbConnector->getPrimaryKeyColumns();
		$this->_table_fk_array	= $this->_dbConnector->getForeignKeyColumns();
		$this->_field_datatype  = $this->_dbConnector->getColumnTypes();
		$this->_enums_values    = $this->_dbConnector->getEnumColumnsValues();

        //assumes the primary key is auto incrementing
        $this->primaryKeyAutoIncrement = true;

        $this->doActionOnShowTable = true;

        $this->onAddExecuteCallBackFunction         = '';
        $this->onFileUploadExecuteCallBackFunction  = '';
        $this->onDeleteFileExecuteCallBackFunction  = '';

        //don't allow primary key to be editable
		$this->_uneditable_fields = $this->_dbConnector->getPrimaryKeyColumns();		
		
        $this->_display_fields   = $this->_table_columns;
        $this->add_fields       = $this->_table_columns;

		if (count($this->_table_columns) == 0){
			$error_msg[] = "No fields in this table!";
			echo_msg_box();
			exit();
		}

		//for filtering if there is a request parameter
		$count_filtered = 0;
		$action = $_REQUEST['action'];
        foreach ($this->_table_columns as $field){
			if ($_REQUEST[$field] != '' && ($action != 'add' && $action != 'delete' && $action != 'update' && $action != 'upload' && $action != 'delete_file')){
				$filter_field = $field;
				$filter_value = $_REQUEST[$field];
				$filter_where_clause = "WHERE $filter_field LIKE \"%" . $filter_value . "%\"";
				$this->addWhereClause($filter_where_clause);
				$this->filtered_table = true;
                $count_filtered++;
			}
		}
        if ($count_filtered > 0){
            $this->filtered_table;
        }
        else{
            $this->filtered_table = false;
        }
		return true;
	}
	
	
	/***********************************************
	 * Funciones de configuracin del ambiente crud 
	************************************************/
	function setView($view)
	{
        $this->_view = $view;
    }
	
	function setSessionNamespace($namespace)
	{
        //$this->_session_namespace = $namespace;
    }
	
	function setModule($module)
	{
		$this->_module = $module;
	}	
	
	/***********************************************
	 * Funciones de configuracin del crud por 
	 * parte del usuario
	************************************************/
	
	function setControllerName($controller)
	{
		$this->_controller = $controller;
	}
	
	function setTemplatePath($path)
	{
		$this->_oldtemplatepath = $this->_view->getTemplatePath();
		$this->_view->setTemplatePath($path);
	}
	
	function setTitle($title)
	{
		$this->_table_title = $title;
	}
		
	function setRequestParamFilter($filter_field, $filter_value)
	{
		if (!$this->isFieldAForeignKey($filter_field))
		{	
			echo "Para establecer un filtro en el titulo el campo $filter_field, debe estar habilitado en una relacin";
			return;
		}
		$this->_display_filter_fields[$filter_field] = $filter_value;
		
		$this->addWhereClause("$filter_field = $filter_value");		
		$this->omitField($filter_field);
	}
	
	function setCSSFile($css_file)
	{
        $this->_css_file = $css_file;
    }
	
	function addTableBorder()
	{
        $this->_border = 1;
    }
	
	function disallowDelete()
	{
        $this->_delete = false;
    }

    function disallowAdd()
	{
        $this->_add = false;
    }
	
	function displayAddFormTop()
	{
    	$this->_add_form_top = true;
    }
	
	function turnOffAjaxADD()
	{
        $this->_ajax_add = false;
    }
	
	function turnOffAjaxEditing()
	{
        $this->ajax_editing = false;
    }
	
	function displayAs($field, $the_field_name)
	{
        $this->displayAs_array[$field] = $the_field_name;
    }

	function setTextareaHeight($field, $height)
	{
        $this->textarea_height[$field] = $height;
    }
	
	function omitField($field_name)
	{
        $key = array_search($field_name, $this->_display_fields);

        if ($this->fieldInArray($field_name, $this->_display_fields)){
            unset($this->_display_fields[$key]);
        }
        else{
            $error_msg[] = "Error in your doNotDisplay function call. There is no field named <b>$field_name</b> in the table <b>" . $this->_table_name . "</b>";
        }
    }
	
	function omitPrimaryKey()
	{
		foreach ($this->_table_pk_array as $pkey)
		{
			$key = array_search($pkey, $this->_display_fields);
			unset($this->_display_fields[$key]);
		}
    }
	    
	function omitAddField($field_name)
	{
        $key = array_search($field_name, $this->add_fields);
		
        if ($key !== FALSE){
            unset($this->add_fields[$key]);
        }
        else{
            $error_msg[] = "Error in your omitAddField function call. There is no field named <b>$field_name</b> in the table <b>" . $this->_table_name . "</b>";
        }
    }
	
	function addWhereClause($where_clause, $logical_operator="AND")
	{
        $this->_sql_where_clauses[] = array($where_clause => $logical_operator);
	}
	
	function addOrderBy($field, $dir="ASC")
	{
		$this->_sql_order_by[] = array($field => $dir);
	}

	function setLimit($limit)
	{
        $this->_limit = $limit;
    }
	
	function turnOnPaging($page = "", $rowsxpage = "")
	{
		if ($page =="") $page = 1;
		if ($rowsxpage =="") $rowsxpage = 50;
		
        $this->_showPaging = true;        
		$this->_current_page = $page;
		$this->_limit = $rowsxpage;
    }
	
	function setPageParameterName($name)
	{
		$this->_page_parameter_name = $name;
	}
	
	function disallowEdit($field)
	{
        $this->_uneditable_fields[] = $field;
    }
	
	function defineCheckbox($field, $value_on="1", $value_off="0")
	{
		$new_array = array($value_on, $value_off);

		$this->_checkbox[$field] = $new_array;
	}
	
	function addButtonToRow($value, $url, $add_fields = "", $attach_params = "", $javascript_tags = "")
	{
        $this->_row_button[] = array(0 => $value, 1 => $url, 2 => $add_fields, 3 => $attach_params, 4 => $javascript_tags);		
    }
	
	function formatFieldWithFunction($field, $function_name)
	{
        $this->_format_field_with_function[$field] = $function_name;
    }
	
	//$array_values ( value => display)
	function defineAllowableValues($field, $array_values, $onedit_textbox = FALSE)
	{
		if ($onedit_textbox != FALSE)
		{
			$this->field_no_dropdown[$field] = TRUE;
		}
		$this->_allowed_values[$field] = $array_values;
	}
	
	/***********************************************
	 * Funciones de Manejo de la BD
	************************************************/
	
	function add($fields)
	{
		$this->_dbConnector->insertRow($fields);
	}
	
	function update($rowId, $field, $newValue)
	{
		$this->_dbConnector->updateRow($rowId, $field, $newValue);
	}	
	
	function delete($rowId)
	{
		$this->_dbConnector->deleteRow($rowId);
	}
	
	/***********************************************
	 * Funciones de Consulta sobre el crud (templates)
	************************************************/

	function getFieldNames()
	{
		return $this->_table_columns;
	}
	
	function fieldIsInt($field)
	{
		$datatype = $this->getFieldDataType($field);
        if (stristr($datatype, "int") !== FALSE || stristr($datatype, "integer") !== FALSE){
            return true;
        }
        return  false;
    }

	function fieldIsDate($field)
	{
		$datatype = $this->getFieldDataType($field);
        if (stristr($datatype, "date") !== FALSE){
            return true;
        }
        return  false;
    }

    function fieldIsDecimal($field)
	{
		$datatype = $this->getFieldDataType($field);				
        if (stristr($datatype, "decimal") !== FALSE || stristr($datatype, "double") !== FALSE){
            return true;
        }
        return  false;
    }

    function fieldIsEnum($field)
	{
		$datatype = $this->getFieldDataType($field);		
        if (stristr($datatype, "enum") !== FALSE){
            return true;
        }
        return  false;
    }
	
	function getNumberOfInstantiatedTables()
	{
		global $num_ajaxCRUD_tables_instantiated;
		return $num_ajaxCRUD_tables_instantiated;
	}
	
	function showCheckbox()
	{
		return $this->showCheckbox;
	}
	
	function getSortDirection()
	{
		return $this->sort_direction;
	}
	
	function isEnableEdit()
	{
		return $this->ajax_editing;
	}
	
	function getDisplayFields()
	{
		return $this->_display_fields;
	}
	
	function getDisplayName($field)
	{
		if (isset($this->displayAs_array[$field]))
			return ($this->displayAs_array[$field]);
		else
			return $field;
	}
	
	function showAddFormOnTop()
	{
		return $this->_add_form_top;
	}
	
	function getAddFields()
	{
		return $this->add_fields;
	}
	
	function getPreField($field, $unique_id)
	{
		return trim($this->_table_name .'_'. $field .'_'. $unique_id);
	}
	
	function isFieldEditable($field)
	{
		return !$this->fieldInArray($field, $this->_uneditable_fields);
	}
	
	function hasFilterFields()
	{
		return (is_array($this->_ajaxFilter_fields) && ($this->getNumberOfFilterFields() > 0));
	}
	
	function getNumberOfFilterFields() /*??*/
	{
		return count($this->_ajaxFilter_fields);
	}
	
	function getFilterFields()
	{
		return $this->_ajaxFilter_fields;
	}
	
	function getFilterBoxSize($field)
	{
		return $this->_ajaxFilterBoxSize[$field];
	}
		
	function isFieldInRequest($field)
	{
		return ($_REQUEST[$field] != '');
	}	
	
	function getFieldValueFromRequest($field)
	{
		return ($_REQUEST[$field]);
	}
		
	function deleteRow()
	{
		return $this->_delete;
	}
	
	function addRow()
	{
		return $this->_add;
	}
	
	function isFieldACheckbox($field)
	{
		return (is_array($this->_checkbox[$field]));
	}
	
	function getCheckboxValueOn($field)
	{

		if ($this->isFieldACheckbox($field))
		{
		
			$values = $this->_checkbox[$field];
			$value_on = $values[0];
			$value_off = $values[1];		
			return $value_on;
		}
        else
		{
			return null;
		}
	}
	
	function getCheckboxValueOff($field)
	{
		if ($this->isFieldACheckbox($field))
		{
			$values = $this->_checkbox[$field];
			$value_on = $values[0];
			$value_off = $values[1];
			return $value_off;
		}
        else
		{
			return null;
		}
	}
	
	function isFieldAForeignKey($field)
	{
		return (array_key_exists($field, $this->_fk_fields) !== false); 
	}
	
	function isFieldAPrimaryKey($field)
	{
		return array_search($field, $this->_table_pk_array) !== false;
	}
	
	function hasFieldPredefinedAllowedValues($field)
	{
		return (is_array($this->_allowed_values[$field]));
	}
	
	function getFieldPredefinedAllowedValues($field)
	{
		return ($this->_allowed_values[$field]);
	}
	
	function isFieldAnFileUpload($field)
	{
		return ($this->fieldInArray($field, $this->file_uploads));	
	}
	
	function getFileUploadFileInfo($field)
	{
		return $this->file_uploads[$field];
	}
	
	function isFieldCategoryRequired($field)
	{
		return ($this->category_required[$field] != true);
	}

	function isFieldNotShowingDropdown($field)
	{	
		return (isset($this->field_no_dropdown[$field]) && $this->field_no_dropdown[$field]);
	}
	
	function isADropdownField($field)
	{		
		return (//Si es un fk a otra tabla
				$this->isFieldAForeignKey($field) || 
				//Si tiene valores predefinidos y no se ha excluido de dropdown fields
				($this->hasFieldPredefinedAllowedValues($field) && !$this->isFieldNotShowingDropdown($field)) ||
				//Si es un enumerado
				$this->fieldIsEnum($field)
				);
	}
	
	function hasFieldUserFormatFunction($field)
	{
		return ($this->_format_field_with_function[$field] != '');
	}
	
	function getUserFormatedFieldValue($field, $data)
	{
		return call_user_func($this->_format_field_with_function[$field], $data);
	}	

    function showUploadForm($field, $unique_id)
	{
		$file_upload_info = $this->getFileUploadFileInfo($field);
		$this->_view->upload_folder = $file_upload_info[$field]->destination_folder; 
		$this->_view->row_id = $unique_id;
		
		echo $this->_view->output('show_upload_form.tpl'); 		
    }
	
	function getRowPrimaryKeyValues($row)
	{
		$pkvalues = array();
		//Obtiene los valores de los campos primary key para la fila dada
		foreach ($this->_table_pk_array as $field)
		{
			$pkvalues[$field] = $row[$field];
		}
		
		return $pkvalues;
	}
	
	function getHtmlRowId($row)
	{
		$hmtl_id = "";		
		$pkvalues = $this->getRowPrimaryKeyValues($row);
		foreach ($pkvalues as $field => $val)
		{	
			$html_id .= ($html_id != ""?"_":"").$val;
		}
		return $html_id;
	}
	
	function isRowSelected($row)
	{
		$selected = true;
		
		//Obtiene los valores del pk de la fila
		$pkvalues = $this->getRowPrimaryKeyValues($row);
		
		//Para todos los campos en la primary key, revisa si han sido enviados en el request para esta fila
		foreach ($this->_table_pk_array as $pkfield)
		{
			if (!$this->isFieldInRequest($pkfield) || $this->getFieldValueFromRequest($pkfield) != $pkvalues[$pkfield])
			{
				$selected = false;
			}
		}
		
		return $selected;
	}
	
	function getRowPKeyRequestParams($row, $referencetable = false)
	{
		$pkey = $this->getRowPrimaryKeyValues($row);
		$str_params = "";
		foreach ($pkey as $field => $val)
		{
			$str_params .= (referencetable?$this->_table_name."_":"")."$field/$val/";
		}
		return $str_params;
	}
	
	function getRowFieldsRequestParams($row, $fields, $referencetable = false)
	{
		$str_params = "";
		foreach ($fields as $field)
		{
			$str_params .= (referencetable?$this->_table_name."_":"")."$field/".$row[$field]."/";
		}
		return $str_params;
	}
	
	function getAddaxCrudUpdateActionUrl($id, $field)
	{		
		$table = $this->_table_name;
		$params = array ('table' => $table, 'field' => $field, 'id' => $id, 'prefield' => $this->getPreField($field, $id) );//&pk=<!--{$this->db_table_pk}-->
		return pnZendPopupURL($this->_module, $this->_controller, 'update', $params);
	}
	
	function getAddaxCrudAddActionUrl()
	{
		$table = $this->_table_name;		
		$params = array('table' => $table);
		return pnZendPopupURL($this->_module, $this->_controller, 'add', $params); 
	}
	
	function getAddaxCrudDeleteActionUrl()
	{
		$table = $this->_table_name;
		$params = array('table' => $table);
		return pnZendPopupURL($this->_module, $this->_controller, 'delete', $params); 
	}
	
	function getAddaxCrudCrudActionUrl()
	{
		return pnZendPopupURL($this->_module, $this->_controller, 'crud'); 
	}
	
	function shouldShowPKeyOnAddForm()
	{
		return $on_add_specify_primary_key;
	}
	
	function getRowCount(){
		return $this->_dbConnector->getRowsCount($this->getWhereClause());        
        //borrar return "<span id='ajaxCRUD_RowCount'>" . $count . "</span>";
    }
	
	function getTitle()
	{
		return $this->_table_title;
	}
	
	function getRequestParamFiltersSubtitle($filter_field, $filter_value)
	{
		foreach ($this->_display_filter_fields as $filter_field => $filter_value)
		{
			$foreign_values = $this->_dbConnector->getForeignValues($filter_field, $this->_fk_fields[$filter_field]);						
			$this->_table_filters_subtitle .= (!empty($this->_table_filters_subtitle)?", ":"").$this->getDisplayName($filter_field).": ".$foreign_values[$filter_value];	
		}
		return $this->_table_filters_subtitle;
	}

    function getTableRowCount(){
        return $this->_dbConnector->getRowsCount(); 
    }
	
	function showAddForm()
	{
		$this->_view->ajax_add = $this->_ajax_add;
		echo $this->_view->output('add_form.tpl'); 
	}
	
	function showPagingLinks()
	{	
		//TODO <kmarcos>Pendiente por AJAX</kmarcos>
		$record_count = $this->getRowCount();
		$total_pages = ($record_count <= $this->_limit)? 1: ceil($record_count / $this->_limit);
		$page_param = $this->_page_parameter_name;
		$url_base =$this->getThisUrl();
		
		//Se remueve la parte de la paginacin para recomponerlo en el template
		$pattern = "/$page_param\/[0-9]*[\/]*/";		
		$url_base =  rtrim(preg_replace($pattern, "", $url_base),'/');
		
		$this->_view->current_page = $this->_current_page;
		$this->_view->total_pages = $total_pages;
		$this->_view->base_url = $url_base;		
		$this->_view->page_param = $page_param;		
		
		echo $this->_view->output('paging_links.tpl'); 
	}
	
	function hasRowButtons()
	{
		return (is_array($this->_row_button) && count($this->_row_button) >0);
	}
	
	function displayRowButtons($row)
	{
		foreach ($this->_row_button as $row_button)
		{
			$value = $row_button[0];
			$url = $row_button[1];
			$add_fields = array();
			if (!empty($row_button[2])) $add_fields = split(",",$row_button[2]);			
			$attach_param = $row_button[3];
			$javascript_onclick_function = $row_button[4];			

			//its most likely a user-defined ajax function
			if ($javascript_onclick_function != "")
				$javascript_for_button ="$javascript_onclick_function(".$row.html_unique_id.");";
			else
			{
				$otherfields = $this->getRowFieldsRequestParams($row, $add_fields, true);
				$locationurl = rtrim($url,'/')."/".$this->getRowPKeyRequestParams($row, true).$otherfields.$attach_param;
				$javascript_for_button ="location.href='".rtrim($locationurl,'/')."'";
			}
			
			$this->_view->row_button_value = $value;
			$this->_view->javascript_for_button = $javascript_for_button;
			echo $this->_view->output('row_button.tpl'); 
		}
    }
	
	function makeAjaxEditor($unique_id, $field, $field_value, $type = 'textarea', $field_size = "", $field_text = "", $onKeyPress_function = "")
	{
        $prefield =  $this->getPreField($field, $unique_id);

		$input_name = $type . "_" . $prefield;

        $return_html = "";

		if ($field_text == "") $field_text = $field_value;
        
		//for getting rid of the html space, replace with actual no text
		if ($field_value == "&nbsp;&nbsp;") $field_value = "";
		
		//Update URL
		$this->_view->ed_action_url = $this->getAddaxCrudUpdateActionUrl($unique_id, $field);
		$this->_view->unique_id = $unique_id;
		$this->_view->prefield = $prefield;
		$this->_view->input_name = $input_name;
		$this->_view->field = $field;
		$this->_view->field_value = $field_value;
		$this->_view->field_size = $field_size;
		$this->_view->field_text = $field_text;
		$this->_view->onKeyPress_function = $onKeyPress_function;
		
		if ($type == 'text')
		{
			echo $this->_view->output('make_ajax_editor_text.tpl'); 		
		}
		elseif($type == 'date')
		{
			echo $this->_view->output('make_ajax_editor_date.tpl'); 
		}
		else{
			echo $this->_view->output('make_ajax_editor_textarea.tpl'); 
		}		
	}//makeAjaxEditor
	
    function makeAjaxDropdown($field, $row)
	{
		$field_value = $row[$field];
		$unique_id = $this->getHtmlRowId($row);
		$prefield = $this->getPreField($field, $unique_id);		
		$array_list = $this->getDropdownValues($field);
		$novalue = false;
		$selected_dropdown_text = $array_list[$field_value];
		if ($selected_dropdown_text == ''){        
            $novalue = true;
            $novalue_text = "";
			if ($this->fieldIsInt($field) || $this->fieldIsDecimal($field))
			{
				$novalue_text = "0";
			}
        }
		
		if ($this->isFieldEditable($field))
		{
			$this->_view->field_value = $field_value;
			$this->_view->selected_dropdown_text = $selected_dropdown_text;
			$this->_view->array_list = $array_list;
			$this->_view->prefield = $prefield;
			$this->_view->novalue = $novalue;
			$this->_view->novalue_text = $novalue_text;
			$this->_view->required = ($this->category_required[$field] == TRUE);
			$this->_view->dd_action_url = $this->getAddaxCrudUpdateActionUrl($unique_id, $field);
			echo $this->_view->output('make_ajax_dropdown.tpl'); 	
		}
		else
		{
			echo $selected_dropdown_text;
		}
	}//makeAjaxDropdown
	
	function makeAjaxCheckbox($unique_id, $field, $field_value)
	{	
		$prefield =  $this->getPreField($field, $unique_id);

		$values = $this->_checkbox[$field];
		$value_on = $values[0];
		$value_off = $values[1];

		$show_value = '';
		if ($value_on != "1" && $value_on != 1) $show_value = $value_on;

		$checked = '';
		if ($field_value == $value_on) $checked = "checked";

		//strip quotes
		$value_on = str_replace('"', "'", $value_on);
		$value_off = str_replace('"', "'", $value_off);
		
        $this->_view->checked = $checked;
        $this->_view->value_on = $value_on;
        $this->_view->value_off = $value_off;
        $this->_view->prefield = $prefield;
        $this->_view->show_value = $show_value;
        $this->_view->cb_action_url = $this->getAddaxCrudUpdateActionUrl($unique_id, $field);
		
		echo $this->_view->output('make_ajax_checkbox.tpl'); 		

	}//makeAjaxCheckbox

	function showMessages()
	{
        global $error_msg;
        global $report_msg;

        if (is_string($error_msg)){
            $error_msg = array();
        }
        if (is_string($report_msg)){
            $report_msg = array();
        }

        //for passing errors/reports over get variables
        if ($_REQUEST['err_msg'] != ''){
            $error_msg[] = $_REQUEST['err_msg'];
        }
        if ($_REQUEST['rep_msg'] != ''){
            $report_msg[] = $_REQUEST['rep_msg'];
        }

        if(is_array($report_msg)){
            $first = true;
                foreach ($report_msg as $e){
                    if($first){
                        $reports.= "&nbsp;&nbsp; $e";
                        $first = false;
                    }
                    else
                        $reports.= "<br /> $e";
                }
        }
        if($reports != ''){
            echo "<div class='report'>$reports</div>";
        }

        if(is_array($error_msg)){
            $first = true;
                foreach ($error_msg as $e){
                    if($first){
                        $errors.= "&nbsp;&nbsp; $e";
                        $first = false;
                    }
                    else
                        $errors.= "<br />$e";
                }
        }
        if($errors != ''){
            echo "<div class='error'>$errors</div>";
        }
    }
	
	/***********************************************
	 * Funciones Internas
	************************************************/
    
	private function getEnumArray($field)
	{		
        return $this->_enums_values[$field];
    }

    private function fieldInArray($field, $the_array)
	{
		//echo "serching $field in ".var_export($the_array, true);
        //try to find index for arrays with array[key] = field_name
        $found_index = array_search($field, $the_array);
        if ($found_index !== FALSE){
            return true;
        }
        //for arrays with array[0] = field_name and array[1] = value
        foreach ($the_array as $the_array_values){
            $field_name = $the_array_values[0];
            if ($field_name == $field){
                return true;
            }
        }
        return false;
    }
	
	private function insertHeader($ajax_file)
	{
		$this->_view->ajaxcrud_root = $this->ajaxcrud_root;
		$this->_view->ajax_file = $this->ajax_file;
		$this->_view->this_page = $_SERVER['PHP_SELF'] ;
		$this->_view->css = $this->_css ;	
		$this->_view->addaxcrud = $this ;	
		
        if ($this->_css_file == ''){
            $this->_css_file = 'default.css';
        }
		
		$this->_view->css_file = $this->_css_file ;
		echo $this->_view->output('header.tpl'); 
	}
	
	private function getFieldDataType($field_name)
	{
        return $this->_field_datatype[$field_name];
    }

	private function getWhereClause()
	{
		if (!is_array($this->_sql_where_clauses) || empty($this->_sql_where_clauses))
		return null;
		
		$strWhere = "";
		
		foreach ($this->_sql_where_clauses as $where_clause)
		{
			foreach ($where_clause as $clause => $op)
			{
				$strWhere .= ( $strWhere != "" ? " $op " :"")." $clause";
			}
		}
		return $strWhere;
	}
	
	private function getOrderByClause()
	{
		if (!is_array($this->_sql_order_by) || empty($this->_sql_order_by))
		return null;
		
		$strOrderBy = "";
		
		foreach ($this->_sql_order_by as $orderbyelement)
		{
			foreach ($orderbyelement as $field => $dir)
			{
				$strOrderBy .= ( $strOrderBy != "" ? "," :"")." $field $dir";
			}
		}
		return $strOrderBy;
	}
	
	private function getLimit()
	{
		return $this->_limit;
	}
	
	private function getOffset()
	{
		if (!$this->_showPaging)
			return null;	
		$offset = ($this->_current_page -1) * $this->_limit;		
		return $offset;
	}
	
	private function getThisUrl()
	{
		return $_SERVER['REQUEST_URI'];
	}

	/////////////////////////////////////////////////////////////
	//////// PENDIENTES
	/////////////////////////////////////////////////////////////


    function addAjaxFilterBox($field_name)
	{
        $this->_ajaxFilter_fields[] = $field_name;
        $this->setAjaxFilterBoxSize($field_name, 10);
    }

    function setAjaxFilterBoxSize($field_name, $size)
	{
        $this->_ajaxFilterBoxSize[$field_name] = $size;
    }

    function addAjaxFilterBoxAllFields()
	{
        foreach ($this->_display_fields as $field)
		{
            $this->addAjaxFilterBox($field);
        }
    }
	
	
	
	function enableRelationship($field, $display_field = null)
	{		
		if (!array_key_exists($field, $this->_table_fk_array))
		{
			echo "El campo $field no tiene definida una relacin";
		}
		if (null == $display_field)
		{
			$display_field = $field;
		}
		$this->_fk_fields[$field] = $display_field;
	}

	//@ADDAX@  Added Category WHERE FILTER
    function defineRelationship($fkCategoryID, $category_table, $category_table_pk, $category_field_name, $category_sort_field = "", $category_required = "1", $category_where = ""){

        $this->db_table_fk_array[]          = $fkCategoryID;
        $this->category_table_array[]       = $category_table;
        $this->category_table_pk_array[]    = $category_table_pk;
        $this->category_field_array[]       = $category_field_name;
        $this->category_sort_field_array[]  = $category_sort_field;
		$this->category_where_array[]  = $category_where;

        //make the relationship required for the field
        if ($category_required == "1"){
            $this->category_required[$fkCategoryID] = TRUE;
        }
    }

    function relationshipFieldOptional(){
        $this->cat_field_required = FALSE;
    }


	

    function omitFieldCompletely($field_name)
	{
        $this->omitField($field_name);
        $this->omitAddField($field_name);
    }

    function addValueOnInsert($field_name, $insert_value){
        //if the value is NOW() then it's a date field or if its an integer --> otherwise put quotes around it.
        //if ($insert_value != "NOW()" && !is_int($insert_value)){
        //    $insert_value = "\"" . $insert_value . "\"";
        //}
        $this->add_values[] = array(0 => $field_name, 1 => $insert_value);
    }

    function onAddExecuteCallBackFunction($function_name){
        $this->onAddExecuteCallBackFunction = $function_name;
        $this->_ajax_add = false;
    }

    function onFileUploadExecuteCallBackFunction($function_name){
        $this->onFileUploadExecuteCallBackFunction = $function_name;
    }

    function onDeleteFileExecuteCallBackFunction($function_name){
        $this->onDeleteFileExecuteCallBackFunction = $function_name;
    }

    function primaryKeyNotAutoIncrement(){
        $this->primaryKeyAutoIncrement = false;
    }

    function setFileUpload($field_name, $destination_folder, $relative_folder = "")
	{
        //put values into array
        $this->file_uploads[] = $field_name;
        $this->file_upload_info[$field_name][destination_folder] = $destination_folder;
        $this->file_upload_info[$field_name][relative_folder] = $relative_folder;

        //the filenames that are saved are not editable
        $this->disallowEdit($field_name);

        //have to add the row via POST now
        $this->_ajax_add = false;
    }

    function appendUploadFilename($append_field){
        $this->filename_append_field = $append_field;
    }

    
  

    function addButton($value, $url, $tags = ""){
		//@ADDAX soporte para varios botones
        $this->bottom_button_array[] = array(0 => $value, 1 => $url, 2 => $tags);
    }
   

    function onAddSpecifyPrimaryKey(){
        $this->on_add_specify_primary_key = true;
    }

	function doAction($action)
	{
		global $error_msg;
		global $report_msg;

		$item = $this->item;
		
		#adding new item (via traditional way, non-ajax -- this is the ONLY way files can be uploaded with ajaxCRUD)
		if ($action == 'add')
		{

            //this if condition is so MULTIPLE ajaxCRUD tables can be used on the same page.
            if ($_REQUEST['table'] == $this->_table_name){

                //for sql insert statement
                $submitted_values = array();

                //for callback function (if defined)
                $submitted_array = array();

                //this new row has (a) file(s) coming with it
                $uploads_on = $_REQUEST['uploads_on'];
                if ($uploads_on == 'true' && $_FILES){
                    $uploads_on = true;
                }

                foreach($this->_table_columns as $field){

                    $submitted_value_cleansed = "";
                    if ($_REQUEST[$field] == ''){
                        if ($this->fieldIsInt($field) || $this->fieldIsDecimal($field)){
                            $submitted_value_cleansed = 0;
                        }
                    }
                    else{
                        $submitted_value_cleansed = $_REQUEST[$field];
                    }


                    $submitted_values[] = $submitted_value_cleansed;
                    //also used for callback function
                    $submitted_array[$field] = $submitted_value_cleansed;
                }

                //get rid of the primary key in the fields column
                if (!$this->on_add_specify_primary_key){
                    unset($submitted_values[0]);    //assumes the primary key is the FIRST field in the array
                }

                //for adding values to the row which were not in the ADD row table - but are specified by ADD on INSERT
                if (count($this->add_values) > 0){
                    foreach ($this->add_values as $add_value){
                        $field_name = $add_value[0];
                        $the_add_value = $add_value[1];

                        if ($submitted_array[$field_name] == ''){
                            $submitted_array[$field_name] = $the_add_value;
                        }

                        //reshuffle numeric indexed array
                        unset($submitted_values);
                        $submitted_values = array();
                        foreach($submitted_array as $field){
                            $submitted_values[] = $field;
                        }

                        //get rid of the primary key in the fields column
                        if (!$this->on_add_specify_primary_key){
                            unset($submitted_values[0]);    //assumes the primary key is the FIRST field in the array
                        }

                    }
                }

                //wrap each field in quotes
                $string_submitted_values = "\"" . implode("\",\"", $submitted_values) . "\"";;


                //for getting datestamp of new row for mysql's "NOW" to work
                $string_submitted_values = str_replace('"NOW()"', 'NOW()', $string_submitted_values);

                //print_r($submitted_values);

                if ($string_submitted_values != ''){
                    if (!$this->on_add_specify_primary_key && $this->primaryKeyAutoIncrement){
                        //don't allow the primary key to be inputted
                        $fields_array_without_pk = $this->_table_columns;
                        unset($fields_array_without_pk[0]);   //assumes the primary key is the FIRST field in the array
                        $string_fields_without_pk = implode(",", $fields_array_without_pk);

                        $query = "INSERT INTO $this->_table_name($string_fields_without_pk) VALUES ($string_submitted_values)";
                    }
                    else{
                        if (!$this->primaryKeyAutoIncrement){
						//TODO pkey
                            $primary_key_value = q1("SELECT MAX($this->_table_pk_array) FROM $this->_table_name");
                            if ($primary_key_value > 0) $primary_key_value++;
                            $primary_key_value = $primary_key_value . ", ";
                        }

                        $string_fields_with_pk = implode(",", $this->_table_columns);
                        $query = "INSERT INTO $this->_table_name($string_fields_with_pk) VALUES ($primary_key_value $string_submitted_values)";
                    }
                    $success = qr($query);

                    if ($success){
                        $insert_id = mysql_insert_id();
                        //$_SESSION[insert_id] = $insert_id;

                        $report_msg[] = "$item Added";

                        if ($uploads_on){
                            foreach($this->file_uploads as $field_name){
                                $file_dest  = $this->file_upload_info[$field_name][destination_folder];

                                if ($_FILES[$field_name]['name'] != ''){
                                    $this->uploadFile($insert_id, $field_name, $file_dest);
                                }
                            }
                        }

                        if ($this->onAddExecuteCallBackFunction != ''){
                            $submitted_array[id] = $insert_id;
							//TODO pkey
                            $submitted_array[$this->_table_pk_array] = $insert_id;
                            call_user_func($this->onAddExecuteCallBackFunction, $submitted_array);
                        }

                    }
                    else{
                        $error_msg[] = "$item could not be added. Please try again.";
                    }
                }
                else{
                    $error_msg[] = "All fields were omitted.";
                }

            }//if POST parameter 'table' == _table_name
		}//action = add

        if ($action == 'upload' && $_REQUEST['field_name'] && $_REQUEST['id'] != ''){
            $update_id      = $_REQUEST['id'];
            $file_field     = $_REQUEST['field_name'];
            $upload_folder  = $this->file_upload_info[$file_field][destination_folder];

            $success = $this->uploadFile($update_id, $file_field, $upload_folder);

            if ($success){
                $report_msg[] = "File Uploaded Sucessfully.";
            }
            else{
                $error_msg[] = "There was an error uploading your file (or none was selected).";
            }

        }//action = upload

        if ($action == 'delete_file' && $_REQUEST['field_name'] && $_REQUEST['id'] != ''){
            $delete_id      = $_REQUEST['id'];
            $file_field     = $_REQUEST['field_name'];
            $upload_folder  = $_REQUEST['upload_folder'];

			//TODO pkey
            $filename = q1("SELECT $file_field FROM $this->_table_name WHERE $this->_table_pk_array = $delete_id");
            $success = qr("UPDATE $this->_table_name SET $file_field = \"\" WHERE $this->_table_pk_array = $delete_id");

            if ($success){
                $file_dest  = $this->file_upload_info[$file_field][destination_folder];

                unlink($file_dest . $filename);
                $report_msg[] = "File Deleted Sucessfully.";

                if ($this->onDeleteFileExecuteCallBackFunction != ''){
                    $delete_file_array = array();
                    $delete_file_array[id]        = $delete_id;
                    $delete_file_array[field]     = $file_field;
                    call_user_func($this->onDeleteFileExecuteCallBackFunction, $delete_file_array);
                }

            }
            else{
                $error_msg[] = "There was an error deleting your file.";
            }

        }//action = delete_file

	}//doAction


    //a file must have been "sent"/posted for this to work
    function uploadFile($row_id, $file_field, $upload_folder){
        @$fileName  = $_FILES[$file_field]['name'];
        @$tmpName   = $_FILES[$file_field]['tmp_name'];
        @$fileSize  = $_FILES[$file_field]['size'];
        @$fileType  = $_FILES[$file_field]['type'];

        $new_filename = make_filename_safe($fileName);
        if ($this->filename_append_field != ""){
            if ($_REQUEST[$this->filename_append_field] != ''){
                $new_filename = $_REQUEST[$this->filename_append_field] . "_" . $new_filename;
            }
            else{
				//TOd pkey
                if ($this->filename_append_field == $this->_table_pk_array){
                    $new_filename = $row_id . "_" . $new_filename;
                }
                else{
				//TODO pkey
                    @$db_value_to_append = q1("SELECT $this->filename_append_field FROM $this->_table_name WHERE $this->_table_pk_array = $row_id");
                    if ($db_value_to_append != ""){
                        $new_filename = $db_value_to_append . "_" . $new_filename;
                    }
                }

            }
        }

        $destination = $upload_folder . $new_filename;

        $success = move_uploaded_file ($tmpName, $destination);

        if ($success){
		//TODO pkey
            $update_success = qr("UPDATE $this->_table_name SET $file_field = \"$new_filename\" WHERE $this->_table_pk_array = $row_id");

            if ($this->onFileUploadExecuteCallBackFunction != ''){
                $file_info_array = array();
                $file_info_array[id]        = $row_id;
                $file_info_array[field]     = $file_field;
                $file_info_array[fileName]  = $new_filename;
                $file_info_array[fileSize]  = $fileSize;
                $file_info_array[fldType]   = $fldType;
                call_user_func($this->onFileUploadExecuteCallBackFunction, $file_info_array);
            }

        }

        if ($update_success){
            return true;
            //$report_msg[] = "File Uploaded.";
        }
        else{
            return false;
            //$error_msg[] = "There was an error uploading your file (or none was selected).";
        }
    }

	function showTable()
	{
        global $error_msg;
        global $report_msg;
        global $num_ajaxCRUD_tables_instantiated;

        $num_ajaxCRUD_tables_instantiated++;

		//Ejecuta la Consulta		
		//TODO 
        /* call functions based on sorting [cancels out default sorting set by addOrderBy] */		
        if ($_REQUEST['sort_field'] != ''){
            $sort_field = $_REQUEST['sort_field'];
            $user_sort_order_direction = $_REQUEST['sort_direction'];

            if ($user_sort_order_direction == 'asc'){
                $this->sort_direction = "desc";
            }
            else{
                $this->sort_direction = "asc";
            }
            $sort_sql = " ORDER BY $sort_field $this->sort_direction";
            $this->addOrderBy($sort_sql);
            $this->sorted_table = true;
        }

		//Trae los registros
		$where = $this->getWhereClause();
		$orderby = $this->getOrderByClause();
		$limit = $this->getLimit();
		$offset = $this->getOffset();
		
		$rows = $this->_dbConnector->getRows($where, $orderby, $limit, $offset);

		
		$row_count = count($rows);
        $this->row_count = $row_count;
        $_SESSION['row_count'] = $row_count;		
		
        if ($row_count == 0)
		{
            $report_msg[] = defined(ADDAXCRUD_TABLE_HAS_NO_ROWS)?constant(ADDAXCRUD_TABLE_HAS_NO_ROWS):"No hay registros.";
        }
		
		//Prepara los Ids de html elementos por cada fila		
		foreach ($rows as $key => $row)
		{
			$id ="";
			foreach ( $this->_table_pk_array as $pkfield )
			{
				$id .= ($id!=""?"_":"") . $row[$pkfield];
			}
			$rows[$key]["html_unique_id"] = $id;
		}		
		
        if ( $num_ajaxCRUD_tables_instantiated == 1 )
		{
            //pull in the  css and javascript files
            $this->insertHeader($this->ajax_file);
        }
		
        if ($this->doActionOnShowTable){
            if ($_REQUEST['action'] != ''){
                $this->doAction($_REQUEST['action']);
            }
        }

		$item = $this->item;

		#############################################
		#
		# Begin code for displaying database elements
		#
		#############################################

        #this is an optional function which will allow you to display errors or report messages as desired. comment it out if desired
        //only show the message box if it hasn't been displayed already
	
		$this->_view->row_count = $row_count;
		$this->_view->table_name = $this->_table_name;
		$this->_view->item = $this->item;
		$this->_view->row_button = $this->_row_button;
		$this->_view->rows = $rows;		
		$this->_view->primary_key_cols = $this->_dbConnector->getPrimaryKeyColumns();
		$this->_view->cellspacing = $this->cellspacing;
		$this->_view->border = $this->_border;
		$this->_view->addaxcrud = $this;
		$this->_view->totalpage = $this->totalpage;
		$this->_view->links = $this->links;
		$this->_view->bottom_button_array = $this->bottom_button_array;
		$this->_view->on_add_specify_primary_key = $this->on_add_specify_primary_key;
		
		$table_html = $this->_view->output('the_table.tpl'); 
		$this->_view->table_html = $table_html;
		
		echo $this->_view->output('show_table.tpl'); 
		
		//Restablece el path de la vista
		$this->_view->setTemplatePath($this->_oldtemplatepath);

		//echo "ANTES ".(var_export($_SESSION,true));
        //for ajax adding
        if ($this->_ajax_add)
		{
			unset($_SESSION['the_table_div']);
            $_SESSION['the_table_div'] = $table_html;
			//echo "despues ".(var_export($_SESSION,true));
			/*try{		
				$addxcrudNamespace = new Zend_Session_Namespace('AddaxCrud');
			}
			catch (Exception $e)
			{
				echo 'Caught exception: ',  $e->getMessage(), "\n";
			}
			
			$addxcrudNamespace->the_table_div = $table_html;*/
        }
		
		//echo $addxcrudNamespace->the_table_div;
		
        //when table is being filtered via ajax, it is retrieved via the session var
        $_SESSION['filtered_table_div'] = $table_html;
        $_SESSION['sorted_table_div' . $num_ajaxCRUD_tables_instantiated] = $table_html;
	}

	

	function getDropdownValues($field)
	{		
		//if is a foreign key
		if ($this->isFieldAForeignKey($field))
		{				
			$array_fvalues = $this->_dbConnector->getForeignValues($field, $this->_fk_fields[$field]);	
			
			//Si este campo se uso como filtro desde el request inicial, no se deben permitir otros valores
			if (array_key_exists($field, $this->_display_filter_fields))
			{
				$field_value = $this->_display_filter_fields[$field];
				$array_list = array ($field_value => $array_fvalues[$field_value]);				
			}
			else
			{
				$array_list = $array_fvalues;
			}
			/*
			
			----------------
			foreach ($this->category_table_array as $key => $category_table)
			{
				$category_field_name = $this->category_field_array[$key];
				$category_table_pk   = $this->category_table_pk_array[$key];
				$category_fk = $this->db_table_fk_array[$key];

				$order_by = '';
				if ($this->category_sort_field_array[$key] != ''){
					$order_by = " ORDER BY " . $this->category_sort_field_array[$key];
				}
				
				//@ADDAX <limit relationship values>
				$str_where = "";
				if ($this->category_where_array[$key] != ''){
					$str_where = " " . $this->category_where_array[$key];
				}
				//@ADDAX </limit relationship values>
				//@ADDAX@ <Fix for allowable values>
				
				if(isset($this->allowed_values[$category_fk]) && is_array($this->allowed_values[$category_fk]))
				{
					$allowed_values = array();
					foreach($this->allowed_values[$category_fk] as $key => $value)
					{
						if(is_array($value))
						{
							$allowed_values[] = $value[0];
						}
						else
						{
							$allowed_values[] = $value;
						}
					}
					$str_values = implode(",", $allowed_values);
					if(!empty($str_where))
					{
						$str_where . " AND ";
					}
					$str_where .= " $category_table_pk IN ($str_values)";
				}
				if(!empty($str_where))
				{
					$str_where = " WHERE $str_where";
				}
				$dropdown_array[] = q("SELECT $category_table_pk, $category_field_name FROM $category_table $str_where $order_by");
				//@ADDAX@ </ Fix for allowable values>
				
			---------------
			
			
			foreach ($this->category_table_array as $key => $category_table)
			{
				
				//@ADDAX <limit relationship values>
				$str_where = "";
				if ($this->category_where_array[$key] != ''){
					$str_where = " " . $this->category_where_array[$key];
				}
				//@ADDAX </limit relationship values>
				//@ADDAX@ <Fix for allowable values>
				
				if(isset($this->allowed_values[$category_fk]) && is_array($this->allowed_values[$category_fk]))
				{
					$allowed_values = array();
					foreach($this->allowed_values[$category_fk] as $key => $value)
					{
						if(is_array($value))
						{
							$allowed_values[] = $value[0];
						}
						else
						{
							$allowed_values[] = $value;
						}
					}
					$str_values = implode(",", $allowed_values);
					if(!empty($str_where))
					{
						$str_where . " AND ";
					}
					$str_where .= " $category_table_pk IN ($str_values)";
				}
				if(!empty($str_where))
				{
					$str_where = " WHERE $str_where";
				}
				$dropdown_array[] = q("SELECT $category_table_pk, $category_field_name FROM $category_table $str_where $order_by");
				//@ADDAX@ </ Fix for allowable values>
			}	
			*/
		}
		//Tiene valores predefinidos
		elseif ($this->hasFieldPredefinedAllowedValues($field) && !$this->isFieldNotShowingDropdown($field))
		{
			$array_list = $this->getFieldPredefinedAllowedValues($field);
		}		
		//Si es un enumerado
		elseif ($this->fieldIsEnum($field))
		{
			$enum_values = $this->getEnumArray($field);
			foreach($enum_values as $enumval)
			{
				$array_list[$enumval] = defined($enumval)?constant($enumval):$enumval;
			}
		}	
		return $array_list;
	}	

}//class


/* In an effect to minimize filecount, I am attaching this (paging) class and a few functions all in this file */
class paging{

	function pageLinks($url){
        global $choose_category,$sort, $num_ajaxCRUD_tables_instantiated;
        $cssclass = "paging_links";
		$this->pShowLinkNotice = "&nbsp;";
		if($this->pRecordCount>$this->pRowsPerPage){
			$this->pShowLinkNotice = "Page ".$this->pPageID. " of ".$this->pRecord;
			//Previous link
			if($this->pPageID!==1){
                $prevPage = $this->pPageID - 1;
                $link = "<a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=1&mid=$ltype&cid=$catid") . "\" class=\"$cssclass\">|<<</a>\n ";
                $link .= "<a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=$prevPage&mid=$ltype&cid=$catid") ."\" class=\"$cssclass\"><<</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n";
			}
			//Number links 1.2.3.4.5.
			for($ctr=1;$ctr<=$this->pRecord;$ctr++){
				if($this->pPageID==$ctr)
                $link .=  "<a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=$ctr") . "\" class=\"$cssclass\"><b>$ctr</b></a>\n";
				else
                $link .= "  <a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=$ctr") . "\" class=\"$cssclass\">$ctr</a>\n";
			}
			//Previous Next link
			if($this->pPageID<($ctr-1)){
                $nextPage = $this->pPageID + 1;
                $link .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=$nextPage&mid=$ltype&cid=$catid") . "\" class=\"$cssclass\">>></a>\n";
                $link .="<a href=\"javascript:;\" onClick=\"" . $this->getOnClick("&pid=".$this->pRecord."&mid=$ltype&cid=$catid") . "\" class=\"$cssclass\">>>|</a>\n";
			}
			return $link;
		}
	}

	function getOnClick($paging_query_string){
		global $num_ajaxCRUD_tables_instantiated;
		$extra_query_params = "Dealer=" . htmlentities($_REQUEST['Dealer']);
		return "pageTable('&" . $extra_query_params . "$paging_query_string', $num_ajaxCRUD_tables_instantiated);";
	}
}

if (!function_exists('make_filename_safe')){

    function make_filename_safe($filename){
        $filename = trim(str_replace(" ","_",$filename));
        $filename = str_replace("'", "", $filename);
        $filename = str_replace('"', '', $filename);
        $filename = str_replace('#', '_', $filename);
        $filename = str_replace('%20', '_', $filename);

        return stripslashes($filename);
    }
}


?>