/**
 * Created by Julio on 6/2/14.
 */

(function( $ ){
    var settings;
    var defaults = {

        position: "top center"
        ,margin_left: 20
        ,margin_right: 60
        ,transparency: 0.5
        ,showlogs: false
    };

    //Depende de que exista jquery. Solo se pueden capturar llamados ajax con jquery.
    function startHandlers(){
        $( document ).ajaxStart(function() {
            showloading();
        });

        $( document ).ajaxError(function() {
            hideloading();
            if(settings.showlogs){
                //showmessage("Recurso no disponible", 'warning');
                console.log("Recurso no disponible");
            }
        });
        $( document ).ajaxStop(function() {
            hideloading();
        });
        $( document ).ajaxComplete(function( event, xhr, settings ) {
            if(settings.showlogs)
                console.log(xhr);
            hideloading();
        });

    }
    function showloading(){
        $('#addaxloading').css('display', 'block');
        if(settings.showlogs)
            console.log('show loading...');
    }
    //type: error, warning, notice, success
    function showmessage(themessage, type){
        if(!type){
            var type = '';
        }
        $('#addaxmessage').attr('class', '');
        $('#addaxmessage').addClass(type);
        $('#addaxmessage .txt').html(themessage);
        $('#addaxmessage').show('fast');
    }
    function hideloading(){
        $('#addaxloading').hide('fast');
        if(settings.showlogs)
            console.log('hide loading...');
    }
    /*
        top left
        top center
        top right
        bottom left
        bottom center
        bottom right

     */
    function setPosition(positionparts, towhom){
        if(settings.showlogs){
            console.log("SEt position: "+ positionparts[0] + " "+positionparts[1] );
        }
        var marginleft = settings.margin_left ;
        var marginright = settings.margin_right ;

        if(positionparts[0].toLowerCase() == 'bottom'){

            $('.addaxholder').css('top', 'auto');
            $('.addaxholder').css('bottom', '0px');
        }else{
            $('.addaxholder').css('top', '0px');
            $('.addaxholder').css('bottom', 'auto');
        }
        if(positionparts[1].toLowerCase() == 'left'){
            $(towhom).css('margin-left', marginleft+'px');
            $(towhom).css('margin-right', 'auto');
        }else
            if(positionparts[1].toLowerCase() == 'right'){
                $(towhom).css('margin-left', 'auto');
                $(towhom).css('margin-right', marginright+'px');
            }else{
                $(towhom).css('margin-left', 'auto');
                $(towhom).css('margin-right', 'auto');
            }
    }
    function initializeloading(elemento){
        //Agregar el elemento.

        var contenido =
            "<div id='addaxloadingmain'>" +

                "<div class='addaxholder'>" +
                    "<div id='addaxloading'>" +
                        "<div class='img'></div>" +
                        "<div class='message_body'>" +
                            "<div class='title'></div>" +
                            "<div class='txt'>Procesando petición</div>" +
                        "</div>" +
                    "</div>" +
                "</div>" +
                "<div class='addaxholder'>" +
                "<div id='addaxmessage' class=''>" +
                        "<div class='img'></div>" +
                        "<div class='message_body'>" +
                            "<div class='title'></div>" +
                            "<div class='txt'></div>" +
                        "</div>" +
                    "</div>" +
                "</div>" +
            "</div>"
           ;

        $('body').append(contenido);

        var position = settings.position;
        var positionparts = position.split(" ");
        if(positionparts.length != 2){
            //posicion por defecto.
            positionparts = ["top", "center"];
        }
        setPosition(positionparts, 'div#addaxloading');


        $('#addaxmessage').click(function(){
            $('#addaxmessage').hide();
        })
    }


    var methods = {
        init : function(options) {
            settings = $.extend( {}, defaults, options );

            initializeloading(this);
            startHandlers();

        },
        set_position : function( newpos ) {
            if(!newpos ){
                var newpos = "top center";
            }
            var positionparts = newpos.split(" ");
            if(positionparts.length != 2){
                //posicion por defecto.
                positionparts = ["top", "center"];
            }

            setPosition(positionparts, 'div#addaxloading');
            if(settings.showlogs)
                console.log("set position: " + newpos);
        }
        ,show_message : function( values ) {
            if(values){
                var message = values.message;
                var type= values.type;
                showmessage(message, type);
            }
        }
        ,remove : function( ) {
            $('#addaxloadingmain').remove();
        }
    };
    $.fn.addaxloading = function(methodOrOptions) {
        if ( methods[methodOrOptions] ) {
            return methods[ methodOrOptions ].apply( this, Array.prototype.slice.call( arguments, 1 ));
        } else if ( typeof methodOrOptions === 'object' || ! methodOrOptions ) {
            // Default to "init"
            return methods.init.apply( this, arguments );
        } else {
            $.error( 'Method ' +  methodOrOptions + ' does not exist on jQuery.tooltip' );
        }
    };

})( jQuery );
/*
Ejemplo de uso.
if (window.jQuery) {

    // jQuery is loaded
    $( document ).ready(function() {
        $( document).addaxloading({
            position: 'top left'//default to top center.
            ,margin_left: 20
            ,margin_right: 60
            ,showlogs: false//optional. Default to false.
        });
    });

     $( document).addaxloading('show_message',{'message':'Mensaje de prueba prueba sdlkfj alsdkfj alsd;kjf ', 'type': 'error'});
     $( document).addaxloading('remove');
     $( document).addaxloading('set_position', 'top right');


 } else {
    // jQuery is not loaded

}*/