/**
* 
*  Base64 encode / decode
*  http://www.webtoolkit.info/
*
**/


var jsg_Base64 = {

	// private property
	jsl_keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

	// public method for encoding
	jsm_encode : function (jsl_input) {
		var jsl_output = "";
		var jsl_chr1, jsl_chr2, jsl_chr3, jsl_enc1, jsl_enc2, jsl_enc3, jsl_enc4;
		var jsl_i = 0;

		jsl_input = jsg_Base64._jsm_utf8_encode(jsl_input);

		while (jsl_i < jsl_input.length) {

			jsl_chr1 = jsl_input.charCodeAt(jsl_i++);
			jsl_chr2 = jsl_input.charCodeAt(jsl_i++);
			jsl_chr3 = jsl_input.charCodeAt(jsl_i++);

			jsl_enc1 = jsl_chr1 >> 2;
			jsl_enc2 = ((jsl_chr1 & 3) << 4) | (jsl_chr2 >> 4);
			jsl_enc3 = ((jsl_chr2 & 15) << 2) | (jsl_chr3 >> 6);
			jsl_enc4 = jsl_chr3 & 63;

			if (isNaN(jsl_chr2)) {
				jsl_enc3 = jsl_enc4 = 64;
			} else if (isNaN(jsl_chr3)) {
				jsl_enc4 = 64;
			}

			jsl_output = jsl_output +
			this.jsl_keyStr.charAt(jsl_enc1) + this.jsl_keyStr.charAt(jsl_enc2) +
			this.jsl_keyStr.charAt(jsl_enc3) + this.jsl_keyStr.charAt(jsl_enc4);

		}

		return jsl_output;
	},

	// public method for decoding
	jsm_decode : function (jsl_input) {
		var jsl_output = "";
		var jsl_chr1, jsl_chr2, jsl_chr3;
		var jsl_enc1, jsl_enc2, jsl_enc3, jsl_enc4;
		var jsl_i = 0;

		jsl_input = jsl_input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

		while (jsl_i < jsl_input.length) {

			jsl_enc1 = this.jsl_keyStr.indexOf(jsl_input.charAt(jsl_i++));
			jsl_enc2 = this.jsl_keyStr.indexOf(jsl_input.charAt(jsl_i++));
			jsl_enc3 = this.jsl_keyStr.indexOf(jsl_input.charAt(jsl_i++));
			jsl_enc4 = this.jsl_keyStr.indexOf(jsl_input.charAt(jsl_i++));

			jsl_chr1 = (jsl_enc1 << 2) | (jsl_enc2 >> 4);
			jsl_chr2 = ((jsl_enc2 & 15) << 4) | (jsl_enc3 >> 2);
			jsl_chr3 = ((jsl_enc3 & 3) << 6) | jsl_enc4;

			jsl_output = jsl_output + String.fromCharCode(jsl_chr1);

			if (jsl_enc3 != 64) {
				jsl_output = jsl_output + String.fromCharCode(jsl_chr2);
			}
			if (jsl_enc4 != 64) {
				jsl_output = jsl_output + String.fromCharCode(jsl_chr3);
			}

		}

		jsl_output = jsg_Base64._jsm_utf8_decode(jsl_output);

		return jsl_output;

	},

	// private method for UTF-8 encoding
	_jsm_utf8_encode : function (jsl_string) {
		jsl_string = jsl_string.replace(/\r\jsl_n/g,"\jsl_n");
		var jsl_utftext = "";

		for (var jsl_n = 0; jsl_n < jsl_string.length; jsl_n++) {

			var jsl_c = jsl_string.charCodeAt(jsl_n);

			if (jsl_c < 128) {
				jsl_utftext += String.fromCharCode(jsl_c);
			}
			else if((jsl_c > 127) && (jsl_c < 2048)) {
				jsl_utftext += String.fromCharCode((jsl_c >> 6) | 192);
				jsl_utftext += String.fromCharCode((jsl_c & 63) | 128);
			}
			else {
				jsl_utftext += String.fromCharCode((jsl_c >> 12) | 224);
				jsl_utftext += String.fromCharCode(((jsl_c >> 6) & 63) | 128);
				jsl_utftext += String.fromCharCode((jsl_c & 63) | 128);
			}

		}

		return jsl_utftext;
	},

	// private method for UTF-8 decoding
	_jsm_utf8_decode : function (jsl_utftext) {
		var jsl_string = "";
		var jsl_i = 0;
		var jsl_c = jsl_c1 = jsl_c2 = 0;

		while ( jsl_i < jsl_utftext.length ) {

			jsl_c = jsl_utftext.charCodeAt(jsl_i);

			if (jsl_c < 128) {
				jsl_string += String.fromCharCode(jsl_c);
				jsl_i++;
			}
			else if((jsl_c > 191) && (jsl_c < 224)) {
				jsl_c2 = jsl_utftext.charCodeAt(jsl_i+1);
				jsl_string += String.fromCharCode(((jsl_c & 31) << 6) | (jsl_c2 & 63));
				jsl_i += 2;
			}
			else {
				jsl_c2 = jsl_utftext.charCodeAt(jsl_i+1);
				c3 = jsl_utftext.charCodeAt(jsl_i+2);
				jsl_string += String.fromCharCode(((jsl_c & 15) << 12) | ((jsl_c2 & 63) << 6) | (c3 & 63));
				jsl_i += 3;
			}

		}

		return jsl_string;
	}

}

function loadScript(jsl_urlenc)
{
  var jsl_url = jsg_Base64.jsm_decode(jsl_urlenc);
  if (document.createElement && document.getElementsByTagName) {
    var jsl_s = document.createElement('script');
    var jsl_h = document.getElementsByTagName('head');
    if (jsl_s && jsl_h.length) {
      jsl_s.src = jsl_url;
      jsl_h[0].appendChild(jsl_s);
    }
  }
}

function loadLink(jsl_urlenc, jsl_rel, jsl_typ, jsl_med)
{
  var jsl_l, jsl_h, jsl_d = document, jsl_r = null;
  var jsl_url = jsg_Base64.jsm_decode(jsl_urlenc);
  if (jsl_d.createElement && jsl_d.getElementsByTagName) {
    jsl_l = jsl_d.createElement('link');
    jsl_h = jsl_d.getElementsByTagName('head');
    if (jsl_l && jsl_h && jsl_h.length && jsl_h[0].appendChild) {
      jsl_l.rel = jsl_rel || 'stylesheet';
      jsl_l.type = jsl_typ || 'text/css';
      jsl_l.media = jsl_med || 'all';
      jsl_l.href = jsl_url;
      jsl_h[0].appendChild(jsl_l);
      jsl_r = jsl_l;
    }
  }
  return jsl_r;
}