/*
  proj4js.js -- Javascript reprojection library. 
  
  Authors:      Mike Adair madairATdmsolutions.ca
                Richard Greenwood richATgreenwoodmap.com
                Didier Richard didier.richardATign.fr
                Stephen Irons
  License:      LGPL as per: http://www.gnu.org/copyleft/lesser.html 
                Note: This program is an almost direct port of the C library
                Proj4.
*/
/* ======================================================================
    proj4js.js
   ====================================================================== */

/*
Author:       Mike Adair madairATdmsolutions.ca
              Richard Greenwood rich@greenwoodmap.com
License:      LGPL as per: http://www.gnu.org/copyleft/lesser.html

$Id: Proj.js 2956 2007-07-09 12:17:52Z steven $
*/

/**
 * Namespace: Proj4js
 *
 * Proj4js is a JavaScript library to transform point coordinates from one 
 * coordinate system to another, including datum transformations.
 *
 * This library is a port of both the Proj.4 and GCTCP C libraries to JavaScript. 
 * Enabling these transformations in the browser allows geographic data stored 
 * in different projections to be combined in browser-based web mapping 
 * applications.
 * 
 * Proj4js must have access to coordinate system initialization strings (which
 * are the same as for PROJ.4 command line).  Thes can be included in your 
 * application using a <script> tag or Proj4js can load CS initialization 
 * strings from a local directory or a web service such as spatialreference.org.
 *
 * Similarly, Proj4js must have access to projection transform code.  These can
 * be included individually using a <script> tag in your page, built into a 
 * custom build of Proj4js or loaded dynamically at run-time.  Using the
 * -combined and -compressed versions of Proj4js includes all projection class
 * code by default.
 *
 * Note that dynamic loading of defs and code happens ascynchrously, check the
 * Proj.readyToUse flag before using the Proj object.  If the defs and code
 * required by your application are loaded through script tags, dynamic loading
 * is not required and the Proj object will be readyToUse on return from the 
 * constructor.
 * 
 * All coordinates are handled as points which have a .x and a .y property
 * which will be modified in place.
 *
 * Override Proj4js.reportError for output of alerts and warnings.
 *
 * See http://trac.osgeo.org/proj4js/wiki/UserGuide for full details.
*/

/**
 * Global namespace object for Proj4js library
 */
Proj4js={defaultDatum:"WGS84",transform:function(a,d,b){if(!a.readyToUse)return this.reportError("Proj4js initialization for:"+a.srsCode+" not yet complete"),b;if(!d.readyToUse)return this.reportError("Proj4js initialization for:"+d.srsCode+" not yet complete"),b;if("900913"==a.srsProjNumber&&"WGS84"!=d.datumCode&&!d.datum_params||"900913"==d.srsProjNumber&&"WGS84"!=a.datumCode&&!a.datum_params){var e=Proj4js.WGS84;this.transform(a,e,b);a=e}"enu"!=a.axis&&this.adjust_axis(a,!1,b);"longlat"==a.projName?
(b.x*=Proj4js.common.D2R,b.y*=Proj4js.common.D2R):(a.to_meter&&(b.x*=a.to_meter,b.y*=a.to_meter),a.inverse(b));a.from_greenwich&&(b.x+=a.from_greenwich);b=this.datum_transform(a.datum,d.datum,b);d.from_greenwich&&(b.x-=d.from_greenwich);"longlat"==d.projName?(b.x*=Proj4js.common.R2D,b.y*=Proj4js.common.R2D):(d.forward(b),d.to_meter&&(b.x/=d.to_meter,b.y/=d.to_meter));"enu"!=d.axis&&this.adjust_axis(d,!0,b);return b},datum_transform:function(a,d,b){if(a.compare_datums(d)||a.datum_type==Proj4js.common.PJD_NODATUM||
d.datum_type==Proj4js.common.PJD_NODATUM)return b;a.datum_type==Proj4js.common.PJD_GRIDSHIFT&&alert("ERROR: Grid shift transformations are not implemented yet.");d.datum_type==Proj4js.common.PJD_GRIDSHIFT&&alert("ERROR: Grid shift transformations are not implemented yet.");if(a.es!=d.es||a.a!=d.a||a.datum_type==Proj4js.common.PJD_3PARAM||a.datum_type==Proj4js.common.PJD_7PARAM||d.datum_type==Proj4js.common.PJD_3PARAM||d.datum_type==Proj4js.common.PJD_7PARAM)a.geodetic_to_geocentric(b),a.datum_type!=
Proj4js.common.PJD_3PARAM&&a.datum_type!=Proj4js.common.PJD_7PARAM||a.geocentric_to_wgs84(b),d.datum_type!=Proj4js.common.PJD_3PARAM&&d.datum_type!=Proj4js.common.PJD_7PARAM||d.geocentric_from_wgs84(b),d.geocentric_to_geodetic(b);d.datum_type==Proj4js.common.PJD_GRIDSHIFT&&alert("ERROR: Grid shift transformations are not implemented yet.");return b},adjust_axis:function(a,d,b){for(var e=b.x,f=b.y,g=b.z||0,h,l,m=0;3>m;m++)if(!d||2!=m||void 0!==b.z)switch(0==m?(h=e,l="x"):1==m?(h=f,l="y"):(h=g,l="z"),
a.axis[m]){case "e":b[l]=h;break;case "w":b[l]=-h;break;case "n":b[l]=h;break;case "s":b[l]=-h;break;case "u":void 0!==b[l]&&(b.z=h);break;case "d":void 0!==b[l]&&(b.z=-h);break;default:return alert("ERROR: unknow axis ("+a.axis[m]+") - check definition of "+src.projName),null}return b},reportError:function(a){},extend:function(a,d){a=a||{};if(d)for(var b in d){var e=d[b];void 0!==e&&(a[b]=e)}return a},Class:function(){for(var a=function(){this.initialize.apply(this,arguments)},d={},b,e=0;e<arguments.length;++e)b=
"function"==typeof arguments[e]?arguments[e].prototype:arguments[e],Proj4js.extend(d,b);a.prototype=d;return a},bind:function(a,d){var b=Array.prototype.slice.apply(arguments,[2]);return function(){var e=b.concat(Array.prototype.slice.apply(arguments,[0]));return a.apply(d,e)}},scriptName:"proj4js-combined.js",defsLookupService:"http://spatialreference.org/ref",libPath:null,getScriptLocation:function(){if(this.libPath)return this.libPath;for(var a=this.scriptName,d=a.length,b=document.getElementsByTagName("script"),
e=0;e<b.length;e++){var f=b[e].getAttribute("src");if(f){var g=f.lastIndexOf(a);if(-1<g&&g+d==f.length){this.libPath=f.slice(0,-d);break}}}return this.libPath||""},loadScript:function(a,d,b,e){var f=document.createElement("script");f.defer=!1;f.type="text/javascript";f.id=a;f.src=a;f.onload=d;f.onerror=b;f.loadCheck=e;/MSIE/.test(navigator.userAgent)&&(f.onreadystatechange=this.checkReadyState);document.getElementsByTagName("head")[0].appendChild(f)},checkReadyState:function(){if("loaded"==this.readyState)if(this.loadCheck())this.onload();
else this.onerror()}};
Proj4js.Proj=Proj4js.Class({readyToUse:!1,title:null,projName:null,units:null,datum:null,x0:0,y0:0,localCS:!1,queue:null,initialize:function(a,d){this.srsCodeInput=a;this.queue=[];d&&this.queue.push(d);if(0<=a.indexOf("GEOGCS")||0<=a.indexOf("GEOCCS")||0<=a.indexOf("PROJCS")||0<=a.indexOf("LOCAL_CS"))this.parseWKT(a),this.deriveConstants(),this.loadProjCode(this.projName);else{if(0==a.indexOf("urn:")){var b=a.split(":");"ogc"!=b[1]&&"x-ogc"!=b[1]||"def"!=b[2]||"crs"!=b[3]||(a=b[4]+":"+b[b.length-
1])}else 0==a.indexOf("http://")&&(b=a.split("#"),b[0].match(/epsg.org/)?a="EPSG:"+b[1]:b[0].match(/RIG.xml/)&&(a="IGNF:"+b[1]));this.srsCode=a.toUpperCase();0==this.srsCode.indexOf("EPSG")?(this.srsCode=this.srsCode,this.srsAuth="epsg",this.srsProjNumber=this.srsCode.substring(5)):0==this.srsCode.indexOf("IGNF")?(this.srsCode=this.srsCode,this.srsAuth="IGNF",this.srsProjNumber=this.srsCode.substring(5)):0==this.srsCode.indexOf("CRS")?(this.srsCode=this.srsCode,this.srsAuth="CRS",this.srsProjNumber=
this.srsCode.substring(4)):(this.srsAuth="",this.srsProjNumber=this.srsCode);this.loadProjDefinition()}},loadProjDefinition:function(){if(Proj4js.defs[this.srsCode])this.defsLoaded();else{var a=Proj4js.getScriptLocation()+"defs/"+this.srsAuth.toUpperCase()+this.srsProjNumber+".js";Proj4js.loadScript(a,Proj4js.bind(this.defsLoaded,this),Proj4js.bind(this.loadFromService,this),Proj4js.bind(this.checkDefsLoaded,this))}},loadFromService:function(){Proj4js.loadScript(Proj4js.defsLookupService+"/"+this.srsAuth+
"/"+this.srsProjNumber+"/proj4js/",Proj4js.bind(this.defsLoaded,this),Proj4js.bind(this.defsFailed,this),Proj4js.bind(this.checkDefsLoaded,this))},defsLoaded:function(){this.parseDefs();this.loadProjCode(this.projName)},checkDefsLoaded:function(){return Proj4js.defs[this.srsCode]?!0:!1},defsFailed:function(){Proj4js.reportError("failed to load projection definition for: "+this.srsCode);Proj4js.defs[this.srsCode]=Proj4js.defs.WGS84;this.defsLoaded()},loadProjCode:function(a){if(Proj4js.Proj[a])this.initTransforms();
else{var d=Proj4js.getScriptLocation()+"projCode/"+a+".js";Proj4js.loadScript(d,Proj4js.bind(this.loadProjCodeSuccess,this,a),Proj4js.bind(this.loadProjCodeFailure,this,a),Proj4js.bind(this.checkCodeLoaded,this,a))}},loadProjCodeSuccess:function(a){Proj4js.Proj[a].dependsOn?this.loadProjCode(Proj4js.Proj[a].dependsOn):this.initTransforms()},loadProjCodeFailure:function(a){Proj4js.reportError("failed to find projection file for: "+a)},checkCodeLoaded:function(a){return Proj4js.Proj[a]?!0:!1},initTransforms:function(){Proj4js.extend(this,
Proj4js.Proj[this.projName]);this.init();this.readyToUse=!0;if(this.queue)for(var a;a=this.queue.shift();)a.call(this,this)},wktRE:/^(\w+)\[(.*)\]$/,parseWKT:function(a){if(a=a.match(this.wktRE)){var d=a[1],b=a[2].split(","),e;e="TOWGS84"==d.toUpperCase()?d:b.shift();e=e.replace(/^\"/,"");e=e.replace(/\"$/,"");a=[];for(var f=0,g="",h=0;h<b.length;++h){for(var l=b[h],m=0;m<l.length;++m)"["==l.charAt(m)&&++f,"]"==l.charAt(m)&&--f;g+=l;0===f?(a.push(g),g=""):g+=","}switch(d){case "LOCAL_CS":this.projName=
"identity";this.localCS=!0;this.srsCode=e;break;case "GEOGCS":this.projName="longlat";this.geocsCode=e;this.srsCode||(this.srsCode=e);break;case "PROJCS":this.srsCode=e;break;case "PROJECTION":this.projName=Proj4js.wktProjections[e];break;case "DATUM":this.datumName=e;break;case "LOCAL_DATUM":this.datumCode="none";break;case "SPHEROID":this.ellps=e;this.a=parseFloat(a.shift());this.rf=parseFloat(a.shift());break;case "PRIMEM":this.from_greenwich=parseFloat(a.shift());break;case "UNIT":this.units=
e;this.unitsPerMeter=parseFloat(a.shift());break;case "PARAMETER":d=e.toLowerCase();b=parseFloat(a.shift());switch(d){case "false_easting":this.x0=b;break;case "false_northing":this.y0=b;break;case "scale_factor":this.k0=b;break;case "central_meridian":this.long0=b*Proj4js.common.D2R;break;case "latitude_of_origin":this.lat0=b*Proj4js.common.D2R}break;case "TOWGS84":this.datum_params=a;break;case "AXIS":d=e.toLowerCase();b=a.shift();switch(b){case "EAST":b="e";break;case "WEST":b="w";break;case "NORTH":b=
"n";break;case "SOUTH":b="s";break;case "UP":b="u";break;case "DOWN":b="d";break;default:b=" "}this.axis||(this.axis="enu");switch(d){case "X":this.axis=b+this.axis.substr(1,2);break;case "Y":this.axis=this.axis.substr(0,1)+b+this.axis.substr(2,1);break;case "Z":this.axis=this.axis.substr(0,2)+b}}for(h=0;h<a.length;++h)this.parseWKT(a[h])}},parseDefs:function(){this.defData=Proj4js.defs[this.srsCode];var a,d;if(this.defData){for(var b=this.defData.split("+"),e=0;e<b.length;e++)switch(d=b[e].split("="),
a=d[0].toLowerCase(),d=d[1],a.replace(/\s/gi,"")){case "title":this.title=d;break;case "proj":this.projName=d.replace(/\s/gi,"");break;case "units":this.units=d.replace(/\s/gi,"");break;case "datum":this.datumCode=d.replace(/\s/gi,"");break;case "nadgrids":this.nagrids=d.replace(/\s/gi,"");break;case "ellps":this.ellps=d.replace(/\s/gi,"");break;case "a":this.a=parseFloat(d);break;case "b":this.b=parseFloat(d);break;case "rf":this.rf=parseFloat(d);break;case "lat_0":this.lat0=d*Proj4js.common.D2R;
break;case "lat_1":this.lat1=d*Proj4js.common.D2R;break;case "lat_2":this.lat2=d*Proj4js.common.D2R;break;case "lat_ts":this.lat_ts=d*Proj4js.common.D2R;break;case "lon_0":this.long0=d*Proj4js.common.D2R;break;case "alpha":this.alpha=parseFloat(d)*Proj4js.common.D2R;break;case "lonc":this.longc=d*Proj4js.common.D2R;break;case "x_0":this.x0=parseFloat(d);break;case "y_0":this.y0=parseFloat(d);break;case "k_0":this.k0=parseFloat(d);break;case "k":this.k0=parseFloat(d);break;case "r_a":this.R_A=!0;break;
case "zone":this.zone=parseInt(d);break;case "south":this.utmSouth=!0;break;case "towgs84":this.datum_params=d.split(",");break;case "to_meter":this.to_meter=parseFloat(d);break;case "from_greenwich":this.from_greenwich=d*Proj4js.common.D2R;break;case "pm":d=d.replace(/\s/gi,"");this.from_greenwich=Proj4js.PrimeMeridian[d]?Proj4js.PrimeMeridian[d]:parseFloat(d);this.from_greenwich*=Proj4js.common.D2R;break;case "axis":d=d.replace(/\s/gi,""),3==d.length&&-1!="ewnsud".indexOf(d.substr(0,1))&&-1!="ewnsud".indexOf(d.substr(1,
1))&&-1!="ewnsud".indexOf(d.substr(2,1))&&(this.axis=d)}this.deriveConstants()}},deriveConstants:function(){"@null"==this.nagrids&&(this.datumCode="none");if(this.datumCode&&"none"!=this.datumCode){var a=Proj4js.Datum[this.datumCode];a&&(this.datum_params=a.towgs84?a.towgs84.split(","):null,this.ellps=a.ellipse,this.datumName=a.datumName?a.datumName:this.datumCode)}this.a||Proj4js.extend(this,Proj4js.Ellipsoid[this.ellps]?Proj4js.Ellipsoid[this.ellps]:Proj4js.Ellipsoid.WGS84);this.rf&&!this.b&&(this.b=
(1-1/this.rf)*this.a);Math.abs(this.a-this.b)<Proj4js.common.EPSLN&&(this.sphere=!0,this.b=this.a);this.a2=this.a*this.a;this.b2=this.b*this.b;this.es=(this.a2-this.b2)/this.a2;this.e=Math.sqrt(this.es);this.R_A&&(this.a*=1-this.es*(Proj4js.common.SIXTH+this.es*(Proj4js.common.RA4+this.es*Proj4js.common.RA6)),this.a2=this.a*this.a,this.b2=this.b*this.b,this.es=0);this.ep2=(this.a2-this.b2)/this.b2;this.k0||(this.k0=1);this.axis||(this.axis="enu");this.datum=new Proj4js.datum(this)}});
Proj4js.Proj.longlat={init:function(){},forward:function(a){return a},inverse:function(a){return a}};Proj4js.Proj.identity=Proj4js.Proj.longlat;Proj4js.defs={WGS84:"+title=long/lat:WGS84 +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees","EPSG:4326":"+title=long/lat:WGS84 +proj=longlat +a=6378137.0 +b=6356752.31424518 +ellps=WGS84 +datum=WGS84 +units=degrees","EPSG:4269":"+title=long/lat:NAD83 +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees","EPSG:3785":"+title= Google Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"};
Proj4js.defs.GOOGLE=Proj4js.defs["EPSG:3785"];Proj4js.defs["EPSG:900913"]=Proj4js.defs["EPSG:3785"];Proj4js.defs["EPSG:102113"]=Proj4js.defs["EPSG:3785"];
Proj4js.common={PI:3.141592653589793,HALF_PI:1.5707963267948966,TWO_PI:6.283185307179586,FORTPI:.7853981633974483,R2D:57.29577951308232,D2R:.017453292519943295,SEC_TO_RAD:4.84813681109536E-6,EPSLN:1E-10,MAX_ITER:20,COS_67P5:.3826834323650898,AD_C:1.0026,PJD_UNKNOWN:0,PJD_3PARAM:1,PJD_7PARAM:2,PJD_GRIDSHIFT:3,PJD_WGS84:4,PJD_NODATUM:5,SRS_WGS84_SEMIMAJOR:6378137,SIXTH:.16666666666666666,RA4:.04722222222222222,RA6:.022156084656084655,RV4:.06944444444444445,RV6:.04243827160493827,msfnz:function(a,d,
b){a*=d;return b/Math.sqrt(1-a*a)},tsfnz:function(a,d,b){b*=a;b=Math.pow((1-b)/(1+b),.5*a);return Math.tan(.5*(this.HALF_PI-d))/b},phi2z:function(a,d){for(var b=.5*a,e,f=this.HALF_PI-2*Math.atan(d),g=0;15>=g;g++)if(e=a*Math.sin(f),e=this.HALF_PI-2*Math.atan(d*Math.pow((1-e)/(1+e),b))-f,f+=e,1E-10>=Math.abs(e))return f;alert("phi2z has NoConvergence");return-9999},qsfnz:function(a,d){var b;return 1E-7<a?(b=a*d,(1-a*a)*(d/(1-b*b)-.5/a*Math.log((1-b)/(1+b)))):2*d},asinz:function(a){1<Math.abs(a)&&(a=
1<a?1:-1);return Math.asin(a)},e0fn:function(a){return 1-.25*a*(1+a/16*(3+1.25*a))},e1fn:function(a){return.375*a*(1+.25*a*(1+.46875*a))},e2fn:function(a){return.05859375*a*a*(1+.75*a)},e3fn:function(a){return 35/3072*a*a*a},mlfn:function(a,d,b,e,f){return a*f-d*Math.sin(2*f)+b*Math.sin(4*f)-e*Math.sin(6*f)},srat:function(a,d){return Math.pow((1-a)/(1+a),d)},sign:function(a){return 0>a?-1:1},adjust_lon:function(a){return a=Math.abs(a)<this.PI?a:a-this.sign(a)*this.TWO_PI},adjust_lat:function(a){return a=
Math.abs(a)<this.HALF_PI?a:a-this.sign(a)*this.PI},latiso:function(a,d,b){if(Math.abs(d)>this.HALF_PI)return+Number.NaN;if(d==this.HALF_PI)return Number.POSITIVE_INFINITY;if(d==-1*this.HALF_PI)return-1*Number.POSITIVE_INFINITY;b*=a;return Math.log(Math.tan((this.HALF_PI+d)/2))+a*Math.log((1-b)/(1+b))/2},fL:function(a,d){return 2*Math.atan(a*Math.exp(d))-this.HALF_PI},invlatiso:function(a,d){var b=this.fL(1,d),e=0,f=0;do e=b,f=a*Math.sin(e),b=this.fL(Math.exp(a*Math.log((1+f)/(1-f))/2),d);while(1E-12<
Math.abs(b-e));return b},sinh:function(a){a=Math.exp(a);return(a-1/a)/2},cosh:function(a){a=Math.exp(a);return(a+1/a)/2},tanh:function(a){a=Math.exp(a);return(a-1/a)/(a+1/a)},asinh:function(a){return(0<=a?1:-1)*Math.log(Math.abs(a)+Math.sqrt(a*a+1))},acosh:function(a){return 2*Math.log(Math.sqrt((a+1)/2)+Math.sqrt((a-1)/2))},atanh:function(a){return Math.log((a-1)/(a+1))/2},gN:function(a,d,b){d*=b;return a/Math.sqrt(1-d*d)}};
Proj4js.datum=Proj4js.Class({initialize:function(a){this.datum_type=Proj4js.common.PJD_WGS84;a.datumCode&&"none"==a.datumCode&&(this.datum_type=Proj4js.common.PJD_NODATUM);if(a&&a.datum_params){for(var d=0;d<a.datum_params.length;d++)a.datum_params[d]=parseFloat(a.datum_params[d]);if(0!=a.datum_params[0]||0!=a.datum_params[1]||0!=a.datum_params[2])this.datum_type=Proj4js.common.PJD_3PARAM;3<a.datum_params.length&&(0!=a.datum_params[3]||0!=a.datum_params[4]||0!=a.datum_params[5]||0!=a.datum_params[6])&&
(this.datum_type=Proj4js.common.PJD_7PARAM,a.datum_params[3]*=Proj4js.common.SEC_TO_RAD,a.datum_params[4]*=Proj4js.common.SEC_TO_RAD,a.datum_params[5]*=Proj4js.common.SEC_TO_RAD,a.datum_params[6]=a.datum_params[6]/1E6+1)}a&&(this.a=a.a,this.b=a.b,this.es=a.es,this.ep2=a.ep2,this.datum_params=a.datum_params)},compare_datums:function(a){return this.datum_type!=a.datum_type?!1:this.a!=a.a||5E-11<Math.abs(this.es-a.es)?!1:this.datum_type==Proj4js.common.PJD_3PARAM?this.datum_params[0]==a.datum_params[0]&&
this.datum_params[1]==a.datum_params[1]&&this.datum_params[2]==a.datum_params[2]:this.datum_type==Proj4js.common.PJD_7PARAM?this.datum_params[0]==a.datum_params[0]&&this.datum_params[1]==a.datum_params[1]&&this.datum_params[2]==a.datum_params[2]&&this.datum_params[3]==a.datum_params[3]&&this.datum_params[4]==a.datum_params[4]&&this.datum_params[5]==a.datum_params[5]&&this.datum_params[6]==a.datum_params[6]:this.datum_type==Proj4js.common.PJD_GRIDSHIFT?0==strcmp(pj_param(this.params,"snadgrids").s,
pj_param(a.params,"snadgrids").s):!0},geodetic_to_geocentric:function(a){var d=a.x,b=a.y,e=a.z?a.z:0,f,g,h;if(b<-Proj4js.common.HALF_PI&&b>-1.001*Proj4js.common.HALF_PI)b=-Proj4js.common.HALF_PI;else if(b>Proj4js.common.HALF_PI&&b<1.001*Proj4js.common.HALF_PI)b=Proj4js.common.HALF_PI;else if(b<-Proj4js.common.HALF_PI||b>Proj4js.common.HALF_PI)return Proj4js.reportError("geocent:lat out of range:"+b),null;d>Proj4js.common.PI&&(d-=2*Proj4js.common.PI);g=Math.sin(b);h=Math.cos(b);f=this.a/Math.sqrt(1-
this.es*g*g);b=(f+e)*h*Math.cos(d);d=(f+e)*h*Math.sin(d);e=(f*(1-this.es)+e)*g;a.x=b;a.y=d;a.z=e;return 0},geocentric_to_geodetic:function(a){var d,b,e,f,g,h,l,m,p,r,q=a.x;e=a.y;var u=a.z?a.z:0;d=Math.sqrt(q*q+e*e);b=Math.sqrt(q*q+e*e+u*u);if(1E-12>d/this.a){if(q=0,1E-12>b/this.a)return}else q=Math.atan2(e,q);e=u/b;f=d/b;g=1/Math.sqrt(1-this.es*(2-this.es)*f*f);l=f*(1-this.es)*g;m=e*g;r=0;do r++,h=this.a/Math.sqrt(1-this.es*m*m),b=d*l+u*m-h*(1-this.es*m*m),h=this.es*h/(h+b),g=1/Math.sqrt(1-h*(2-h)*
f*f),h=f*(1-h)*g,g*=e,p=g*l-h*m,l=h,m=g;while(1E-24<p*p&&30>r);d=Math.atan(g/Math.abs(h));a.x=q;a.y=d;a.z=b;return a},geocentric_to_geodetic_noniter:function(a){var d=a.x,b=a.y,e=a.z?a.z:0,f,g,h,l,m,d=parseFloat(d),b=parseFloat(b),e=parseFloat(e);m=!1;if(0!=d)f=Math.atan2(b,d);else if(0<b)f=Proj4js.common.HALF_PI;else if(0>b)f=-Proj4js.common.HALF_PI;else if(m=!0,f=0,0<e)g=Proj4js.common.HALF_PI;else if(0>e)g=-Proj4js.common.HALF_PI;else return;h=d*d+b*b;d=Math.sqrt(h);b=e*Proj4js.common.AD_C;h=Math.sqrt(b*
b+h);b/=h;h=d/h;b=e+this.b*this.ep2*b*b*b;l=d-this.a*this.es*h*h*h;h=Math.sqrt(b*b+l*l);b/=h;h=l/h;l=this.a/Math.sqrt(1-this.es*b*b);e=h>=Proj4js.common.COS_67P5?d/h-l:h<=-Proj4js.common.COS_67P5?d/-h-l:e/b+l*(this.es-1);0==m&&(g=Math.atan(b/h));a.x=f;a.y=g;a.z=e;return a},geocentric_to_wgs84:function(a){if(this.datum_type==Proj4js.common.PJD_3PARAM)a.x+=this.datum_params[0],a.y+=this.datum_params[1],a.z+=this.datum_params[2];else if(this.datum_type==Proj4js.common.PJD_7PARAM){var d=this.datum_params[3],
b=this.datum_params[4],e=this.datum_params[5],f=this.datum_params[6],g=f*(e*a.x+a.y-d*a.z)+this.datum_params[1],d=f*(-b*a.x+d*a.y+a.z)+this.datum_params[2];a.x=f*(a.x-e*a.y+b*a.z)+this.datum_params[0];a.y=g;a.z=d}},geocentric_from_wgs84:function(a){if(this.datum_type==Proj4js.common.PJD_3PARAM)a.x-=this.datum_params[0],a.y-=this.datum_params[1],a.z-=this.datum_params[2];else if(this.datum_type==Proj4js.common.PJD_7PARAM){var d=this.datum_params[3],b=this.datum_params[4],e=this.datum_params[5],f=this.datum_params[6],
g=(a.x-this.datum_params[0])/f,h=(a.y-this.datum_params[1])/f,f=(a.z-this.datum_params[2])/f;a.x=g+e*h-b*f;a.y=-e*g+h+d*f;a.z=b*g-d*h+f}}});
Proj4js.Point=Proj4js.Class({initialize:function(a,d,b){"object"==typeof a?(this.x=a[0],this.y=a[1],this.z=a[2]||0):"string"==typeof a&&"undefined"==typeof d?(a=a.split(","),this.x=parseFloat(a[0]),this.y=parseFloat(a[1]),this.z=parseFloat(a[2])||0):(this.x=a,this.y=d,this.z=b||0)},clone:function(){return new Proj4js.Point(this.x,this.y,this.z)},toString:function(){return"x="+this.x+",y="+this.y},toShortString:function(){return this.x+", "+this.y}});
Proj4js.PrimeMeridian={greenwich:0,lisbon:-9.131906111111,paris:2.337229166667,bogota:-74.080916666667,madrid:-3.687938888889,rome:12.452333333333,bern:7.439583333333,jakarta:106.807719444444,ferro:-17.666666666667,brussels:4.367975,stockholm:18.058277777778,athens:23.7163375,oslo:10.722916666667};
Proj4js.Ellipsoid={MERIT:{a:6378137,rf:298.257,ellipseName:"MERIT 1983"},SGS85:{a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},GRS80:{a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},IAU76:{a:6378140,rf:298.257,ellipseName:"IAU 1976"},airy:{a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},"APL4.":{a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},NWL9D:{a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},mod_airy:{a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},
andrae:{a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},aust_SA:{a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},GRS67:{a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},bessel:{a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},bess_nam:{a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},clrk66:{a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},clrk80:{a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},CPM:{a:6375738.7,rf:334.29,
ellipseName:"Comm. des Poids et Mesures 1799"},delmbr:{a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},engelis:{a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},evrst30:{a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},evrst48:{a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},evrst56:{a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},evrst69:{a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},evrstSS:{a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},
fschr60:{a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},fschr60m:{a:6378155,rf:298.3,ellipseName:"Fischer 1960"},fschr68:{a:6378150,rf:298.3,ellipseName:"Fischer 1968"},helmert:{a:6378200,rf:298.3,ellipseName:"Helmert 1906"},hough:{a:6378270,rf:297,ellipseName:"Hough"},intl:{a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},kaula:{a:6378163,rf:298.24,ellipseName:"Kaula 1961"},lerch:{a:6378139,rf:298.257,ellipseName:"Lerch 1979"},mprts:{a:6397300,rf:191,ellipseName:"Maupertius 1738"},
new_intl:{a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},plessis:{a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},krass:{a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},SEasia:{a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},walbeck:{a:6376896,b:6355834.8467,ellipseName:"Walbeck"},WGS60:{a:6378165,rf:298.3,ellipseName:"WGS 60"},WGS66:{a:6378145,rf:298.25,ellipseName:"WGS 66"},WGS72:{a:6378135,rf:298.26,ellipseName:"WGS 72"},WGS84:{a:6378137,rf:298.257223563,ellipseName:"WGS 84"},
sphere:{a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}};
Proj4js.Datum={WGS84:{towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},GGRS87:{towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},NAD83:{towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},NAD27:{nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},potsdam:{towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},carthage:{towgs84:"-263.0,6.0,431.0",
ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},hermannskogel:{towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},ire65:{towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},nzgd49:{towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},OSGB36:{towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"}};
Proj4js.WGS84=new Proj4js.Proj("WGS84");Proj4js.Datum.OSB36=Proj4js.Datum.OSGB36;Proj4js.wktProjections={"Lambert Tangential Conformal Conic Projection":"lcc",Mercator:"merc","Popular Visualisation Pseudo Mercator":"merc",Transverse_Mercator:"tmerc","Transverse Mercator":"tmerc","Lambert Azimuthal Equal Area":"laea","Universal Transverse Mercator System":"utm"};
Proj4js.Proj.aea={init:function(){Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN?Proj4js.reportError("aeaInitEqualLatitudes"):(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.con=this.t1=this.sin_po,this.ms1=Proj4js.common.msfnz(this.e3,this.sin_po,this.cos_po),this.qs1=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=
this.sin_po,this.ms2=Proj4js.common.msfnz(this.e3,this.sin_po,this.cos_po),this.qs2=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=Proj4js.common.qsfnz(this.e3,this.sin_po,this.cos_po),Math.abs(this.lat1-this.lat2)>Proj4js.common.EPSLN?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*
this.qs0)/this.ns0)},forward:function(a){var d=a.x,b=a.y;this.sin_phi=Math.sin(b);this.cos_phi=Math.cos(b);var b=Proj4js.common.qsfnz(this.e3,this.sin_phi,this.cos_phi),b=this.a*Math.sqrt(this.c-this.ns0*b)/this.ns0,e=this.ns0*Proj4js.common.adjust_lon(d-this.long0),d=b*Math.sin(e)+this.x0,b=this.rh-b*Math.cos(e)+this.y0;a.x=d;a.y=b;return a},inverse:function(a){var d,b,e;a.x-=this.x0;a.y=this.rh-a.y+this.y0;0<=this.ns0?(d=Math.sqrt(a.x*a.x+a.y*a.y),b=1):(d=-Math.sqrt(a.x*a.x+a.y*a.y),b=-1);e=0;0!=
d&&(e=Math.atan2(b*a.x,b*a.y));b=d*this.ns0/this.a;d=(this.c-b*b)/this.ns0;1E-10<=this.e3?(b=1-.5*(1-this.es)*Math.log((1-this.e3)/(1+this.e3))/this.e3,b=1E-10<Math.abs(Math.abs(b)-Math.abs(d))?this.phi1z(this.e3,d):0<=d?.5*PI:-.5*PI):b=this.phi1z(e3,d);e=Proj4js.common.adjust_lon(e/this.ns0+this.long0);a.x=e;a.y=b;return a},phi1z:function(a,d){var b,e,f=Proj4js.common.asinz(.5*d);if(a<Proj4js.common.EPSLN)return f;for(var g=a*a,h=1;25>=h;h++)if(sinphi=Math.sin(f),cosphi=Math.cos(f),b=a*sinphi,e=
1-b*b,b=.5*e*e/cosphi*(d/(1-g)-sinphi/e+.5/a*Math.log((1-b)/(1+b))),f+=b,1E-7>=Math.abs(b))return f;Proj4js.reportError("aea:phi1z:Convergence error");return null}};
Proj4js.Proj.sterea={dependsOn:"gauss",init:function(){Proj4js.Proj.gauss.init.apply(this);this.rc?(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative")):Proj4js.reportError("sterea:init:E_ERROR_0")},forward:function(a){a.x=Proj4js.common.adjust_lon(a.x-this.long0);Proj4js.Proj.gauss.forward.apply(this,[a]);sinc=Math.sin(a.y);cosc=Math.cos(a.y);cosl=Math.cos(a.x);k=this.k0*this.R2/(1+this.sinc0*sinc+this.cosc0*
cosc*cosl);a.x=k*cosc*Math.sin(a.x);a.y=k*(this.cosc0*sinc-this.sinc0*cosc*cosl);a.x=this.a*a.x+this.x0;a.y=this.a*a.y+this.y0;return a},inverse:function(a){var d,b;a.x=(a.x-this.x0)/this.a;a.y=(a.y-this.y0)/this.a;a.x/=this.k0;a.y/=this.k0;(rho=Math.sqrt(a.x*a.x+a.y*a.y))?(c=2*Math.atan2(rho,this.R2),sinc=Math.sin(c),cosc=Math.cos(c),b=Math.asin(cosc*this.sinc0+a.y*sinc*this.cosc0/rho),d=Math.atan2(a.x*sinc,rho*this.cosc0*cosc-a.y*this.sinc0*sinc)):(b=this.phic0,d=0);a.x=d;a.y=b;Proj4js.Proj.gauss.inverse.apply(this,
[a]);a.x=Proj4js.common.adjust_lon(a.x+this.long0);return a}};function phi4z(a,d,b,e,f,g,h,l,m){var p,r,q,u,w,v;m=g;for(v=1;15>=v;v++)if(p=Math.sin(m),tanphi=Math.tan(m),l=tanphi*Math.sqrt(1-a*p*p),r=Math.sin(2*m),q=d*m-b*r+e*Math.sin(4*m)-f*Math.sin(6*m),u=d-2*b*Math.cos(2*m)+4*e*Math.cos(4*m)-6*f*Math.cos(6*m),p=2*q+l*(q*q+h)-2*g*(l*q+1),w=a*r*(q*q+h-2*g*q)/(2*l),l=2*(g-q)*(l*u-2/r)-2*u,p/=w+l,m+=p,1E-10>=Math.abs(p))return m;Proj4js.reportError("phi4z: No convergence");return null}
function e4fn(a){var d;d=1+a;a=1-a;return Math.sqrt(Math.pow(d,d)*Math.pow(a,a))}
Proj4js.Proj.poly={init:function(){this.lat0=0;this.temp=this.b/this.a;this.es=1-Math.pow(this.temp,2);this.e=Math.sqrt(this.es);this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.ml0=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(a){var d,b,e,f,g;e=a.y;b=Proj4js.common.adjust_lon(a.x-this.long0);1E-7>=Math.abs(e)?(g=this.x0+this.a*b,d=this.y0-this.a*this.ml0):(d=
Math.sin(e),b=Math.cos(e),e=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,e),f=Proj4js.common.msfnz(this.e,d,b),b=d,g=this.x0+this.a*f*Math.sin(b)/d,d=this.y0+this.a*(e-this.ml0+f*(1-Math.cos(b))/d));a.x=g;a.y=d;return a},inverse:function(a){var d,b;a.x-=this.x0;a.y-=this.y0;d=this.ml0+a.y/this.a;if(1E-7>=Math.abs(d))d=a.x/this.a+this.long0,b=0;else{d=d*d+a.x/this.a*(a.x/this.a);d=phi4z(this.es,this.e0,this.e1,this.e2,this.e3,this.al,d,void 0,b);if(1!=d)return d;d=Proj4js.common.adjust_lon(Proj4js.common.asinz(NaN*
a.x/this.a)/Math.sin(b)+this.long0)}a.x=d;a.y=b;return a}};
Proj4js.Proj.equi={init:function(){this.x0||(this.x0=0);this.y0||(this.y0=0);this.lat0||(this.lat0=0);this.long0||(this.long0=0)},forward:function(a){var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0),b=this.x0+this.a*b*Math.cos(this.lat0),d=this.y0+this.a*d;this.t1=b;this.t2=Math.cos(this.lat0);a.x=b;a.y=d;return a},inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=a.y/this.a;Math.abs(d)>Proj4js.common.HALF_PI&&Proj4js.reportError("equi:Inv:DataError");var b=Proj4js.common.adjust_lon(this.long0+
a.x/(this.a*Math.cos(this.lat0)));a.x=b;a.y=d}};
Proj4js.Proj.merc={init:function(){this.lat_ts&&(this.k0=this.sphere?Math.cos(this.lat_ts):Proj4js.common.msfnz(this.es,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))},forward:function(a){var d=a.x,b=a.y;if(90<b*Proj4js.common.R2D&&-90>b*Proj4js.common.R2D&&180<d*Proj4js.common.R2D&&-180>d*Proj4js.common.R2D)return Proj4js.reportError("merc:forward: llInputOutOfRange: "+d+" : "+b),null;if(Math.abs(Math.abs(b)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN)return Proj4js.reportError("merc:forward: ll2mAtPoles"),null;
if(this.sphere)d=this.x0+this.a*this.k0*Proj4js.common.adjust_lon(d-this.long0),b=this.y0+this.a*this.k0*Math.log(Math.tan(Proj4js.common.FORTPI+.5*b));else var e=Math.sin(b),b=Proj4js.common.tsfnz(this.e,b,e),d=this.x0+this.a*this.k0*Proj4js.common.adjust_lon(d-this.long0),b=this.y0-this.a*this.k0*Math.log(b);a.x=d;a.y=b;return a},inverse:function(a){var d=a.x-this.x0,b=a.y-this.y0;if(this.sphere)b=Proj4js.common.HALF_PI-2*Math.atan(Math.exp(-b/this.a*this.k0));else if(b=Math.exp(-b/(this.a*this.k0)),
b=Proj4js.common.phi2z(this.e,b),-9999==b)return Proj4js.reportError("merc:inverse: lat = -9999"),null;d=Proj4js.common.adjust_lon(this.long0+d/(this.a*this.k0));a.x=d;a.y=b;return a}};Proj4js.Proj.utm={dependsOn:"tmerc",init:function(){this.zone?(this.lat0=0,this.long0=(6*Math.abs(this.zone)-183)*Proj4js.common.D2R,this.x0=5E5,this.y0=this.utmSouth?1E7:0,this.k0=.9996,Proj4js.Proj.tmerc.init.apply(this),this.forward=Proj4js.Proj.tmerc.forward,this.inverse=Proj4js.Proj.tmerc.inverse):Proj4js.reportError("utm:init: zone must be specified for UTM")}};
Proj4js.Proj.eqdc={init:function(){this.mode||(this.mode=0);this.temp=this.b/this.a;this.es=1-Math.pow(this.temp,2);this.e=Math.sqrt(this.es);this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.sinphi=Math.sin(this.lat1);this.cosphi=Math.cos(this.lat1);this.ms1=Proj4js.common.msfnz(this.e,this.sinphi,this.cosphi);this.ml1=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat1);0!=this.mode?
(Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN&&Proj4js.reportError("eqdc:Init:EqualLatitudes"),this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=Proj4js.common.msfnz(this.e,this.sinphi,this.cosphi),this.ml2=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat2),Math.abs(this.lat1-this.lat2)>=Proj4js.common.EPSLN?this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1):this.ns=this.sinphi):this.ns=this.sinphi;this.g=this.ml1+this.ms1/this.ns;this.ml0=Proj4js.common.mlfn(this.e0,
this.e1,this.e2,this.e3,this.lat0);this.rh=this.a*(this.g-this.ml0)},forward:function(a){var d=a.x,b=Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,a.y),b=this.a*(this.g-b),e=this.ns*Proj4js.common.adjust_lon(d-this.long0),d=this.x0+b*Math.sin(e),b=this.y0+this.rh-b*Math.cos(e);a.x=d;a.y=b;return a},inverse:function(a){a.x-=this.x0;a.y=this.rh-a.y+this.y0;var d,b;0<=this.ns?(b=Math.sqrt(a.x*a.x+a.y*a.y),d=1):(b=-Math.sqrt(a.x*a.x+a.y*a.y),d=-1);var e=0;0!=b&&(e=Math.atan2(d*a.x,d*a.y));d=this.phi3z(this.g-
b/this.a,this.e0,this.e1,this.e2,this.e3);e=Proj4js.common.adjust_lon(this.long0+e/this.ns);a.x=e;a.y=d;return a},phi3z:function(a,d,b,e,f){var g,h;g=a;for(var l=0;15>l;l++)if(h=(a+b*Math.sin(2*g)-e*Math.sin(4*g)+f*Math.sin(6*g))/d-g,g+=h,1E-10>=Math.abs(h))return g;Proj4js.reportError("PHI3Z-CONV:Latitude failed to converge after 15 iterations");return null}};
Proj4js.Proj.tmerc={init:function(){this.e0=Proj4js.common.e0fn(this.es);this.e1=Proj4js.common.e1fn(this.es);this.e2=Proj4js.common.e2fn(this.es);this.e3=Proj4js.common.e3fn(this.es);this.ml0=this.a*Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,this.lat0)},forward:function(a){var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0),e,f;e=Math.sin(d);var g=Math.cos(d);if(this.sphere){var h=g*Math.sin(b);if(1E-10>Math.abs(Math.abs(h)-1))return Proj4js.reportError("tmerc:forward: Point projects into infinity"),
93;f=.5*this.a*this.k0*Math.log((1+h)/(1-h));e=Math.acos(g*Math.cos(b)/Math.sqrt(1-h*h));0>d&&(e=-e);d=this.a*this.k0*(e-this.lat0)}else{f=g*b;var b=Math.pow(f,2),g=this.ep2*Math.pow(g,2),h=Math.tan(d),l=Math.pow(h,2);e=1-this.es*Math.pow(e,2);e=this.a/Math.sqrt(e);d=this.a*Proj4js.common.mlfn(this.e0,this.e1,this.e2,this.e3,d);f=this.k0*e*f*(1+b/6*(1-l+g+b/20*(5-18*l+Math.pow(l,2)+72*g-58*this.ep2)))+this.x0;d=this.k0*(d-this.ml0+e*h*b*(.5+b/24*(5-l+9*g+4*Math.pow(g,2)+b/30*(61-58*l+Math.pow(l,2)+
600*g-330*this.ep2))))+this.y0}a.x=f;a.y=d;return a},inverse:function(a){var d,b,e,f;if(this.sphere){b=Math.exp(a.x/(this.a*this.k0));var g=.5*(b-1/b);e=this.lat0+a.y/(this.a*this.k0);f=Math.cos(e);d=Math.sqrt((1-f*f)/(1+g*g));b=Proj4js.common.asinz(d);0>e&&(b=-b);d=0==g&&0==f?this.long0:Proj4js.common.adjust_lon(Math.atan2(g,f)+this.long0)}else{var g=a.x-this.x0,h=a.y-this.y0;b=d=(this.ml0+h/this.k0)/this.a;for(f=0;;f++){e=(d+this.e1*Math.sin(2*b)-this.e2*Math.sin(4*b)+this.e3*Math.sin(6*b))/this.e0-
b;b+=e;if(Math.abs(e)<=Proj4js.common.EPSLN)break;if(6<=f)return Proj4js.reportError("tmerc:inverse: Latitude failed to converge"),95}if(Math.abs(b)<Proj4js.common.HALF_PI){d=Math.sin(b);e=Math.cos(b);var l=Math.tan(b);f=this.ep2*Math.pow(e,2);var h=Math.pow(f,2),m=Math.pow(l,2),p=Math.pow(m,2);d=1-this.es*Math.pow(d,2);var r=this.a/Math.sqrt(d);d=r*(1-this.es)/d;var g=g/(r*this.k0),q=Math.pow(g,2);b-=r*l*q/d*(.5-q/24*(5+3*m+10*f-4*h-9*this.ep2-q/30*(61+90*m+298*f+45*p-252*this.ep2-3*h)));d=Proj4js.common.adjust_lon(this.long0+
g*(1-q/6*(1+2*m+f-q/20*(5-2*f+28*m-3*h+8*this.ep2+24*p)))/e)}else b=Proj4js.common.HALF_PI*Proj4js.common.sign(h),d=this.long0}a.x=d;a.y=b;return a}};Proj4js.defs.GOOGLE="+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs";Proj4js.defs["EPSG:900913"]=Proj4js.defs.GOOGLE;
Proj4js.Proj.gstmerc={init:function(){var a=this.b/this.a;this.e=Math.sqrt(1-a*a);this.lc=this.long0;this.rs=Math.sqrt(1+this.e*this.e*Math.pow(Math.cos(this.lat0),4)/(1-this.e*this.e));var a=Math.sin(this.lat0),d=Math.asin(a/this.rs),b=Math.sin(d);this.cp=Proj4js.common.latiso(0,d,b)-this.rs*Proj4js.common.latiso(this.e,this.lat0,a);this.n2=this.k0*this.a*Math.sqrt(1-this.e*this.e)/(1-this.e*this.e*a*a);this.xs=this.x0;this.ys=this.y0-this.n2*d;this.title||(this.title="Gauss Schreiber transverse mercator")},
forward:function(a){var d=a.y,b=this.rs*(a.x-this.lc),d=this.cp+this.rs*Proj4js.common.latiso(this.e,d,Math.sin(d)),e=Math.asin(Math.sin(b)/Proj4js.common.cosh(d)),e=Proj4js.common.latiso(0,e,Math.sin(e));a.x=this.xs+this.n2*e;a.y=this.ys+this.n2*Math.atan(Proj4js.common.sinh(d)/Math.cos(b));return a},inverse:function(a){var d=a.x,b=a.y,e=Math.atan(Proj4js.common.sinh((d-this.xs)/this.n2)/Math.cos((b-this.ys)/this.n2)),d=Math.asin(Math.sin((b-this.ys)/this.n2)/Proj4js.common.cosh((d-this.xs)/this.n2)),
d=Proj4js.common.latiso(0,d,Math.sin(d));a.x=this.lc+e/this.rs;a.y=Proj4js.common.invlatiso(this.e,(d-this.cp)/this.rs);return a}};
Proj4js.Proj.ortho={init:function(a){this.sin_p14=Math.sin(this.lat0);this.cos_p14=Math.cos(this.lat0)},forward:function(a){var d,b,e,f,g;b=a.y;e=Proj4js.common.adjust_lon(a.x-this.long0);d=Math.sin(b);b=Math.cos(b);f=Math.cos(e);g=this.sin_p14*d+this.cos_p14*b*f;if(0<g||Math.abs(g)<=Proj4js.common.EPSLN)var h=1*this.a*b*Math.sin(e),l=this.y0+1*this.a*(this.cos_p14*d-this.sin_p14*b*f);else Proj4js.reportError("orthoFwdPointError");a.x=h;a.y=l;return a},inverse:function(a){var d,b,e,f;a.x-=this.x0;
a.y-=this.y0;d=Math.sqrt(a.x*a.x+a.y*a.y);d>this.a+1E-7&&Proj4js.reportError("orthoInvDataError");b=Proj4js.common.asinz(d/this.a);e=Math.sin(b);f=Math.cos(b);b=this.long0;Math.abs(d);e=Proj4js.common.asinz(f*this.sin_p14+a.y*e*this.cos_p14/d);d=Math.abs(this.lat0)-Proj4js.common.HALF_PI;Math.abs(d)<=Proj4js.common.EPSLN&&(b=0<=this.lat0?Proj4js.common.adjust_lon(this.long0+Math.atan2(a.x,-a.y)):Proj4js.common.adjust_lon(this.long0-Math.atan2(-a.x,a.y)));Math.sin(e);a.x=b;a.y=e;return a}};
Proj4js.Proj.somerc={init:function(){var a=this.lat0;this.lambda0=this.long0;var d=Math.sin(a),b=this.a,e=1/this.rf,e=2*e-Math.pow(e,2),f=this.e=Math.sqrt(e);this.R=this.k0*b*Math.sqrt(1-e)/(1-e*Math.pow(d,2));this.alpha=Math.sqrt(1+e/(1-e)*Math.pow(Math.cos(a),4));this.b0=Math.asin(d/this.alpha);this.K=Math.log(Math.tan(Math.PI/4+this.b0/2))-this.alpha*Math.log(Math.tan(Math.PI/4+a/2))+this.alpha*f/2*Math.log((1+f*d)/(1-f*d))},forward:function(a){var d=Math.log(Math.tan(Math.PI/4-a.y/2)),b=this.e/
2*Math.log((1+this.e*Math.sin(a.y))/(1-this.e*Math.sin(a.y))),b=2*(Math.atan(Math.exp(-this.alpha*(d+b)+this.K))-Math.PI/4),e=this.alpha*(a.x-this.lambda0),d=Math.atan(Math.sin(e)/(Math.sin(this.b0)*Math.tan(b)+Math.cos(this.b0)*Math.cos(e))),b=Math.asin(Math.cos(this.b0)*Math.sin(b)-Math.sin(this.b0)*Math.cos(b)*Math.cos(e));a.y=this.R/2*Math.log((1+Math.sin(b))/(1-Math.sin(b)))+this.y0;a.x=this.R*d+this.x0;return a},inverse:function(a){for(var d=(a.x-this.x0)/this.R,b=2*(Math.atan(Math.exp((a.y-
this.y0)/this.R))-Math.PI/4),e=Math.asin(Math.cos(this.b0)*Math.sin(b)+Math.sin(this.b0)*Math.cos(b)*Math.cos(d)),d=Math.atan(Math.sin(d)/(Math.cos(this.b0)*Math.cos(d)-Math.sin(this.b0)*Math.tan(b))),d=this.lambda0+d/this.alpha,b=0,f=e,g=-1E3,h=0;1E-7<Math.abs(f-g);){if(20<++h){Proj4js.reportError("omercFwdInfinity");return}b=1/this.alpha*(Math.log(Math.tan(Math.PI/4+e/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(f))/2));g=f;f=2*Math.atan(Math.exp(b))-Math.PI/2}a.x=d;
a.y=f;return a}};
Proj4js.Proj.stere={ssfn_:function(a,d,b){d*=b;return Math.tan(.5*(Proj4js.common.HALF_PI+a))*Math.pow((1-d)/(1+d),.5*b)},TOL:1E-8,NITER:8,CONV:1E-10,S_POLE:0,N_POLE:1,OBLIQ:2,EQUIT:3,init:function(){this.phits=this.lat_ts?this.lat_ts:Proj4js.common.HALF_PI;var a=Math.abs(this.lat0);Math.abs(a)-Proj4js.common.HALF_PI<Proj4js.common.EPSLN?this.mode=0>this.lat0?this.S_POLE:this.N_POLE:this.mode=a>Proj4js.common.EPSLN?this.OBLIQ:this.EQUIT;this.phits=Math.abs(this.phits);if(this.es){var d;switch(this.mode){case this.N_POLE:case this.S_POLE:Math.abs(this.phits-
Proj4js.common.HALF_PI)<Proj4js.common.EPSLN?this.akm1=2*this.k0/Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)):(a=Math.sin(this.phits),this.akm1=Math.cos(this.phits)/Proj4js.common.tsfnz(this.e,this.phits,a),a*=this.e,this.akm1/=Math.sqrt(1-a*a));break;case this.EQUIT:this.akm1=2*this.k0;break;case this.OBLIQ:a=Math.sin(this.lat0),d=2*Math.atan(this.ssfn_(this.lat0,a,this.e))-Proj4js.common.HALF_PI,a*=this.e,this.akm1=2*this.k0*Math.cos(this.lat0)/Math.sqrt(1-a*a),this.sinX1=
Math.sin(d),this.cosX1=Math.cos(d)}}else switch(this.mode){case this.OBLIQ:this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0);case this.EQUIT:this.akm1=2*this.k0;break;case this.S_POLE:case this.N_POLE:this.akm1=Math.abs(this.phits-Proj4js.common.HALF_PI)>=Proj4js.common.EPSLN?Math.cos(this.phits)/Math.tan(Proj4js.common.FORTPI-.5*this.phits):2*this.k0}},forward:function(a){var d=a.x,d=Proj4js.common.adjust_lon(d-this.long0),b=a.y,e,f;if(this.sphere){var g,h,l;g=Math.sin(b);h=Math.cos(b);
l=Math.cos(d);d=Math.sin(d);switch(this.mode){case this.EQUIT:f=1+h*l;f<=Proj4js.common.EPSLN&&F_ERROR;f=this.akm1/f;e=f*h*d;f*=g;break;case this.OBLIQ:f=1+this.sinph0*g+this.cosph0*h*l;f<=Proj4js.common.EPSLN&&F_ERROR;f=this.akm1/f;e=f*h*d;f*=this.cosph0*g-this.sinph0*h*l;break;case this.N_POLE:l=-l,b=-b;case this.S_POLE:Math.abs(b-Proj4js.common.HALF_PI)<this.TOL&&F_ERROR,f=this.akm1*Math.tan(Proj4js.common.FORTPI+.5*b),e=d*f,f*=l}}else{l=Math.cos(d);d=Math.sin(d);g=Math.sin(b);if(this.mode==this.OBLIQ||
this.mode==this.EQUIT)X=2*Math.atan(this.ssfn_(b,g,this.e)),sinX=Math.sin(X-Proj4js.common.HALF_PI),cosX=Math.cos(X);switch(this.mode){case this.OBLIQ:A=this.akm1/(this.cosX1*(1+this.sinX1*sinX+this.cosX1*cosX*l));f=A*(this.cosX1*sinX-this.sinX1*cosX*l);e=A*cosX;break;case this.EQUIT:A=2*this.akm1/(1+cosX*l);f=A*sinX;e=A*cosX;break;case this.S_POLE:b=-b,l=-l,g=-g;case this.N_POLE:e=this.akm1*Proj4js.common.tsfnz(this.e,b,g),f=-e*l}e*=d}a.x=e*this.a+this.x0;a.y=f*this.a+this.y0;return a},inverse:function(a){var d=
(a.x-this.x0)/this.a,b=(a.y-this.y0)/this.a,e,f,g,h=e=0,l,m=g=0;if(this.sphere){h=Math.sqrt(d*d+b*b);m=2*Math.atan(h/this.akm1);g=Math.sin(m);m=Math.cos(m);e=0;switch(this.mode){case this.EQUIT:f=Math.abs(h)<=Proj4js.common.EPSLN?0:Math.asin(b*g/h);if(0!=m||0!=d)e=Math.atan2(d*g,m*h);break;case this.OBLIQ:f=Math.abs(h)<=Proj4js.common.EPSLN?this.phi0:Math.asin(m*sinph0+b*g*cosph0/h);m-=sinph0*Math.sin(f);if(0!=m||0!=d)e=Math.atan2(d*g*cosph0,m*h);break;case this.N_POLE:b=-b;case this.S_POLE:f=Math.abs(h)<=
Proj4js.common.EPSLN?this.phi0:Math.asin(this.mode==this.S_POLE?-m:m),e=0==d&&0==b?0:Math.atan2(d,b)}a.x=Proj4js.common.adjust_lon(e+this.long0);a.y=f}else{l=Math.sqrt(d*d+b*b);switch(this.mode){case this.OBLIQ:case this.EQUIT:e=2*Math.atan2(l*this.cosX1,this.akm1);g=Math.cos(e);f=Math.sin(e);h=0==l?Math.asin(g*this.sinX1):Math.asin(g*this.sinX1+b*f*this.cosX1/l);e=Math.tan(.5*(Proj4js.common.HALF_PI+h));d*=f;b=l*this.cosX1*g-b*this.sinX1*f;m=Proj4js.common.HALF_PI;g=.5*this.e;break;case this.N_POLE:b=
-b;case this.S_POLE:e=-l/this.akm1,h=Proj4js.common.HALF_PI-2*Math.atan(e),m=-Proj4js.common.HALF_PI,g=-.5*this.e}for(l=this.NITER;l--;h=f)if(f=this.e*Math.sin(h),f=2*Math.atan(e*Math.pow((1+f)/(1-f),g))-m,Math.abs(h-f)<this.CONV)return this.mode==this.S_POLE&&(f=-f),e=0==d&&0==b?0:Math.atan2(d,b),a.x=Proj4js.common.adjust_lon(e+this.long0),a.y=f,a}}};
Proj4js.Proj.nzmg={iterations:1,init:function(){this.A=[];this.A[1]=.6399175073;this.A[2]=-.1358797613;this.A[3]=.063294409;this.A[4]=-.02526853;this.A[5]=.0117879;this.A[6]=-.0055161;this.A[7]=.0026906;this.A[8]=-.001333;this.A[9]=6.7E-4;this.A[10]=-3.4E-4;this.B_re=[];this.B_im=[];this.B_re[1]=.7557853228;this.B_im[1]=0;this.B_re[2]=.249204646;this.B_im[2]=.003371507;this.B_re[3]=-.001541739;this.B_im[3]=.04105856;this.B_re[4]=-.10162907;this.B_im[4]=.01727609;this.B_re[5]=-.26623489;this.B_im[5]=
-.36249218;this.B_re[6]=-.6870983;this.B_im[6]=-1.1651967;this.C_re=[];this.C_im=[];this.C_re[1]=1.3231270439;this.C_im[1]=0;this.C_re[2]=-.577245789;this.C_im[2]=-.007809598;this.C_re[3]=.508307513;this.C_im[3]=-.112208952;this.C_re[4]=-.15094762;this.C_im[4]=.18200602;this.C_re[5]=1.01418179;this.C_im[5]=1.64497696;this.C_re[6]=1.9660549;this.C_im[6]=2.5127645;this.D=[];this.D[1]=1.5627014243;this.D[2]=.5185406398;this.D[3]=-.03333098;this.D[4]=-.1052906;this.D[5]=-.0368594;this.D[6]=.007317;this.D[7]=
.0122;this.D[8]=.00394;this.D[9]=-.0013},forward:function(a){var d=(a.y-this.lat0)/Proj4js.common.SEC_TO_RAD*1E-5,b=a.x-this.long0,e=1,f=0;for(n=1;10>=n;n++)e*=d,f+=this.A[n]*e;var d=f,e=1,g=0,h=0,l=0;for(n=1;6>=n;n++)f=e*d-g*b,g=g*d+e*b,e=f,h=h+this.B_re[n]*e-this.B_im[n]*g,l=l+this.B_im[n]*e+this.B_re[n]*g;x=l*this.a+this.x0;y=h*this.a+this.y0;a.x=x;a.y=y;return a},inverse:function(a){var d=(a.y-this.y0)/this.a,b=(a.x-this.x0)/this.a,e=1,f=0,g,h=0,l=0;for(n=1;6>=n;n++)g=e*d-f*b,f=f*d+e*b,e=g,h=
h+this.C_re[n]*e-this.C_im[n]*f,l=l+this.C_im[n]*e+this.C_re[n]*f;for(i=0;i<this.iterations;i++){var m=h,p=l,r,e=d;g=b;for(n=2;6>=n;n++)r=m*h-p*l,p=p*h+m*l,m=r,e+=(n-1)*(this.B_re[n]*m-this.B_im[n]*p),g+=(n-1)*(this.B_im[n]*m+this.B_re[n]*p);var m=1,p=0,f=this.B_re[1],q=this.B_im[1];for(n=2;6>=n;n++)r=m*h-p*l,p=p*h+m*l,m=r,f+=n*(this.B_re[n]*m-this.B_im[n]*p),q+=n*(this.B_im[n]*m+this.B_re[n]*p);l=f*f+q*q;h=(e*f+g*q)/l;l=(g*f-e*q)/l}d=h;b=1;h=0;for(n=1;9>=n;n++)b*=d,h+=this.D[n]*b;d=this.lat0+h*Proj4js.common.SEC_TO_RAD*
1E5;a.x=this.long0+l;a.y=d;return a}};Proj4js.Proj.mill={init:function(){},forward:function(a){var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0),b=this.x0+this.a*b,d=this.y0+this.a*Math.log(Math.tan(Proj4js.common.PI/4+d/2.5))*1.25;a.x=b;a.y=d;return a},inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=Proj4js.common.adjust_lon(this.long0+a.x/this.a),b=2.5*(Math.atan(Math.exp(.8*a.y/this.a))-Proj4js.common.PI/4);a.x=d;a.y=b;return a}};
Proj4js.Proj.gnom={init:function(a){this.sin_p14=Math.sin(this.lat0);this.cos_p14=Math.cos(this.lat0);this.infinity_dist=1E3*this.a;this.rc=1},forward:function(a){var d,b,e,f,g;b=a.y;e=Proj4js.common.adjust_lon(a.x-this.long0);d=Math.sin(b);b=Math.cos(b);f=Math.cos(e);g=this.sin_p14*d+this.cos_p14*b*f;0<g||Math.abs(g)<=Proj4js.common.EPSLN?(x=this.x0+1*this.a*b*Math.sin(e)/g,y=this.y0+1*this.a*(this.cos_p14*d-this.sin_p14*b*f)/g):(Proj4js.reportError("orthoFwdPointError"),x=this.x0+this.infinity_dist*
b*Math.sin(e),y=this.y0+this.infinity_dist*(this.cos_p14*d-this.sin_p14*b*f));a.x=x;a.y=y;return a},inverse:function(a){var d,b,e,f;a.x=(a.x-this.x0)/this.a;a.y=(a.y-this.y0)/this.a;a.x/=this.k0;a.y/=this.k0;(d=Math.sqrt(a.x*a.x+a.y*a.y))?(f=Math.atan2(d,this.rc),b=Math.sin(f),e=Math.cos(f),f=Proj4js.common.asinz(e*this.sin_p14+a.y*b*this.cos_p14/d),d=Math.atan2(a.x*b,d*this.cos_p14*e-a.y*this.sin_p14*b),d=Proj4js.common.adjust_lon(this.long0+d)):(f=this.phic0,d=0);a.x=d;a.y=f;return a}};
Proj4js.Proj.sinu={init:function(){this.R=6370997},forward:function(a){var d,b;b=a.y;d=Proj4js.common.adjust_lon(a.x-this.long0);d=this.R*d*Math.cos(b)+this.x0;b=this.R*b+this.y0;a.x=d;a.y=b;return a},inverse:function(a){var d,b;a.x-=this.x0;a.y-=this.y0;d=a.y/this.R;Math.abs(d)>Proj4js.common.HALF_PI&&Proj4js.reportError("sinu:Inv:DataError");b=Math.abs(d)-Proj4js.common.HALF_PI;Math.abs(b)>Proj4js.common.EPSLN?(b=this.long0+a.x/(this.R*Math.cos(d)),b=Proj4js.common.adjust_lon(b)):b=this.long0;a.x=
b;a.y=d;return a}};
Proj4js.Proj.vandg={init:function(){this.R=6370997},forward:function(a){var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0);Math.abs(d);var e=Proj4js.common.asinz(2*Math.abs(d/Proj4js.common.PI));(Math.abs(b)<=Proj4js.common.EPSLN||Math.abs(Math.abs(d)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN)&&Math.tan(.5*e);var f=.5*Math.abs(Proj4js.common.PI/b-b/Proj4js.common.PI),g=f*f,h=Math.sin(e),e=Math.cos(e),e=e/(h+e-1),h=e*(2/h-1),h=h*h,g=Proj4js.common.PI*this.R*(f*(e-h)+Math.sqrt(g*(e-h)*(e-h)-
(h+g)*(e*e-h)))/(h+g);0>b&&(g=-g);b=this.x0+g;g=Math.abs(g/(Proj4js.common.PI*this.R));d=0<=d?this.y0+Proj4js.common.PI*this.R*Math.sqrt(1-g*g-2*f*g):this.y0-Proj4js.common.PI*this.R*Math.sqrt(1-g*g-2*f*g);a.x=b;a.y=d;return a},inverse:function(a){var d,b,e,f,g,h,l,m;a.x-=this.x0;a.y-=this.y0;m=Proj4js.common.PI*this.R;d=a.x/m;b=a.y/m;e=d*d+b*b;f=-Math.abs(b)*(1+e);g=f-2*b*b+d*d;h=-2*f+1+2*b*b+e*e;m=b*b/h+(2*g*g*g/h/h/h-9*f*g/h/h)/27;l=(f-g*g/3/h)/h;f=2*Math.sqrt(-l/3);m=3*m/l/f;1<Math.abs(m)&&(m=
0<=m?1:-1);m=Math.acos(m)/3;lat=0<=a.y?(-f*Math.cos(m+Proj4js.common.PI/3)-g/3/h)*Proj4js.common.PI:-(-f*Math.cos(m+Proj4js.common.PI/3)-g/3/h)*Proj4js.common.PI;Math.abs(d)<Proj4js.common.EPSLN&&(lon=this.long0);lon=Proj4js.common.adjust_lon(this.long0+Proj4js.common.PI*(e-1+Math.sqrt(1+2*(d*d-b*b)+e*e))/2/d);a.x=lon;a.y=lat;return a}};
Proj4js.Proj.cea={init:function(){},forward:function(a){var d=a.y;dlon=Proj4js.common.adjust_lon(a.x-this.long0);var b=this.x0+this.a*dlon*Math.cos(this.lat_ts),d=this.y0+this.a*Math.sin(d)/Math.cos(this.lat_ts);a.x=b;a.y=d;return a},inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=Proj4js.common.adjust_lon(this.long0+a.x/this.a/Math.cos(this.lat_ts)),b=Math.asin(a.y/this.a*Math.cos(this.lat_ts));a.x=d;a.y=b;return a}};
Proj4js.Proj.eqc={init:function(){this.x0||(this.x0=0);this.y0||(this.y0=0);this.lat0||(this.lat0=0);this.long0||(this.long0=0);this.lat_ts||(this.lat_ts=0);this.title||(this.title="Equidistant Cylindrical (Plate Carre)");this.rc=Math.cos(this.lat_ts)},forward:function(a){var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0),d=Proj4js.common.adjust_lat(d-this.lat0);a.x=this.x0+this.a*b*this.rc;a.y=this.y0+this.a*d;return a},inverse:function(a){var d=a.y;a.x=Proj4js.common.adjust_lon(this.long0+(a.x-
this.x0)/(this.a*this.rc));a.y=Proj4js.common.adjust_lat(this.lat0+(d-this.y0)/this.a);return a}};
Proj4js.Proj.cass={init:function(){this.sphere||(this.en=this.pj_enfn(this.es),this.m0=this.pj_mlfn(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))},C1:.16666666666666666,C2:.008333333333333333,C3:.041666666666666664,C4:.3333333333333333,C5:.06666666666666667,forward:function(a){var d,b,e=a.x,f=a.y,e=Proj4js.common.adjust_lon(e-this.long0);this.sphere?(d=Math.asin(Math.cos(f)*Math.sin(e)),b=Math.atan2(Math.tan(f),Math.cos(e))-this.phi0):(this.n=Math.sin(f),this.c=Math.cos(f),b=this.pj_mlfn(f,
this.n,this.c,this.en),this.n=1/Math.sqrt(1-this.es*this.n*this.n),this.tn=Math.tan(f),this.t=this.tn*this.tn,this.a1=e*this.c,this.c*=this.es*this.c/(1-this.es),this.a2=this.a1*this.a1,d=this.n*this.a1*(1-this.a2*this.t*(this.C1-(8-this.t+8*this.c)*this.a2*this.C2)),b-=this.m0-this.n*this.tn*this.a2*(.5+(5-this.t+6*this.c)*this.a2*this.C3));a.x=this.a*d+this.x0;a.y=this.a*b+this.y0;return a},inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=a.x/this.a,b=a.y/this.a;this.sphere?(this.dd=b+this.lat0,
phi=Math.asin(Math.sin(this.dd)*Math.cos(d)),lam=Math.atan2(Math.tan(d),Math.cos(this.dd))):(ph1=this.pj_inv_mlfn(this.m0+b,this.es,this.en),this.tn=Math.tan(ph1),this.t=this.tn*this.tn,this.n=Math.sin(ph1),this.r=1/(1-this.es*this.n*this.n),this.n=Math.sqrt(this.r),this.r=this.r*(1-this.es)*this.n,this.dd=d/this.n,this.d2=this.dd*this.dd,phi=ph1-this.n*this.tn/this.r*this.d2*(.5-(1+3*this.t)*this.d2*this.C3),lam=this.dd*(1+this.t*this.d2*(-this.C4+(1+3*this.t)*this.d2*this.C5))/Math.cos(ph1));a.x=
Proj4js.common.adjust_lon(this.long0+lam);a.y=phi;return a},pj_enfn:function(a){en=[];en[0]=this.C00-a*(this.C02+a*(this.C04+a*(this.C06+a*this.C08)));en[1]=a*(this.C22-a*(this.C04+a*(this.C06+a*this.C08)));var d=a*a;en[2]=d*(this.C44-a*(this.C46+a*this.C48));d*=a;en[3]=d*(this.C66-a*this.C68);en[4]=d*a*this.C88;return en},pj_mlfn:function(a,d,b,e){b*=d;d*=d;return e[0]*a-b*(e[1]+d*(e[2]+d*(e[3]+d*e[4])))},pj_inv_mlfn:function(a,d,b){k=1/(1-d);phi=a;for(i=Proj4js.common.MAX_ITER;i;--i)if(s=Math.sin(phi),
t=1-d*s*s,t=(this.pj_mlfn(phi,s,Math.cos(phi),b)-a)*t*Math.sqrt(t)*k,phi-=t,Math.abs(t)<Proj4js.common.EPSLN)return phi;Proj4js.reportError("cass:pj_inv_mlfn: Convergence error");return phi},C00:1,C02:.25,C04:.046875,C06:.01953125,C08:.01068115234375,C22:.75,C44:.46875,C46:.013020833333333334,C48:.007120768229166667,C66:.3645833333333333,C68:.005696614583333333,C88:.3076171875};
Proj4js.Proj.gauss={init:function(){sphi=Math.sin(this.lat0);cphi=Math.cos(this.lat0);cphi*=cphi;this.rc=Math.sqrt(1-this.es)/(1-this.es*sphi*sphi);this.C=Math.sqrt(1+this.es*cphi*cphi/(1-this.es));this.phic0=Math.asin(sphi/this.C);this.ratexp=.5*this.C*this.e;this.K=Math.tan(.5*this.phic0+Proj4js.common.FORTPI)/(Math.pow(Math.tan(.5*this.lat0+Proj4js.common.FORTPI),this.C)*Proj4js.common.srat(this.e*sphi,this.ratexp))},forward:function(a){var d=a.x,b=a.y;a.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*
b+Proj4js.common.FORTPI),this.C)*Proj4js.common.srat(this.e*Math.sin(b),this.ratexp))-Proj4js.common.HALF_PI;a.x=this.C*d;return a},inverse:function(a){var d=a.x/this.C,b=a.y;num=Math.pow(Math.tan(.5*b+Proj4js.common.FORTPI)/this.K,1/this.C);for(var e=Proj4js.common.MAX_ITER;0<e;--e){b=2*Math.atan(num*Proj4js.common.srat(this.e*Math.sin(a.y),-.5*this.e))-Proj4js.common.HALF_PI;if(1E-14>Math.abs(b-a.y))break;a.y=b}if(!e)return Proj4js.reportError("gauss:inverse:convergence failed"),null;a.x=d;a.y=
b;return a}};
Proj4js.Proj.omerc={init:function(){this.mode||(this.mode=0);this.lon1||(this.lon1=0,this.mode=1);this.lon2||(this.lon2=0);this.lat2||(this.lat2=0);var a=1-Math.pow(this.b/this.a,2);Math.sqrt(a);this.sin_p20=Math.sin(this.lat0);this.cos_p20=Math.cos(this.lat0);this.con=1-this.es*this.sin_p20*this.sin_p20;this.com=Math.sqrt(1-a);this.bl=Math.sqrt(1+this.es*Math.pow(this.cos_p20,4)/(1-a));this.al=this.a*this.bl*this.k0*this.com/this.con;Math.abs(this.lat0)<Proj4js.common.EPSLN?this.el=this.d=this.ts=
1:(this.ts=Proj4js.common.tsfnz(this.e,this.lat0,this.sin_p20),this.con=Math.sqrt(this.con),this.d=this.bl*this.com/(this.cos_p20*this.con),this.f=0<this.d*this.d-1?0<=this.lat0?this.d+Math.sqrt(this.d*this.d-1):this.d-Math.sqrt(this.d*this.d-1):this.d,this.el=this.f*Math.pow(this.ts,this.bl));0!=this.mode?(this.g=.5*(this.f-1/this.f),this.gama=Proj4js.common.asinz(Math.sin(this.alpha)/this.d),this.longc-=Proj4js.common.asinz(this.g*Math.tan(this.gama))/this.bl,this.con=Math.abs(this.lat0),this.con>
Proj4js.common.EPSLN&&Math.abs(this.con-Proj4js.common.HALF_PI)>Proj4js.common.EPSLN?(this.singam=Math.sin(this.gama),this.cosgam=Math.cos(this.gama),this.sinaz=Math.sin(this.alpha),this.cosaz=Math.cos(this.alpha),this.u=0<=this.lat0?this.al/this.bl*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz):-(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz)):Proj4js.reportError("omerc:Init:DataError")):(this.sinphi=Math.sin(this.at1),this.ts1=Proj4js.common.tsfnz(this.e,this.lat1,this.sinphi),
this.sinphi=Math.sin(this.lat2),this.ts2=Proj4js.common.tsfnz(this.e,this.lat2,this.sinphi),this.h=Math.pow(this.ts1,this.bl),this.l=Math.pow(this.ts2,this.bl),this.f=this.el/this.h,this.g=.5*(this.f-1/this.f),this.j=(this.el*this.el-this.l*this.h)/(this.el*this.el+this.l*this.h),this.p=(this.l-this.h)/(this.l+this.h),this.dlon=this.lon1-this.lon2,this.dlon<-Proj4js.common.PI&&(this.lon2-=2*Proj4js.common.PI),this.dlon>Proj4js.common.PI&&(this.lon2+=2*Proj4js.common.PI),this.dlon=this.lon1-this.lon2,
this.longc=.5*(this.lon1+this.lon2)-Math.atan(this.j*Math.tan(.5*this.bl*this.dlon)/this.p)/this.bl,this.dlon=Proj4js.common.adjust_lon(this.lon1-this.longc),this.gama=Math.atan(Math.sin(this.bl*this.dlon)/this.g),this.alpha=Proj4js.common.asinz(this.d*Math.sin(this.gama)),Math.abs(this.lat1-this.lat2)<=Proj4js.common.EPSLN?Proj4js.reportError("omercInitDataError"):this.con=Math.abs(this.lat1),this.con<=Proj4js.common.EPSLN||Math.abs(this.con-HALF_PI)<=Proj4js.common.EPSLN?Proj4js.reportError("omercInitDataError"):
Math.abs(Math.abs(this.lat0)-Proj4js.common.HALF_PI)<=Proj4js.common.EPSLN&&Proj4js.reportError("omercInitDataError"),this.singam=Math.sin(this.gam),this.cosgam=Math.cos(this.gam),this.sinaz=Math.sin(this.alpha),this.cosaz=Math.cos(this.alpha),this.u=0<=this.lat0?this.al/this.bl*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz):-(this.al/this.bl)*Math.atan(Math.sqrt(this.d*this.d-1)/this.cosaz))},forward:function(a){var d,b,e,f,g;e=a.x;b=a.y;d=Math.sin(b);f=Proj4js.common.adjust_lon(e-this.longc);
e=Math.sin(this.bl*f);Math.abs(Math.abs(b)-Proj4js.common.HALF_PI)>Proj4js.common.EPSLN?(d=Proj4js.common.tsfnz(this.e,b,d),d=this.el/Math.pow(d,this.bl),g=.5*(d-1/d),d=(g*this.singam-e*this.cosgam)/(.5*(d+1/d)),b=Math.cos(this.bl*f),1E-7>Math.abs(b)?e=this.al*this.bl*f:(e=this.al*Math.atan((g*this.cosgam+e*this.singam)/b)/this.bl,0>b&&(e+=Proj4js.common.PI*this.al/this.bl))):(d=0<=b?this.singam:-this.singam,e=this.al*b/this.bl);Math.abs(Math.abs(d)-1)<=Proj4js.common.EPSLN&&Proj4js.reportError("omercFwdInfinity");
f=.5*this.al*Math.log((1-d)/(1+d))/this.bl;e-=this.u;d=this.y0+e*this.cosaz-f*this.sinaz;a.x=this.x0+f*this.cosaz+e*this.sinaz;a.y=d;return a},inverse:function(a){var d,b,e,f;a.x-=this.x0;a.y-=this.y0;d=a.x*this.cosaz-a.y*this.sinaz;e=a.y*this.cosaz+a.x*this.sinaz;e+=this.u;b=Math.exp(-this.bl*d/this.al);d=.5*(b-1/b);b=.5*(b+1/b);e=Math.sin(this.bl*e/this.al);f=(e*this.cosgam+d*this.singam)/b;Math.abs(Math.abs(f)-1)<=Proj4js.common.EPSLN?(lon=this.longc,lat=0<=f?Proj4js.common.HALF_PI:-Proj4js.common.HALF_PI):
(b=1/this.bl,f=Math.pow(this.el/Math.sqrt((1+f)/(1-f)),b),lat=Proj4js.common.phi2z(this.e,f),d=this.longc-Math.atan2(d*this.cosgam-e*this.singam,b)/this.bl,lon=Proj4js.common.adjust_lon(d));a.x=lon;a.y=lat;return a}};
Proj4js.Proj.lcc={init:function(){this.lat2||(this.lat2=this.lat0);this.k0||(this.k0=1);if(Math.abs(this.lat1+this.lat2)<Proj4js.common.EPSLN)Proj4js.reportError("lcc:init: Equal Latitudes");else{var a=this.b/this.a;this.e=Math.sqrt(1-a*a);var a=Math.sin(this.lat1),d=Math.cos(this.lat1),d=Proj4js.common.msfnz(this.e,a,d),b=Proj4js.common.tsfnz(this.e,this.lat1,a),e=Math.sin(this.lat2),f=Math.cos(this.lat2),f=Proj4js.common.msfnz(this.e,e,f),e=Proj4js.common.tsfnz(this.e,this.lat2,e),g=Proj4js.common.tsfnz(this.e,
this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>Proj4js.common.EPSLN?this.ns=Math.log(d/f)/Math.log(b/e):this.ns=a;this.f0=d/(this.ns*Math.pow(b,this.ns));this.rh=this.a*this.f0*Math.pow(g,this.ns);this.title||(this.title="Lambert Conformal Conic")}},forward:function(a){var d=a.x,b=a.y;if(!(90>=b&&-90<=b&&180>=d&&-180<=d))return Proj4js.reportError("lcc:forward: llInputOutOfRange: "+d+" : "+b),null;var e=Math.abs(Math.abs(b)-Proj4js.common.HALF_PI);if(e>Proj4js.common.EPSLN)b=Proj4js.common.tsfnz(this.e,
b,Math.sin(b)),b=this.a*this.f0*Math.pow(b,this.ns);else{e=b*this.ns;if(0>=e)return Proj4js.reportError("lcc:forward: No Projection"),null;b=0}d=this.ns*Proj4js.common.adjust_lon(d-this.long0);a.x=this.k0*b*Math.sin(d)+this.x0;a.y=this.k0*(this.rh-b*Math.cos(d))+this.y0;return a},inverse:function(a){var d,b,e,f=(a.x-this.x0)/this.k0,g=this.rh-(a.y-this.y0)/this.k0;0<this.ns?(d=Math.sqrt(f*f+g*g),b=1):(d=-Math.sqrt(f*f+g*g),b=-1);e=0;0!=d&&(e=Math.atan2(b*f,b*g));if(0!=d||0<this.ns){if(b=1/this.ns,
d=Math.pow(d/(this.a*this.f0),b),d=Proj4js.common.phi2z(this.e,d),-9999==d)return null}else d=-Proj4js.common.HALF_PI;e=Proj4js.common.adjust_lon(e/this.ns+this.long0);a.x=e;a.y=d;return a}};
Proj4js.Proj.laea={S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4,init:function(){var a=Math.abs(this.lat0);Math.abs(a-Proj4js.common.HALF_PI)<Proj4js.common.EPSLN?this.mode=0>this.lat0?this.S_POLE:this.N_POLE:Math.abs(a)<Proj4js.common.EPSLN?this.mode=this.EQUIT:this.mode=this.OBLIQ;if(0<this.es)switch(this.qp=Proj4js.common.qsfnz(this.e,1),this.mmf=.5/(1-this.es),this.apa=this.authset(this.es),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp);this.dd=
1/this.rq;this.xmf=1;this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),a=Math.sin(this.lat0),this.sinb1=Proj4js.common.qsfnz(this.e,a)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*a*a)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}else this.mode==this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))},forward:function(a){var d,b,e=a.x,f=a.y,e=Proj4js.common.adjust_lon(e-
this.long0);if(this.sphere){var g,h,l;l=Math.sin(f);h=Math.cos(f);g=Math.cos(e);switch(this.mode){case this.OBLIQ:case this.EQUIT:b=this.mode==this.EQUIT?1+h*g:1+this.sinph0*l+this.cosph0*h*g;if(b<=Proj4js.common.EPSLN)return Proj4js.reportError("laea:fwd:y less than eps"),null;b=Math.sqrt(2/b);d=b*h*Math.sin(e);b*=this.mode==this.EQUIT?l:this.cosph0*l-this.sinph0*h*g;break;case this.N_POLE:g=-g;case this.S_POLE:if(Math.abs(f+this.phi0)<Proj4js.common.EPSLN)return Proj4js.reportError("laea:fwd:phi < eps"),
null;b=Proj4js.common.FORTPI-.5*f;b=2*(this.mode==this.S_POLE?Math.cos(b):Math.sin(b));d=b*Math.sin(e);b*=g}}else{var m=h=0,p=0;g=Math.cos(e);e=Math.sin(e);l=Math.sin(f);l=Proj4js.common.qsfnz(this.e,l);if(this.mode==this.OBLIQ||this.mode==this.EQUIT)h=l/this.qp,m=Math.sqrt(1-h*h);switch(this.mode){case this.OBLIQ:p=1+this.sinb1*h+this.cosb1*m*g;break;case this.EQUIT:p=1+m*g;break;case this.N_POLE:p=Proj4js.common.HALF_PI+f;l=this.qp-l;break;case this.S_POLE:p=f-Proj4js.common.HALF_PI,l=this.qp+l}if(Math.abs(p)<
Proj4js.common.EPSLN)return Proj4js.reportError("laea:fwd:b < eps"),null;switch(this.mode){case this.OBLIQ:case this.EQUIT:p=Math.sqrt(2/p);b=this.mode==this.OBLIQ?this.ymf*p*(this.cosb1*h-this.sinb1*m*g):(p=Math.sqrt(2/(1+m*g)))*h*this.ymf;d=this.xmf*p*m*e;break;case this.N_POLE:case this.S_POLE:0<=l?(d=(p=Math.sqrt(l))*e,b=g*(this.mode==this.S_POLE?p:-p)):d=b=0}}a.x=this.a*d+this.x0;a.y=this.a*b+this.y0;return a},inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=a.x/this.a,b=a.y/this.a;if(this.sphere){var e=
0,f,g=0;f=Math.sqrt(d*d+b*b);var h=.5*f;if(1<h)return Proj4js.reportError("laea:Inv:DataError"),null;h=2*Math.asin(h);if(this.mode==this.OBLIQ||this.mode==this.EQUIT)g=Math.sin(h),e=Math.cos(h);switch(this.mode){case this.EQUIT:h=Math.abs(f)<=Proj4js.common.EPSLN?0:Math.asin(b*g/f);d*=g;b=e*f;break;case this.OBLIQ:h=Math.abs(f)<=Proj4js.common.EPSLN?this.phi0:Math.asin(e*sinph0+b*g*cosph0/f);d=d*g*cosph0;b=(e-Math.sin(h)*sinph0)*f;break;case this.N_POLE:b=-b;h=Proj4js.common.HALF_PI-h;break;case this.S_POLE:h-=
Proj4js.common.HALF_PI}lam=0!=b||this.mode!=this.EQUIT&&this.mode!=this.OBLIQ?Math.atan2(d,b):0}else{h=0;switch(this.mode){case this.EQUIT:case this.OBLIQ:d/=this.dd;b*=this.dd;g=Math.sqrt(d*d+b*b);if(g<Proj4js.common.EPSLN)return a.x=0,a.y=this.phi0,a;f=2*Math.asin(.5*g/this.rq);e=Math.cos(f);d*=f=Math.sin(f);this.mode==this.OBLIQ?(h=e*this.sinb1+b*f*this.cosb1/g,b=g*this.cosb1*e-b*this.sinb1*f):(h=b*f/g,b=g*e);break;case this.N_POLE:b=-b;case this.S_POLE:e=d*d+b*b;if(!e)return a.x=0,a.y=this.phi0,
a;h=1-e/this.qp;this.mode==this.S_POLE&&(h=-h)}lam=Math.atan2(d,b);h=this.authlat(Math.asin(h),this.apa)}a.x=Proj4js.common.adjust_lon(this.long0+lam);a.y=h;return a},P00:.3333333333333333,P01:.17222222222222222,P02:.10257936507936508,P10:.06388888888888888,P11:.0664021164021164,P20:.016415012942191543,authset:function(a){var d,b=[];b[0]=a*this.P00;d=a*a;b[0]+=d*this.P01;b[1]=d*this.P10;d*=a;b[0]+=d*this.P02;b[1]+=d*this.P11;b[2]=d*this.P20;return b},authlat:function(a,d){var b=a+a;return a+d[0]*
Math.sin(b)+d[1]*Math.sin(b+b)+d[2]*Math.sin(b+b+b)}};
Proj4js.Proj.aeqd={init:function(){this.sin_p12=Math.sin(this.lat0);this.cos_p12=Math.cos(this.lat0)},forward:function(a){var d=a.x,b,e=Math.sin(a.y),f=Math.cos(a.y),d=Proj4js.common.adjust_lon(d-this.long0),g=Math.cos(d),h=this.sin_p12*e+this.cos_p12*f*g;if(Math.abs(Math.abs(h)-1)<Proj4js.common.EPSLN){if(b=1,0>h){Proj4js.reportError("aeqd:Fwd:PointError");return}}else b=Math.acos(h),b/=Math.sin(b);a.x=this.x0+this.a*b*f*Math.sin(d);a.y=this.y0+this.a*b*(this.cos_p12*e-this.sin_p12*f*g);return a},
inverse:function(a){a.x-=this.x0;a.y-=this.y0;var d=Math.sqrt(a.x*a.x+a.y*a.y);if(d>2*Proj4js.common.HALF_PI*this.a)Proj4js.reportError("aeqdInvDataError");else{var b=d/this.a,e=Math.sin(b),b=Math.cos(b),f=this.long0,g;if(Math.abs(d)<=Proj4js.common.EPSLN)g=this.lat0;else{g=Proj4js.common.asinz(b*this.sin_p12+a.y*e*this.cos_p12/d);var h=Math.abs(this.lat0)-Proj4js.common.HALF_PI;Math.abs(h)<=Proj4js.common.EPSLN?f=0<=lat0?Proj4js.common.adjust_lon(this.long0+Math.atan2(a.x,-a.y)):Proj4js.common.adjust_lon(this.long0-
Math.atan2(-a.x,a.y)):(h=b-this.sin_p12*Math.sin(g),Math.abs(h)<Proj4js.common.EPSLN&&Math.abs(a.x)<Proj4js.common.EPSLN||(Math.atan2(a.x*e*this.cos_p12,h*d),f=Proj4js.common.adjust_lon(this.long0+Math.atan2(a.x*e*this.cos_p12,h*d))))}a.x=f;a.y=g;return a}}};
Proj4js.Proj.moll={init:function(){},forward:function(a){for(var d=a.y,b=Proj4js.common.adjust_lon(a.x-this.long0),e=d,f=Proj4js.common.PI*Math.sin(d),g=0;;g++){var h=-(e+Math.sin(e)-f)/(1+Math.cos(e)),e=e+h;if(Math.abs(h)<Proj4js.common.EPSLN)break;50<=g&&Proj4js.reportError("moll:Fwd:IterationError")}e/=2;Proj4js.common.PI/2-Math.abs(d)<Proj4js.common.EPSLN&&(b=0);d=.900316316158*this.a*b*Math.cos(e)+this.x0;e=1.4142135623731*this.a*Math.sin(e)+this.y0;a.x=d;a.y=e;return a},inverse:function(a){var d;
a.x-=this.x0;d=a.y/(1.4142135623731*this.a);.999999999999<Math.abs(d)&&(d=.999999999999);d=Math.asin(d);var b=Proj4js.common.adjust_lon(this.long0+a.x/(.900316316158*this.a*Math.cos(d)));b<-Proj4js.common.PI&&(b=-Proj4js.common.PI);b>Proj4js.common.PI&&(b=Proj4js.common.PI);d=(2*d+Math.sin(2*d))/Proj4js.common.PI;1<Math.abs(d)&&(d=1);d=Math.asin(d);a.x=b;a.y=d;return a}};