<?php
/**
 * Zikula Application Framework
 * @copyright (c) 2001, Zikula Development Team
 * @link http://www.zikula.org
 * @version $Id: pnadmin.php 27274 2009-10-30 13:49:20Z mateo $
 * @license GNU/GPL - http://www.gnu.org/copyleft/gpl.html
 * @package      Zikula_System_Modules
 * @subpackage   AuthPN
 * @author       Mark West
 */

/**
 * the main administration function
 *
 * This function is the default function, and is called whenever the
 * module is called without defining arguments.
 * As such it can be used for a number of things, but most commonly
 * it either just shows the module menu and returns or calls whatever
 * the module designer feels should be the default function (often this
 * is the view() function)
 *
 * @author       The Zikula Development Team
 * @return       output       The main module admin page.
 */
function AuthPN_admin_main()
{
    // Security check
    if (!SecurityUtil::checkPermission('AuthPN::', '::', ACCESS_EDIT)) {
        return LogUtil::registerPermissionError();
    }

    // create an output object
    $pnRender = & pnRender::getInstance('AuthPN', false);

    // Return the output that has been generated by this function
    return $pnRender->fetch('authpn_admin_main.htm');
}

/**
 * Modify configuration
 *
 * This is a standard function to modify the configuration parameters of the
 * module
 *
 * @author       The Zikula Development Team
 * @return       output       The configuration page
 */
function AuthPN_admin_modifyconfig()
{
    // Security check
    if (!SecurityUtil::checkPermission('AuthPN::', '::', ACCESS_ADMIN)) {
        return LogUtil::registerPermissionError();
    }

    // Create output object
    $pnRender = & pnRender::getInstance('AuthPN', false);

    // Assign all module variables
    $pnRender->assign(pnModGetVar('AuthPN'));

    // Return the output that has been generated by this function
    return $pnRender->fetch('authpn_admin_modifyconfig.htm');
}

/**
 * Update the configuration
 *
 * This is a standard function to update the configuration parameters of the
 * module given the information passed back by the modification form
 * Modify configuration
 *
 * @author       The Zikula Development Team
 * @param        bold           print items in bold
 * @param        itemsperpage   number of items per page
 */
function AuthPN_admin_updateconfig()
{
    // Security check
    if (!SecurityUtil::checkPermission('AuthPN::', '::', ACCESS_EDIT)) {
        return LogUtil::registerPermissionError();
    }

    // confirm the forms auth key
    if (!SecurityUtil::confirmAuthKey()) {
        return LogUtil::registerAuthidError(pnModURL('AuthPN', 'admin', 'main'));
    }

    $authmodules = FormUtil::getPassedValue('authmodules', 'AuthPN', 'POST');
    pnModSetVar('AuthPN', 'authmodules', $authmodules);

    // Let any other modules know that the modules configuration has been updated
    pnModCallHooks('module','updateconfig', 'AuthPN', array('module' => 'AuthPN'));

    // the module configuration has been updated successfuly
    LogUtil::registerStatus(__('Done! Saved module configuration.'));

    return pnRedirect(pnModURL('AuthPN', 'admin', 'main'));
}
