<?php
class Addax_Controller_Crud extends Zend_Controller_Action 
{

	const DAOPREFIX = 'DAO';
	const BASEPREFIX = 'BASE';
	
	private function getSimpleTableName($table)
	{
		$tablenamepos = strpos($table,  self::DAOPREFIX);			
		$tablename = $table;
		if ($tablenamepos !== false) 
		{
			$tablename = substr($table, $tablenamepos+strlen( self::DAOPREFIX));
		}
		return $tablename;
	}
	
    public function init()
    {	
		$controller = Zend_Controller_Front::getInstance();		
		$this->request = $controller->getRequest();
		Zend_Loader::loadClass('AddaxCRUD');
		/*	
		require_once('Addax/View/Adapter/Smarty.php'); 
        $this->view = new Addax_View_Adapter_Smarty();				
		$this->view->setTemplatePath(APPLICATION_PATH . '/templates/smarty/ajax');				
		$this->view->setCompilePath(ZIKULA_PATH . '/pnTemp/zfSmarty_compiled');		
		$this->view->setCachePath(ZIKULA_PATH . '/pnTemp/zfSmarty_cache');
        $this->_helper->viewRenderer->setNoRender(); 		
		*/
    }

	public function updateAction()
	{		
		try
		{
			$table = $this->request->getParam('table');
			$field = $this->request->getParam('field');
			$id = $this->request->getParam('id');
			$prefield = $this->request->getParam('prefield');
			$newvalue = $this->request->getParam('new_ajax_value');
			$newdisplayvalue = $this->request->getParam('new_ajax_display_value');
			$tablename = $this->getSimpleTableName($table);			
			Zend_Loader::loadClass( self::DAOPREFIX . self::BASEPREFIX . $tablename);
			Zend_Loader::loadClass($table);
			$tbl= new AddaxCRUD($table);
			$tbl->update($id, $field, $newvalue);
			$outputvalue =((!is_null($newdisplayvalue) && !empty($newdisplayvalue))? $newdisplayvalue: $newvalue);
			echo "$prefield|$outputvalue";
		}
		catch(Exception $e)
		{
			echo 'Caught exception: ',  $e->getMessage(), "\n";
		}
	}
	
	public function deleteAction()
	{		
		try
		{
			
			$table = $this->request->getParam('table');					
			$id = $this->request->getParam('id');			
			$tablename = $this->getSimpleTableName($table);			
			Zend_Loader::loadClass( self::DAOPREFIX . self::BASEPREFIX . $tablename);
			Zend_Loader::loadClass($table);					
			$tbl= new AddaxCRUD($table);					
			$tbl->delete($id);		
			echo "id|$id"; return;
		}
		catch(Exception $e)
		{
			echo 'Caught exception: ',  $e->getMessage(), "\n";
		}		
	}
	
	public function addAction()
	{
		try
		{		
			$table = $this->request->getParam('table');		
			$tablename = $this->getSimpleTableName($table);			
			Zend_Loader::loadClass( self::DAOPREFIX . self::BASEPREFIX . $tablename);
			Zend_Loader::loadClass($table);
			
			$tbl = new AddaxCRUD($table);		
			
			$fields = $tbl->getFieldNames();
			$params = array();
			foreach ($fields as $field)
			{
				$params[$field] = $this->request->getParam($field);
			}
			$tbl->add($params);		
			
			$redirector = Zend_Controller_Action_HelperBroker::getStaticHelper('redirector');
			$redirector->setUseAbsoluteUri(true);
			$redirector->gotoUrl($_SERVER['HTTP_REFERER']);		
		}
		catch(Exception $e)
		{
			echo 'Caught exception: ',  $e->getMessage(), "\n";
		}
	}
	
	public function crudAction()
	{
		$action = $this->request->getParam('crudaction');			
		if ($action == 'add')
		{			
			echo $_SESSION['the_table_div'];
			//echo"algo";
		}
		else
		{
			echo "Pendiente";
		}
		#
		//echo "en crudaction ".(var_export($_SESSION,true));
		/*try{		
			$addxcrudNamespace = new Zend_Session_Namespace('AddaxCrud');
		}
		catch (Exception $e)
		{
			echo '2 Caught exception: ',  $e->getMessage(), "\n";
		}
		echo (var_export($addxcrudNamespace,true));
		if (isset($addxcrudNamespace->the_table_div)) {
		echo "isset";
		}
		else
		{
			echo "NOT isset";
		}
		echo $addxcrudNamespace->the_table_div."hola";*/
		//echo $_SESSION['the_table_div']."hola";
	}
}
?>
