<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 9/24/14
 * Time: 10:17 AM
 */

class BitacoraConsultaHandler {

    private $userid;
    public function __construct(){
        Zend_Loader::loadClass('DAOBaseCoBitacoraConsultas');
        Zend_Loader::loadClass('DAOCoBitacoraConsultas');

        $this->userid = sessionutil::getVar("uid");

    }
    public function eliminarconsultasviejasUsuario(){
        @session_start();
        try{
            if($_SESSION['usuarioelimino']){
                //nada.
            }else{
                //eliminar
                $manager = Doctrine_Manager::getInstance();
                $conn = $manager->getCurrentConnection();
                $conn->update(
                    Doctrine_Core::getTable("DAOCoBitacoraConsultas")
                    , array('resultados' => null, 'tiene_resultados' => false)
                    , array('usuario_id' => $this->userid, 'tiene_resultados' => 1)
                );

            }
            $_SESSION['usuarioelimino'] = true;
        }catch (Exception $ee){
            echo ($ee);die;
        }


    }
    public function registrarconsulta($datosimpresion, $duracionejecucion = 0){
        $idconsulta = null;
        //$datosimpresion['informacion_consulta'] los datos de la consulta. Hacerle unset y lo demás son los resultados.


        $bitacoraconsultas = new DAOCoBitacoraConsultas();
        $bitacoraconsultas->filtros = json_encode($datosimpresion['informacion_consulta']);
        unset($datosimpresion['informacion_consulta']);
        $bitacoraconsultas->usuario_id = $this->userid;
        $bitacoraconsultas->resultados = json_encode($datosimpresion);
        $bitacoraconsultas->tiene_resultados = true;
        $bitacoraconsultas->duracion_ejecucion = $duracionejecucion;

        $bitacoraconsultas->save();
        $idconsulta = $bitacoraconsultas->id;
        //retornar el id de la consulta. Para referencia de tod.o mundo.
        return $idconsulta;
    }

    public function cargardatosconsulta($idconsulta, $modopreparacion = true){

        $q = Doctrine_Query::create()
            ->from('DAOCoBitacoraConsultas s')
            ->where("s.id = $idconsulta");
        $consulta = $q->fetchArray();
        //print_r($consulta); die;
        if(count($consulta) < 1){
            return false;

        }else{
            $retorno = $consulta[0];
            $retorno_final = array();
            $informacionconsulta = json_decode($retorno['filtros'], true);
            $resultadosconsulta = json_decode($retorno['resultados'], true);

            if($modopreparacion){
                $retorno_final = array('informacion_consulta' => $informacionconsulta);
                $retorno_final = array_merge($retorno_final, $resultadosconsulta);
            }else{
                $retorno['filtros'] = $informacionconsulta;
                $retorno['resultados'] = $resultadosconsulta;
                $retorno_final = $retorno;
            }

            return $retorno_final;
        }
    }
} 