<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 9/8/14
 * Time: 2:59 PM
 */
define('DBACTUAL', 'mysql');
class ApiSenasaHandler {

    public static $TIPO_FINCA_GANADERA = 'finca';
    public static $TIPO_SUBASTA = 'subasta';
    public static $TIPO_MATADERO = 'matadero';
    public static $TODOS = 'ALL';
    public static $TIPO_ORIGEN = 'origen';

    public static $MYSQL = 'mysql';
    public static $SQLSERVER = 'sqlserver';
    public static $SEPARADOR = '___';
    public static $ORDEN_GUIAS = 'establecimiento_origen';

    public static $AGRUPACION_SEMANA = 'semana';
    public static $AGRUPACION_MES = 'mes';
    public static $AGRUPACION_ANNO = 'anno';
    public static $ID_VARIABLE_RIESGO = 27;

    public $limit = false;
    public function __construct(){
        Zend_Loader::loadClass('CurlHandler');
        //Zend_Loader::loadClass('BitacoraConsultaHandler');
        $this->curl = new CurlHandler();
    }
    public function getlimit(){
        $limit = "";
        if($this->limit){
            $limit = "LIMIT 20";
        }
        return $limit;
    }
    public function getDataBasicaEstablecimientos( ){
        $limit = $this->getlimit();

        $idvariableriesgo = self::$ID_VARIABLE_RIESGO;
        $sql = <<<EOD

            SELECT

                 est.identificador as codigo,
                 est.nombre as nombre_establecimiento,
                 region.nombre as region,
                 provincias.nprovincia as provincia,
                 cantones.ncanton as canton,
                 distritos.ndistrito as distrito,

                 tipo.id as tipo_id,
                 tipo.nombre as tipo,
                 clase.id as clase_id,
                 clase.nombre as clase,
                 subclase.id as subclase_id,
                 subclase.nombre as subclase,

                 subactividad.nombre as actividad_principal,
                 subactividad.nombre_combo as actividad_principal_full,

                 est.direccion,
                 est.caserio,
                 riesgovalor.nombre as categoria_riesgo,

                 est.cuadricula

                 ,(CAST(est.latitud AS CHAR(50))) as latitud
                 ,(CAST(est.longitud AS CHAR(50))) as longitud
                 ,est.centroide,


                 IFNULL(pobtotal.valor , 0)as pobtotal,
                 IFNULL(pobterneros.valor , 0)as pobterneros,
                 IFNULL(pobteneras.valor, 0) as pobteneras,
                 IFNULL(pobnovillos.valor, 0) as pobnovillos,
                 IFNULL(pobnovillas.valor, 0) as pobnovillas,
                 IFNULL(pobvacas.valor, 0) as pobvacas,
                 IFNULL(pobtoros.valor, 0) as pobtoros

                 ,IF ( ( IFNULL(pobterneros.valor , 0) + IFNULL(pobteneras.valor, 0) + IFNULL(pobnovillos.valor, 0) + IFNULL(pobnovillas.valor, 0) + IFNULL(pobvacas.valor, 0) +IFNULL(pobtoros.valor, 0) ) <> IFNULL(pobtotal.valor , 0)
                           ,'SI','NO' ) as 'diferencia_poblacional'

                 ,IF(cert.id IS NOT NULL, 'SI', 'NO') as 'tiene_certificado'
                 ,IF(cert.id IS NOT NULL,
                           IF (cert.estado = 'Vigente', 'Al dia',cert.estado )
                      , 'N/A') as 'tiene_certificado_aldia'

                 ,IF(cert.id IS NOT NULL,
                           COUNT(DISTINCT(bitrenovacion.id))
                      , 'N/A') as 'renovaciones_certificado'
                 ,IF(cert.id IS NOT NULL,
                           IF(bitvencimientos.id IS NOT NULL, 'SI', 'NO' )
                      , 'N/A') as 'vencimientos_certificado'

            FROM
                 se_establecimiento est
                 LEFT JOIN subactividad ON subactividad.id = est.actividad_principal
                 LEFT JOIN clase ON clase.id = est.clase
                 LEFT JOIN tipo ON tipo.id = clase.tipo_id
                 LEFT JOIN subclase ON subclase.id = est.subclase

                 LEFT JOIN provincias ON provincias.cod_prov = est.provincia
                 LEFT JOIN cantones ON cantones.canto = est.canton AND cantones.prov = est.provincia
                 LEFT JOIN distritos ON distritos.distrito = est.distrito AND distritos.prov = est.provincia AND distritos.canton = est.canton
                 LEFT JOIN region ON region.id = est.region

                 LEFT JOIN se_variables_establecimiento_valor riesgo ON riesgo.establecimiento_id = est.id AND riesgo.variable_id = $idvariableriesgo
                 LEFT JOIN se_riesgo riesgovalor ON riesgovalor.id = riesgo.valor

                 LEFT JOIN se_caracterizacionesActividad AS pobtotal ON pobtotal.variable_id = 104 AND pobtotal.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobterneros ON pobterneros.variable_id = 105 AND pobterneros.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobteneras ON pobteneras.variable_id = 106 AND pobteneras.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobnovillos ON pobnovillos.variable_id = 107 AND pobnovillos.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobnovillas ON pobnovillas.variable_id = 108 AND pobnovillas.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobvacas ON pobvacas.variable_id = 109 AND pobvacas.identificador = est.id
                 LEFT  JOIN se_caracterizacionesActividad AS pobtoros ON pobtoros.variable_id = 110 AND pobtoros.identificador = est.id



                 LEFT JOIN cvo_certificados cert ON cert.establecimiento_identificador = est.identificador
                 LEFT JOIN se_bitacora bitrenovacion ON bitrenovacion.id_referencia = cert.id AND bitrenovacion.seccion = 'Renovacion_CVO'
                 LEFT JOIN se_bitacora bitvencimientos ON bitvencimientos.id_referencia = cert.id AND bitvencimientos.seccion = 'Vencido_CVO'


            WHERE
                 est.id = (SELECT max(see.id) as id FROM se_establecimiento see where see.identificador = est.identificador )

            GROUP BY est.identificador
            ORDER BY est.id
            $limit
EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getDataAreasEstablecimientos( ){
        $limit = $this->getlimit();

        $sql = <<<EOD

            SELECT

               est.identificador as codigo


               ,v1.valor as pp_area_produccion_cultivo
               ,v2.valor as pp_area_bosque
               ,v3.valor as pp_area_no_aprovechada
               ,v4.valor as pp_area_construccion
               ,v5.valor as otros_area_terreno
               ,v6.valor as otros_area_construccion


            FROM
                se_establecimiento est
                LEFT JOIN se_variables_establecimiento_valor v1 ON v1.establecimiento_id = est.id AND v1.variable_id = 5
                LEFT JOIN se_variables_establecimiento_valor v2 ON v2.establecimiento_id = est.id AND v2.variable_id = 6
                LEFT JOIN se_variables_establecimiento_valor v3 ON v3.establecimiento_id = est.id AND v3.variable_id = 7
                LEFT JOIN se_variables_establecimiento_valor v4 ON v4.establecimiento_id = est.id AND v4.variable_id = 8
                LEFT JOIN se_variables_establecimiento_valor v5 ON v5.establecimiento_id = est.id AND v5.variable_id = 16
                LEFT JOIN se_variables_establecimiento_valor v6 ON v6.establecimiento_id = est.id AND v6.variable_id = 17

            WHERE
                 est.id = (SELECT max(see.id) as id FROM se_establecimiento see where see.identificador = est.identificador )


            ORDER BY est.id
            $limit
EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getDataActividadesEstablecimientos( ){
        $limit = $this->getlimit();

        $sql = <<<EOD

            SELECT
                 DISTINCT
                 est.identificador as codigo
                 ,subact.id as actividad_id
                 ,subact.nombre as actividad
                 ,subact.nombre_combo as actividad_combo
                 ,rub.id as rubro_id
                 ,rub.nombre as rubro
                 ,clase.id as clase_id
                 ,clase.nombre as clase
                 ,tipo.id as tipo_id
                 ,tipo.nombre as tipo

               ,IF(tipo.id = 1, 1, 0) as es_produccion_primaria
               ,IFNULL(varval.valor, 0) as total_poblacion


            FROM
                se_establecimiento est
                LEFT JOIN se_subActividadesAdicionales subadc ON subadc.identificador = est.id
                 LEFT JOIN subactividad subact ON subact.id = subadc.idSubActividad
                 LEFT JOIN rubros rub ON rub.id = subact.rubro_id
                 LEFT JOIN clase ON clase.id = rub.clase_id
                 LEFT JOIN tipo ON tipo.id = clase.tipo_id

                 LEFT JOIN variables var ON var.rubro_id = subact.rubro_id AND var.id IN ( 104, 127, 134, 147, 202, 222, 356, 357, 358 )
                 LEFT JOIN se_caracterizacionesActividad varval ON varval.variable_id = var.id AND varval.identificador = est.id


            WHERE
                 est.id = (SELECT max(see.id) as id FROM se_establecimiento see where see.identificador = est.identificador )
            ORDER BY est.id
            $limit
EOD;
        /*
         * Se elimina esto del join de varval
         * AND subadc.referencia_actividad = varval.referencia_caracterizacion
         */

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getDataVariablesActividadEstablecimientos($actividad, $actividad_id, $codigoestablecimiento ){
        $limit = $this->getlimit();

        $sql = <<<EOD

            SELECT

                c.nombre as 'clase'
                ,c.id as 'clase_id'

                ,r.nombre as 'rubro'
                ,r.id as 'rubro_id'
                ,v.nombre as variable
                ,v.id as variable_id
                ,v.tipo as variable_tipo
                ,varval.valor as variable_valor
                ,s.id as actividad_id
				,s.nombre as actividad

            FROM
                se_establecimiento est
                LEFT JOIN se_caracterizacionesActividad varval
                    ON
                        varval.identificador = est.id
                        AND varval.actividad_id = $actividad_id

                LEFT JOIN variables v ON varval.variable_id = v.id
                LEFT JOIN rubros r ON r.id = v.rubro_id
                LEFT JOIN clase c ON c.id = r.clase_id AND c.tipo_id = 1
                LEFT JOIN subactividad s ON s.id = varval.actividad_id

            WHERE
                est.identificador = '$codigoestablecimiento'
                AND est.id = (SELECT max(see.id) as id FROM se_establecimiento see where see.identificador = est.identificador )
                AND v.tipo = 'numerico'
            GROUP BY v.id
EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        if(array_key_exists('resultado', $retorno)){
            if($retorno['resultado'] === 0){
                $retorno = array();//El retorno es una respuesta sin resultados.
            }
        }
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }



    public function getDataPersonasEstablecimientos( ){
        $limit = $this->getlimit();
        /*
         * En SQLServer usar esto en lugar del group by.
         *
         *
             Select
                  A.maskid
                , A.maskname
                , A.schoolid
                , B.schoolname
                , STUFF((
                      SELECT ',' + T.maskdetail
                      FROM dbo.maskdetails T
                      WHERE A.maskid = T.maskid
                      FOR XML PATH('')), 1, 1, '') as maskdetail
            FROM dbo.tblmask A
            JOIN dbo.school B ON B.ID = A.schoolid
            Group by  A.maskid
                , A.maskname
                , A.schoolid
                , B.schoolname
         */
        $sql = <<<EOD

            SELECT

            est.identificador as codigo
            ,per.nombre
            ,per.cedula
            ,IF(cedula_juridica = 1, 'juriica',
              IF(cedula_residencia = 1 , 'residencia','fisica'

              )
            ) as tipo_cedula

            ,per.telefono
            ,per.celular
            ,per.fax
            ,per.correo

            ,provincias.nprovincia as provincia
            ,cantones.ncanton as canton
            ,distritos.ndistrito as distrito

            ,per.caserio
            ,per.direccion
            ,per.tipo as tipo_persona

            ,GROUP_CONCAT( CONCAT(nombre_representante, ' ', cedula_representante)
                            SEPARATOR ', ') as representantes

        FROM
            se_establecimiento est
            LEFT JOIN se_persona per ON per.identificador = est.id

            LEFT JOIN provincias ON provincias.cod_prov = per.provincia
            LEFT JOIN cantones ON cantones.canto = per.canton AND cantones.prov = per.provincia
            LEFT JOIN distritos ON distritos.distrito = per.distrito AND distritos.prov = per.provincia AND distritos.canton = per.canton
            LEFT JOIN se_representante rep ON rep.id_persona_relacionada = per.id


        WHERE
             est.id = (SELECT max(see.id) as id FROM se_establecimiento see where see.identificador = est.identificador )

        GROUP BY per.id
        ORDER BY est.id

        $limit
EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getTipos( ){
        $sql = <<<EOD

            SELECT
               id, nombre, codigo, habilitado
            FROM
                tipo

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getClases( ){
        $sql = <<<EOD

            SELECT
               id, codigo, tipo_id, nombre, habilitado
            FROM
                clase

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }
    public function getRubros( ){
        $sql = <<<EOD

            SELECT
               id, codigo, clase_id, nombre, habilitado
            FROM
                rubros

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getActividades( ){
        $sql = <<<EOD

            SELECT
               id, codigo, rubro_id, nombre, habilitado, nombre_combo
            FROM
                subactividad

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getSubclases( ){
        $sql = <<<EOD

            SELECT
               id, clase_id, nombre, habilitado, codigo
            FROM
                subclase

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        $sql = base64_encode($sql);
        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$SIREA);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$retorno]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getDatosMovimientosNivel1($fecha, $codigoestablecimiento){
        $limit = $this->getlimit();

        $sql = <<<EOD

            SELECT


                g.numero as numero_guia
                ,g.id as guia_id
                ,g.fecha_recepcion

                ,origen.identificador as origen_codigo
                ,origen.latitud as origen_latitud
                ,origen.longitud as origen_longitud
                ,origen.actividad_principal as origen_actividad_principal_id
                ,actorigen.nombre as origen_actividad_principal
                ,case
                   when actorigen.id IN ( 169,207 ) then "subasta"
                   when actorigen.id IN ( 232,40 ) then "matadero"
                   when actorigen.id IN ( 1,2,3,4 ) then "finca"

                end as origen_actividad_tipo


                ,destino.identificador as destino_codigo
                ,destino.latitud as destino_latitud
                ,destino.longitud as destino_longitud

                ,destino.actividad_principal as destino_actividad_principal_id
                ,actdestino.nombre as destino_actividad_principal
                ,case
                   when actdestino.id IN ( 169,207 ) then "subasta"
                   when actdestino.id IN ( 232,40 ) then "matadero"
                   when actdestino.id IN ( 1,2,3,4 ) then "finca"

                end as destino_actividad_tipo

                ,case
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 169,207 ) then "finca2subasta"
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 232,40 ) then "finca2matadero"
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 1,2,3,4 ) then "finca2finca"

                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 169,207 ) then "subasta2subasta"
                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 232,40 ) then "subasta2matadero"
                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 1,2,3,4 ) then "subasta2finca"


                end as movimiento_tipo


                ,(g.toros) AS toros_guia
                ,(g.vacas) AS vacas_guia
                ,(g.terneros) AS terneros_guia
                ,(g.novillos) AS novillos_guia
                ,(g.novillas) AS novillas_guia
                ,(g.indefinido) AS indefinido_guia
                ,(g.total_animales) AS total_animales_guia
                ,(g.total_otros_animales) AS total_otros_animales_guia


                FROM
                     (     SELECT
                               g.numero
                                  ,g.id
                               ,fecha_recepcion as fecha_recepcion
                               ,(g.toros) AS toros
                               ,(g.vacas) AS vacas
                               ,(g.terneros) AS terneros
                               ,(g.novillos) AS novillos
                               ,(g.novillas) AS novillas
                               ,(g.indefinido) AS indefinido
                               ,(g.total_animales) AS total_animales
                               ,(g.total_otros_animales) AS total_otros_animales

                               ,IFNULL(g.establecimiento_origen_real_id, g.establecimiento_origen_id ) establecimiento_origen_id
                               ,IFNULL(g.establecimiento_destino_real_id, g.establecimiento_destino_id ) establecimiento_destino_id

                          FROM zfzikulaDEV.tr_guia g

                          WHERE
                               g.fecha_recepcion >= '$fecha'
                               AND
                                    ( ( g.establecimiento_origen_id IN( '$codigoestablecimiento') AND g.establecimiento_origen_real_id IS NULL )  OR (g.establecimiento_origen_real_id IN( '$codigoestablecimiento' )) )



                     ) AS g
                     LEFT JOIN zfzikula.se_establecimiento origen ON g.establecimiento_origen_id =origen.identificador AND origen.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = origen.identificador )
                          LEFT JOIN zfzikula.subactividad actorigen ON actorigen.id = origen.actividad_principal



                     LEFT JOIN zfzikula.se_establecimiento destino ON g.establecimiento_destino_id =destino.identificador AND destino.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = destino.identificador )
                        LEFT JOIN zfzikula.subactividad actdestino ON actdestino.id = destino.actividad_principal



                WHERE


                     destino.id IS NOT NULL
                GROUP BY g.id
                ORDER BY  g.fecha_recepcion ASC

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getDatosMovimientosNivel1Inverso($fecha, $codigoestablecimiento){
        $limit = $this->getlimit();

        $sql = <<<EOD

            SELECT


                g.numero as numero_guia
                ,g.id as guia_id
                ,g.fecha_recepcion

                ,origen.identificador as origen_codigo
                ,origen.latitud as origen_latitud
                ,origen.longitud as origen_longitud
                ,origen.actividad_principal as origen_actividad_principal_id
                ,actorigen.nombre as origen_actividad_principal
                ,case
                   when actorigen.id IN ( 169,207 ) then "subasta"
                   when actorigen.id IN ( 232,40 ) then "matadero"
                   when actorigen.id IN ( 1,2,3,4 ) then "finca"

                end as origen_actividad_tipo


                ,destino.identificador as destino_codigo
                ,destino.latitud as destino_latitud
                ,destino.longitud as destino_longitud

                ,destino.actividad_principal as destino_actividad_principal_id
                ,actdestino.nombre as destino_actividad_principal
                ,case
                   when actdestino.id IN ( 169,207 ) then "subasta"
                   when actdestino.id IN ( 232,40 ) then "matadero"
                   when actdestino.id IN ( 1,2,3,4 ) then "finca"

                end as destino_actividad_tipo

                ,case
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 169,207 ) then "finca2subasta"
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 232,40 ) then "finca2matadero"
                   when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 1,2,3,4 ) then "finca2finca"

                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 169,207 ) then "subasta2subasta"
                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 232,40 ) then "subasta2matadero"
                   when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 1,2,3,4 ) then "subasta2finca"


                end as movimiento_tipo


                ,(g.toros) AS toros_guia
                ,(g.vacas) AS vacas_guia
                ,(g.terneros) AS terneros_guia
                ,(g.novillos) AS novillos_guia
                ,(g.novillas) AS novillas_guia
                ,(g.indefinido) AS indefinido_guia
                ,(g.total_animales) AS total_animales_guia
                ,(g.total_otros_animales) AS total_otros_animales_guia


                FROM
                     (     SELECT
                               g.numero
                                  ,g.id
                               ,fecha_recepcion as fecha_recepcion
                               ,(g.toros) AS toros
                               ,(g.vacas) AS vacas
                               ,(g.terneros) AS terneros
                               ,(g.novillos) AS novillos
                               ,(g.novillas) AS novillas
                               ,(g.indefinido) AS indefinido
                               ,(g.total_animales) AS total_animales
                               ,(g.total_otros_animales) AS total_otros_animales

                               ,IFNULL(g.establecimiento_origen_real_id, g.establecimiento_origen_id ) establecimiento_origen_id
                               ,IFNULL(g.establecimiento_destino_real_id, g.establecimiento_destino_id ) establecimiento_destino_id

                          FROM zfzikulaDEV.tr_guia g

                          WHERE
                               g.fecha_recepcion >= '$fecha'
                               AND
                                    ( ( g.establecimiento_destino_id IN( '$codigoestablecimiento') AND g.establecimiento_destino_real_id IS NULL )  OR (g.establecimiento_destino_real_id IN( '$codigoestablecimiento' )) )



                     ) AS g
                     LEFT JOIN zfzikula.se_establecimiento origen ON g.establecimiento_origen_id =origen.identificador AND origen.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = origen.identificador )
                          LEFT JOIN zfzikula.subactividad actorigen ON actorigen.id = origen.actividad_principal



                     LEFT JOIN zfzikula.se_establecimiento destino ON g.establecimiento_destino_id =destino.identificador AND destino.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = destino.identificador )
                        LEFT JOIN zfzikula.subactividad actdestino ON actdestino.id = destino.actividad_principal



                WHERE


                     destino.id IS NOT NULL
                GROUP BY g.id
                ORDER BY  g.fecha_recepcion ASC

EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getDatosMovimientosNivel2($fecha_recepcion_guia_n1, $fecha_recepcion_siguiente_guia_n1, $establecimiento_origen_n2, $idguia){
        $limit = $this->getlimit();

        $sql = <<<EOD
            SELECT

            g.id as guia_id
            ,g.numero as numero_guia
            ,g.fecha_recepcion

            ,origen.identificador as origen_codigo
            ,origen.latitud as origen_latitud
            ,origen.longitud as origen_longitud
            ,origen.actividad_principal as origen_actividad_principal_id
            ,actorigen.nombre as origen_actividad_principal
            ,case
               when actorigen.id IN ( 169,207 ) then "subasta"
               when actorigen.id IN ( 232,40 ) then "matadero"
               when actorigen.id IN ( 1,2,3,4 ) then "finca"

            end as origen_actividad_tipo


            ,destino.identificador as destino_codigo
            ,destino.latitud as destino_latitud
            ,destino.longitud as destino_longitud

            ,destino.actividad_principal as destino_actividad_principal_id
            ,actdestino.nombre as destino_actividad_principal
            ,case
               when actdestino.id IN ( 169,207 ) then "subasta"
               when actdestino.id IN ( 232,40 ) then "matadero"
               when actdestino.id IN ( 1,2,3,4 ) then "finca"

            end as destino_actividad_tipo

            ,case
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 169,207 ) then "finca2subasta"
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 232,40 ) then "finca2matadero"
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 1,2,3,4 ) then "finca2finca"

               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 169,207 ) then "subasta2subasta"
               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 232,40 ) then "subasta2matadero"
               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 1,2,3,4 ) then "subasta2finca"


            end as movimiento_tipo



            ,(g.toros) AS toros_guia
            ,(g.vacas) AS vacas_guia
            ,(g.terneros) AS terneros_guia
            ,(g.novillos) AS novillos_guia
            ,(g.novillas) AS novillas_guia
            ,(g.indefinido) AS indefinido_guia
            ,(g.total_animales) AS total_animales_guia
            ,(g.total_otros_animales) AS total_otros_animales_guia


            , case
                when detn2.id IS NULL then 0
                when detn2.id IS NOT NULL then 1
            end as estricto

            FROM
                 (     SELECT
                           g.numero
                              ,g.id
                           ,fecha_recepcion as fecha_recepcion
                           ,(g.toros) AS toros
                           ,(g.vacas) AS vacas
                           ,(g.terneros) AS terneros
                           ,(g.novillos) AS novillos
                           ,(g.novillas) AS novillas
                           ,(g.indefinido) AS indefinido
                           ,(g.total_animales) AS total_animales
                           ,(g.total_otros_animales) AS total_otros_animales

                           ,IFNULL(g.establecimiento_origen_real_id, g.establecimiento_origen_id ) establecimiento_origen_id
                           ,IFNULL(g.establecimiento_destino_real_id, g.establecimiento_destino_id ) establecimiento_destino_id

                      FROM zfzikulaDEV.tr_guia g

                      WHERE
                           (
                                 (g.fecha_recepcion >= '$fecha_recepcion_guia_n1' AND g.fecha_recepcion <= '$fecha_recepcion_siguiente_guia_n1')
                                 OR (g.fecha_creacion  >= '$fecha_recepcion_guia_n1' AND g.fecha_creacion  <= '$fecha_recepcion_siguiente_guia_n1')

                           )

                           AND
                                ( ( g.establecimiento_origen_id IN( '$establecimiento_origen_n2') AND g.establecimiento_origen_real_id IS NULL )  OR (g.establecimiento_origen_real_id IN( '$establecimiento_origen_n2' )) )



                 ) AS g
                 LEFT JOIN zfzikula.se_establecimiento origen ON g.establecimiento_origen_id =origen.identificador AND origen.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = origen.identificador )
                      LEFT JOIN zfzikula.subactividad actorigen ON actorigen.id = origen.actividad_principal


                 LEFT JOIN zfzikula.se_establecimiento destino ON g.establecimiento_destino_id =destino.identificador AND destino.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = destino.identificador )
                    LEFT JOIN zfzikula.subactividad actdestino ON actdestino.id = destino.actividad_principal



                LEFT JOIN zfzikulaDEV.tr_detalle_guia detn2 ON detn2.consecutivo_subasta IN ( SELECT consecutivo_subasta FROM zfzikulaDEV.tr_detalle_guia detn1 WHERE detn1.id_guia = $idguia ) AND g.id = detn2.id_guia
            WHERE


                 destino.id IS NOT NULL
                 AND
                    (
                         actdestino.id IN ( 1,2,3,4 , 169,207, 232,40 )


                    )

            GROUP BY g.id
            ORDER BY g.fecha_recepcion ASC




EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }


    public function getDatosMovimientosNivel2Inverso($fecha_recepcion_guia_n1, $fecha_recepcion_siguiente_guia_n1, $establecimiento_origen_n2, $idguia){
        $limit = $this->getlimit();

        $sql = <<<EOD
            SELECT

            g.id as guia_id
            ,g.numero as numero_guia
            ,g.fecha_recepcion

            ,origen.identificador as origen_codigo
            ,origen.latitud as origen_latitud
            ,origen.longitud as origen_longitud
            ,origen.actividad_principal as origen_actividad_principal_id
            ,actorigen.nombre as origen_actividad_principal
            ,case
               when actorigen.id IN ( 169,207 ) then "subasta"
               when actorigen.id IN ( 232,40 ) then "matadero"
               when actorigen.id IN ( 1,2,3,4 ) then "finca"

            end as origen_actividad_tipo


            ,destino.identificador as destino_codigo
            ,destino.latitud as destino_latitud
            ,destino.longitud as destino_longitud

            ,destino.actividad_principal as destino_actividad_principal_id
            ,actdestino.nombre as destino_actividad_principal
            ,case
               when actdestino.id IN ( 169,207 ) then "subasta"
               when actdestino.id IN ( 232,40 ) then "matadero"
               when actdestino.id IN ( 1,2,3,4 ) then "finca"

            end as destino_actividad_tipo

            ,case
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 169,207 ) then "finca2subasta"
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 232,40 ) then "finca2matadero"
               when actorigen.id IN ( 1,2,3,4 ) AND actdestino.id IN ( 1,2,3,4 ) then "finca2finca"

               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 169,207 ) then "subasta2subasta"
               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 232,40 ) then "subasta2matadero"
               when actorigen.id IN ( 169,207 ) AND actdestino.id IN ( 1,2,3,4 ) then "subasta2finca"


            end as movimiento_tipo



            ,(g.toros) AS toros_guia
            ,(g.vacas) AS vacas_guia
            ,(g.terneros) AS terneros_guia
            ,(g.novillos) AS novillos_guia
            ,(g.novillas) AS novillas_guia
            ,(g.indefinido) AS indefinido_guia
            ,(g.total_animales) AS total_animales_guia
            ,(g.total_otros_animales) AS total_otros_animales_guia


            , case
                when detn2.id IS NULL then 0
                when detn2.id IS NOT NULL then 1
            end as estricto

            FROM
                 (     SELECT
                           g.numero
                              ,g.id
                           ,fecha_recepcion as fecha_recepcion
                           ,(g.toros) AS toros
                           ,(g.vacas) AS vacas
                           ,(g.terneros) AS terneros
                           ,(g.novillos) AS novillos
                           ,(g.novillas) AS novillas
                           ,(g.indefinido) AS indefinido
                           ,(g.total_animales) AS total_animales
                           ,(g.total_otros_animales) AS total_otros_animales

                           ,IFNULL(g.establecimiento_origen_real_id, g.establecimiento_origen_id ) establecimiento_origen_id
                           ,IFNULL(g.establecimiento_destino_real_id, g.establecimiento_destino_id ) establecimiento_destino_id

                      FROM zfzikulaDEV.tr_guia g

                      WHERE
                           (
                                 (g.fecha_recepcion >= '$fecha_recepcion_guia_n1' AND g.fecha_recepcion <= '$fecha_recepcion_siguiente_guia_n1')
                                 OR (g.fecha_creacion  >= '$fecha_recepcion_guia_n1' AND g.fecha_creacion  <= '$fecha_recepcion_siguiente_guia_n1')

                           )

                           AND
                                ( ( g.establecimiento_destino_id IN( '$establecimiento_origen_n2') AND g.establecimiento_destino_real_id IS NULL )  OR (g.establecimiento_destino_real_id IN( '$establecimiento_origen_n2' )) )



                 ) AS g
                 LEFT JOIN zfzikula.se_establecimiento origen ON g.establecimiento_origen_id =origen.identificador AND origen.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = origen.identificador )
                      LEFT JOIN zfzikula.subactividad actorigen ON actorigen.id = origen.actividad_principal


                 LEFT JOIN zfzikula.se_establecimiento destino ON g.establecimiento_destino_id =destino.identificador AND destino.id = (SELECT MAX(est2.id) FROM zfzikula.se_establecimiento est2 WHERE est2.identificador = destino.identificador )
                    LEFT JOIN zfzikula.subactividad actdestino ON actdestino.id = destino.actividad_principal



                LEFT JOIN zfzikulaDEV.tr_detalle_guia detn2 ON detn2.consecutivo_subasta IN ( SELECT consecutivo_subasta FROM zfzikulaDEV.tr_detalle_guia detn1 WHERE detn1.id_guia = $idguia ) AND g.id = detn2.id_guia
            WHERE


                 destino.id IS NOT NULL
                 AND
                    (
                         actdestino.id IN ( 1,2,3,4 , 169,207, 232,40 )


                    )

            GROUP BY g.id
            ORDER BY g.fecha_recepcion ASC




EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getEstablecimientosConGuiasSalida(){
        $limit = $this->getlimit();

        $sql = <<<EOD
            SELECT
                DISTINCT g.establecimiento_origen_id as codigo
            FROM
                tr_guia g

            WHERE
                (g.tipo = 'recepcion' AND g.estado IN ('Procesada') )
                OR (g.tipo = 'salida' )




EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

    public function getEstablecimientosConGuiasEntrada(){
        $limit = $this->getlimit();

        $sql = <<<EOD
            SELECT
                DISTINCT g.establecimiento_destino_id as codigo
            FROM
                tr_guia g

            WHERE g.establecimiento_destino_id LIKE '___-______'



EOD;

        //echo $sql; die;
        error_log("CONSULTA ENVIAR: [$sql]");
        //nota. T Grupal necesita encode primero URL y luego b64.
        $sql = urlencode($sql);
        $sql = base64_encode($sql);

        $postdata = "";
        $postdata .= "encoded=1";
        $postdata .= "&consulta=$sql";
        $time_inicio = time();
        $retorno = $this->curl->hacerLlamadoCurl('consultadirecta', $postdata, CurlHandler::$TGRUPAL);
        //echo ( "DATOS [".print_r($retorno, true) . "]"); die;
        $cantidad = count($retorno);
        echo ("Cantidad de filas respuesta [$cantidad]");
        //error_log ( "DATOS [".print_r($retorno, true) . "]");
        //echo ( "DATOS [".print_r($retorno, true) . "]");
        return $retorno;
    }

} 