<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 7/21/15
 * Time: 6:34 PM
 */

class EstablecimientosManager {
    /*
     * @var cbSQLConnect
     */
    static $RUBRO_BOVINO_ID = 2;
    static $SRID_WGS84_mysql = 3;
    static $CONSULTA_ZONA = 'consulta-zona';//provincia, canton, distrito.
    static $CONSULTA_RECTANGULO = 'consulta-rectangulo'; // rectangulo.
    static $CONSULTA_POLIGONO = 'consulta-poligono';//poligono n vertices.
    static $CONSULTA_FOCAL = 'consulta-focal';//puntos. Se usa areas alrededor.
    static $EXTRA_JOIN = 'extrajoins';//puntos. Se usa areas alrededor.
    static $EXTRA_WHERE = 'extrawhere';//puntos. Se usa areas alrededor.
    public static $PARAM1 = 'valuno';//puntos. Se usa areas alrededor.

    public static $CAPA_ESTAB_NIVEL_GENERAL = "establecimientos";
    public static $CAPA_ESTAB_NIVEL_ACTIVIDADPRINCIPAL = "establecimientos_actividad_principal";
    public static $CAPA_ESTAB_NIVEL_ACTIVIDADSECUNDARIA = "establecimientos_actividad_secundaria";
    public static $CAPA_ESTAB_NIVEL_RIESGO = "establecimientos_riesgo";
    public static $CAPA_ESTAB_NIVEL_PRODUCCION = "establecimientos_produccion";
    public static $CAPA_ESTAB_NIVEL_CATEGORIZACION_PRODUCCION = "establecimientos_categorizacion_produccion";
    public static $CAPA_ESTAB_NIVEL_BOVINOS_CATEGORIZADOS = "establecimientos_bovinos_categorizados";
    public static $ESTABLECIMIENTOS_TOT_POBLACION = "establecimientos_tot_poblacion";
    public static $ESTABLECIMIENTOS_DET_POBLACION = "establecimientos_det_poblacion";
    public static $CANTIDAD_ESTABLECIMIENTOS_TOTAL = "Cantidad Establecimientos Total";
    public static $ID_TOTALES = 0;

    public static $PROVINCIA = "provincia";
    public static $CANTON = "canton";
    public static $DISTRITO = "distrito";

    public static $COD_CANTON = "cod_cant";
    public static $COD_DISTRITO = "codigo";

    private $database ;
    private $capaactual ;
    private $tipo ;
    private $viewparams ;
    public $rubroscount ;
    public $establecimiento_totales ;
    public $archivo_totales_actual ;
    public $rutaarchivos ;
    public function __construct(){
        $this->establecimiento_totales = array();
        $this->database =UtilsMap::getDBConnection();
        $this->rutaarchivos = realpath(ZIKULA_PATH . "/../archivos/");
    }
    public function obtenerInfoEstablecimiento($id = false, $codigo = false){
            $consulta = "SELECT
                    est.id
                    ,est.codigo
                    ,est.nombre_establecimiento
                    ,est.region
                    ,est.provincia
                    ,est.canton
                    ,est.distrito
                    ,est.tipo
                    ,IF( est.es_produccion_primaria = 1, 'si', 'no') as es_produccion_primaria
                    ,est.clase
                    ,est.subclase
                    ,est.actividad_principal
                    ,est.direccion
                    ,est.caserio
                    ,est.categoria_riesgo
                    ,est.cuadricula
                    ,est.latitud
                    ,est.longitud
                    ,IF( est.centroide = 1, 'si', 'no') as centroide

                FROM
                    sem_establecimientos est
                ";
        $binds = array();
        $resultado = true;
        if($id){
            $consulta .= "
            WHERE est.id = :idestab";
            $binds = array(':idestab' => $id);

        }elseif($codigo){
            $consulta .= "
            WHERE est.codigo = :codigoestab";
            $binds = array(':codigoestab' => $codigo);
        }else{
            $resultado = false;//no se puede obtener info sin identificación.
        }
        if($resultado){

            $resultado = $this->database->Query($consulta, $binds);

        }
        return $resultado;
    }

    public function obtenerInfoPersonasEstablecimiento($id){
        $consulta = "SELECT
                    per.id
                    ,per.nombre
                    ,per.cedula
                    ,
                    case
                        when per.tipo_persona LIKE 'resp_princ' then 'Responsable Principal'
                        when per.tipo_persona LIKE 'resp_sec' then 'Responsable Secundario'
                        when per.tipo_persona LIKE 'propietario' then 'Propietario'
                        when per.tipo_persona LIKE 'asoc_adic' then 'Asociado Adicional'
                    end as tipo_puesto
                    ,per.telefono
                    ,per.celular
                    ,per.correo
                    ,per.provincia
                    ,per.canton
                    ,per.distrito
                    ,per.caserio
                    ,per.direccion

                FROM
                     sem_personas_establecimiento per
                 WHERE per.sem_establecimientos_id = $id
                ";
        $binds = array();
        $resultado = true;
        if($id){
            $binds = array(':idestab' => $id);

        }else{
            $resultado = false;//no se puede obtener info sin identificación.
        }
        if($resultado){

            $resultado = $this->database->Query($consulta, $binds);

        }
        return $resultado;
    }

    public function obtenerInfoTotalesPoblacion($id){
        $rubrobovino = self::$RUBRO_BOVINO_ID;
        $consulta = "

              SELECT
                    est.id
                    ,'Produccion Ganado Bovino' as 'categoria'
                    ,est.pobtotal as poblacion
                    ,rubro.id as rubro_id

                FROM
                    sem_establecimientos est
                    INNER JOIN sem_actividad actividad ON actividad.id = est.actividad_principal_id
                    INNER JOIN sem_rubros rubro ON rubro.id = actividad.rubro_id

                WHERE
                  est.id = :idestab
                  AND est.es_produccion_primaria = 1
                  AND rubro.id = $rubrobovino

              UNION

              SELECT
                act.sem_establecimientos_id
                ,act.rubro as 'categoria'
                ,act.total_poblacion as poblacion
                ,act.rubro_id as rubro_id
              FROM
                sem_total_poblacion_actividades act
              WHERE act.sem_establecimientos_id = :idestab
                AND act.es_produccion_primaria = 1
                ";

        $binds = array(':idestab' => $id);
        $resultado = $this->database->Query($consulta, $binds);

        if(count($resultado) <= 0){
            $resultado = false;
        }
        return $resultado;
    }

    public function obtenerInfoDetallesPoblacion($id, $rubro){
        $id = $id * 1;
        $rubro = $rubro * 1;
        if($rubro == self::$RUBRO_BOVINO_ID){
            $consulta = "

                SELECT
                    'Terneros' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobterneros as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro

              UNION
                SELECT
                    'Terneras' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobteneras as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro
              UNION
                SELECT
                    'Novillos' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobnovillos as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro

              UNION
                SELECT
                    'Novillas' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobnovillas as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro

              UNION
                SELECT
                    'Vacas' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobvacas as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro

              UNION
                SELECT
                    'Toros' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobtoros as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro

              UNION
                SELECT
                    'Bovinos Total' as variable
                    ,'numerico' as variable_tipo
                    ,est.pobtotal as variable_valor
                    ,est.actividad_principal_full as actividad
                FROM
                    sem_establecimientos est

                WHERE
                  est.id = $id
                  AND est.rubro_id  = $rubro
                ";

            $binds = array(':idestab' => $id * 1, ':rubro' => $rubro);
        }else{
            $consulta = "
            SELECT
                vpp.variable
                ,vpp.variable_tipo
                ,vpp.variable_valor
                ,vpp.actividad
              FROM
                sem_variables_produccionprimaria vpp
              WHERE vpp.sem_establecimientos_id = $id
                  AND vpp.rubro_id = $rubro
            ";

            $binds = array(':idestab' => $id * 1, ':rubro' => $rubro * 1);
        }

        try{
            $resultado = $this->database->Query($consulta, $binds);
            //echo ("QUERY DETALLES POBLACION: [$consulta] [". print_r($binds, true) . "\n"); //die;
            //print_r($resultado); die;
            //echo ("RESULTADO DETALLES POBLACION: [". print_r($resultado, true) . "\n"); //die;
        }catch(Exception $ee){
            $resultado = array();
            error_log("ERROR $ee");
        }

        if(count($resultado) <= 0){
            $resultado = false;
        }
        return $resultado;
    }
    public function obtenerInfoPoblacionBovina($id){

    }

    public function consultarUbicacionEstablecimiento($codigo){

        //print_r($features); die;
        $parametros = $this->getConsultaParametros();
        $extrajoins = $parametros[self::$EXTRA_JOIN];
        $extrawhere = $parametros[self::$EXTRA_WHERE];
        if(!empty($extrawhere) )
            $extrawhere = " AND " . $extrawhere;
        try{
            $rubroscount = array();
            $establecimientos_lista = array();
            {
                $contador = 0;

                $sql = "
                SELECT est.id, est.codigo, est.rubro, est.latitud, est.longitud
FROM sem_establecimientos est
WHERE est.codigo LIKE '%$codigo'

$extrawhere


LIMIT 1
";

                //echo("Ejecutar SQL [$sql]");//die;
                $manager = Doctrine_Manager::getInstance();
                $conn = $manager->getCurrentConnection();
                $establecimientosdentro = $conn->fetchAll($sql);
                $popuphandler = new Popuphandler();

                $retorno = false;
                if(count($establecimientosdentro)> 0){
                    $retorno = $establecimientosdentro[0];
                }else{
                    $retorno = false;
                }
                return $retorno;
            }
        }catch (Exception $ee){
            echo ( "$ee ");
            return array();
        }


    }
    public function consultarEstablecimientosSeleccionados($tipo, $features, $zona = false, $radios = false, $capaactual = false , $viewparams = false){
        $this->capaactual = $capaactual;
        $this->viewparams = $viewparams;
        $this->tipo = $tipo;
        $retorno = false;
        switch($tipo){

            case self::$CONSULTA_POLIGONO:
            case self::$CONSULTA_RECTANGULO:
            $retorno =$this->consultarEstablecimientosPoligono($features);
                break;

            case self::$CONSULTA_FOCAL:
                $retorno =$this->consultarEstablecimientosRadios($features, $radios);
                break;

            case self::$CONSULTA_ZONA:
                $retorno =$this->consultarEstablecimientosZona($zona);
                break;
        }
        return $retorno;
    }
    public function getConsultaParametros(){
        $capaactual = $this->capaactual;
        $viewparams = $this->viewparams;//separados por ;, valores por :. Ejemplo: "valuno:8;"

        $viewparams = explode(';', $viewparams);
        $parametros_capa =array();
        $parametros_capa[self::$PARAM1] = 0; //valor por defecto.
        foreach($viewparams as $currparams){
            $partes = explode(':', $currparams);
            $parametros_capa[$partes[0]] = $partes[1];//key:val
        }

        $extrawhere = "";
        $extrajoins = "";
        switch($capaactual){
            case self::$CAPA_ESTAB_NIVEL_GENERAL:
                //nada. Esta capa no tiene filtros.
                break;
            case self::$CAPA_ESTAB_NIVEL_ACTIVIDADPRINCIPAL:
                $extrajoins = "INNER JOIN  sem_actividad  act ON act.id = est.actividad_principal_id";
                $extrawhere = " (%valuno% = act.id OR %valuno% = 0) ";
                break;
            case self::$CAPA_ESTAB_NIVEL_ACTIVIDADSECUNDARIA:
                $extrajoins = "INNER JOIN  sem_total_poblacion_actividades  actsec ON actsec.sem_establecimientos_id = est.id";
                $extrawhere = " (%valuno% = actsec.actividad_id OR %valuno% = 0) ";
                break;
            case self::$CAPA_ESTAB_NIVEL_RIESGO:
                $extrajoins = "INNER JOIN sem_categoria_riesgo riesgo ON riesgo.nombre = est.categoria_riesgo";
                $extrawhere = " (%valuno% = riesgo.id OR %valuno% = 0) ";
                break;
            case self::$CAPA_ESTAB_NIVEL_PRODUCCION:
                $extrajoins = "INNER JOIN sem_actividad actividad ON actividad.id = est.actividad_principal_id
          INNER JOIN sem_rubros rubro ON rubro.id = actividad.rubro_id";
                $extrawhere = "rubro.clase_id = 11
          AND ( %valuno% = rubro.id OR %valuno% = 0 )
";
                break;

            case self::$CAPA_ESTAB_NIVEL_CATEGORIZACION_PRODUCCION:
                $extrajoins = "INNER JOIN sem_actividad actividad ON actividad.id = est.actividad_principal_id
          INNER JOIN sem_rubros rubro ON rubro.id = actividad.rubro_id";
                $extrawhere = "rubro.clase_id = 11
          AND ( %valuno% = rubro.id OR %valuno% = 0 )";
                break;

            case self::$CAPA_ESTAB_NIVEL_BOVINOS_CATEGORIZADOS:
                $extrajoins = "INNER JOIN sem_actividad actividad ON actividad.id = est.actividad_principal_id
          INNER JOIN sem_rubros rubro ON rubro.id = actividad.rubro_id
		  INNER JOIN sem_categoria_bovinos cat ON cat.id = %valuno%";
                $extrawhere = "rubro.clase_id = 11
          AND ( 2 = rubro.id  )";
                break;
        }
        foreach ($parametros_capa as $nombre => $valor) {
            //echo ("REPLACING %$nombre% with $valor");die;
            $extrajoins = str_replace("%". $nombre. "%", $valor, $extrajoins);
            $extrawhere = str_replace("%". $nombre. "%", $valor, $extrawhere);
        }
        $retorno = array(self::$EXTRA_JOIN => $extrajoins, self::$EXTRA_WHERE => $extrawhere);
        return $retorno;
    }
    public function consultarEstablecimientosPoligono($features){
        //print_r($features); die;
        $parametros = $this->getConsultaParametros();
        $extrajoins = $parametros[self::$EXTRA_JOIN];
        $extrawhere = $parametros[self::$EXTRA_WHERE];
        if(!empty($extrawhere) )
            $extrawhere = " AND " . $extrawhere;
        try{
            $rubroscount = array();
            $establecimientos_lista = array();
            foreach($features as $feature_actual){
                $contador = 0;
                $sql = "  GeomFromText( 'POLYGON((";
                $puntos = array();
                foreach($feature_actual as $punto_actual){
                    $puntos[] = $punto_actual['x'] . ' '.$punto_actual['y'];//  " 0 0, 0 200, 200 200, 0 0";

                }

                $sql .= implode(', ', $puntos);
                $sql .= "))' ,3) ";

                $sql = "
SELECT est.id, est.codigo, est.rubro
FROM sem_establecimientos est
$extrajoins
WHERE ST_Intersects(est.geometria ,$sql) = 1
$extrawhere
";

                //echo("Ejecutar SQL [$sql]");//die;
                $manager = Doctrine_Manager::getInstance();
                $conn = $manager->getCurrentConnection();
                $establecimientosdentro = $conn->fetchAll($sql);
                $popuphandler = new Popuphandler();


                foreach ($establecimientosdentro as $establecimientoactual) {
                    if(!empty($establecimientoactual['rubro'])) {
                        if(!array_key_exists($establecimientoactual['rubro'], $rubroscount)) $rubroscount[$establecimientoactual['rubro']] = 0;
                        $rubroscount[$establecimientoactual['rubro']]++;
                    }
                    //$establecimientoactual['rubro'] = iconv('iso-8859-1', "UTF-8",$establecimientoactual['rubro']);
                    //$establecimientos_lista[ $establecimientoactual['id']]= $establecimientoactual['codigo'];


                    $establecimientos_lista[$establecimientoactual['id']] = $popuphandler->senasaDatosSecciones($establecimientoactual['id'], $this->capaactual, true);
                }


               /* foreach($establecimientos_lista as $idestablecimiento => $establecimiento_elemactual){
                    $establecimientos_lista[$idestablecimiento] = $popuphandler->senasaDatosSecciones($idestablecimiento, $this->capaactual, true);
                }*/
                //print_r($establecimientos_lista);

                //self::resultadosToAnsi($rubroscount);
                //print_r($rubroscount); die;
                foreach($rubroscount as $rubro => $valor){

                    $rubroread = iconv('iso-8859-1', "UTF-8",$rubro);
                    $this->rubroscount[$rubroread]  = $valor;
                }
                //$this->rubroscount = $rubroscount;

                $this->establecimiento_totales = $this->calcularTotales($establecimientos_lista, true);
                $this->crearArchivoDetalles($establecimientos_lista);
                return $establecimientos_lista;
            }
        }catch (Exception $ee){
            echo ( "$ee ");
            return array();
        }




    }
    public function consultarEstablecimientosRadios($features, $radios = array()){
        /*
         * SET @radius = 20;
            SET @g1 = POINT(-84.0629690742391,10.630731010747912);
            SET @g2 = POINT(-84.0629690742391,10.900554807262306);--omitir
            SELECT ST_Distance(@g1, @g2);--omitir
            SELECT id, codigo
            FROM sem_establecimientos est
            WHERE ST_Distance_Sphere(est.geometria, @g1) < @radius;







         */
        //print_r($radios); die;
        sort($radios);//menor a mayor.
        try{
            $rubroscount =array();
            $parametros = $this->getConsultaParametros();
            $extrajoins = $parametros[self::$EXTRA_JOIN];
            $extrawhere = $parametros[self::$EXTRA_WHERE];
            if(!empty($extrawhere) )
                $extrawhere = " AND " . $extrawhere;

            $srid = self::$SRID_WGS84_mysql;
            $establecimientos_lista = array();
            $popuphandler = new Popuphandler();
            //todo: manejar por features. Luego manejar repetidos por feature y por radio, eliminarlos del listado total, pero dar opciones con y sin en los totales.
            foreach($features as $feature_actual){
                foreach($radios as $radioactual){
                    if(!array_key_exists($radioactual, $establecimientos_lista))
                        $establecimientos_lista[$radioactual] = array();

                    $radioenmetros = $radioactual * 1000;

                    {
                    //foreach($features as $feature_actual){
                        $contador = 0;

                        $puntos = array();
                        $sql = "  GeomFromText( 'POINT(".$feature_actual['x']." ".$feature_actual['y']." )', $srid) ";//  " 0 0, 0 200, 200 200, 0 0";


                        $sql = "SELECT est.id, est.codigo, est.rubro
                                FROM sem_establecimientos est
                                $extrajoins
                                WHERE ST_Distance_Sphere(est.geometria, $sql) <= $radioenmetros
                                $extrawhere
                                ";
                        //echo("Ejecutar SQL [$sql]");//die;
                        $manager = Doctrine_Manager::getInstance();
                        $conn = $manager->getCurrentConnection();
                        $establecimientosdentro = $conn->fetchAll($sql);
                        //print_r($establecimientosdentro); die;
                        /*if($radioactual == 3){
                            print_r($establecimientosdentro); die;
                        }*/
                        foreach ($establecimientosdentro as $establecimientoactual) {
                            //$establecimientos_lista[$radioactual][ $establecimientoactual['id']]= $establecimientoactual['codigo'];


                            if(true) {
                            //if(!empty($rubro)) {
                                $rubro = $establecimientoactual['rubro'];
                                if(!array_key_exists($radioactual, $rubroscount)) $rubroscount[$radioactual] = array();
                                if(!array_key_exists($rubro, $rubroscount[$radioactual])) $rubroscount[$radioactual][ $rubro ] = 0;
                                $rubroscount[$radioactual][ $establecimientoactual['rubro'] ]++;
                            }


                            $establecimientos_lista[$radioactual][ $establecimientoactual['id']]= $popuphandler->senasaDatosSecciones($establecimientoactual['id'], $this->capaactual, true);
                        }

                    }

                }
            }

            foreach($rubroscount as $rubro => $valor){

                $rubroread = iconv('iso-8859-1', "UTF-8",$rubro);
                $this->rubroscount[$rubroread]  = $valor;
            }
            //$this->rubroscount = $rubroscount;
            foreach($establecimientos_lista as $radio => $establecimientos_lista_actual){
                /*if($radio == 3){
                    print_r($establecimientos_lista[$radio]);
                    die;
                }*/

                $this->establecimiento_totales[$radio] = $this->calcularTotales($establecimientos_lista[$radio], true);
            }
            $this->eliminarRepetidosCircular($establecimientos_lista, $radios);
            $this->crearArchivoDetalles($establecimientos_lista, $radios);
            //print_r($establecimientos_lista); die;
            return $establecimientos_lista;

        }catch (Exception $ee){

            echo ( "$ee ");
            return array();
        }

    }
    public function eliminarRepetidosCircular(&$establecimientos_lista, $radios){
        sort($radios);//por si acaso.
        $establecimientos_ya_incluidos = array();
        /*
         * Ya ordenado por radios, si empezamos desde el radio menor, en este se va a incluir todos los establecimientos
         * que haya en ese radio.
         * EN el segundo radio, ya se tiene una lista de cuáles son los establecimientos en el radio anterior, y todos esos
         * se deberían omitir, al mismo tiempo que la lista va creciendo, y así sucesivamente con los demás radios.
         *
         * Esto permite ir eliminando radios que ya aparecieron en niveles anteriores, dejando solo los resultados de los anillos.
         */
        foreach($radios as $radio_actual){
            foreach( $establecimientos_lista[$radio_actual] as $id => $datosestab){
                if($id == 0) continue;//totales no se deben eliminar.
                //busqueda en hash table es duracion constante sin importar cuantos registros haya.
                if(array_key_exists($id, $establecimientos_ya_incluidos)){
                    //ya el establecimiento esta incluido.
                    unset($establecimientos_lista[$radio_actual][$id]);
                }else{
                    $establecimientos_ya_incluidos[$id] = true ;//boolean 1 es el menor espacio posible en memoria.
                }
            }
        }
    }
    public function calcularTotales(&$establecimientos_lista, $textual = false){

        $ids = array_keys($establecimientos_lista);
        $cantidad = count($establecimientos_lista);
        //print_r($ids);
        //die;
        $capaactual = $this->capaactual;
        $establecimiento_totales = array();
        $tot_poblacion = array();
        $establecimientos_tot_poblacion = array();
        $det_poblacion = array();
        $establecimientos_det_poblacion = array();
        $indice = $indice2 = false;
        switch($capaactual){
            case Popuphandler::$CAPA_ESTAB_NIVEL_2:
                $indice = 1;
                if($textual){$indice = 'Tot. Población'; }
                $establecimiento_totales[$indice] = array();
                break;
            case Popuphandler::$CAPA_ESTAB_NIVEL_3:
                $indice = 1; if($textual){$indice = 'Tot. Población'; }
                $establecimiento_totales[$indice] = array();
                $indice2 = 2; if($textual){$indice2 = 'Det. Población'; }
                $establecimiento_totales[$indice2] = array();
                break;
            case Popuphandler::$CAPA_ESTAB_NIVEL_4:
                $indice = 1; if($textual){$indice = 'Tot. Población'; }
                $establecimiento_totales[$indice] = array();
                $indice2 = 2; if($textual){$indice2 = 'Det. Población'; }
                $establecimiento_totales[$indice2] = array();
                break;
        }
        //echo (" indice [$indice] indice2 [$indice2] ");
        foreach($establecimientos_lista as $id => $datos){
            //if($id == $id){
            //    echo ("Estab  $id " /*. print_r($datos, true)*/ );
            //}
            if($indice){

                foreach ($datos[$indice] as $key=>$values) {

                    /*
                     * [id] => 30818 [categoria] => Produccion Ganado Bovino  [poblacion] => 3 [rubro_id] => 2
                     */
                    $categoria = $values['categoria'];
                    if(!array_key_exists( $categoria, $tot_poblacion )){
                        $tot_poblacion[ $categoria] = $establecimientos_tot_poblacion[ $categoria] = 0;
                    }
                    $tot_poblacion[ $categoria] += $values['poblacion'];
                    ++$establecimientos_tot_poblacion[ $categoria];
                }

            }
            if($indice2){
                foreach ($datos[$indice2] as $key=>$values) {
                    /*
                     [0] => Array
                        (
                            [0] => Array
                                (
                                    [variable] => Terneros
                                    [variable_tipo] => numerico
                                    [variable_valor] => 2
                                    [actividad] => Produccion Ganado Bovino--Produccion con doble proposito
                                )
                     */
                    $actividad = '';
                    foreach($values as $categoriakey => $categoriavalue){
                        $actividad = $categoriavalue['actividad'];
                        $variable = $categoriavalue['variable'];



                        if(!array_key_exists( $actividad, $det_poblacion )){
                            $establecimientos_det_poblacion[$actividad]=0;
                            $det_poblacion[ $actividad] = array();
                        }
                        if(!array_key_exists( $variable, $det_poblacion[$actividad] )) $det_poblacion[$actividad][$variable] = 0;
                        $det_poblacion[$actividad][$variable] +=$categoriavalue['variable_valor'];

                    }
                    ++$establecimientos_det_poblacion[$actividad];
                }
            }

        }
        //
        $establecimiento_totales[$indice] = array();
        foreach($tot_poblacion as $key => $value){

            $establecimiento_totales[$indice][]= array(
                'categoria' =>$key
                ,'poblacion' =>$value
                ,'id' =>0
            );
        }
        $establecimiento_totales[$indice2] = array();
        $contador = 0;
        foreach($det_poblacion as $actividad => $variables){
            $establecimiento_totales[$indice2][$contador] = array();
            foreach($variables as $variablenombre => $variablevalor){
                $establecimiento_totales[$indice2][$contador][] = array(
                    'variable' => $variablenombre
                    ,'variable_valor' => $variablevalor
                    ,'actividad' => $actividad
                );
            }

            $contador++;
        }
        $indice = 0;
        if($textual){$indice = 'Establecimiento'; }
        $establecimiento_totales[$indice] = array(
            0 => array(
                'id' => 0
                ,'codigo' => 'Totales'
                ,'Cantidad Establecimientos Total' => $cantidad
                ,self::$ESTABLECIMIENTOS_TOT_POBLACION => $establecimientos_tot_poblacion
                ,self::$ESTABLECIMIENTOS_DET_POBLACION => $establecimientos_det_poblacion
            )
        );
        //$establecimientos_lista[0] = $establecimiento_totales;

        //array_unshift($establecimientos_lista, $establecimiento_totales);
        $retorno = array();
        $retorno[0] = $establecimiento_totales;
        return $retorno;
        //print_r($establecimiento_totales); die;
    }
    public function consultarEstablecimientosZona($zona){
        try{
            $rubroscount = array();
            $establecimientos_lista = array();

            //print_r($zona); die;
            $provincia = $zona[self::$PROVINCIA];
            $canton = $zona[self::$CANTON];
            $distrito = $zona[self::$DISTRITO];
            if(!$distrito || !$canton || !$provincia){
                return array();//no se puede trabajar sin informacion de distrito.
            }

            $parametros = $this->getConsultaParametros();
            $extrajoins = $parametros[self::$EXTRA_JOIN];
            $extrawhere = $parametros[self::$EXTRA_WHERE];
            if(!empty($extrawhere) )
                $extrawhere = " AND " . $extrawhere;

            $srid = self::$SRID_WGS84_mysql;
            $popuphandler = new Popuphandler();
            $sql = "SELECT est.id, est.codigo, est.rubro";
            $campo = $codigo = '';
            if($distrito){
                $campo = self::$COD_DISTRITO;
                $codigo = $provincia . str_pad($canton, 2, 0, STR_PAD_LEFT) . str_pad($distrito, 2, 0, STR_PAD_LEFT);
                $sql .= "
                    FROM  sem_establecimientos est
                        INNER JOIN capa_sobrepuestas_distritos sp ON ST_Intersects(sp.SHAPE ,est.geometria) = 1
                        $extrajoins
                ";
            }else if($canton){
                $campo = self::$COD_CANTON;
                $codigo = $provincia . str_pad($canton, 2, 0, STR_PAD_LEFT);
                $sql .= "
                    FROM  sem_establecimientos est
                        INNER JOIN  capa_sobrepuestas_cantones sp ON ST_Intersects(sp.SHAPE ,est.geometria) = 1
                        $extrajoins
                ";
            }
            $sql .= "
                    WHERE sp.$campo = '$codigo'
                    $extrawhere
            ";


            //echo("Ejecutar SQL [$sql]");die;
            $manager = Doctrine_Manager::getInstance();
            $conn = $manager->getCurrentConnection();
            $establecimientosdentro = $conn->fetchAll($sql);

            foreach ($establecimientosdentro as $establecimientoactual) {
                //$establecimientos_lista[ $establecimientoactual['id']]= $establecimientoactual['codigo'];
                if(!array_key_exists($establecimientoactual['rubro'], $rubroscount)) $rubroscount[$establecimientoactual['rubro']] = 0;
                $rubroscount[$establecimientoactual['rubro']]++;

                $establecimientos_lista[$establecimientoactual['id']] = $popuphandler->senasaDatosSecciones($establecimientoactual['id'], $this->capaactual, true);
            }


            /* foreach($establecimientos_lista as $idestablecimiento => $establecimiento_elemactual){
                 $establecimientos_lista[$idestablecimiento] = $popuphandler->senasaDatosSecciones($idestablecimiento, $this->capaactual, true);
             }*/
            //print_r($establecimientos_lista);
            $this->rubroscount = $rubroscount;
            $this->establecimiento_totales = $this->calcularTotales($establecimientos_lista, true);
            $this->crearArchivoDetalles($establecimientos_lista);
            return $establecimientos_lista;

        }catch (Exception $ee){
            error_log("ERRROR [$ee]");
            return array();
        }
    }
    public function obtenerInfoEstablecimientosLista(&$listaestablecimientos){

    }
    public function crearArchivoDetalles($establecimientos_lista, $radios = false){

        $rubroscountgoodarray = array();
        $rubroscountgoodarray = $this->rubroscount;

        $rutaarchivos = $this->rutaarchivos;
        $rawname = session_id() . time();
        $filebasename = $r = hash("md5", $rawname, false);
        $fullfile = $rutaarchivos . DIRECTORY_SEPARATOR . $filebasename;
        $filedata = array(
            'establecimientos_lista' => $establecimientos_lista
            ,'establecimiento_totales' => $this->establecimiento_totales
            ,'rubroscount' => $rubroscountgoodarray
            ,'radios' => $radios
            ,'tipo' => $this->tipo
            ,'viewparams' => $this->viewparams
            ,'capaactual' => $this->capaactual
        );
        //echo $fullfile; die;
        $this->archivo_totales_actual = $filebasename;
        $jsons = json_encode($filedata);

        //file_put_contents ( $fullfile, json_encode($filedata) );
        file_put_contents ( $fullfile, $jsons );
        return $filebasename;
    }

    public static function resultadosToUTF(&$resultados){
        //return false;
        foreach($resultados as $key => $data){
            foreach($data as $datakey => $dataval){
                if(is_string($dataval))
                    $resultados[$key][$datakey]  = iconv('iso-8859-1', "UTF-8" ,$dataval);
            }
        }

    }
    public static function resultadosToAnsi(&$resultados){
        //return false;
        foreach($resultados as $key => $data){
            //foreach($data as $datakey => $dataval){
            if(is_string($data))
                $resultados[$key]  = iconv("UTF-8", 'iso-8859-1',$data);
            if(is_string($key)){
                $keynueva  = iconv("UTF-8", 'iso-8859-1',$key);
                $resultados[$keynueva] = $resultados[$key];
                unset($resultados[$key]);
            }
            //}
        }


    }
} 