<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 5/8/15
 * Time: 4:24 PM
 */
/*
 * Esta clase maneja el despliegue del visor de mapas. Retorna el HTML del visor.
 */
class MapHandler {
    public static $INFOCAPA = 'infocapa';
    public static $CAPA = 'capa';
    public static $NOMBREDESPLIEGUE = 'nombredespliegue';
    public static $CAPA_SOLICITUDES_QUERY = 'Solicitudes:solicitudes_poligonos_q';
    public static $CAPA_SOLICITUDES= 'Solicitudes:solicitudes_poligonos';
    public function __construct(){

        error_reporting( E_ALL & ~E_NOTICE & ~E_WARNING);

        ini_set('display_errors', '0');


        if(!defined('ZIKULA_PATH')){
            define('ZIKULA_PATH', realpath(dirname(__FILE__) . "/../../../../../" ));
        }
        if(!defined('DIRECTORIOCOMPARTIDOS')){
            define('DIRECTORIOCOMPARTIDOS', realpath(ZIKULA_PATH . "/../compartidos/"));
        }
        //echo "Current zikula path: " . ZIKULA_PATH; die;
        //Incluir rutas y archivos.
        set_include_path(realpath(ZIKULA_PATH ) . PATH_SEPARATOR . get_include_path());
        set_include_path(realpath(ZIKULA_PATH . "/mapdata/includes/classes") . PATH_SEPARATOR . get_include_path());
        set_include_path(realpath(ZIKULA_PATH . "/mapdata/compartidos/") . PATH_SEPARATOR . get_include_path());

        require_once('config/config.php');

        require_once(realpath(ZIKULA_PATH ) . '/mapdata/backend/backend.php');
        require_once(realpath(ZIKULA_PATH ) . '/mapdata/backend/geohandler.php');

        set_include_path(realpath(dirname(__FILE__) . "/system/SecurityCenter/pnincludes") . PATH_SEPARATOR . get_include_path());
        set_include_path(realpath(dirname(__FILE__) . "/system/SecurityCenter/pnincludes/HTMLSax3") . PATH_SEPARATOR . get_include_path());

        require_once('addax/maptemplates/map.php');
        require_once('SolicitudesHandler.php');
        require_once('EstablecimientosManager.php');
        require_once('CyberMySQLPDO/cbSQLConnect.class.php');

        require_once('UtilsMap.php');
        require_once('BDHelper.php');
        $this->database =UtilsMap::getDBConnection();
    }
    public function obtenerCapasBase(){
        $sqlconsulta = <<<EOD
            SELECT nombredespliegue, nombrews, nombrecapa, nombretabla, orden, visibleinicio
            FROM  sem_capas
            ORDER BY orden DESC
EOD;

        $results = $this->database->Query($sqlconsulta, array());
        $retorno = false;
        if(count($results) <= 0){
            $retorno = false;
        }else{
            $capasbase = array();
            $infocapas = array();
            foreach($results as $capabaseactual){
                $capaconws = $capabaseactual['nombrews'] . ':'.$capabaseactual['nombrecapa'];
                $capasbase[] = $capaconws;
                $infocapas[ $capaconws ] = $capabaseactual;
            }
            $retorno = array(self::$INFOCAPA => $infocapas, self::$CAPA => $capasbase);
            //$retorno = $capasbase;
        }

        return $retorno;
    }
    public function getSenasaOptions(&$variables){
        $bdhelp = new BDHelper();
        $actividades = $bdhelp->getActividades();
        $html = "<option value='' selected='selected'>-Todas-</option>";
        foreach($actividades as $actividad_actual){
            $html .= "<option value='$actividad_actual[id]'>$actividad_actual[nombre_combo]</option>";
        }
        $variables['actividades'] = $html;


        $riesgos = $bdhelp->getRiesgos();
        $html = "<option value='' selected='selected'>-Todos-</option>";
        foreach($riesgos as $riesgo_actual){
            $html .= "<option value='$riesgo_actual[id]'>$riesgo_actual[nombre]</option>";
        }
        $variables['riesgos'] = $html;

        $rubros = $bdhelp->getRubros();
        $html = "<option value='' selected='selected'>-Todos-</option>";
        foreach($rubros as $rubro_actual){
            $html .= "<option value='$rubro_actual[id]'>$rubro_actual[nombre]</option>";
        }
        $variables['rubros'] = $html;

        $categoriasbovinos = $bdhelp->getCategoriasBovinos();
        $html = "<option value='' selected='selected'>-Seleccione-</option>";
        foreach($categoriasbovinos as $categoriasbovino_actual){
            $html .= "<option value='$categoriasbovino_actual[id]'>$categoriasbovino_actual[nombredespliegue]</option>";
        }
        $variables['categoriabovinos'] = $html;

        $presetsEnfermedades = $bdhelp->getPresetsEnfermedades();
        $html = "<option value='' selected='selected'>-Seleccione-</option>";
        foreach($presetsEnfermedades as $presetsEnfermedades_actual){
            $html .= "<option value='$presetsEnfermedades_actual[valores]'>$presetsEnfermedades_actual[nombre]</option>";
        }
        $variables['presetsenfermedades'] = $html;



    }
    public function getGeoOptions(&$variables){
        $variables['provinciahtml'] = getprovinciaoptionshtml();
        $variables['cantonescode'] = getcantonprovinciaoptionshtml();
        $variables['distritoscode'] = getdistritocantonprovinciaoptionshtml();
        $variables['pobladoscode'] = getpobladodistritocantonprovinciaoptionshtml();

        $html = "<option value='' selected='selected'>-Seleccione-</option>";
        foreach(Definiciones::$googlemapstypes as $tipo => $tipo_nombre){
            $html .= "<option value='$tipo'>$tipo_nombre</option>";
        }
        $variables['googlemapstypes'] = $html;
    }
    private function setHeaders(){
        header('P3P: CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');
        header('Content-Type: text/html; charset=UTF-8');
        error_reporting( E_ALL & ~E_NOTICE & ~E_WARNING);
        //error_reporting( E_ALL );
        ini_set('display_errors', '0');

    }
    public function getExtentGeometry($geometry){
        //Formato ejemplo POLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))
        $info = $this->parseTextPolygonGeometry($geometry);
        $extent = array($info[0], $info[2]);
        return $extent;
    }
    public function parseTextPolygonGeometry($geometry){
        $retorno = array();
        //Formato ejemplo POLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))
        $output_array = array();
        preg_match("/(.*\(\()(.*)(\)\))/", $geometry, $output_array);

        $puntos = explode(",", $output_array[2]) ;
        foreach($puntos as $punto){
            $puntoxy = explode(' ', $punto);//x = 0, y = 1.
            $retorno[] = array('x' => $puntoxy[0], 'y' => $puntoxy[1]);
        }
        return $retorno;
    }
    function obtenerCapasIniciales($capasbasemapa, $capasgeodatos){
        if($capasgeodatos){

        }
        $retorno = array();
        //print_r($capasbasemapa); die;
        foreach( $capasbasemapa[self::$INFOCAPA] as $capaconws => $infocapa){
            if($infocapa['visibleinicio']){
                $retorno[] = $capaconws;
            }
        }

        return $retorno;
    }
    public function obtenerVisor($header = true){
        $this->setHeaders();
        $variables = array();

        $this->getGeoOptions($variables);
        $this->getSenasaOptions($variables);
        $capasbasemapa = $this->obtenerCapasBase();
        $capasgeodatos = $this->capasGeodatos($tipoquery=true);
        $capasiniciales = $this->obtenerCapasIniciales($capasbasemapa, $capasgeodatos);
        $capassobrepuestas = false;
        if(false){
            $capassobrepuestas = array();
            $sobrepuesta1_info = array(
                                        'viewparams' => 'sol:'.$solicitudid.';'
                                        ,self::$CAPA_SOLICITUDES_QUERY => array( 'nombredespliegue' => 'Polígono Solicitud PMB')
                                );
            $sobrepuesta1_capas = array(self::$CAPA_SOLICITUDES_QUERY);
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);



            $sobrepuesta1_info = array('viewparams' => 'sol:'.$solicitudid.';');
            $sobrepuesta1_info = array_merge($sobrepuesta1_info, $capasgeodatos[self::$INFOCAPA]);
            $sobrepuesta1_capas = $capasgeodatos[self::$CAPA];
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);

        }
        $extrastyles = extraStyles();
        //$varsjs = getVarsjs($capasbasemapa[self::$CAPA], $capasgeodatos[self::$CAPA], $capasiniciales, $capassobrepuestas);
        $varsjs = getVarsjs($capasbasemapa, $capasgeodatos, $capasiniciales, $capassobrepuestas);
        $extrajs = extrajs();

        $areamaxima = Definiciones::$areamaxima;
        $varsjs .= <<<EOD
            var areamaxima = $areamaxima;
EOD;

        $jsconsulta = <<<EOD

        function postInit(){
            var mylayersshow = [];
            setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);
            setSobrepuestasLayersVisibility("sobrepuesta2", 0, mylayersshow);
        }

        lastFuncion = postInit;
EOD;
;
        if($solicitudid){
            $solicitudhandler = new SolicitudesHandler();
            $infosolicitud = $solicitudhandler->solicitudInfo($solicitudid);
            if($infosolicitud !== false){
                $geometry = $infosolicitud['extent'];
                $extentdata = $this->getExtentGeometry($geometry);
                $extentstring = $extentdata[0]['x'] . ','.$extentdata[0]['y']
                                . ','.$extentdata[1]['x'] . ','.$extentdata[1]['y'];

                $js_capageodatos = '';
                if($capasgeodatos){
                    $capasgeodatos_lista = array();

                    $capasgeodatos_str = implode(',',$capasgeodatos[self::$CAPA]);

                    $js_capageodatos = "
                        var mylayersshow = ['$capasgeodatos_str'];
                        setSobrepuestasLayersVisibility('sobrepuesta2', 0, mylayersshow);
                    ";
                }
                $capasolicitudespoligonos = self::$CAPA_SOLICITUDES_QUERY;
                $jsconsulta = <<<EOD

                    capasolicitudesshow = true;
                    function consultarActual(){
                        var mylayersshow = ['$capasolicitudespoligonos'];
                        setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);

                        $js_capageodatos
                    }
                    function zoomEnFinca(){
                        consultarActual();
                        goToPoint($extentstring, "EPSG:5367");

                    }
                    forzarExtent = zoomEnFinca; //Funcion a ejecutarse al terminar de crear el mapa. DEBE contener un goToPoint.
                    //hideLoadingCallback_consulta =consultarActual;
EOD;

            }
        }

        if($header){
            $htmlheader = TemplateMapa::$html_header;
        }
        $variables['extrajs'] = $extrajs;
        $variables['varsjs'] = $varsjs;
        $variables['extrastyles'] = $extrastyles;
        $variables['GOOGLE_API_KEY'] = GOOGLE_API_KEY;
        $variables['javascriptconsultas'] = $jsconsulta;//avascript a ejecutar segun diferentes situaciones.
        $variables['headerhtml'] = $htmlheader;//avascript a ejecutar segun diferentes situaciones.
        $variables['URL_GEOSERVER_GENERIC_GETMAP'] = URL_GEOSERVER_GENERIC_GETMAP;//avascript a ejecutar segun diferentes situaciones.

        $htmlmapa=TemplateMapa::$html;

        $this->generarSalida($htmlmapa, $variables);


    }

    public function obtenerVisorTestCenso($solicitudid = null,$pmb = null,$inventario = null, $header = true){
        $this->setHeaders();
        $variables = array();

        $this->getGeoOptions($variables);
        $capasbasemapa = $this->obtenerCapasBase();
        $capasgeodatos = $this->capasGeodatos($tipoquery=true);
        $capasiniciales = $this->obtenerCapasIniciales($capasbasemapa, $capasgeodatos);
        $capassobrepuestas = false;
        if($solicitudid){
            $capassobrepuestas = array();
            $sobrepuesta1_info = array(
                'viewparams' => 'sol:'.$solicitudid.';'
            ,self::$CAPA_SOLICITUDES_QUERY => array( 'nombredespliegue' => 'Polígono Solicitud PMB')
            );
            $sobrepuesta1_capas = array(self::$CAPA_SOLICITUDES_QUERY);
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);



            $sobrepuesta1_info = array('viewparams' => 'sol:'.$solicitudid.';');
            $sobrepuesta1_info = array_merge($sobrepuesta1_info, $capasgeodatos[self::$INFOCAPA]);
            $sobrepuesta1_capas = $capasgeodatos[self::$CAPA];
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);

        }else{
            $capassobrepuestas = array();
            $sobrepuesta1_info = array(
                self::$CAPA_SOLICITUDES => array( 'nombredespliegue' => 'Polígono Solicitud PMB')
            );
            $sobrepuesta1_capas = array(self::$CAPA_SOLICITUDES);
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);


        }
        $extrastyles = extraStyles();
        //$varsjs = getVarsjs($capasbasemapa[self::$CAPA], $capasgeodatos[self::$CAPA], $capasiniciales, $capassobrepuestas);
        $varsjs = getVarsjs($capasbasemapa, $capasgeodatos, $capasiniciales, $capassobrepuestas);
        $extrajs = extrajs();

        $capasolicitudespoligonos = self::$CAPA_SOLICITUDES;
        $jsconsulta = <<<EOD

        function postInit(){

            var mylayersshow = ['$capasolicitudespoligonos'];
            setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);
            setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);

            mylayersshow = [];
            setSobrepuestasLayersVisibility("sobrepuesta2", 0, mylayersshow);


        }

        lastFuncion = postInit;

        function consultarActual(){
                        userprojection = "EPSG:5367";
     // Set up symbols for pantries
          // Yellow symbol for unselected pantries
          var pantryStyle = new OpenLayers.Style({
              pointRadius: 10, fillColor: "green",
               fillOpacity: 0.5, strokeColor: "black"
          });

          // Blue symbol for selected pantries
          var selectedPantryStyle = new OpenLayers.Style({
              pointRadius: 10, fillColor: "blue",
               fillOpacity: 0.5, strokeColor: "blue"
          });

          // Set up style map for pantries
          var pantryStyleMap = new OpenLayers.StyleMap({'default': pantryStyle,'select': selectedPantryStyle});


     // Define the food pantries GeoJSON layer
          var pantriesLayer = new OpenLayers.Layer.Vector("Pantries", {

            strategies: [new OpenLayers.Strategy.Fixed()],
            protocol: new OpenLayers.Protocol.HTTP({
              url: "/tmp/puntos.txt",
              format: new OpenLayers.Format.GeoJSON()
            }),
            styleMap: pantryStyleMap

            //,projection: CRTM05
          //     ,srs: 'EPSG:900913'

          ,projection: 'EPSG:4326'
               ,displayProjection: 'EPSG:900913'
               ,srs: 'EPSG:4326'
          }

          );


          map.addLayer(pantriesLayer);


          // Listen for feature selection and unselection events.
          selectControl = new OpenLayers.Control.SelectFeature([pantriesLayer], {
               clickout: true, toggle: false,
               multiple: false, hover: false,
               toggleKey: "ctrlKey", // ctrl key removes from selection
               multipleKey: "shiftKey", // shift key adds to selection
               box: true

              ,onSelect: onFeatureSelect,
              onUnselect: onFeatureUnselect
          });

          map.addControl(selectControl);
          selectControl.activate();



// Handle the feature selection even
          function onFeatureSelect(feature){
            console.log(feature);
          }

          // Handle the feature unselection event
          function onFeatureUnselect(feature){
            // Set the HTML back to what it was before

          }
                    }
        hideLoadingCallback_consulta =consultarActual;
EOD;
        ;
        if($solicitudid){
            $solicitudhandler = new SolicitudesHandler();
            $infosolicitud = $solicitudhandler->solicitudInfo($solicitudid);
            if($infosolicitud !== false){
                $geometry = $infosolicitud['extent'];
                $extentdata = $this->getExtentGeometry($geometry);
                $extentstring = $extentdata[0]['x'] . ','.$extentdata[0]['y']
                    . ','.$extentdata[1]['x'] . ','.$extentdata[1]['y'];

                $js_capageodatos = '';
                if($capasgeodatos){
                    $capasgeodatos_lista = array();

                    $capasgeodatos_str = implode(',',$capasgeodatos[self::$CAPA]);

                    $js_capageodatos = "
                        var mylayersshow = ['$capasgeodatos_str'];
                        setSobrepuestasLayersVisibility('sobrepuesta2', 0, mylayersshow);
                    ";
                }
                $capasolicitudespoligonos = self::$CAPA_SOLICITUDES_QUERY;
                $jsconsulta = <<<EOD

                    capasolicitudesshow = true;
                    function consultarActual(){
                        var mylayersshow = ['$capasolicitudespoligonos'];
                        setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);

                        $js_capageodatos
                    }
                    function zoomEnFinca(){
                        consultarActual();
                        goToPoint($extentstring, "EPSG:5367");

                    }
                    forzarExtent = zoomEnFinca; //Funcion a ejecutarse al terminar de crear el mapa. DEBE contener un goToPoint.
                    //hideLoadingCallback_consulta =consultarActual;
EOD;

            }
        }

        if($header){
            $htmlheader = TemplateMapa::$html_header;
        }
        $variables['extrajs'] = $extrajs;
        $variables['varsjs'] = $varsjs;
        $variables['extrastyles'] = $extrastyles;
        $variables['GOOGLE_API_KEY'] = GOOGLE_API_KEY;
        $variables['javascriptconsultas'] = $jsconsulta;//avascript a ejecutar segun diferentes situaciones.
        $variables['headerhtml'] = $htmlheader;//avascript a ejecutar segun diferentes situaciones.

        $htmlmapa=TemplateMapa::$html;
        $this->generarSalida($htmlmapa, $variables);


    }

    public function obtenerVisorAllSolicitudes($solicitudid = null,$pmb = null,$inventario = null, $header = true){
        $this->setHeaders();
        $variables = array();

        $this->getGeoOptions($variables);
        $capasbasemapa = $this->obtenerCapasBase();
        $capasgeodatos = $this->capasGeodatos($tipoquery=true);
        $capasiniciales = $this->obtenerCapasIniciales($capasbasemapa, $capasgeodatos);
        $capassobrepuestas = false;
        if($solicitudid){
            $capassobrepuestas = array();
            $sobrepuesta1_info = array(
                'viewparams' => 'sol:'.$solicitudid.';'
            ,self::$CAPA_SOLICITUDES_QUERY => array( 'nombredespliegue' => 'Polígono Solicitud PMB')
            );
            $sobrepuesta1_capas = array(self::$CAPA_SOLICITUDES_QUERY);
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);



            $sobrepuesta1_info = array('viewparams' => 'sol:'.$solicitudid.';');
            $sobrepuesta1_info = array_merge($sobrepuesta1_info, $capasgeodatos[self::$INFOCAPA]);
            $sobrepuesta1_capas = $capasgeodatos[self::$CAPA];
            $capassobrepuestas[] = array(self::$INFOCAPA => $sobrepuesta1_info, self::$CAPA => $sobrepuesta1_capas);

        }
        $extrastyles = extraStyles();
        //$varsjs = getVarsjs($capasbasemapa[self::$CAPA], $capasgeodatos[self::$CAPA], $capasiniciales, $capassobrepuestas);
        $varsjs = getVarsjs($capasbasemapa, $capasgeodatos, $capasiniciales, $capassobrepuestas);
        $extrajs = extrajs();

        $jsconsulta = <<<EOD

        function postInit(){
            var mylayersshow = [];
            setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);
            setSobrepuestasLayersVisibility("sobrepuesta2", 0, mylayersshow);
        }

        lastFuncion = postInit;
EOD;
        ;
        if($solicitudid){
            $solicitudhandler = new SolicitudesHandler();
            $infosolicitud = $solicitudhandler->solicitudInfo($solicitudid);
            if($infosolicitud !== false){
                $geometry = $infosolicitud['extent'];
                $extentdata = $this->getExtentGeometry($geometry);
                $extentstring = $extentdata[0]['x'] . ','.$extentdata[0]['y']
                    . ','.$extentdata[1]['x'] . ','.$extentdata[1]['y'];

                $js_capageodatos = '';
                if($capasgeodatos){
                    $capasgeodatos_lista = array();

                    $capasgeodatos_str = implode(',',$capasgeodatos[self::$CAPA]);

                    $js_capageodatos = "
                        var mylayersshow = ['$capasgeodatos_str'];
                        setSobrepuestasLayersVisibility('sobrepuesta2', 0, mylayersshow);
                    ";
                }
                $capasolicitudespoligonos = self::$CAPA_SOLICITUDES_QUERY;
                $jsconsulta = <<<EOD

                    capasolicitudesshow = true;
                    function consultarActual(){
                        var mylayersshow = ['$capasolicitudespoligonos'];
                        setSobrepuestasLayersVisibility("sobrepuesta1", 0, mylayersshow);

                        $js_capageodatos
                    }
                    function zoomEnFinca(){
                        consultarActual();
                        goToPoint($extentstring, "EPSG:5367");

                    }
                    forzarExtent = zoomEnFinca; //Funcion a ejecutarse al terminar de crear el mapa. DEBE contener un goToPoint.
                    //hideLoadingCallback_consulta =consultarActual;
EOD;

            }
        }

        if($header){
            $htmlheader = TemplateMapa::$html_header;
        }
        $variables['extrajs'] = $extrajs;
        $variables['varsjs'] = $varsjs;
        $variables['extrastyles'] = $extrastyles;
        $variables['GOOGLE_API_KEY'] = GOOGLE_API_KEY;
        $variables['javascriptconsultas'] = $jsconsulta;//avascript a ejecutar segun diferentes situaciones.
        $variables['headerhtml'] = $htmlheader;//avascript a ejecutar segun diferentes situaciones.

        $variables['headerhtml'] = $htmlheader;//avascript a ejecutar segun diferentes situaciones.

        $htmlmapa=TemplateMapa::$html;
        $this->generarSalida($htmlmapa, $variables);


    }
    private function generarSalida($htmlmapa, $variables){
        foreach ($variables as $variable => $valor) {
            $htmlmapa = str_replace('%%'.$variable.'%%' , $valor, $htmlmapa);
        }
        echo $htmlmapa; die;
    }

    public function capasGeodatos($tipoquery = false){

        $sqlconsulta = <<<EOD

            SELECT

            nombredespliegue
            ,nombrews
            ,nombrecapa
            ,nombretabla
            ,tipogeometria
        FROM
             su_geodatos


EOD;

        $results = $this->database->Query($sqlconsulta, array());
        $retorno = false;
        if(count($results) <= 0){
            $retorno = false;
        }else{
            $capasbase = array();
            $capainfo = array();
            foreach($results as $capabaseactual){
                $capaconws = $capabaseactual['nombrews'].':'. $capabaseactual['nombrecapa'] .($tipoquery?'_q':'');
                $capasbase[] =$capaconws;
                $capainfo[$capaconws] = $capabaseactual;
            }
            $retorno = array(self::$INFOCAPA => $capainfo, self::$CAPA => $capasbase);
        }
        //print_r($retorno); die;

        return $retorno;
    }


} 