<?php
/**
 * Created by PhpStorm.
 * User: Julio
 * Date: 8/22/14
 * Time: 1:56 PM
 */
ini_set('memory_limit', '128M');
require_once('GeonetworksHandler.php');
class XmlHandler {
    private $file;
    public function print_xml($file, $raw = false){
        $this->file = $file;
        //get logged user for md5 key.

        $username = Session::getCurrentUser();
        $mapeado = @definiciones::$mapeoestudiantesimportacion[$username];
        if(empty($mapeado)){

            error_log("El usuario actual no esta mapeado!");
            return $this->retornarerror();
        }
        $geonetworkhandler = new GeonetworksHandler();
        $layerinfo = $geonetworkhandler->getlayerinfo_geoserver($file);
        if($layerinfo){
            $haymetadata = false;$urlxml = false;
            if(count($layerinfo['metadataLinks']) > 0){
                if(count($layerinfo['metadataLinks']['metadataLink'] ) > 0){
                    $metadatalink = $layerinfo['metadataLinks']['metadataLink'][0];//solo el primero.
                    $urlxml = $metadatalink['content'];
                    $haymetadata = true;
                }
            }
            if(!$haymetadata){
                error_log("La capa existe, pero no tiene metadatalinks!");
                return $this->retornarerror();
            }else{

                $xmlarchivo = CurlHandler::Get($urlxml);
                if($raw){
                    header("Content-Type: application/xml; charset=utf-8");
                    echo $xmlarchivo;
                    die;
                }else{

                    $this->imprimirxml($xmlarchivo);
                }
            }



        }else{

            return $this->retornarerror();
        }



    }
    private function retornarerror(){
        $username = Session::getCurrentUser();
        //imprimir mensaje de documento no encontrado.
        $archivoquery = $this->file;
        $html = <<<EOD
        <html>
        <head>
            <title>Curso::SIG aplicado a obras viales</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <link rel="shortcut icon" href="images/favicon.ico" />

            <link rel="stylesheet" href="/styles/xml.css" type="text/css">
        </head>
        <body>
            <div class="header">
                <div class="headerfloattxt">
                    Curso maestría: SIG aplicado a obras viales
                </div>
                <a href="/index.php">
                            <span class="left_subheader">
                            </span>
                </a>
                <div class="right_subheader">
                </div>
            </div>
            <center>
                <p>
                    $username

                </p>
            </center>
            <div class='xmlcontent'>
                El archivo xml de la capa $archivoquery NO fue encontrado
            </div>
        </body>
        </html>
EOD;
        echo $html; die;
        return false;
    }
    private function imprimirxml($elarchivo){
        $username = Session::getCurrentUser();
        /*
        $doc = new DOMDocument();
        $doc->preserveWhiteSpace = true;
        $doc->formatOutput = true;
        $doc->load($elarchivo);

        $xmlcontent= $doc->saveXML();*/
        /*$xmlstring = file_get_contents($elarchivo);
        $xml = new SimpleXMLElement($xmlstring);
        $xmlcontent= '';
        foreach ($xml->children() as $second_gen) {
            $xmlcontent .= '<br /><div style="margin-left: 5px;"> ' . $second_gen . ' </div>';

            /*foreach ($second_gen->children() as $third_gen) {
                echo ' who begot a ' . $third_gen['role'] . ';';

                foreach ($third_gen->children() as $fourth_gen) {
                    echo ' and that ' . $third_gen['role'] .
                        ' begot a ' . $fourth_gen['role'];
                }
            }*/
        //}

        //$xml  = simplexml_load_file($elarchivo);
        $xml  = simplexml_load_string($elarchivo);



        $xmlcontentarray = $this->xml2array_parse($xml);

        $xmlcontent='';
        $xmlcontent = $this->array_to_html($xmlcontentarray, 0);
        $archivoname = $this->file;
        $archivoquery = $this->file;
        $html = <<<EOD
        <html>
        <head>
            <title>Curso::SIG aplicado a obras viales</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <link rel="shortcut icon" href="images/favicon.ico" />

            <link rel="stylesheet" href="/styles/xml.css" type="text/css">
        </head>
        <body>
            <div class="header">
                <div class="headerfloattxt">
                    Curso maestría: SIG aplicado a obras viales
                </div>
                <a href="/index.php">
                            <span class="left_subheader">
                            </span>
                </a>
                <div class="right_subheader">
                </div>
            </div>
            <h2>Metadatos ISO 19115</h2>
            <center>

                <p>
                    $username
                    <br />
                    Ver archivo xml <a href='/backend/backend.php?function=viewxml&file=$archivoquery&raw=1' target='_blank'>$archivoname</a>
                </p>
            </center>
            <div class='xmlcontent'>
                $xmlcontent
            </div>
        </body>
        </html>
EOD;
        echo $html; die;
        return true;

    }
    function xml2array_parse($xml){
        foreach ($xml->children() as $parent => $child){
            $return["$parent"] = $this->xml2array_parse($child)?$this->xml2array_parse($child):"$child";
        }
        return $return;
    }
    function array_to_html($array, $level){
        ++$level;
        $retorno = '';
        $margin = $level * 5;
        if(!is_array($array)){
            $retorno .= "<div class='elem node' style='margin-left: ".$margin."px;'><span>$array</span> ";
            $retorno .= "</div>";
        }else{
            foreach ($array as $parent => $child) {
                $retorno .= "<div class='elem parent parent$level' style='margin-left: ".$margin."px;'><span>$parent</span> ";
                $retorno .= $this->array_to_html($child, $level);
                $retorno .= "</div>";
            }
        }

        return $retorno;


    }
}



class XmlArray {

    public function load_dom ($xml) {
        $node=simplexml_import_dom($xml);
        return $this->add_node($node);
    }

    public function load_string ($s) {
        $node=simplexml_load_string($s);
        return $this->add_node($node);
    }

    private function add_node ($node, &$parent=null, $namespace='', $recursive=false) {

        $namespaces = $node->getNameSpaces(true);
        $content="$node";

        $r['name']=$node->getName();
        if (!$recursive) {
            $tmp=array_keys($node->getNameSpaces(false));
            $r['namespace']=$tmp[0];
            $r['namespaces']=$namespaces;
        }
        if ($namespace) $r['namespace']=$namespace;
        if ($content) $r['content']=$content;

        foreach ($namespaces as $pre=>$ns) {
            foreach ($node->children($ns) as $k=>$v) {
                $this->add_node($v, $r['children'], $pre, true);
            }
            foreach ($node->attributes($ns) as $k=>$v) {
                $r['attributes'][$k]="$pre:$v";
            }
        }
        foreach ($node->children() as $k=>$v) {
            $this->add_node($v, $r['children'], '', true);
        }
        foreach ($node->attributes() as $k=>$v) {
            $r['attributes'][$k]="$v";
        }

        $parent[]=&$r;
        return $parent[0];

    }

}