/**
 * Created by Julio on 7/25/15.
 */

$(function() {
    $("#tabs").tabs();
    $( "#nivelmapaholder" ).buttonset();
    $( "#modificar-elemento" ).button();
    $( "#lista-botones-consulta" ).buttonset();

    //$('select').css('min-width: 300px');
    $('select').select2();
    $('select#filtro-nivel1-modo').on("change",
        function(){
            var modo = $('select#filtro-nivel1-modo').val();
            if(modo == 'actividad' ){
                $('div#n1-actividad').show();
                $('div#n1-riesgo').hide();
            }else{
                $('div#n1-actividad').hide();
                $('div#n1-riesgo').show();
            }
        });

    $('div.filtros-niveles select').on("change",
        function(){
            setMapa();
        });
    $('input[name=radionivelmapaholder]').on("change",
        function() {

            var nivelactual = $('input[name=radionivelmapaholder]:checked').val();

            $('div.filtros-niveles').hide();
            $('div#filtro-' +nivelactual).show();

            setMapa();

        });

    var capadefault = 'establecimientos';
//setCapa(capadefault, '', 0);


    $('input[name=botones-consulta]').on("change",
        function() {
            activarConsultaGeografica(true);


        });
    inicializarControles();

    $("select#consulta-focal-radios-control").select2({
        maximumSelectionLength: 6
        ,placeholder: "Radios de consulta focal"

    })


    $("#consulta-focal-input-latitud").mask("9.99999");
    $("#consulta-focal-input-longitud").mask("-99.99999");

    $.mask.definitions['~'] = '([0-9])?';
    $.mask.definitions['h'] = '([\-])?';
    $("#navegacion-cod-establecimiento").mask("~~~h999999");


    $('div.upper-toolbar div').click(function(){
        manejarMenuHerramientas(this);
    });
});
function manejarMenuHerramientas(elem, apicall ){
    var reactivar = false;
    var id = $(elem).attr('id');
    if(id == 'controles-grilla' ){
        //Este control no desactiva los demas.

    }else{
        var idactivos = [];
        $('div.upper-toolbar div.active').each(function(){
            var idactivo = $(this).attr('id');
            idactivos.push(idactivo);
        });

        //$('div.upper-toolbar div').removeClass('active');

        $('div.upper-toolbar div#'+id).addClass('active');
        if(grillaOn){
            $('div.upper-toolbar div#controles-grilla').addClass('active');

        }
    }



    if(id == 'controles-mano' ){
        activarMano();


    }
    if(id == 'controles-medirlinea' ){
        if(!apicall){
            activarMedirLinea();

            $('div.upper-toolbar div').removeClass('active');
            $('div#overmap-holder>div').hide();
        }

        $('div.upper-toolbar div#'+id).addClass('active');
    }
    if(id == 'controles-medirpoligono' ){
        if(!apicall){
            activarMedirPoligono();
            $('div.upper-toolbar div').removeClass('active');
            $('div#overmap-holder>div').hide();
        }



        $('div.upper-toolbar div#'+id).addClass('active');
    }
    if(id == 'controles-querypoint' ){
        if(!apicall){
            activarConsultaPunto();
            $('div.upper-toolbar div').removeClass('active');
            $('div#overmap-holder>div').hide();
        }

        $('div.upper-toolbar div#'+id).addClass('active');
    }
    if(id == 'controles-refesh' ){
        for(i in map.layers){
            map.layers[i].redraw();
        }
        $('div.upper-toolbar div#'+id).removeClass('active');
    }
    if(id == 'controles-navegador' ){
        //$('div#controles-holder-navegacion').show();
        leyendaOn= false;
        if(!navegacionOn){
            $('div#controles-holder-navegacion').show();
            navegacionOn= true;
        }else{
            $('div#controles-holder-navegacion').hide();
            navegacionOn= false;
            $('div.upper-toolbar div#controles-navegador').removeClass('active');
        }

        $('div#controles-holder-leyenda').hide();
        $('div.upper-toolbar div#controles-leyenda').removeClass('active');

    }
    if(id == 'controles-leyenda' ){
        legend();
        navegacionOn= false;
        //$('div#controles-holder-leyenda').show();

        if(!leyendaOn){
            $('div#controles-holder-leyenda').show();
            leyendaOn= true;
        }else{
            $('div#controles-holder-leyenda').hide();
            leyendaOn= false;
            $('div.upper-toolbar div#controles-leyenda').removeClass('active');
        }

        reactivar = true;
        $('div#controles-holder-navegacion').hide();
        $('div.upper-toolbar div#controles-navegador').removeClass('active');
    }
    if(id == 'controles-grilla' ){
        if(!grillaOn){
            setCapa('Sobrepuestas:capa_sobrepuestas_cuadricula', '', 0);
            grillaOn = true;
            $('div.upper-toolbar div#controles-grilla').addClass('active');
        }else{
            //Ocultar la capa grilla.
            nivel = 0;
            if(capasManuales[nivel] != null ){
                map.removeLayer( capasManuales[nivel] );
            }
            capasManuales[nivel] = null;
            grillaOn = false;
            $('div.upper-toolbar div#controles-grilla').removeClass('active');
        }

        reactivar = true;

    }
    if(id == 'controles-capas' ){
        if(!capasOn){
            $('div#controles-holder-capas').show();
            capasOn= true;
        }else{
            $('div#controles-holder-capas').hide();
            capasOn= false;
            $('div.upper-toolbar div#controles-capas').removeClass('active');
        }


    }
}
var grillaOn= false;
var capasOn= false;
var leyendaOn= false;
var navegacionOn= false;

function setMapa(){
    var nivelactual = $('input[name=radionivelmapaholder]:checked').val();
    if(nivelactual == "nivel1")
        setMapaEstablecimientosGenerales();
    else if(nivelactual == "nivel2")
        setMapaProduccionPrimaria();
    else if(nivelactual == "nivel3")
        setMapaCategorizacionProduccionPrimaria();
    else if(nivelactual == "nivel4")
        setMapaBovinosCategorizados();

}
function setMapaEstablecimientosGenerales(){

    var modo = $('#filtro-nivel1-modo').val();
    var actividad = $('#filtro-nivel1-actividad').val();
    var tipoactividad = $('#filtro-nivel1-tipoactividad').val();
    var riesgo = $('#filtro-nivel1-riesgo').val();

    var capa = ''
    var filtros = '';

    if(modo == 'actividad' ){
        if(tipoactividad = 'primaria' )
            capa = 'establecimientos_actividad_principal';
        else
            capa = 'establecimientos_actividad_secundaria';

        if(actividad != '' )
            filtros = 'valuno:'+actividad+';';

    }else{
        if(riesgo != '' )
            filtros = 'valuno:'+riesgo+';';
        capa = 'establecimientos_riesgo';

    }

    setCapa(capa, filtros, 0);

}
function setMapaProduccionPrimaria(){
    var capa = 'establecimientos_produccion';
    var actividad = $('#filtro-nivel2-actividad').val();
    var filtros = '';
    if(actividad != '' )
        filtros = 'valuno:'+actividad+';';

    setCapa(capa, filtros, 0);
}
function setMapaCategorizacionProduccionPrimaria(){

    var capa = 'establecimientos_categorizacion_produccion';
    var actividad = $('#filtro-nivel3-actividad').val();
    var filtros = '';

    if(actividad != '' )
        filtros = 'valuno:'+actividad+';';

    setCapa(capa, filtros, 0);
}
function setMapaBovinosCategorizados(){

    var categoria = $('#filtro-nivel4-categoria').val();
    var filtros = '';

    if(categoria != '' )
        filtros = 'valuno:'+categoria+';';

    var capa = 'establecimientos_bovinos_categorizados';
    setCapa(capa, filtros, 0);
}

var capasManuales = [];
capasManuales[0] = null;
function setCapa(capa, filtros, nivel){

    if(!nivel) nivel = 0;
    if(capasManuales[nivel] != null ){
        map.removeLayer( capasManuales[nivel] );
    }

    readable = "Capa Nombre";
    url = '%%URL_GEOSERVER_GENERIC_GETMAP%%';
    base = false;
    layers = capa;
    transparent = true;
    format ="image/png";
    viewparams=  filtros
    buffer = 1;
    group = "capasManuales" + nivel;

    var layer = new OpenLayers.Layer.WMS(
        nivel
        , url
        , {
            "layers": layers
            , "transparent": transparent
            , "format": format
            ,"projection": CRTM05
            ,"srs": 'EPSG:900913'
            ,'viewparams': viewparams

        },{
            "projection": CRTM05,
            "isBaseLayer": base
            , "buffer" : buffer
            , "group" : group
            , opacity: 1
        }
    );
    capasManuales[nivel] = layer;
    layer.setVisibility(true);

    layer.events.register("loadstart", layer, function() {   showLoading(0, layer); });
    layer.events.register("loadend", layer, function() {   hideLoading(0, layer); });
    themap.addLayer(layer);
    map.setLayerIndex(vectors, 1000);vectors.setZIndex(1000);
}

function desactivarSeleccionConsulta(){
    $('div#lista-botones-consulta input').prop('checked', false);
    $('div#lista-botones-consulta input').removeAttr('checked');
    $( "div#lista-botones-consulta" ).buttonset('refresh');

    addaxcontrol.activate();
    control_punto.deactivate();
    control_poligono.deactivate();
    control_box.deactivate();

}
function activarConsultaGeografica(limpiar){

    addaxcontrol.deactivate();
    control_punto.deactivate();
    control_poligono.deactivate();
    control_box.deactivate();
    if(limpiar)
        vectors.removeAllFeatures();
    map.setLayerIndex(vectors, 1000);vectors.setZIndex(1000);
    var herramientaactual = $('input[name=botones-consulta]:checked').val();
    $('div#consulta-focal-radios').hide();
    if(herramientaactual == 'consulta-rectangulo'){
        control_box.activate();
    }else if(herramientaactual == 'consulta-poligono'){
        control_poligono.activate();
    }else if(herramientaactual == 'consulta-zona'){

    }else if(herramientaactual == 'consulta-focal'){
        $('div#consulta-focal-radios').show();
        control_punto.activate();

        if(!radioslayer){
            radioslayer = new OpenLayers.Layer.Vector("Vector Layer 2");
            map.addLayer(radioslayer);
        }


    }
}
var controlesselect = control_punto = control_poligono = control_box = modify =null;
var vectors = null;
var radioslayer = null;
function limpiarSeleccionConsulta(){ limpiarDibujos(); }
function limpiarDibujos(){
    vectors.destroyFeatures();
    if(radioslayer)
        radioslayer.destroyFeatures();
}
var estilosRadios =[
    '#D2C246','#2699BF', '#DD5542', '#E88FF1', '#9292F1', '#81DCC2','#8DE478'
];
//evento cuando se termina de pintar un punto.
function doneHandlerRadios(lineGeom) {
    //lineGeom.x, .y contiene lat long a proyección del mapa.
    var radios = $('select#consulta-focal-radios-control').val();
    var iterador = cantidadradios = radios.length;
    var point = new OpenLayers.Geometry.Point(lineGeom.x, lineGeom.y);
    while(iterador--) {
        radioactual = radios[iterador];
        radioactual = radioactual * 1000; //kms en metros.
        coloractual = estilosRadios[iterador];

        var sunpoly = OpenLayers.Geometry.Polygon.createRegularPolygon
            ( point, radioactual, 36, 0 );
        var suncircle = new OpenLayers.Feature.Vector(sunpoly, null, {
            fillColor: coloractual, fillOpacity: 0.2, strokeColor: "#1C1A0C", strokeOpacity: 1 });

        radioslayer.addFeatures([suncircle]);
        //vectors.addFeatures([point]);


    }
    var point_ft = new OpenLayers.Feature.Vector(point, null, null);
    ///agregar el punto que por alguna razon no se agrega solo...
    vectors.addFeatures([point_ft]);
}
function beforeFeatureAddedSenasaVert(addingfeature) {

    var herramientaactual = $('input[name=botones-consulta]:checked').val();
    if(herramientaactual == 'consulta-rectangulo' || herramientaactual == 'consulta-poligono'){

        var areaactual = addingfeature.feature.geometry.getArea();
        areaactual = areaactual / 1000000;
        if(areamaxima < areaactual){
            alert("El área a consultar sobrepasa el máximo permitido ("+areamaxima+" Kms2)");

            control = getControlActivo();
            control.undo();

            return false;
        }
    }
    return true;
}
function beforeFeatureAddedSenasa(addingfeature) {

    var herramientaactual = $('input[name=botones-consulta]:checked').val();
    if(herramientaactual == 'consulta-focal'){

    }
    if(herramientaactual == 'consulta-zona'){

    }
    if(herramientaactual == 'consulta-rectangulo' || herramientaactual == 'consulta-poligono'){
        //solo permitir uno.
        //area addingfeature.feature.geometry.getArea()
        var cantidad = vectors.features.length;
        if(cantidad >= 1){
            //limpiarDibujos();
            alert("Consulta restringida a un único polígono");
            return false;
        }
        var areaactual = addingfeature.feature.geometry.getArea();
        areaactual = areaactual / 1000000;
        if(areamaxima < areaactual){
            alert("El área a consultar sobrepasa el máximo permitido ("+areamaxima+" Kms2)");
            return false;
        }
    }
    return true;
}

function inicializarControles(){
    var renderer = OpenLayers.Util.getParameters(window.location.href).renderer;
    renderer = (renderer) ? [renderer] : OpenLayers.Layer.Vector.prototype.renderers;

    var defaultStyle = new OpenLayers.Style({
        fillColor: "#2082A2",
        fillOpacity: 0.7,
        strokeColor: "#1C1A0C",
        strokeOpacity: 1,
        strokeWidth: 1,
        pointRadius: 6
    });

    var selectStyle = new OpenLayers.Style({
        fillColor: "#76C9E4",
        fillOpacity: 0.7,
        strokeColor: "#23216F",
        strokeOpacity: 1,
        strokeWidth: 1,
        pointRadius: 6
        ,graphicName: "cross"
    });

    vectors = new OpenLayers.Layer.Vector("Vector Layer", {
        renderers: renderer
        ,styleMap: new OpenLayers.StyleMap({
            'default': defaultStyle,
            'select': selectStyle})
    });
    vectors.events.on({
        'featureselected': function(feature) {
            manejarSelectVector(feature);
        },
        'featureunselected': function(feature) {
            manejarDeselectVector(feature)
        }
    });

    map.addLayers([vectors]);
    vectors.setZIndex(1000);map.setLayerIndex(vectors, 1000);

    var options = {
        handlerOptions: {
            //freehand: true,
            style: {
                fillColor: "#76C9E4",
                fillOpacity: 0.7,
                strokeColor: "#23216F",
                strokeOpacity: 1,
                strokeWidth: 1,
                pointRadius: 6
            }
        }
    };

    control_poligono= new OpenLayers.Control.DrawFeature(
        vectors, OpenLayers.Handler.Polygon, options
    );
    control_box= new OpenLayers.Control.DrawFeature(vectors,
        OpenLayers.Handler.RegularPolygon, {
            handlerOptions: {
                sides: 4,
                irregular: true
                , style: options.handlerOptions.style
            }
        }
    );
    vectors.events.on({
        'beforefeatureadded': beforeFeatureAddedSenasa
        ,'featuremodified': beforeFeatureAddedSenasaVert
        ,'vertexmodified': beforeFeatureAddedSenasaVert
    });

    options.callbacks = {
        "done": doneHandlerRadios
    };
    control_punto= new OpenLayers.Control.DrawFeature(
        vectors, OpenLayers.Handler.Point, options
    );

    control_box.handler.style = options.handlerOptions.style
    modify= new OpenLayers.Control.ModifyFeature(vectors)
    controlesselect = {'control_punto': control_punto, 'control_poligono': control_poligono, 'control_box': control_box,'modify': modify};

    for(key in controlesselect) {

        var control = controlesselect[key];
        map.addControl(control);
        control.deactivate();
    }

    OpenLayers.Event.observe(document, "keydown", function(evt) {
        var handled = false;
        switch (evt.keyCode) {
            case 90: // z
                if (evt.metaKey || evt.ctrlKey) {
                    control = getControlActivo();
                    control.undo();
                    handled = true;
                }
                break;
            case 89: // y
                if (evt.metaKey || evt.ctrlKey) {
                    control = getControlActivo();
                    control.redo();
                    handled = true;
                }
                break;
            case 27: // esc
                control = getControlActivo();
                control.cancel();
                handled = true;
                break;
            case 46: //del
                if(modificando){
                    currentfeature = vectors.selectedFeatures[0]
                    controlesselect.modify.unselectFeature();
                    vectors.destroyFeatures([currentfeature]);
                }
                break;
        }
        if (handled) {
            OpenLayers.Event.stop(evt);
        }
    });

}
function getControlActivo(){
    map.setLayerIndex(vectors, 1000);vectors.setZIndex(1000);
    var activoactual = false;
    for(key in controlesselect) {
        var control = controlesselect[key];
        if(control.active)
            return control;
    }
    return activoactual;
}
function desactivarControlesSeleccion(){
    for(key in controlesselect) {
        var control = controlesselect[key];
        control.deactivate();
    }
}
function desactivarTodosControles(){
    desactivarControlesSeleccion();
    addaxcontrol.deactivate();
}
var modificando = false;
function modificarElemento(){

    activoactual = getControlActivo();
    if ( $('#modificar-elemento').is(":checked") ){
        //activar modificacion. Desactivar controles.

        if(!activoactual){
            $('#modificar-elemento').removeAttr('checked');
            $('#modificar-elemento').button('refresh');
            modificando = false;
        }else{
            desactivarTodosControles();
            controlesselect.modify.activate();
            modificando = true;
        }
    }else{
        if(!activoactual){
            modificando = false;
        }else{
            desactivarTodosControles();
            activarConsultaGeografica();
        }
        modificando = false;
    }


}
function manejarSelectVector(feature){

}
function manejarDeselectVector(feature){

}

function vectorFeaturesToJson(){
    var consulta={};
    var herramientaactual = $('input[name=botones-consulta]:checked').val();
    if(!capasManuales[0]){
        alert('Debe seleccionar un tipo de mapa.'); return false;
    }
    var capaactual = capasManuales[0].params.LAYERS;//todo: considerar más de una capa manual??
    if(!capaactual){
        alert('Debe seleccionar un tipo de mapa.'); return false;
    }
    var capaparams = capasManuales[0].params.VIEWPARAMS;
    consulta={'tipo':herramientaactual, 'capaactual': capaactual, 'viewparams': capaparams};
    if(herramientaactual == 'consulta-zona'){
        //En este no se generan features.
        provincia = $('#provincia').val();
        canton = $("#canton").find(":selected").attr("canton");
        distrito = $("#distrito").find(":selected").attr("distrito");
        consulta.zona = {'provincia': provincia, 'canton': canton, 'distrito': distrito};//zona seleccionada. Segun si hay distrito, provincia o canton.
        if(provincia == '' && canton == '' && distrito == ''){
            alert('Por favor seleccione al menos una provincia para consultar');
            consulta = false;
        }
    }else{
        consulta.features = [];
        if(herramientaactual == 'consulta-rectangulo' || herramientaactual == 'consulta-poligono'){
            if(vectors.features.length == 0){
                alert('Por favor seleccione un área de consulta');
                consulta = false;
            }else{
                for(key in vectors.features) {

                    var puntosactual = [];
                    featureactual = vectors.features[key];
                    var components = featureactual.geometry.components[0].components;
                    for(components_id in components) {
                        curr_component = components[components_id].clone();
                        curr_component = curr_component.transform(new OpenLayers.Projection("EPSG:900913"), new OpenLayers.Projection("EPSG:4326"));

                        var datosactual = {};
                        datosactual['x'] = curr_component.x;
                        datosactual['y'] = curr_component.y;
                        puntosactual.push(datosactual);
                    }
                    consulta.features.push( puntosactual );
                }
            }


        }else if(herramientaactual == 'consulta-focal'){
            if(vectors.features.length == 0){
                alert('Por favor seleccione un área de consulta');
                consulta = false;
            }else{
                var herramientaactual = $('input[name=botones-consulta]:checked').val();
                consulta={'tipo':herramientaactual, 'capaactual': capaactual, 'viewparams': capaparams};
                consulta.features = [];
                for(key in vectors.features) {

                    var datosactual = {};
                    featureactual = vectors.features[key];
                    var curr_component = featureactual.geometry.clone();
                    curr_component = curr_component.transform(new OpenLayers.Projection("EPSG:900913"), new OpenLayers.Projection("EPSG:4326"));

                    datosactual['x'] = curr_component.x;
                    datosactual['y'] = curr_component.y;



                    consulta.features.push( datosactual );
                }
                var radios = $('select#consulta-focal-radios-control').val();
                consulta.radios = radios//[1,3,5,7];//t-odo: Esto se debe pedir al usuario
            }

        }
    }
    return consulta;

}


function ejecutarSeleccionConsulta(){

    var featuresinfo = vectorFeaturesToJson();
    if(featuresinfo == false){
        return featuresinfo;
    }
    $('div#resultadosholder').html("Cargando...<br /><img src='images/loading.gif' alt='loading gif'>");
    $('div#resultadosholder').show();

    var jqxhr = $.post( "/zf_Central/Popup/consultazonaestablecimientos", featuresinfo, function(data) {
            $('div#resultadosholder').html(data);

            $("div.datosestablecimiento").tabs();
            var herramientaactual = $('input[name=botones-consulta]:checked').val();
            if(herramientaactual == 'consulta-focal'){
                /*$( "div#resultados-geografica-categorizacion-cantidad" ).accordion({
                    collapsible: true, active:false
                });*/
                /*$( "div.resultados-geografica-senasa-radios" ).accordion({
                    collapsible: true, active:0
                });*/
                /*
                $( "div.radios-holder" ).accordion({
                    collapsible: true, active:false
                });*/

            }else{
                /*$( "div#resultados-geografica-categorizacion-cantidad" ).accordion({
                    collapsible: true, active:false
                });*/
                /*
                $( "div#resultados-geografica-senasa" ).accordion({
                    collapsible: true, active:0
                });*/
            }


            $("#resultados-consulta").tabs();
            $('div#resultadosholder select').attr('style', 'width: 200px;');
            $('div#resultadosholder select').select2();
        },'html'
    );
}
function mostrarResultadoConsulta(resultados){

}


function toogleResultadosView(){
    $('div.resultadosholder-button').toggleClass( "active" );
    //$('div#filtrosholder').toggle( "fast");
    $('div#resultadosholder').slideToggle( "fast" );
}

function agregarPuntoFocalNumero(){
    //validar y luego.

    //-87.10188808820847 - -82.5528466684191 long
    //5.498559956512215 - 11.219773428777373 lat

    var lat = longitud = 0;
    lat = $('input#consulta-focal-input-latitud').val();
    longitud = $('input#consulta-focal-input-longitud').val();
    if(
        lat < 5.498559956512215  || lat > 11.219773428777373
        || longitud < -87.10188808820847 || longitud >  -82.5528466684191
        ){
        alert("Los puntos geográficos están fuera de la extensión de Costa Rica");
        return false;
    }
    addFocoByLatLong(lat, longitud);
}
function addFocoByLatLong(lat, long, capa){
    var point = new OpenLayers.Geometry.Point(long, lat);
    point = point.transform( new OpenLayers.Projection("EPSG:4326") , new OpenLayers.Projection("EPSG:900913"));
    var point_ft = new OpenLayers.Feature.Vector(point, null, null);
    if(capa){
        capa.addFeatures(point_ft);
    }else{

        vectors.addFeatures(point_ft);
    }
}
var capasbusqueda = [];
var busqueda_establecimientos = 0;
capasbusqueda[busqueda_establecimientos] = null;

function navegarEstablecimiento(){
    var codigo = $('input#navegacion-cod-establecimiento').val();
    var featuresinfo = {
        'codigo': codigo
    }
    var renderer = OpenLayers.Util.getParameters(window.location.href).renderer;
    renderer = (renderer) ? [renderer] : OpenLayers.Layer.Vector.prototype.renderers;
    if(capasbusqueda[busqueda_establecimientos] == null){
        var estiloBusqueda = new OpenLayers.Style({
            fillColor: "#C87E2D",
            fillOpacity: 0.7,
            strokeColor: "#AB9858",
            strokeOpacity: 1,
            strokeWidth: 1,
            pointRadius: 5
        });
        capasbusqueda[busqueda_establecimientos] = new OpenLayers.Layer.Vector("Busqueda Vector Layer", {
            renderers: renderer
            ,styleMap: new OpenLayers.StyleMap({
                'default': estiloBusqueda,
                'select': estiloBusqueda})
        });
        map.addLayer(capasbusqueda[busqueda_establecimientos]);
    }else{
        var capa = capasbusqueda[busqueda_establecimientos];
        capa.destroyFeatures();
    }
    var jqxhr = $.post( "/zf_Central/Popup/consultarubicacionestablecimiento", featuresinfo, function(data) {
            if(data.result){
                $('#navegacion-cod-establecimiento-limpiar').show();
                var mapcenter2= new OpenLayers.LonLat(data.data.longitud, data.data.latitud);
                mapcenter2 = (mapcenter2.transform(
                    new OpenLayers.Projection("EPSG:4326"),
                    map.getProjectionObject()
                ));
                map.setCenter(mapcenter2);
                var zoomlevel = 16;
                map.zoomTo(zoomlevel);


                addFocoByLatLong(data.data.latitud, data.data.longitud, capasbusqueda[busqueda_establecimientos]);

                overridecapa = 'establecimientos';
                var params = {'QUERY_LAYERS': overridecapa} ;
                var eventoactual = {feature: {}};
                data.data.params = params;
                eventoactual.feature = {geometry: {}, data: data.data };
                eventoactual.feature.geometry = {x: mapcenter2.lon, y: mapcenter2.lat}
                querylayerwfspoint(eventoactual, overridecapa, params);

            }else{
                alert("No se encuentra el establecimiento buscado")
            }
        },'json'
    );
}
function limpiarBusquedaEstablecimientos(){
    var capa = capasbusqueda[busqueda_establecimientos];
    capa.destroyFeatures();
    this.map.removePopup(map.popups[0]);
    $('#navegacion-cod-establecimiento-limpiar').hide();
}

function cambiarPresetControl(){
    var presetactual = $('select#consulta-focal-radios-niveles-presets-control').val();
    if(presetactual){
        presetactual = presetactual.split(',');
        $("select#consulta-focal-radios-control").val(presetactual);
    }else{
        $("select#consulta-focal-radios-control").val(0);
    }
    $("select#consulta-focal-radios-control").select2('destroy');
    $("select#consulta-focal-radios-control").select2({
        maximumSelectionLength: 6
        ,placeholder: "Radios de consulta focal"

    })
}

function actualizarSelectorGoogleMaps(tipoactual){

    if(!tipoactual)
        tipoactual = $('select#googlemap-types-selector').val();
    if(tipoactual && tipoactual != ''){
        gsat.type = tipoactual;
        gsat.redraw()
    }
}