

function setSimpleView()
{
	var url, transparent, format;
	url = globals["default"]["service"] + "?map=" + getValueToUse(mapsdata[mapActual]["simpleview"], "map","layers");
	transparent = getValueToUse(mapsdata[mapActual]["simpleview"], "transparent","layers");
	format = getValueToUse(mapsdata[mapActual]["simpleview"], "format","layers");
	var layer = new OpenLayers.Layer.WMS(
		mapActual,
        url,
		{
			"layers": mapsdata[mapActual]["simpleview"]["layers"]
			, "transparent": transparent
			, "format": format
		}
		,
		{
			"isBaseLayer": true
			, "buffer" :1
		}
	);
	map.addLayer(layer);
	configureMap();
}

function setAdvanceView()
{
	var url, layers, transparent, format, base, visibility, group, readable, buffer;
	base = mapsdata[mapActual]["base"];
	url = globals["default"]["service"] + "?map=" + mapsdata["bases"][base]["map"];
	layers = mapsdata["bases"][base]["layers"];
	transparent = mapsdata["bases"][base]["transparent"];
	format = mapsdata["bases"][base]["format"];
	readable = mapsdata["bases"][base]["readable"];
	var base = new OpenLayers.Layer.WMS(
		base,
	    url,
		{
			"layers": layers
			, "transparent": transparent
			, "format": format
		}
		,
		{
			"isBaseLayer": true
			, "buffer" : 2
			, "readable": readable
		}
	);
	map.addLayer(base);
	for(var i in mapsdata[mapActual]["layers"])
	{
		//group = mapsdata[mapActual]["layers"][i];
		try
		{
			group = mapsdata["layers"][i]["layers"];
		}
		catch(e)
		{
			//console.log(i);
		}
		group = i;
		for(var j in mapsdata["layers"][group]["layers"])
		{
			url = getValueForLayerGroup(group, j, "service") + "?map=" + getValueForLayerGroup(group, j, "map");
			transparent = getValueForLayerGroup(group, j, "transparent");
			format = getValueForLayerGroup(group, j, "format");
			base = getValueForLayerGroup(group, j, "base");
			visibility = getValueForLayerGroup(group, j, "visibility");
			buffer = getValueForLayerGroup(group, j, "buffer");
			layers = getValueForLayerGroup(group, j, "layers");
			var layer = new OpenLayers.Layer.WMS(
				j
				, url
				, {
					"layers": layers
					, "transparent": transparent
					, "format": format
				}
				,
				{
					"isBaseLayer": base
					, "buffer" : buffer
					, "group" : group
				}
			);
			layer.setVisibility(visibility);
			map.addLayer(layer);
		}
	}
	configureMap();
}

function getValueForLayerGroup(group, layer, data)
{
	if(typeof(mapsdata[mapActual]["layers"][group][data]) != 'undefined' && typeof(mapsdata[mapActual]["layers"][group][data]) != 'function' && mapsdata[mapActual]["layers"][group][data] !== "")
	{
		return mapsdata[mapActual]["layers"][group][data];
	}
	else if(typeof(mapsdata["layers"][group]["layers"][layer][data]) != 'undefined' && typeof(mapsdata["layers"][group]["layers"][layer][data]) != 'function' && mapsdata["layers"][group]["layers"][layer][data] !== "")
	{
		return mapsdata["layers"][group]["layers"][layer][data];
	}
	else if(typeof(mapsdata["layers"][group][data]) != 'undefined' && typeof(mapsdata["layers"][group][data]) != 'function' && mapsdata["layers"][group][data] !== "")
	{
		return mapsdata["layers"][group][data];
	}
	else
	{
		return globals["default"][data];
	}
}
function getValueToUse(layer, data, type)
{
	if(typeof(layer[data]) != 'undefined' && typeof(layer[data]) != 'function' && layer[data] !== "")
	{
		return layer[data];
	}
	else
	{
		return mapsdata[mapActual]["default"][type][data];
	}
}

function configureMap()
{
	var maxExtent;
	//console.log(maxExtent);
	//console.log(mapActual);
	try
	{
		map.setCenter((mapsdata[mapActual]["maxextent"]).getCenterLonLat());
//		map.setOptions({"maxExtent": mapsdata[mapActual]["maxextent"]});
		map.zoomToExtent(mapsdata[mapActual]["maxextent"]);
	}
	catch(err){}
}

