

function initSelectableList()
{
	if(mapsdata[mapActual]["selectable"])
	{
		var defGroup = mapsdata[mapActual]["selectable"]["default"]["group"];
		var defLayers = mapsdata[mapActual]["selectable"]["default"]["layer"];
		setSelectableValues(defGroup, defLayers);
	}
	$("#selectablecontentadvance").html("");
	var group = null;
	for(var i in mapsdata[mapActual]["selectable"]["groups"])
	{
		group = mapsdata[mapActual]["selectable"]["groups"][i];
		if(!mapsdata["layers"][group]["selectable"])
		{
			continue;
		}
		var collapsibleHtml = "	<div data-role=\"collapsible\" id=\"selectable_"+group+"\">";
		collapsibleHtml += "		<h3>"+mapsdata["layers"][group]["readable"]+"</h3>";
		collapsibleHtml += "	</div>";
		$("#selectablecontentadvance").prepend(collapsibleHtml);
		for(var j in mapsdata["layers"][group]["layers"])
		{
			if(!mapsdata["layers"][group]["layers"][j]["selectable"])
			{
				continue;
			}
			var selectlayerHtml = "<input type=\"radio\" name=\"selectlayer\" theme=\"a\" id=\"selectlayer_"+group+"_"+j+"\" value=\""+group+"_"+j+"\" class=\"selectlayer\"";
			if(group == mapsdata[mapActual]["selectable"]["default"]["group"] && j == mapsdata[mapActual]["selectable"]["default"]["layer"])
			{
				selectlayerHtml += " checked";
			}
			selectlayerHtml += " />";
			selectlayerHtml += "<label theme=\"a\" for=\"selectlayer_"+group+"_"+j+"\">" + mapsdata["layers"][group]["layers"][j]["readable"] + "</label>";
			//$(selectlayerHtml).prependTo("#selectable_"+group);
			$(selectlayerHtml).appendTo("#selectable_"+group);
			$("#selectlayer_"+group+"_"+j).click(function()
			{
				selectableChange($(this).attr("id"));
			});
		}
		if(typeof $("#selectable_"+group).collapsible == 'function'){
			$("#selectable_"+group).collapsible();
		}
		
		if(typeof $("#selectable_"+group).buttonset == 'function'){
			$("#selectable_"+group).buttonset();
		}
		
		
	}
}

function selectableChange(id)
{
	var values = id.split("_");
	setSelectableValues(values[1], values[2]);
	
	if(typeof $.mobile == 'function'){
		$.mobile.changePage("#mappage");
	} 
}

function setSelectableValues(group, layers)
{
	var map = mapsdata["layers"][group]["map"];
	var layer = mapsdata["layers"][group]["layers"][layers]["selectable"];
	if(typeof(mapsdata["layers"][group]["layers"][layers]["popup"]) == "undefined" || mapsdata["layers"][group]["layers"][layers]["popup"] == null)
	{
		addaxcontrol.selectlocation.popupClass = null;
	}
	else
	{
		addaxcontrol.selectlocation.popupClass = mapsdata["layers"][group]["layers"][layers]["popup"];
	}
	addaxcontrol.selectlocation.layer = {"map": map, "layer": layer};
}



