<?php
// ======================================================================
// AddaxGroups by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxGroups
 * ADDAX Group Administration
 * 
 * Funciones de usuario.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxGroups
 * @author      erodriguez
 * ======================================================================
 */ 

 
/**
 * Agrega los scripts necesarios para que puedan ser usados por este modulo 
 */

function AddaxGroups_additionalheaders()
{
	// Use PostNuke variable for insertion of special HTML header tags.
	$themename = pnUserGetTheme();
	global $additional_header;
	
	$additional_header[] = "<link rel=\"stylesheet\" href=\"/javascript/addax/jquery/plugins/jquery.autocomplete.css\" type=\"text/css\" media=\"screen\" />";
	$additional_header[] = "<script type='text/javascript' src='/javascript/addax/jquery/plugins/jquery.autocomplete.js'></script>";
	$additional_header[] = "<script type='text/javascript' src='/javascript/addax/jquery/plugins/jquery.bgiframe.min.js'></script>";

}

/**
 * Despliegue del ususario 
 */


function AddaxGroups_user_adminGroupMembership()
{        
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    $pnRender =& new pnRender('AddaxGroups');
    	AddaxGroups_additionalheaders();

       $res = pnModAPIFunc("AddaxGroups", "user", "getGroupedUsers");
       $res2 = pnModAPIFunc("AddaxGroups", "user", "getGroups");
       $res3 = pnModAPIFunc("AddaxGroups", "user", "getUsers");
       $pnRender->assign('groupedUsers',$res);  
       $pnRender->assign('groups',$res2); 
       $pnRender->assign('users',$res3); 
	return $pnRender->fetch('AddaxGroups_user_main.htm');
} 

/**
 * Funcion principal de usuario
 */

// function AddaxGroups_user_generateCheckboxes(){
// 	//Saco los usuarios que pertenescan a algun grupo en particular
// 	$userGroups = pnModAPIFunc("AddaxGroups", "user", "getGroupedUsers", $params);
// }


/**
 * Cambia el estado de pertenencia de un usuario 
 */

function AddaxGroups_user_changeUserGroupState(){
     if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
         return pnVarPrepHTMLDisplay(_MODULENOAUTH);
     }
	//Tomo los parametros 
	$groupid = pnVarCleanFromInput("GroupID");
	$userid = pnVarCleanFromInput("UserID");
	$status = pnVarCleanFromInput("Status"); 
	$params = array(
			"groupid" => $groupid, 
			"userid" => $userid, 
			"status" => $status
			); 
	
	$result = pnModAPIFunc("AddaxGroups", "user", "setUserGroupState", $params); 
	error_log("Resultado de la consulta: $result"); 


	$result_array = array('result' => $result, 
				'uid' => $userid, 
				'gid' => $groupid); 


	error_log("Result:". ($result?"true":"false")." UID: $userid GID: $groupid");

	//Encabezado por si el browser es MSIE 
    	if ($browser=="msie 6.0"){
	        header("Content-Type: text/html; charset=iso-8859-1" );
    	}
	$str_result = json_encode($result_array);
	return $str_result; 
}

/**
 * Llena el textbox del autocomplete 
 */

function AddaxGroups_user_getPlayers(){
     if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
         return pnVarPrepHTMLDisplay(_MODULENOAUTH);
     }
	//SQL Inyection?
	$q = strtolower($_GET["q"]);
	if (!$q){ return true;}
	$items = pnModAPIFunc('AddaxGroups', 'user', 'getPlayers');
 	//error_log("q: $q");
	foreach ($items as $key=>$value) {
 		//error_log("$key|$value");
		if (strpos(strtolower($value), $q) !== false) {
			echo "$value|$key\n"; 
	 		//error_log("Match: $key|$value");
		}
	}
	return true; 
}

?>
