<?php
// ======================================================================
// AddaxGroups by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxGroups
 * ADDAX Group Administration
 * 
 * API con las funciones de usuario.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxGroups
 * @author      erodriguez
 * ======================================================================
 */
 
/**
 * Devuelve los usuarios con su asociacion al grupo 
 */
define('GRUPO_DEFECTO','Users');

function AddaxGroups_userapi_getGroupedUsers(){
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
	$dbconn =& pnDBGetConn(true);

	//Por ahora supongo que vienen de un textbox separado por puntos y comas
	$textBox = pnModGetVar("AddaxGroups", "selectedgroups"); 
	//error_log("Valor del textbox: $textBox"); 
	$groupNames = explode(";", $textBox); 
	$groupNames[] = GRUPO_DEFECTO; 

	$prefix = pnConfigGetVar('prefix', '');
	if($prefix)
		$prefix = $prefix . "_";
	
	//Estructura donde se guardan todos los usuarios y su respectivo estado 
   	for($i = 0; $i < count($groupNames); $i++) {
		if($i == 0){
 			$whereClause .= " ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
		}
		else {
			$whereClause .= "OR ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 	
		}
   	}
	
	//Consulta que devuelve cada usuario y su grupo asociado 
	$sql = "SELECT ".$prefix."users.pn_uid, ".$prefix."groups.pn_gid FROM ".$prefix."users, ".$prefix."group_membership, ".$prefix."groups WHERE ".$prefix."users.pn_uid = ".$prefix."group_membership.pn_uid AND ".$prefix."group_membership.pn_gid = ".$prefix."groups.pn_gid AND ($whereClause) ORDER BY ".$prefix."users.pn_uid, ".$prefix."groups.pn_gid"; 

	error_log("SQL GROUPING: $sql"); 
	$result = $dbconn->Execute($sql);


	//Validacion
	if ($dbconn->ErrorNo() != 0) {
        	pnSessionSetVar('addaxgroupserrormsg', pnVarPrepHTMLDisplay(AA_DATABASEERROR));
        	error_log("DB Error: ".$dbconn->ErrorMsg());
        	return false;
    	}


	//E.D. que guarda el resultado de la consulta 

	$primeraVez = 1; 
	$arrAux = array(); 

	for (; !$result->EOF; $result->MoveNext()) {
		//error_log("UID: $uid GID: $gid");  
		list($uid,$gid) = $result->fields;
		if((!$primeraVez)&&($aux != $uid)) {
			$asoc[$aux] = $arrAux; 
			$arrAux = array(); 
		}
		$arrAux[$gid] = 1; 
		$aux = $uid; 
		$primeraVez = 0; 
	}

	//Ultimo elemento! 
	$asoc[$aux] = $arrAux; 



	$result->Close();

	return $asoc; 
}

/**
 * Devuelve los grupos 
 */

function AddaxGroups_userapi_getGroups(){
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

	$dbconn =& pnDBGetConn(true);

	//Por ahora supongo que vienen de un textbox separado por puntos y comas
	$textBox = pnModGetVar("AddaxGroups", "selectedgroups"); 
	//error_log("Valor del textbox: $textBox"); 
	$groupNames = explode(";", $textBox); 
	
	$prefix = pnConfigGetVar('prefix', '');
	if($prefix)
		$prefix = $prefix . "_";

	//Estructura donde se guardan todos los usuarios y su respectivo estado 
   	for($i = 0; $i < count($groupNames); $i++) {
		if($i == 0){
 		$whereClause .= " ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		} else {
		$whereClause .= "OR ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		}
   	}

	//Consulta que devuelve cada usuario y su grupo asociado 
	$sql = "SELECT ".$prefix."groups.pn_gid, ".$prefix."groups.pn_name FROM ".$prefix."groups WHERE $whereClause ORDER BY ".$prefix."groups.pn_gid"; 

	//error_log("SQL imp: $sql"); 
	$result = $dbconn->Execute($sql);


	//Validacion
	if ($dbconn->ErrorNo() != 0) {
        	pnSessionSetVar('addaxgroupserrormsg', pnVarPrepHTMLDisplay(AA_DATABASEERROR));
        	error_log("DB Error: ".$dbconn->ErrorMsg());
        	return false;
    	}

	//E.D. que guarda el resultado de la consulta 
	$groups = array();
	for (; !$result->EOF; $result->MoveNext()) {
		list($gid,$groupname) = $result->fields;
		$groups[$gid] = $groupname; 
	}
	$result->Close();

	return $groups; 
}

/**
 * Devuelve los usuarios
 */

function AddaxGroups_userapi_getUsers(){
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

	$dbconn =& pnDBGetConn(true);

	//Por ahora supongo que vienen de un textbox separado por puntos y comas
	$textBox = pnModGetVar("AddaxGroups", "selectedgroups"); 
	//error_log("Valor del textbox: $textBox"); 
	$groupNames = explode(";", $textBox); 
	$groupNames[] = GRUPO_DEFECTO; 
	
	$prefix = pnConfigGetVar('prefix', '');
	if($prefix)
		$prefix = $prefix . "_";

	//Estructura donde se guardan todos los usuarios y su respectivo estado 
   	for($i = 0; $i < count($groupNames); $i++) {
 		if($i == 0){
  		$whereClause .= " ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		} else {
		$whereClause .= "OR ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		}
   	}

	//Consulta que devuelve cada usuario y su grupo asociado 
	$sql = "SELECT ".$prefix."users.pn_uid, ".$prefix."users.pn_uname, ".$prefix."users.pn_email, ".$prefix."users.pn_email FROM ".$prefix."users, ".$prefix."group_membership, ".$prefix."groups WHERE ".$prefix."users.pn_uid = ".$prefix."group_membership.pn_uid AND ".$prefix."group_membership.pn_gid = ".$prefix."groups.pn_gid AND ($whereClause) AND ".$prefix."users.pn_uid <> 1 ORDER BY ".$prefix."users.pn_uid"; 

	error_log("get usrs SQL: $sql"); 
	$result = $dbconn->Execute($sql);


	//Validacion
	if ($dbconn->ErrorNo() != 0) {
        	pnSessionSetVar('addaxgroupserrormsg', pnVarPrepHTMLDisplay(AA_DATABASEERROR));
        	error_log("DB Error: ".$dbconn->ErrorMsg());
        	return false;
    	}

	//E.D. que guarda el resultado de la consulta 
	$users = array();
	for (; !$result->EOF; $result->MoveNext()) {
		list($uid,$name,$email,$femail) = $result->fields;
		$arr = array("name" => $name, "email" => $email, "teamname" => $femail); 
		$users[$uid] = $arr;
		//error_log("User $uid: $name");  
	}
	$result->Close();
	return $users; 
}

/**
 * Cambia el estado de asociacion entre un usuario y un grupo 
 */

function AddaxGroups_userapi_setUserGroupState($params){
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
	extract($params); 
	$dbconn =& pnDBGetConn(true);
	$prefix = pnConfigGetVar('prefix', '');
	if($prefix)
		$prefix = $prefix . "_";
		
	if($status){
		$sql = "INSERT INTO ".$prefix."group_membership (pn_uid, pn_gid) VALUES ($userid, $groupid)"; 
	
	} else {
		$sql = "DELETE FROM ".$prefix."group_membership WHERE pn_uid = $userid AND pn_gid = $groupid"; 
	}

	error_log("SQL: $sql"); 
	$result = $dbconn->Execute($sql);


	//Validacion
	if ($dbconn->ErrorNo() != 0) {
        	pnSessionSetVar('addaxgroupserrormsg', pnVarPrepHTMLDisplay(AA_DATABASEERROR));
        	error_log("DB Error: ".$dbconn->ErrorMsg());
        	return false;
    	}
	return true; 
}

/**
 * Devuelve los usuarios
 */

function AddaxGroups_userapi_getPlayers(){
    if (!pnSecAuthAction(0, 'AddaxGroups::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
	$dbconn =& pnDBGetConn(true);

	$prefix = pnConfigGetVar('prefix', '');
	if($prefix)
		$prefix = $prefix . "_";

	//Por ahora supongo que vienen de un textbox separado por puntos y comas
	$textBox = pnModGetVar("AddaxGroups", "selectedgroups"); 
	//error_log("Valor del textbox: $textBox"); 
	$groupNames = explode(";", $textBox); 


	//Estructura donde se guardan todos los usuarios y su respectivo estado 
   	for($i = 0; $i < count($groupNames); $i++) {
 		if($i == 0){
  		$whereClause .= " ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		} else {
		$whereClause .= "OR ".$prefix."groups.pn_name = \"". $groupNames[$i]. "\" "; 
 		}
   	}

		//WHERE pn_users.pn_uid = pn_group_membership.pn_uid AND pn_group_membership.pn_gid = pn_groups.pn_gid AND ($whereClause)"; 

   	$sql = "SELECT ".$prefix."users.pn_uid, ".$prefix."users.pn_uname, ".$prefix."users.pn_email
  		FROM ".$prefix."users, ".$prefix."group_membership, ".$prefix."groups 
		WHERE ".$prefix."users.pn_uid = ".$prefix."group_membership.pn_uid AND ".$prefix."group_membership.pn_gid = ".$prefix."groups.pn_gid "; 

// 	$sql = "SELECT pn_users.pn_uid, pn_users.pn_name, pn_users.pn_email, pn_users.pn_femail
// 	FROM pn_users DISJOIN pn_group_membership ON pn_users.pn_uid = pn_group_membership.pn_uid
// 	DISJOIN pn_groups.pn_gid ON pn_groups.pn_gid = pn_group_membership.pn_uid AND ($whereClause)";
/*
$sql = "SELECT u.pn_uid, u.pn_name, u.pn_email, u.pn_femail
 		FROM pn_users u, pn_group_membership ug
		WHERE u.pn_uid = ug.pn_uid AND ug.pn_gid NOT IN (
			SELECT g.pn_gid
			FROM pn_groups g
			WHERE $whereClause)";*/
		

	error_log("SQL: $sql"); 


	$result = $dbconn->Execute($sql);

	if ($dbconn->ErrorNo() != 0) {
        	pnSessionSetVar('fantasyreportserrormsg', pnVarPrepHTMLDisplay(AA_DATABASEERROR));
        	error_log("DB Error: ".$dbconn->ErrorMsg());
        	return false;
    	}

	// Check for no rows found, and if so return
	if ($result->EOF) {
        	return false;
	}

	$items = array();
	for (; !$result->EOF; $result->MoveNext()) {
		list($id,$name,$email,$privatename) = $result->fields;
		$items[$id] = "$name - $email - $privatename"; 
	}
	$result->Close();
	return $items; 
}

?>
