<?php
// ======================================================================
// AddaxNewUser by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxNewUser
 * Modulo de usuarios
 * 
 * Funciones de usuario.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxNewUser
 * @author      addax
 * ======================================================================
 */ 
if (!defined("_AQ_OK")) define('_AQ_OK',1);
if (!defined("_AQ_NOK")) define('_AQ_NOK',-1);

/**
 * Funcion principal de usuario
 */
function AddaxNewUser_user_main()
{        
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
      
    $pnRender =& new pnRender('AddaxNewUser');

    return $pnRender->fetch('AddaxNewUser_user_main.htm');
}
/**
 * Presenta el formulario de registro de nuevo usuario
 */
function AddaxNewUser_user_register()
{

    if (!pnSecAuthAction(0, 'AddaxNewUser::', 'register::', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    
    // new by class007
    if (!pnConfigGetVar('reg_allowreg')) {
        $echo ='<strong>' . _REGISTERDISABLED . '</strong><br />' ;
        // show reasons only when entered
        $reg_noregreasons = pnConfigGetVar('reg_noregreasons');
        if (strlen(trim($reg_noregreasons)) > 0) {
        $echo.= '<br /><strong>' . _REASONS . "</strong><br />&nbsp;&nbsp;&nbsp;&nbsp;" . pnVarPrepForDisplay($reg_noregreasons) . '<br />';
        }
        return $echo;
    }

    //el mail sera el mismo nombre de usuario?
    $emailasuser = pnModGetVar('AddaxNewUser', 'emailasuser');
    if (isset($emailasuser) && $emailasuser){
        $getuname = false;
    }
    else{
        $getuname = true;
    }

    //Averigua si es usa activacion de cuenta y si estamos en preregistro
    $preregistro = false;
    $accountactivation = pnModGetVar('AddaxNewUser', 'accountactivation');
    if ($accountactivation){
        if (!(pnModLoad('AccountActivation','user'))){
            return pnVarPrepHTMLDisplay(ACCOUNTACTIVATION_NOTAVAILABLE);
        }
        //Obtiene el numero de dias pendientes para abrir el sitio
        $pendingdays = pnModAPIFunc('AccountActivation', 'user', 'daysPending');
        $preregistro = ($pendingdays>0?true:false);
    }
    
    // generate the form authorisation key
    // added to prevent multiple automated signups - markwest
    $authid = pnSecGenAuthKey();

    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->assign('size', 100);    
    $pnRender->assign('get_username',$getuname);
    $pnRender->assign('reg_optitems',pnConfigGetVar('reg_optitems'));
    $pnRender->assign('reg_verifyemail',pnConfigGetVar('reg_verifyemail'));
    $pnRender->assign('preregistro', $preregistro);
    $pnRender->assign('legal',pnModAvailable("legal"));
    $pnRender->assign('url_legal',pnVarPrepForDisplay(pnModURL('legal')));
    $pnRender->assign('url_legal_user_privacy',pnVarPrepForDisplay(pnModURL('legal', 'user', 'privacy')));
    return $pnRender->fetch('AddaxNewUser_user_register.htm');
}

/**
 * Completa el registro del nuevo usuario
 */
function AddaxNewUser_user_finishnewuser($var)
{

    // confirm the form authorisation key
    // added to prevent multiple automated signups - markwest
    /*
	if (!pnSecConfirmAuthKey()) {
      echo _BADAUTHKEY;
      include 'footer.php';
      exit;
    }*/
    global $browser;
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();
    $column = &$pntable['users_column'];

    list($agreetoterms,
         $uname,
         $name,
         $email,
         $femail,
         $vemail,
         $browser) = pnVarCleanFromInput('agreetoterms',
                                        'uname',
                                        'realname',
                                        'email',
                                        'femail',
                                        'vemail',
                                        'browsername');

    $reg_optitems = pnConfigGetVar('reg_optitems');

    if ($reg_optitems) {
        list($name,
             $url,
             $bio,
             $user_avatar,
             $user_icq,
             $user_occ,
             $user_from,
             $user_intrest,
             $user_sig,
             $user_aim,
             $user_yim,
             $user_msnm,
             $user_viewemail,
             $timezoneoffset,
             $dynadata) = pnVarCleanFromInput('realname',
                                              'url',
                                              'bio',
                                              'user_avatar',
                                              'user_icq',
                                              'user_occ',
                                              'user_from',
                                              'user_intrest',
                                              'user_sig',
                                              'user_aim',
                                              'user_yim',
                                              'user_msnm',
                                              'user_viewemail',
                                              'timezoneoffset',
                                              'dynadata');
    }

    //Look for CHECKBOX VALUE HACK AND PROCESS IT TO CONFORM WITH POSTNUKE REGULAR DYNAMIC DATA
    $checkbox_properties = array();
    $fixeddynadata = array();
    if (!empty($dynadata) && is_array($dynadata)) 
    {
        foreach($dynadata as $key=>$value)
        {
            //error_log("Key to analize: $key => $value");
            if(ereg('-', $key))
            {
                if(!empty($value) && isset($value))
                {
                    $key_values = split('-', $key);
                    if(!isset($fixeddynadata[$key_values[0]]) || empty($fixeddynadata[$key_values[0]]))
                    {
                        $fixeddynadata[$key_values[0]] = $key_values[1];
                    }
                    else
                    {
                        $fixeddynadata[$key_values[0]] .= "," . $key_values[1];
                    }
                }
            }
            else
            {
                if(!empty($value) && isset($value))
                {
                    $fixeddynadata[$key] = $value;
                }
            }
        }
    }

    //Valida el nombre
    /*if (!isset($name) || $name=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(REALNAMEREQUIRED));
    }*/
    $firstname = $fixeddynadata['_FIRSTNAME'];
    if (empty($firstname) || $firstname ==""){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(FIRSTNAMEREQUIRED));
    }
    $lastname = $fixeddynadata['_LASTNAME'];
    if (empty($lastname) || $lastname ==""){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(LASTNAMEREQUIRED));
    }
    $name = trim($firstname).' '.trim($lastname);
    
    //Valida el team name
    $teamname = $fixeddynadata['_TEAMNAME'];
    if (empty($teamname) || $teamname ==""){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(TEAMNAMEREQUIRED));
    }
    if(ereg('[^A-Za-z0-9]', $teamname)){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(TEAMNAMEALPHANUMERIC));
    }
    //Valida que sea único
    $sql="SELECT COUNT(*) FROM $pntable[users] WHERE $column[femail]='".mysql_real_escape_string($teamname)."'";
    $result =& $dbconn->Execute($sql);
    if ($dbconn->ErrorNo() <> 0) {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(TEAMNAMEREQUIRED));
    }
    else{
        list($count) = $result->fields;
        $result->Close();
    }
    if ($count>0){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(TEAMNAMEUNIQUE));
    }
    $femail = $teamname;
    
    //Valida el correo
    if (!isset($email) || $email=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(CORRECTEMAIL));
    }
    //Si no se requiere verificar el email obtiene el password
    $reg_verifyemail = pnConfigGetVar('reg_verifyemail');
    if (!$reg_verifyemail) {
        list($pass, $vpass) = pnVarCleanFromInput('pass', 'vpass');
    }
    //Si el correo sera el mismo nombre de usuario
    $emailasuser = pnModGetVar('AddaxNewUser', 'emailasuser');
    if (isset($emailasuser) && $emailasuser){        
        $uname = $email;        
    }
    
    $adminmail = pnConfigGetVar('adminmail');
    $sitename = pnConfigGetVar('sitename');
    $siteurl = pnGetBaseURL();
    $Default_Theme = pnConfigGetVar('Default_Theme');
    $commentlimit = pnConfigGetVar('commentlimit');
    $storynum = pnConfigGetVar('storyhome');
    
    if (!$reg_optitems) {
        // if we don't show optional items
        // we should set the timezone based on site settings
        // and clear all other optional items
        $timezoneoffset = pnConfigGetVar('timezone_offset');
        $name = '';
        $femail = '';
        $url = '';
        $bio = '';
        $user_avatar = 'blank.gif';
        $user_icq = '';
        $user_occ = '';
        $user_from = '';
        $user_intrest = '';
        $user_sig = '';
        $user_aim = '';
        $user_yim = '';
        $user_msnm = '';
        $dynadata = '';
    }
    $minpass = pnConfigGetVar('minpass'); //by class007

    // add vpass and vemail check. by class007
    // TODO: remove it to userCheck() [class007]
    if ("$email" != "$vemail") {
        $stop = _EMAILSDIFF;
    }
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }
    
    if ((!empty($pass)) && ("$pass" != "$vpass")) {
        $stop = _PASSDIFFERENT;
    } elseif (($pass != "") && (strlen($pass) < $minpass)) {
        $stop = _YOURPASSMUSTBE . " $minpass " . _CHARLONG;
    } elseif (empty($pass) && !$reg_verifyemail) {
        $stop = _PASSWDNEEDED;
    } 
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }

    //valida la fecha de nacimiento
    $bthday = $fixeddynadata['_BTHDAY'];
    if (empty($bthday) || $bthday =="" || $bthday==_DATEPICKERMSG){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(BTHDAYREQUIRED));
    }

    //Obtiene el deposito inicial
    $initialdeposit = $fixeddynadata['_INITIALDEPOSIT'];
    $depositvalue = intval(substr($initialdeposit, strlen('_US')));
    if ($depositvalue < 0){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(DEPOSITVALUEINVALID));
    }
    
    $stop = userCheck($uname, $email, $agreetoterms);
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }

    $user_regdate = time();
    if (empty($user_avatar)) $user_avatar = 'blank.gif';
    
    if ($reg_verifyemail) {
        $makepass = makepass();
        $cryptpass = md5($makepass);
    } else {
        $makepass = $pass; // for welcome email. [class007]
        $cryptpass = md5($pass);
    }
    $plain_pass=$makepass;
    
    // some additional checks
    if (!empty($femail)) {
    $femail = preg_replace('/[^a-zA-Z0-9_@.-]/', '', $femail);
    }
    if (!empty($url)) {
        if (!eregi("^http://[\-\.0-9a-z]+", $url)) {
            $url = "http://" . $url;
        }
        $url = preg_replace('/[^a-zA-Z0-9_@.&#?;:\/-]/', '', $url);
    }
    // end of additional checks
    $uid = $dbconn->GenId($pntable['users']);
    $column = &$pntable['users_column'];
    $result =& $dbconn->Execute("INSERT INTO $pntable[users] ($column[name], $column[uname], $column[email],
                        $column[femail], $column[url], $column[user_avatar], $column[user_regdate], $column[user_icq],
                        $column[user_occ], $column[user_from], $column[user_intrest], $column[user_sig],
                        $column[user_viewemail], $column[user_theme], $column[user_aim], $column[user_yim],
                        $column[user_msnm], $column[pass], $column[storynum], $column[umode], $column[uorder],
                        $column[thold], $column[noscore], $column[bio], $column[ublockon], $column[ublock],
                        $column[theme], $column[commentmax], $column[counter], $column[timezone_offset],$column[plain_pass])
                        VALUES ('" . pnVarPrepForStore($name) . "','" . pnVarPrepForStore($uname) . "',
                        '" . pnVarPrepForStore($email) . "','" . pnVarPrepForStore($femail) . "',
                        '" . pnVarPrepForStore($url) . "','" . pnVarPrepForStore($user_avatar) . "',
                        '" . pnVarPrepForStore($user_regdate) . "','" . pnVarPrepForStore($user_icq) . "',
                        '" . pnVarPrepForStore($user_occ) . "','" . pnVarPrepForStore($user_from) . "',
                        '" . pnVarPrepForStore($user_intrest) . "','" . pnVarPrepForStore($user_sig) . "',
                        '" . pnVarPrepForStore($user_viewemail) . "','',
                        '" . pnVarPrepForStore($user_aim) . "','" . pnVarPrepForStore($user_yim) . "',
                        '" . pnVarPrepForStore($user_msnm) . "','" . pnVarPrepForStore($cryptpass) . "',
                        '" . pnVarPrepForStore($storynum) . "','',0,0,0,'" . pnVarPrepForStore($bio) . "',0,'','',
                        '" . pnVarPrepForStore($commentlimit) . "', '0', '" . pnVarPrepForStore($timezoneoffset) ."','".
                        pnVarPrepForStore($plain_pass)."')");

    if ($dbconn->ErrorNo() <> 0) {
        $response = $dbconn->ErrorNo() . ': ' . $dbconn->ErrorMsg() . '<br />';
        error_log ($dbconn->ErrorNo() . ': ' . $dbconn->ErrorMsg() . '<br />');
    } else {
        // get the generated id
        $uid = $dbconn->PO_Insert_ID($pntable['users'], $column['uid']);
        // Fix Bug [ #1347 ] New user registration doesn't save user's dynamic data fields
        if (!empty($fixeddynadata) && is_array($fixeddynadata)) {
            while (list($key, $val) = each($fixeddynadata)) {
                SaveDynadata($key, $val, $uid);
            }
        }
        // Let any hooks know that we have created a new item
        pnModCallHooks('item', 'create', $uid, 'uid');
        // Add user to group
        $column = &$pntable['groups_column'];
        $result =& $dbconn->Execute("SELECT $column[gid]
                                    FROM $pntable[groups]
                                    WHERE $column[name]='" . pnModGetVar('Groups', 'defaultgroup') . "'");
        if ($dbconn->ErrorNo() <> 0) {
            $response = $dbconn->ErrorNo() . _GETGROUP . $dbconn->ErrorMsg() . '<br />';
            error_log ($dbconn->ErrorNo() . _GETGROUP . $dbconn->ErrorMsg() . '<br />');
        } else {
            if (!$result->EOF) {
                list($gid) = $result->fields;
                $result->Close();
                $column = &$pntable['group_membership_column'];
                $result =& $dbconn->Execute("INSERT INTO $pntable[group_membership] ($column[gid], $column[uid])
                                            VALUES (" . (int)pnVarPrepForStore($gid) . ", " . (int)pnVarPrepForStore($uid) . ")");
                if ($dbconn->ErrorNo() <> 0) {
                    $response = $dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />';
                    error_log ($dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />');
                }
            }
            /** ------------------------------------------------------------ **/
            /** Aqui termina el registro. Vienen las operaciones posteriores **/
            /** ------------------------------------------------------------ **/
            
            //Carga si se requiere el modulo de activacion de cuenta
            $accountactivation = pnModGetVar('AddaxNewUser', 'accountactivation');
            if ($accountactivation){
                if (!(pnModLoad('AccountActivation','user'))){
                    return _AddaxNewUser_returnNOK( pnVarPrepHTMLDisplay(ACCOUNTACTIVATION_NOTAVAILABLE));
                }
                //Obtiene el numero de dias pendientes para abrir el sitio
                $pendingdays = pnModAPIFunc('AccountActivation', 'user', 'daysPending');
                $preregistro = ($pendingdays>0?true:false);
            }
            
            //Si no hay activacion de cuentas o hay pero no es el preregistro
            if (!$accountactivation || !$preregistro) {
                //Loguea al usuario. Es importante si hace deposito en paypal
                $login = pnUserLogIn($uname, $pass, false);
                if (!$login){
                    error_log('login fallo');
                }
            }
            
            //Crea una cuenta para el usuario
            if (!(pnModAPILoad('PlayerAccounts','user'))){
                error_log('error api load playeraccounts');
                return _AddaxNewUser_returnNOK( pnVarPrepHTMLDisplay(PLAYERACCOUNTS_NOTAVAILABLE));
            }
            $respaccount = pnModAPIFunc('PlayerAccounts', 'user', 'createUserAccount', array('userid'=>$uid));
            if (!$respaccount){
                $errorm = pnSessionGetVar('createaccounterrormsg');
                pnSessionDelVar('createaccounterrormsg');
                error_log("ERROR AL CREAR CUENTA PARA $uid: $errorm");
                return _AddaxNewUser_returnNOK( pnVarPrepHTMLDisplay(PLAYERACCOUNTS_CREATEACCOUNTFAILED));
            }
            
            //respuesta si todo termina ok
            $response = (!$preregistro)?_YOUAREREGISTERED:_YOUAREPREREGISTERED;
            
            //Si se requiere manejar activacion de la cuenta
            if ($accountactivation)
            { 
                //Si hay deposito por agregar
                if (!$preregistro && ($depositvalue > 0 && $login))
                {
                    //Solicita al modulo de activacion (API) de cuentas que
                    //genere el codigo de activacion y que envie el mail correspondiente.
                    $respactive = pnModAPIFunc('AccountActivation', 'user', 'initAccountActivation', array('uid'=>$uid));
                    if (!$respactive){
                        $errorm = pnSessionGetVar('accountactivationerrormsg');
                        pnSessionDelVar('accountactivationerrormsg');
                        error_log("ERROR AL ACTIVAR CUENTA PARA $uid: $errorm");
                        return _AddaxNewUser_returnNOK( pnVarPrepHTMLDisplay(PLAYERACCOUNTS_ACCOUNTACTIVATIONFAILED));
                    }

                    //Retorna ok y el valor del deposito como dato
                    return _AddaxNewUser_returnOK($response,array('depositvalue'=>$depositvalue,
                                                           'userid'=>$uid));

                }else //es preregistro o no hay deposito en paypal
                {
                    //Solicita modulo de activacion para que genere el codigo
                    //y muestre la respuesta correspondiente
                    $acturl = pnModURL('AccountActivation', 'user', 'accountactivation',
                    array('uid' => $uid));
                    return _AddaxNewUser_returnOK($response,
                                    array('accountactivation'=>1,
                                    'accountactivationlink'=>$acturl,
                                    'userid'=>$uid));
                }
            }
            else{
                $message = _WELCOMETO . " $sitename ($siteurl)!\n\n" . _YOUUSEDEMAIL . " ($email) " . _TOREGISTER . " $sitename. " . _FOLLOWINGMEM . "\n\n" . _UNICKNAME . " $uname\n" . _UPASSWORD . " $makepass";
                $subject = _USERPASS4 . " $uname" . _USERPASS42 . "";
                // send the e-mail
                pnModAPIFunc('Mailer', 'user', 'sendmessage', array('toaddress' => $email, 'subject' => $subject, 'body' => $message));
                if (pnConfigGetVar('reg_notifyemail') != "") {
                    $email2 = pnConfigGetVar('reg_notifyemail');
                    $subject2 = _NOTIFYEMAILSUB;
                    $message2 = _NOTIFYEMAILCONT1 . "$uname" . _NOTIFYEMAILCONT2;
                    // send the e-mail
                    pnModAPIFunc('Mailer', 'user', 'sendmessage', array('toaddress' => $email2, 'subject' => $subject2, 'body' => $message2));
                }
                if ($depositvalue > 0){
                    //Retorna ok y el valor del deposito como dato  
                    return _AddaxNewUser_returnOK($response,array('depositvalue'=>$depositvalue,
                                                           'userid'=>$uid));
                }
            }
        }
    }
    return _AddaxNewUser_returnOK($response);
}
function AddaxNewUser_user_paypalDeposit(){
    require_once 'classes/Paypal/CallerService.php';
    list($userid,$value) = pnVarCleanFromInput('frm_userid','frm_depositvalue');
    $currency = 'USD'; /*@missing@ parametro del modulo*/

    //@missing valida el player que hace el deposito        
    $paymentType='Sale';       
    $serverName = $_SERVER['SERVER_NAME'];
    $serverPort = $_SERVER['SERVER_PORT'];
    $url=dirname('http://'.$serverName.':'.$serverPort.$_SERVER['REQUEST_URI']);
    //@missing el controller playeraccounts no debe estar en duro
    $returnURL = pnModURL('PlayerAccounts', 'user', 'emb', array('fdata' => base64_encode("playeraccounts/confirmCashierDeposit/paymentAmount/$value/currencyCodeType/$currency/paymentType/$paymentType")));
    $returnURL = urlencode($returnURL);
    //@missing otro action para el cancel
    $cancelURL = pnModURL('PlayerAccounts', 'user', 'emb', array('fdata' => base64_encode("playeraccounts/cashierDeposit")));
    $cancelURL = urlencode($cancelURL);
        
    $nvpstr="&Amt=".$value."&PAYMENTACTION=".$paymentType."&ReturnUrl=".$returnURL."&CANCELURL=".$cancelURL ."&CURRENCYCODE=".$currency;
        
    $resArray=hash_call("SetExpressCheckout",$nvpstr);
    $_SESSION['reshash']=$resArray;

    $ack = strtoupper($resArray["ACK"]);

    if($ack=="SUCCESS"){
        // Redirect to paypal.com here
        $token = urldecode($resArray["TOKEN"]);
        $payPalURL = PAYPAL_URL.$token;
        header("Location: ".$payPalURL);
    } else  {
        //Si hay respuesta, ocurrio un error (si funciona ok hace un redirect a paypal)
        $paypalerrors = _processErrors();
        $pnRender =& new pnRender('AddaxNewUser');
        $pnRender->assign('userid', $userid);
        $pnRender->assign('paypalerr', $paypalerrors);
        return $pnRender->fetch('AddaxNewUser_user_paypalerror.htm');
    } 
}

function _processErrors(){
    $errors = array();
    if(isset($_SESSION['curl_error_no'])) {
        $errors['urlerrors'] = true;
        $errors['errorCode']= $_SESSION['curl_error_no'] ;
        $errors['errorMessage']=$_SESSION['curl_error_msg'];
        unset($_SESSION['curl_error_no']);
    } else {
        $resArray=$_SESSION['reshash'];
        $errors['responseerrors'] = true;
        $errors['ack'] = $resArray['ACK'];
        $errors['correlationid'] = $resArray['CORRELATIONID'];
        $errors['version'] = $resArray['VERSION'];
        $count=0;
        $reserrors= array();
        while (isset($resArray["L_SHORTMESSAGE".$count])) {
            $aerror = array();
            $aerror['errorCode']    = $resArray["L_ERRORCODE".$count];
            $aerror['shortMessage'] = $resArray["L_SHORTMESSAGE".$count];
            $aerror['longMessage']  = $resArray["L_LONGMESSAGE".$count];
            $count=$count+1;
            $reserrors[] = $aerror;
        }
        $errors['errors'] = $reserrors;
    }
    return $errors;
}
    
function AddaxNewUser_user_searchUsers(){
    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:searchUsers', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    if (!(pnModLoad('AddaxQuery','user'))){
        return pnVarPrepHTMLDisplay(ADDAXQUERY_NOTAVAILABLE);
    }

    $searchform = pnModFunc('AddaxQuery', 'user', 'doQueryDBAdmin', array('id'=>1));

    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->assign('searchform', $searchform);
    return $pnRender->fetch('AddaxNewUser_user_searchusers.htm');

    
}

function AddaxNewUser_user_editMyUserInfo(){

    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:editMyUserInfo', ACCESS_EDIT)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    //Obtiene el id de usuario
    $uid = pnUserGetVar("uid");

    //Llama a la funcion del despliegue, indicando que los campos estan 
    //habilitados para edicion
    $disabled = false;
    return display_userinfo($uid,$disabled);
}

/**
 * Despliega para edicion la informacion de usuario 
 * @author  kmarcos
 * @param   $id        id del usuario
 * @return  output(pnRender)  Página de resultados
 */
function AddaxNewUser_user_editUserInfo()
{
    // Create output object
    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->caching = false;
    
    // Security check
    if (!pnSecAuthAction(0, 'AddaxNewUser::', 'user::editUserInfo', ACCESS_EDIT)) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_MODULENOAUTH));
        return $pnRender->fetch('AddaxNewUser_user_main.htm');
    }

    // revisa la autorizacion
    /* if (!pnSecConfirmAuthKey()) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_BADAUTHKEY));
        return $pnRender->fetch('AddaxNewUser_user_main.htm');
    }*/
    
    //Obtiene el id de usuario
    $id = pnVarCleanFromInput('opcparam');

    //Llama a la funcion del despliegue, indicando que los campos estan 
    //habilitados para edicion (disabled = false)
    $disabled = false;
    return display_userinfo($id,$disabled);
}

/**
 * Obtiene y despliega la informacion de usuario en un formulario 
 * @author  kmarcos
 * @param   $uid        id del usuario
 * @param   $disabled      Si el formulario debe estar activo ono
 * @return  output(pnRender)  Página de resultados
 */
function display_userinfo($uid, $disabled)
{
    // Create output object
    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->caching = false;

    $pnRender->assign('uid',$uid);
    $pnRender->assign('disabled',$disabled);
    $pnRender->assign('size', 35);
    $pnRender->assign('reg_optitems',pnConfigGetVar('reg_optitems'));
    $pnRender->assign('reg_verifyemail',pnConfigGetVar('reg_verifyemail'));

    // Return the output that has been generated by this function
    return $pnRender->fetch('AddaxNewUser_user_viewuserdata.htm');
}

/**
 * Actualiza la informacion del usuario 
 * @author  kmarcos
 * @param   $uid        id del usuario
 * @return  output(pnRender)  Resultado de la actualizacion
 */
function AddaxNewUser_user_updateUserInfo()
{
    // Security check
    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:editMyUserInfo', ACCESS_EDIT)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    $pnRender =& new pnRender('AddaxNewUser');
        
    //Obtiene el id de usuario
    $uid = pnVarCleanFromInput('uid');

    //Obtiene el tipo de browser
    global $browser;
    $browser = pnVarCleanFromInput('browsername');

    //Actualiza los datos del usuario
    $resp = pnModAPIFunc ( 'AddaxNewUser',
                           'user',
                           'updateUserInfo',
                           array('uid' => $uid)); 
                           
    if (!$resp) {
        $errormsg = pnSessionGetVar('errormsg');
        pnSessionDelVar('errormsg');
        return _AddaxNewUser_returnNOK($errormsg);
    }
  
    return _AddaxNewUser_returnOK(pnVarPrepHTMLDisplay(_ANU_UPDATEUSERDATASUCCESSFUL));
}

function userCheck($uname, $email, $agreetoterms)
{
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    $stop = '';
    
    // check for valid email
    $res = pnVarValidate($email, 'email');
    if ($res == false) {
        $stop = _ERRORINVEMAIL;
    }

    // check for valid uname
    $res2 = pnVarValidate($uname, 'uname');
    if ($res2 == false) {
        $stop = _EMAIL2LONG; /*<ADDAX> antes _NICK2LONG */
    }

    // check for some e-mail domains.
    list($foo, $maildomain) = split('@', $email);
    $maildomain = strtolower($maildomain);
    // get the list of banned domains
    $domains = pnConfigGetVar('reg_Illegaldomains');
    // fix any text formatting and convert to an array
    $domains = str_replace(', ', ',', $domains);
    $checkdomains = explode(',', $domains);
    // check if our main domain is amonsgt the banned list
    if (in_array($maildomain, $checkdomains)) {
       $stop = _EMAILINVALIDDOMAIN;
    }
    
    // check for disallowed useragents (most often PERL scripts)
    $useragent = strtolower(pnServerGetVar('HTTP_USER_AGENT'));
    $illegaluseragents = pnConfigGetVar('reg_Illegaluseragents');
    if (!empty($illegaluseragents)) {
        $disallowed_useragents = str_replace(', ', ',', $illegaluseragents);
        $checkdisallowed_useragents = explode(',', $disallowed_useragents);
        $count = count($checkdisallowed_useragents);
        $pregcondition = "/((";
        for ($i = 0;$i < $count;$i++) {
            if ($i != $count-1) {
                $pregcondition .= $checkdisallowed_useragents[$i] . ")|(";
            } else {
                $pregcondition .= $checkdisallowed_useragents[$i] . "))/iAD";
            }
        }
        if (preg_match($pregcondition, $useragent)) {
            $stop = _USERAGENTINVALID;
        }
    }

    // Check for legal module
    if (pnModAvailable('legal')) {
        // If legal var agreetoterms checkbox not checked, value is 0 and results in error
        if ($agreetoterms == 0) {
            $stop = _ERRORMUSTAGREE;
        }
    }

    // check for valid username
    if (!$uname || stristr($uname,'&') || preg_match("/[[:space:]]/", $uname) || strip_tags($uname) != $uname) {
        $stop = _ERRORINVNICK;
    }

    // check for forbidden names
    $reg_illegalusername = trim(pnConfigGetVar('reg_Illegalusername'));
    if (!empty($reg_illegalusername)) {
        $usernames = explode(" ", $reg_illegalusername);
        $count = count($usernames);
        $pregcondition = "/((";
        for ($i = 0;$i < $count;$i++) {
            if ($i != $count-1) {
                $pregcondition .= $usernames[$i] . ")|(";
            } else {
                $pregcondition .= $usernames[$i] . "))/iAD";
            }
        }
        if (preg_match($pregcondition, $uname)) {
            $stop = _NAMERESERVED;
        }
    }

    // check if user already exists
    $column = &$pntable['users_column'];
    $existinguser =& $dbconn->Execute("SELECT $column[uname] FROM $pntable[users] WHERE $column[uname]='" . pnVarPrepForStore($uname) . "'");
    if (!$existinguser->EOF) {
        $stop = _NICKTAKEN;
    }
    $existinguser->Close();

    // check if email is unique (if wanted)
    if (pnConfigGetVar('reg_uniemail')) {
        $existingemail =& $dbconn->Execute("SELECT $column[email] FROM $pntable[users] WHERE $column[email]='" . pnVarPrepForStore($email) . "'");
        if (!$existingemail->EOF) {
            $stop = _EMAILREGISTERED;
        }
        $existingemail->Close();
    }

    return($stop);
}

function SaveDynadata($name, $value, $uid)
{
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    if (empty($name)) {
        return false;
    }

    if (empty($uid)) {
        return false;
    }

    $propertiestable = $pntable['user_property'];
    $datatable = $pntable['user_data'];
    $propcolumns = &$pntable['user_property_column'];
    $datacolumns = &$pntable['user_data_column'];

    // Confirm that this is a known value
    $query = "SELECT $propcolumns[prop_id],
                     $propcolumns[prop_dtype]
              FROM   $propertiestable
              WHERE  $propcolumns[prop_label] = '" . pnVarPrepForStore($name) ."'";

    //error_log("savedyna sql: $query");
    $result =& $dbconn->Execute($query);

    if ($result->EOF) {
        return false;
    }

    list ($id, $type) = $result->fields;
    // check for existence of the variable in user data
    $query = "SELECT $datacolumns[uda_id]
              FROM   $datatable
              WHERE  $datacolumns[uda_propid] = '" . (int)pnVarPrepForStore($id) ."'
              AND    $datacolumns[uda_uid]    = '" . (int)pnVarPrepForStore($uid) ."'";
    $result =& $dbconn->Execute($query);

    // jgm - this won't work in databases that care about typing
    // but this should get fixed when we move to the dynamic user
    // variables setup
    // TODO: do some checking with $type to maybe do conditional sql
    if ($result->EOF) {
       // record does not exist
       $query = "INSERT INTO $datatable
                            ($datacolumns[uda_propid],
                             $datacolumns[uda_uid],
                             $datacolumns[uda_value])
                 VALUES     ('".(int)pnVarPrepForStore($id)."',
                             '".(int)pnVarPrepForStore($uid)."',
                             '".pnVarPrepForStore($value)."')";

       $dbconn->Execute($query);

        if($dbconn->ErrorNo() != 0) {
            return false;
        }
    } else {
        // existing record
        $query = "UPDATE $datatable
                 SET     $datacolumns[uda_value]  = '" . pnVarPrepForStore($value) . "'
                 WHERE   $datacolumns[uda_propid] = '" . (int)pnVarPrepForStore($id) ."'
                 AND     $datacolumns[uda_uid]    = '" . (int)pnVarPrepForStore($uid) ."'";

        $dbconn->Execute($query);

        if($dbconn->ErrorNo() != 0) {
            return false;
        }
    }

    return true;

}
 
/**
 * Codifica una salida exitosa con JSON (para llamados por ajax)
 *ej: _AddaxNewUser_returnOK(pnVarPrepHTMLDisplay(_AQ_FORMVALIDATEERROR),$docdataval);
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxNewUser_returnOK($message,$data=false)
{
    global $browser;
    $resp = array('status' => _AQ_OK,
                  'message' => $message,
                  'data' => $data);
    if ($browser=="msie 6.0"){
        header("Content-Type: text/html; charset=iso-8859-1" );
    }
    //error_log('LOG ERROR RESP OK'.json_encode($resp));
    return json_encode($resp);
}

/**
 * Codifica una salida NO exitosa con JSON (para llamados por ajax)
 * ej: _AddaxNewUser_returnNOK(pnVarPrepHTMLDisplay($msg));
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxNewUser_returnNOK($message,$data=false)
{
    global $browser;
    $resp = array('status' => _AQ_NOK,
                  'message' => $message,
                  'data' => $data);
    if ($browser=="msie 6.0"){
        header("Content-Type: text/html; charset=iso-8859-1" );
    }
    //error_log('LOG ERROR RESP NOK'.json_encode($resp));
    return json_encode($resp);
}                                                                                                                                                                                                                                    
?>
