<?php
// ======================================================================
// AddaxNewUser by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxNewUser
 * Modulo de usuarios
 * 
 * Funciones de administracion.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxNewUser
 * @author      addax
 * ======================================================================
 */ 
 
/**
 * Funcion principal de administracion
 */
function AddaxNewUser_admin_main()
{    
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    $pnRender =& new pnRender('AddaxNewUser');

    return $pnRender->fetch('AddaxNewUser_admin_main.htm');
}

/**
 * Modify configuration
 *
 * This is a standard function to modify the configuration parameters of the
 * module
 *
 * @author       addax
 * @return       output       The configuration page
 */
 function AddaxNewUser_admin_modifyconfig()
 {
    // Autorizacion
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    
    // Crea Render
    $pnRender =& new pnRender('AddaxNewUser');
    
    //Asigna el valor actual de los parametros de configuracion
    $pnRender->assign('emailasuser',pnModGetVar('AddaxNewUser', 'emailasuser'));
    $pnRender->assign('accountactivation',pnModGetVar('AddaxNewUser', 'accountactivation'));
    $pnRender->assign('userspreregister',pnModGetVar('AddaxNewUser', 'userspreregister'));
    $pnRender->assign('grupoadmingral',pnModGetVar('AddaxNewUser', 'grupoadmingral'));
    $pnRender->assign('grupofuncregcatastr',pnModGetVar('AddaxNewUser', 'grupofuncregcatastr'));
    $pnRender->assign('gruporegente',pnModGetVar('AddaxNewUser', 'gruporegente'));

    // Retorna la salida generada
    return $pnRender->fetch('AddaxNewUser_admin_modifyconfig.htm');
}


/**
 * Update the configuration
 *
 * This is a standard function to update the configuration parameters of the
 * module given the information passed back by the modification form
 * Modify configuration
 *
 * @author       addax
 */
function AddaxNewUser_admin_updateconfig()
{
     // Autorizacion
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
   
    // revisa la autorizacion
    if (!pnSecConfirmAuthKey()) {
        return pnVarPrepHTMLDisplay(_BADAUTHKEY);
    }
   
        
    // Verifica que se haya enviado por el usuario
    $submit = pnVarCleanFromInput('submit');
    if(!$submit) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    
    //Toma las variables del formulario
    $emailasuser= pnVarCleanFromInput('emailasuser');
    $accountactivation= pnVarCleanFromInput('accountactivation');
    $userspreregister= pnVarCleanFromInput('userspreregister');
    $grupoadmingral= pnVarCleanFromInput('grupoadmingral');
    $grupofuncregcatastr= pnVarCleanFromInput('grupofuncregcatastr');
    $gruporegente= pnVarCleanFromInput('gruporegente');
    
    
    //Actualiza la configuracion
    pnModSetVar('AddaxNewUser', 'emailasuser', $emailasuser);
    pnModSetVar('AddaxNewUser', 'accountactivation', $accountactivation);
    pnModSetVar('AddaxNewUser', 'userspreregister', $userspreregister);
	pnModSetVar('AddaxNewUser','grupoadmingral',$grupoadmingral);
    pnModSetVar('AddaxNewUser','grupofuncregcatastr',$grupofuncregcatastr);    
    pnModSetVar('AddaxNewUser','gruporegente',$gruporegente); 
    
    //Mensaje de actualizado correctamente
    pnSessionSetVar('statusmsg', pnVarPrepHTMLDisplay(_CONFIGUPDATED));

    // Esta funcion no genera salida, asi que se redirige a la pagina ppal
    return pnRedirect(pnModURL('AddaxNewUser', 'admin', 'main'));
}

?>