<?php
/** =====================================================================
 * Función de Smarty para desplegar las propiedades adicionales en el registro
 * de nuevo usuario
 *
 * Ejemplo: 
 * <!--[displayuserproperties labels="_PAISRESIDENCIA,_TELEFONO" size=40 disable="yes" uid=1]--> 
 * <!--[displayuserproperties labels="_PAISRESIDENCIA" uid=1]-->
 *
 * @author  kmarcos
 * @param   array       $params     Arreglo con los parametros de la función:
 *                                  $labels Lista separada por comas de las propiedades
 *                                  $size tamaño del ancho del campo de la propiedad 
 * @param   object      &$smarty    Referencia al objeto Smarty
 * @return  string      Código HTML de despliegue.
 * ======================================================================
 */ 

function smarty_function_displayuserproperties($params, &$smarty)
{
    extract($params); 
    unset($params);

    // valores por defecto
    if (!isset($labels)) {
        return;
    }
    if (!isset($size)|| !is_numeric($size)) {
        $size = 35;
    }
    $disabled = "";
    if ($disable == "yes"){
        $disabled = "disabled";
    }
    $note_txt="";
    if(isset($note)){
        $note_txt = "<span class='notedisplayprop'>$note</span>";
    }
    $required_txt ="";
    if ($required == "yes"){
        $required_txt="<td valign='center' class='requiredfield'>*</td>";
    }
    
    $showPaypal_txt = '';
    /*if ($showPaypal == 'true'){
        $showPaypal_txt = '<img src="https://www.paypal.com/en_US/i/logo/PayPal_mark_37x23.gif" align="left" style="float:right;margin:0px 5px;">';
    }*/

    $labels_array= split(',',$labels);
    $labels="";
    foreach($labels_array as $l)
    {
        if ($labels != "") {
            $labels .= ',';
        }
        $labels .= "'".trim($l)."'";
    }

    $output="";   
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();
    $propertytable = $pntable['user_property'];
    $propertycolumn = &$pntable['user_property_column'];
		error_log("tablas: [". var_export($pntable, true) . "]");

    $sql = "select " . $propertycolumn['prop_id'] . " AS prop_id, " . $propertycolumn['prop_label'] . " AS prop_label, " . $propertycolumn['prop_dtype'] . " AS prop_dtype, " . $propertycolumn['prop_length'] . " AS prop_length, " . $propertycolumn['prop_weight'] . " AS prop_weight, " . $propertycolumn['prop_validation'] . " AS prop_validation, " . $propertycolumn['prop_values'] . " AS prop_values, ". $propertycolumn['prop_value_cols'] . " AS prop_value_cols " . "FROM " . $propertytable . " " . "WHERE " . $propertycolumn['prop_weight'] . "!=0 ";

    if(!empty($labels))
    {
	   $sql .= " AND $propertycolumn[prop_label] IN ($labels) ";
    }
	$sql .= " ORDER BY " . $propertycolumn['prop_weight'];
    $result =& $dbconn->Execute($sql);    
	error_log($sql);

    $prop_label_text = "";
    while (!$result->EOF) {
        list($prop_id, $prop_label, $prop_dtype, $prop_length, $prop_weight, $prop_validation, $prop_values, $prop_value_cols) = $result->fields;
        $result->MoveNext();
        // do not display email & fakeemail & password
        if ($prop_label != '_UREALEMAIL')
        {
            $prop_label_text = (defined($prop_label) ? constant($prop_label) : $prop_label);
            $output .=  '<td class="labels_td"  align="right"><label>' . $prop_label_text . '</label>'.$note_txt;
            $output .= '</td><td valign="center" align="left" class="TD'.$prop_label.'">';
            error_log("t[$prop_label]: manda[" . _UDCONST_MANDATORY . ", cor[" . _UDCONST_CORE 
						. ", st[" . _UDCONST_STRING
						. ", tex[" . _UDCONST_TEXT
						. ", floa[" . _UDCONST_FLOAT
						. ", int[" . _UDCONST_INTEGER
						. ", rad[" . _UDCONST_RADIO
						. ", chks[" . _UDCONST_CHECKBOXES
						. ", comb[" . _UDCONST_SINGLECOMBO
						. ", date[" . _UDCONST_DATE
						);
            switch ($prop_dtype)
            {
                case _UDCONST_MANDATORY;
                case _UDCONST_CORE;
                    switch ($prop_label) {
                        case '_XUREALNAME':
                             $output .=  '<input type="text" name="realname" id="realname" value="' . pnVarPrepForDisplay(pnUserGetVar('name',$uid)) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="60"  '.$disabled.' />';
                        break;
                        case '_UREALEMAIL':
                              $output .=  '<input type="text" name="email" value="' . pnVarPrepForDisplay(pnUserGetVar('email')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="60" '.$disabled.' >'                           .'&nbsp;'._REQUIRED.'&nbsp;'._EMAILNOTPUBLIC.'</td>';
                        break;
                        case '_UFAKEMAIL':
                             $output .=  '<input type="text" name="femail" value="' . pnVarPrepForDisplay(pnUserGetVar('femail')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="60"  '.$disabled.' />';
                        break;
                        case '_YOURHOMEPAGE':
                             $output .=  '<input type="text" name="url" value="' . pnVarPrepForDisplay(pnUserGetVar('url')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                        break;
                        case '_TIMEZONEOFFSET':
                            $tzoffset = pnConfigGetVar('timezone_offset');
                            global $tzinfo;
                            $output .=  '<select name="timezoneoffset" '.$disabled.' >';
                            foreach ($tzinfo as $tzindex => $tzdata) {
                                $output .=  "\n".'<option value="'.pnVarPrepForDisplay($tzindex).'"';
                                if ($tzoffset == $tzindex) {
                                    $output .=  'selected="selected"';
                                }
                                $output .=  '>';
                                $output .=  pnVarPrepHTMLDisplay($tzdata);
                                $output .=  '</option>';
                            }
                            $output .=  '</select>';
                            break;
                        case '_YOURAVATAR':
                             $user_avatar = pnUserGetVar('user_avatar');
                             $output .=  '<select name="user_avatar" onchange="showimage()" '.$disabled.' >';
                             $handle = opendir('images/avatar');
                             while ($file = readdir($handle)) {
                                $filelist[] = $file;
                            }
                            asort($filelist);
                            while (list ($key, $file) = each ($filelist)) {
                                ereg('.gif|.jpg', $file);
                                if ($file != '.' && $file != '..' && $file != 'CVS' && $file != 'index.html') {
                                   $output .=  '<option value="'.pnVarPrepForDisplay($file).'"';
                                    if ($file == "blank.gif") {
                                        $output .=  'selected="selected"';
                                    }
                                    $output .=  '>'.pnVarPrepForDisplay($file).'</option>';
                                }
                            }
                            $output .=  '</select>&nbsp;&nbsp;<img src="images/avatar/blank.gif" name="avatar" width="32" height="32" alt="" />';
                            break;
                        case '_YICQ':
                            $output .=  '<input type="text" name="user_icq" value="' . pnVarPrepForDisplay(pnUserGetVar('user_icq')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YAIM':
                            $output .=  '<input type="text" name="user_aim" value="' . pnVarPrepForDisplay(pnUserGetVar('user_aim')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YYIM':
                            $output .=  '<input type="text" name="user_yim" value="' . pnVarPrepForDisplay(pnUserGetVar('user_yim')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YMSNM':
                            $output .=  '<input type="text" name="user_msnm" value="' . pnVarPrepForDisplay(pnUserGetVar('user_msnm')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YLOCATION':
                            $output .=  '<input type="text" name="user_from" value="' . pnVarPrepForDisplay(pnUserGetVar('user_from')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YOCCUPATION':
                            $output .=  '<input type="text" name="user_occ" value="' . pnVarPrepForDisplay(pnUserGetVar('user_occ')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_YINTERESTS':
                            $output .=  '<input type="text" name="user_intrest" value="' . pnVarPrepForDisplay(pnUserGetVar('user_intrest')) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                            break;
                        case '_SIGNATURE':
                            $output .=  '<textarea cols="80" rows="10" name="user_sig"  '.$disabled.' >' . pnVarPrepForDisplay(pnUserGetVar('user_sig')) . '</textarea><br />'. _OPTIONAL . '&nbsp;' . _255CHARMAX . '<br />' . _ALLOWEDHTML . '<br />';
                            $AllowableHTML = pnConfigGetVar('AllowableHTML');
                            while (list($key, $access,) = each($AllowableHTML)) {
                                if ($access > 0) $output .=  " &lt;" . $key . "&gt;";
                            }
                            break;
                        case '_EXTRAINFO':
                            $output .=  '<textarea cols="80" rows="10" name="bio" '.$disabled.' >' . pnVarPrepForDisplay(pnUserGetVar('bio')) . '</textarea>&nbsp;<br />' . _CANKNOWABOUT;
                            break;
                        case '_PASSWORD':
                            $output .= '<input type="password" name="pass" id="pass_new_user" size="'.pnVarPrepForDisplay($size).'" maxlength="20"/>';
                            break;
                        case '_PASSWDAGAIN':
                            $output .= '<input type="password" name="vpass" id="vpass_new_user" size="'.pnVarPrepForDisplay($size).'" maxlength="20"/>';
                            break;    
                        default:
                            $output .=  "Undefined $prop_id, $prop_label, $prop_dtype, $prop_length, $prop_weight, $prop_validation,$prop_values,$prop_value_cols";
                    }
                    break;
                case _UDCONST_STRING:
                    if (empty($prop_length)) $prop_length = 30;
                    $output .=  '<input class="required" title="'.FIELDREQUIRED.'" type="text" id="'.pnVarPrepForDisplay($prop_label).'" alt="{event: \'blur,change\'}" name="dynadata['.pnVarPrepForDisplay($prop_label).']" value="' . pnVarPrepForDisplay(pnUserGetVar($prop_label,$uid)) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="'.pnVarPrepForDisplay($prop_length).'"  '.$disabled.' />';
                    break;
                case _UDCONST_TEXT:
                    $output .=  '<textarea wrap="virtual" cols="'.$size.'" rows="3" name="dynadata['.pnVarPrepForDisplay($prop_label).']" '.$disabled.' >' . pnVarPrepForDisplay(pnUserGetVar($prop_label,$uid)) . '</textarea>';
                    break;
                case _UDCONST_FLOAT:
                case _UDCONST_INTEGER:
                    $output .=  '<input type="text" name="dynadata['.pnVarPrepForDisplay($prop_label).']" value="' . pnVarPrepForDisplay(pnUserGetVar($prop_label,$uid)) . '" size="'.pnVarPrepForDisplay($size).'" maxlength="100"  '.$disabled.' />';
                    break;
                /* <ADDAX> */    
		        case _UDCONST_RADIO:
		            $values = split(',', $prop_values);
		            $col_width= (int)(100/$prop_value_cols);
		            $column_index = 0;
		            $user_value = pnUserGetVar($prop_label,$uid);
		            $output .=  '<table cellspacing="0" cellpadding="0" border="0" width="100%">';
		            foreach($values as $value)
		            {
			           $checked = '';
			           $value_text = (defined($value) ? constant($value) : $value);
			            if($user_value == $value)
			            {
				        $checked='checked';
			            }
			            if($column_index==0)
			            {
				            $output .=  '<tr>';
			            }
		     	        $output .=  '<td  width="'.$col_width. '%" align="left" valign="middle"><input name="dynadata['.pnVarPrepForDisplay($prop_label).']" type="radio" value="'.$value.'" ' . $checked .' '.$disabled.' >' . pnVarPrepForDisplay($value_text) .'</input>&nbsp;&nbsp;</td>';
			            $column_index++;
			            if($column_index==$prop_value_cols)
			            {
				            $output .=  "</tr>\n";
				            $column_index = 0;
			            }
		            }
		            $output .=  "</table>\n";
                    break;
		        case _UDCONST_CHECKBOXES:
			        $values = split(',', $prop_values);
			        $user_values = split(',', pnUserGetVar($prop_label,$uid));			        
			        $col_width= (int)(100/$prop_value_cols);
		            $column_index = 0;
		             $output .=  '<table class="checkboxtable" cellspacing="0" cellpadding="0" border="0">';
		            foreach($values as $value)
		            {
			            $checked = '';
			            $value_text = (defined($value) ? constant($value) : $value);
			            /*if(pnUserGetVar($prop_label.'_'.$value) == $value)
			            {
				            $checked='checked';
			            }*/
			            if (in_array($value,$user_values))
			            {
				            $checked='checked';
			            }
			            if($column_index==0)
			            {
				            $output .=  '<tr>';
			            }
			            $output .=  '<td  align="left" valign="top"><input name="dynadata['.pnVarPrepForDisplay($prop_label.'-'.$value).']" type="checkbox" '.$disabled.'  value="'.$value.'" ' . $checked .'/>&nbsp;</td><td align="left" valign="top">' . pnVarPrepForDisplay($value_text) .'</td>';
			            $column_index++;
                        if($column_index==$prop_value_cols)
                        {
                            $output .=  "</tr>\n";
                            $column_index = 0;
                        }
		            }
		            $output .=  "</table>\n";
                    break;
		        case _UDCONST_SINGLECOMBO:
          
                    $output .=  '<select style="width:'.pnVarPrepForDisplay($size).'px;" name="dynadata['.pnVarPrepForDisplay($prop_label).']" '.$disabled.' >';
                    $values = split(',', $prop_values);
                    $user_value = pnUserGetVar($prop_label,$uid);
                    if (!isset($user_value))
                        $isfirstvalue=true;
                    foreach($values as $value)
                    {
                        $selected = '';
                        $value_text = (defined($value) ? constant($value) : $value);
                        if ($user_value == $value || ( !isset($user_value) && $isfirstvalue))
                        {
                            $selected='selected';
                            $isfirstvalue = false;
                        }
                        $output .=  '<option value="'.$value.'" ' . $selected .' >' . pnVarPrepForDisplay($value_text) .'</option>';
                    }
                    $output .=  '</select>';
                    break;
                case _UDCONST_DATE:
                    //datepicker
                    if (!isset($minYearRange)|| !is_numeric($minYearRange)) {$minYearRange = -35;}
                    else{$minYearRange = intval($minYearRange);}
                    if (!isset($maxYearRange)|| !is_numeric($maxYearRange)) {$maxYearRange = +10;}
                    else{$maxYearRange = intval($maxYearRange);}
                    $today = getdate();
                    $thisyear = intval($today['year']);
                    $minYearRange = $thisyear + $minYearRange;
                    $maxYearRange = $thisyear + $maxYearRange;               
                    $value = pnUserGetVar($prop_label,$uid);
                    //el name es diferente del id porque con el id incluyendo []
                    //no funciona el datepicker
                    $output .= '<p class="datepickertarget"><input type="text" name="dynadata['.pnVarPrepForDisplay($prop_label).']"  id="'.pnVarPrepForDisplay($prop_label).'"  size="'.pnVarPrepForDisplay($size).'"  value="'.((isset($value)&&trim($value)!="")?$value:_DATEPICKERMSG).'" '.$disabled.' /></p>'.'<script type="text/javascript">$(document).ready(function(){  $("#'.pnVarPrepForDisplay($prop_label).'").datepicker({yearRange:\''.$minYearRange.':'.$maxYearRange.' \',dateFormat: "dd/mm/yy"});});</script>';
                    break;
                /*</ADDAX>*/
            } 

            $output .=  "$showPaypal_txt</td>".$required_txt;
        }
    }
    return $output;
}

?>
