<?php
// ======================================================================
// AddaxNewUser by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxNewUser
 * Modulo de usuarios
 * 
 * Funciones de usuario.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxNewUser
 * @author      addax
 * ======================================================================
 */ 
if (!defined("_AQ_OK")) define('_AQ_OK',1);
if (!defined("_AQ_NOK")) define('_AQ_NOK',-1);

/**
 * Funcion principal de usuario
 */
function AddaxNewUser_user_main()
{        
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
      
    $pnRender =& new pnRender('AddaxNewUser');

    return $pnRender->fetch('AddaxNewUser_user_main.htm');
}
/**
 * Presenta el formulario de registro de nuevo usuario
 */
function AddaxNewUser_user_newUser()
{

    if (!pnSecAuthAction(0, 'AddaxNewUser::', 'newUser::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    
    // generate the form authorisation key
    // added to prevent multiple automated signups - markwest
    $authid = pnSecGenAuthKey();

    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->assign('size', 100);    
    $pnRender->assign('reg_optitems',pnConfigGetVar('reg_optitems'));
    $pnRender->assign('reg_verifyemail',pnConfigGetVar('reg_verifyemail'));

    return $pnRender->fetch('AddaxNewUser_user_register.htm');
}

/**
 * Hace el registro del nuevo usuario
 */
function AddaxNewUser_user_finishnewuser($var)
{
    // confirm the form authorisation key
    // added to prevent multiple automated signups - markwest
	/*if (!pnSecConfirmAuthKey()) {
      echo _BADAUTHKEY;
      include 'footer.php';
      exit;
    }*/
    global $browser;
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();
    $column = &$pntable['users_column'];

    list($uname,
         $name,
         $email,
         $femail,
         $vemail,
         $browser) = pnVarCleanFromInput(
                                        'uname',
                                        'realname',
                                        'email',
                                        'femail',
                                        'vemail',
                                        'browsername');

    $reg_optitems = pnConfigGetVar('reg_optitems');

	/* Se desactiva esto, porque este flag tambien es visto por el modulo NewUser que no debe presentar el registro de items opcionales 
    if ($reg_optitems) {
        list($url,
             $bio,
             $user_avatar,
             $user_icq,
             $user_occ,
             $user_from,
             $user_intrest,
             $user_sig,
             $user_aim,
             $user_yim,
             $user_msnm,
             $user_viewemail,
             $timezoneoffset,
             $dynadata) = pnVarCleanFromInput(
                                              'url',
                                              'bio',
                                              'user_avatar',
                                              'user_icq',
                                              'user_occ',
                                              'user_from',
                                              'user_intrest',
                                              'user_sig',
                                              'user_aim',
                                              'user_yim',
                                              'user_msnm',
                                              'user_viewemail',
                                              'timezoneoffset',
                                              'dynadata');
    }*/
	
	$dynadata = pnVarCleanFromInput('dynadata');

    //Look for CHECKBOX VALUE HACK AND PROCESS IT TO CONFORM WITH POSTNUKE REGULAR DYNAMIC DATA
    $checkbox_properties = array();
    $fixeddynadata = array();
    if (!empty($dynadata) && is_array($dynadata)) 
    {
        foreach($dynadata as $key=>$value)
        {
            error_log("Key to analize: $key => $value");
            if(ereg('-', $key))
            {
                if(!empty($value) && isset($value))
                {
                    $key_values = split('-', $key);
                    if(!isset($fixeddynadata[$key_values[0]]) || empty($fixeddynadata[$key_values[0]]))
                    {
                        $fixeddynadata[$key_values[0]] = $key_values[1];
                    }
                    else
                    {
                        $fixeddynadata[$key_values[0]] .= "," . $key_values[1];
                    }
                }
            }
            else
            {
                if(!empty($value) && isset($value))
                {
                    $fixeddynadata[$key] = $value;
                }
            }
        }
    }

    //Valida el nombre
    if (!isset($name) || $name=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(REALNAMEREQUIRED));
    }
              
    //Valida el username
    /*if (!isset($uname) || $uname=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(USERNAMEREQUIRED));
    }*/ 
    
    //Valida el correo
    if (!isset($email) || $email=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(CORRECTEMAIL));
    }

    //Si el correo sera el mismo nombre de usuario
    $emailasuser = pnModGetVar('AddaxNewUser', 'emailasuser');
    if (isset($emailasuser) && $emailasuser){        
        $uname = $email;        
    }

    $stop = userCheck($uname, $email, $agreetoterms);
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }
    //Valida los telefonos
//     $tels = $fixeddynadata['_TELEFONOSCONTACTO'];
//     if (!isset($tels) || $tels=="")
//     {
//         return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(TELESREQUIRED));
//     }
    
    
    
    //Si no se requiere verificar el email obtiene el password
    $reg_verifyemail = pnConfigGetVar('reg_verifyemail');
    if (!$reg_verifyemail) {
        list($pass, $vpass) = pnVarCleanFromInput('pass', 'vpass');
    }
    
    $adminmail = pnConfigGetVar('adminmail');
    $sitename = pnConfigGetVar('sitename');
    $siteurl = pnGetBaseURL();
    $Default_Theme = pnConfigGetVar('Default_Theme');
    $commentlimit = pnConfigGetVar('commentlimit');
    $storynum = pnConfigGetVar('storyhome');
    
    if (!$reg_optitems) {        
        // if we don't show optional items
        // we should set the timezone based on site settings
        // and clear all other optional items
        $timezoneoffset = pnConfigGetVar('timezone_offset');
        $femail = '';
        $url = '';
        $bio = '';
        $user_avatar = 'blank.gif';
        $user_icq = '';
        $user_occ = '';
        $user_from = '';
        $user_intrest = '';
        $user_sig = '';
        $user_aim = '';
        $user_yim = '';
        $user_msnm = '';
        $dynadata = '';
    }
    $minpass = pnConfigGetVar('minpass'); //by class007

    // add vpass and vemail check. by class007
    // TODO: remove it to userCheck() [class007]
    /*if ("$email" != "$vemail") {
        $stop = _EMAILSDIFF;
    }*/
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }
    
    if ((!empty($pass)) && ("$pass" != "$vpass")) {
        $stop = _PASSDIFFERENT;
    } elseif (($pass != "") && (strlen($pass) < $minpass)) {
        $stop = _YOURPASSMUSTBE . " $minpass " . _CHARLONG;
    } elseif (empty($pass) && !$reg_verifyemail) {
        $stop = _PASSWDNEEDED;
    } 
    if (!empty($stop))
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay($stop));
    }
    

    $user_regdate = time();
    if (empty($user_avatar)) $user_avatar = 'blank.gif';
    
    if ($reg_verifyemail) {
		$makepass = makepass(); 
        $cryptpass = md5($makepass);
    } else {
        $makepass = $pass; // for welcome email. [class007]
        $cryptpass = md5($pass);
    }
    $plain_pass=$makepass;
    
    // some additional checks
    if (!empty($femail)) {
    $femail = preg_replace('/[^a-zA-Z0-9_@.-]/', '', $femail);
    }
    if (!empty($url)) {
        if (!eregi("^http://[\-\.0-9a-z]+", $url)) {
            $url = "http://" . $url;
        }
        $url = preg_replace('/[^a-zA-Z0-9_@.&#?;:\/-]/', '', $url);
    }
    // end of additional checks
    $uid = $dbconn->GenId($pntable['users']);
    $column = &$pntable['users_column'];
    $sql = "INSERT INTO $pntable[users] ($column[name], $column[uname], $column[email],
                        $column[femail], $column[url], $column[user_avatar], $column[user_regdate], $column[user_icq],
                        $column[user_occ], $column[user_from], $column[user_intrest], $column[user_sig],
                        $column[user_viewemail], $column[user_theme], $column[user_aim], $column[user_yim],
                        $column[user_msnm], $column[pass], $column[storynum], $column[umode], $column[uorder],
                        $column[thold], $column[noscore], $column[bio], $column[ublockon], $column[ublock],
                        $column[theme], $column[commentmax], $column[counter], $column[timezone_offset])
                        VALUES ('" . pnVarPrepForStore($name) . "','" . pnVarPrepForStore($uname) . "',
                        '" . pnVarPrepForStore($email) . "','" . pnVarPrepForStore($femail) . "',
                        '" . pnVarPrepForStore($url) . "','" . pnVarPrepForStore($user_avatar) . "',
                        '" . pnVarPrepForStore($user_regdate) . "','" . pnVarPrepForStore($user_icq) . "',
                        '" . pnVarPrepForStore($user_occ) . "','" . pnVarPrepForStore($user_from) . "',
                        '" . pnVarPrepForStore($user_intrest) . "','" . pnVarPrepForStore($user_sig) . "',
                        '" . pnVarPrepForStore($user_viewemail) . "','',
                        '" . pnVarPrepForStore($user_aim) . "','" . pnVarPrepForStore($user_yim) . "',
                        '" . pnVarPrepForStore($user_msnm) . "','" . pnVarPrepForStore($cryptpass) . "',
                        '" . pnVarPrepForStore($storynum) . "','',0,0,0,'" . pnVarPrepForStore($bio) . "',0,'','',
                        '" . pnVarPrepForStore($commentlimit) . "', '0', '" . pnVarPrepForStore($timezoneoffset)."')";
                        //error_log($sql);
    $result =& $dbconn->Execute($sql);
    if ($dbconn->ErrorNo() <> 0) {
        $response = $dbconn->ErrorNo() . ': ' . $dbconn->ErrorMsg() . '<br />';
        error_log ($dbconn->ErrorNo() . ': ' . $dbconn->ErrorMsg() . '<br />');
    } else {
        // get the generated id
        $uid = $dbconn->PO_Insert_ID($pntable['users'], $column['uid']);
        // Fix Bug [ #1347 ] New user registration doesn't save user's dynamic data fields
        if (!empty($fixeddynadata) && is_array($fixeddynadata)) {
            while (list($key, $val) = each($fixeddynadata)) {
                SaveDynadata($key, $val, $uid);
            }
        }
        // Let any hooks know that we have created a new item
        pnModCallHooks('item', 'create', $uid, 'uid');
        // Add user to group
        $column = &$pntable['groups_column'];
        $result =& $dbconn->Execute("SELECT $column[gid]
                                    FROM $pntable[groups]
                                    WHERE $column[name]='" . pnModGetVar('Groups', 'defaultgroup') . "'");
        if ($dbconn->ErrorNo() <> 0) {
            $response = $dbconn->ErrorNo() . _GETGROUP . $dbconn->ErrorMsg() . '<br />';
            error_log ($dbconn->ErrorNo() . _GETGROUP . $dbconn->ErrorMsg() . '<br />');
        } else {
            if (!$result->EOF) {
                list($gid) = $result->fields;
                $result->Close();
                $column = &$pntable['group_membership_column'];
                $result =& $dbconn->Execute("INSERT INTO $pntable[group_membership] ($column[gid], $column[uid])
                                            VALUES (" . (int)pnVarPrepForStore($gid) . ", " . (int)pnVarPrepForStore($uid) . ")");
                if ($dbconn->ErrorNo() <> 0) {
                    $response = $dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />';
                    error_log ($dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />');
                }
            }

            //agrega a los otros grupos
            $grupoadmingral = pnModGetVar('AddaxNewUser','grupoadmingral');
            $grupofuncregcatastr = pnModGetVar('AddaxNewUser','grupofuncregcatastr');
            $gruporegente = pnModGetVar('AddaxNewUser','gruporegente');
            $grupos = split(",",$fixeddynadata['_GRUPOSUSUARIO']);
			error_log("eligio grupo $grupo el del regente es $gruporegente");
            foreach ($grupos as $grupo){
                switch($grupo){
                    case '_GRUPOADMINGRAL':$groupid=$grupoadmingral;break;
                    case '_GRUPOFUNCREGCATASTR':$groupid=$grupofuncregcatastr;break;
                    case '_GRUPOREGENTE':$groupid=$gruporegente;break;
                    default: $groupid = -1;
                }
                if ($groupid != -1){
                    $column = &$pntable['group_membership_column'];
                    $result =& $dbconn->Execute("INSERT INTO $pntable[group_membership] ($column[gid], $column[uid])
                                            VALUES (" . (int)pnVarPrepForStore($groupid) . ", " . (int)pnVarPrepForStore($uid) . ")");
                    if ($dbconn->ErrorNo() <> 0) {                    
                        error_log ($dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />');
                    }
                }
            }
            
            //respuesta si todo termina ok
            $response = _YOUAREREGISTERED;
            
        }
    }
    header("Content-Type: text/html; charset=UTF-8" );
    return _AddaxNewUser_returnOK($response);
}   
    
function AddaxNewUser_user_activateUser(){

    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    
    $userid = pnVarCleanFromInput('userid');
    $activar = pnVarCleanFromInput('activar');
    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->assign('uid', $userid);
    $pnRender->assign('activar', $activar);
    return $pnRender->fetch('AddaxNewUser_user_de-activate.htm');
}

function AddaxNewUser_user_deactivate(){
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    list($uid,$dynadata) = pnVarCleanFromInput('uid','dynadata');
    $checkbox_properties = array();
    $fixeddynadata = array();
    if (!empty($dynadata) && is_array($dynadata)) 
    {
        foreach($dynadata as $key=>$value)
        {
            //error_log("Key to analize: $key => $value");
            if(ereg('-', $key))
            {
                if(!empty($value) && isset($value))
                {
                $key_values = split('-', $key);
                if(!isset($fixeddynadata[$key_values[0]]) || empty($fixeddynadata[$key_values[0]]))
                {
                    $fixeddynadata[$key_values[0]] = $key_values[1];
                }
                else
                {
                    $fixeddynadata[$key_values[0]] .= "," . $key_values[1];
                }
                }
            }
            else
            {
                if(!empty($value) && isset($value))
                {
                $fixeddynadata[$key] = $value;
                }
            }
        }
    }
    
     //valida la fecha de desactivacion
    $desacdate = $fixeddynadata['_FECHADESACTIVACION'];
    if (empty($desacdate) || $desacdate =="" || $desacdate==_DATEPICKERMSG){
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(DESACTIVEDAYREQUIRED));
    }
    //Valida el motivo
    $desacmotivo = $fixeddynadata['_MOTIVODESACTIVACION'];
    if (!isset($desacmotivo) || $desacmotivo=="")
    {
        return _AddaxNewUser_returnNOK(pnVarPrepForDisplay(DESACTIVEMOTIVOREQUIRED));
    }
    if (!empty($fixeddynadata) && is_array($fixeddynadata)) {
        while (list($key, $val) = each($fixeddynadata)) {
            //error_log("actualizando: $key con $val a $uid");
            pnUserSetVar($key, $val, (int)pnVarPrepForStore($uid));
        }
    }
    header("Content-Type: text/html; charset=UTF-8" );
    $response = SUCCESSDESACTIVEDUSER;
    $response = str_replace("%fecha%", $desacdate, $response);

    return _AddaxNewUser_returnOK(pnVarPrepForDisplay($response));
}

function AddaxNewUser_user_activate(){
    
    if (!pnSecAuthAction(0, 'AddaxNewUser::', '::', ACCESS_ADMIN)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    $uid= pnVarCleanFromInput('uid');
    
    //error_log("Antes de.. ".pnUserGetVar('_FECHADESACTIVACION',$uid).' '.pnUserGetVar('_MOTIVODESACTIVACION',$uid));
    pnUserSetVar('_FECHADESACTIVACION', "", (int)pnVarPrepForStore($uid));
    pnUserSetVar('_MOTIVODESACTIVACION', "", (int)pnVarPrepForStore($uid));
    //error_log("DEspues de.. ".pnUserGetVar('_FECHADESACTIVACION',$uid).' '.pnUserGetVar('_MOTIVODESACTIVACION',$uid));
    header("Content-Type: text/html; charset=UTF-8" );
    return _AddaxNewUser_returnOK(pnVarPrepForDisplay(SUCCESSACTIVEDUSER));
}
    
function AddaxNewUser_user_searchUsers(){
    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:searchUsers', ACCESS_READ)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }
    if (!(pnModLoad('AddaxQuery','user'))){
        return pnVarPrepHTMLDisplay(ADDAXQUERY_NOTAVAILABLE);
    }

    $searchform = pnModFunc('AddaxQuery', 'user', 'doQueryDBAdmin', array('id'=>1));

    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->assign('searchform', $searchform);
    return $pnRender->fetch('AddaxNewUser_user_searchusers.htm');

    
}

function AddaxNewUser_user_editMyUserInfo(){

    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:editMyUserInfo', ACCESS_EDIT)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }

    //Obtiene el id de usuario
    $uid = pnUserGetVar("uid");

    //Llama a la funcion del despliegue, indicando que los campos estan 
    //habilitados para edicion
    $disabled = false;
    return display_userinfo($uid,$disabled);
}

/**
 * Despliega para edicion la informacion de usuario 
 * @author  kmarcos
 * @param   $id        id del usuario
 * @return  output(pnRender)  Página de resultados
 */
function AddaxNewUser_user_editUserInfo()
{
    // Create output object
    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->caching = false;
    
    // Security check
    if (!pnSecAuthAction(0, 'AddaxNewUser::', 'user::editUserInfo', ACCESS_EDIT)) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_MODULENOAUTH));
        return $pnRender->fetch('AddaxNewUser_user_main.htm');
    }

    // revisa la autorizacion
    /* if (!pnSecConfirmAuthKey()) {
        $pnRender->assign("message",pnVarPrepHTMLDisplay(_BADAUTHKEY));
        return $pnRender->fetch('AddaxNewUser_user_main.htm');
    }*/
    
    //Obtiene el id de usuario
    $id = pnVarCleanFromInput('opcparam');

    //Llama a la funcion del despliegue, indicando que los campos estan 
    //habilitados para edicion (disabled = false)
    $disabled = false;
    return display_userinfo($id,$disabled, true);
}

/**
 * Obtiene y despliega la informacion de usuario en un formulario 
 * @author  kmarcos
 * @param   $uid        id del usuario
 * @param   $disabled      Si el formulario debe estar activo ono
 * @return  output(pnRender)  Página de resultados
 */
function display_userinfo($uid, $disabled, $adminview = false)
{
    // Create output object
    $pnRender =& new pnRender('AddaxNewUser');
    $pnRender->caching = false;

    $pnRender->assign('uid',$uid);
    $pnRender->assign('adminview',$adminview);
    $pnRender->assign('disabled',$disabled);
    $pnRender->assign('size', 35);
    $pnRender->assign('reg_optitems',pnConfigGetVar('reg_optitems'));
    $pnRender->assign('reg_verifyemail',pnConfigGetVar('reg_verifyemail'));

    // Return the output that has been generated by this function
    return $pnRender->fetch('AddaxNewUser_user_viewuserdata.htm');
}

/**
 * Actualiza la informacion del usuario 
 * @author  kmarcos
 * @param   $uid        id del usuario
 * @return  output(pnRender)  Resultado de la actualizacion
 */
function AddaxNewUser_user_updateUserInfo()
{
    // Security check
    if (!pnSecAuthAction(0, 'AddaxNewUser::', ':user:editMyUserInfo', ACCESS_EDIT)) {
        return pnVarPrepHTMLDisplay(_MODULENOAUTH);
    }    
    
    $pnRender =& new pnRender('AddaxNewUser');
        
    //Obtiene el id de usuario
    $uid = pnVarCleanFromInput('uid');

    //Obtiene el tipo de browser
    global $browser;
    $browser = pnVarCleanFromInput('browsername');

    //Actualiza los datos del usuario
    $resp = pnModAPIFunc ( 'AddaxNewUser',
                           'user',
                           'updateUserInfo',
                           array('uid' => $uid)); 
                           
    if (!$resp) {
        $errormsg = pnSessionGetVar('errormsg');
        pnSessionDelVar('errormsg');
        return _AddaxNewUser_returnNOK($errormsg);
    }
    header("Content-Type: text/html; charset=UTF-8" );
    return _AddaxNewUser_returnOK(pnVarPrepHTMLDisplay(_ANU_UPDATEUSERDATASUCCESSFUL));
}

function userCheck($uname, $email, $agreetoterms)
{
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    $stop = '';
    
    // check for valid email
    $res = pnVarValidate($email, 'email');
    if ($res == false) {
        $stop = _ERRORINVEMAIL;
    }

    // check for valid uname
    $res2 = pnVarValidate($uname, 'uname');
    if ($res2 == false) {
        $stop = _EMAIL2LONG; /*<ADDAX> antes _NICK2LONG */
    }

    // check for some e-mail domains.
    list($foo, $maildomain) = split('@', $email);
    $maildomain = strtolower($maildomain);
    // get the list of banned domains
    $domains = pnConfigGetVar('reg_Illegaldomains');
    // fix any text formatting and convert to an array
    $domains = str_replace(', ', ',', $domains);
    $checkdomains = explode(',', $domains);
    // check if our main domain is amonsgt the banned list
    if (in_array($maildomain, $checkdomains)) {
       $stop = _EMAILINVALIDDOMAIN;
    }
    
    // check for disallowed useragents (most often PERL scripts)
    $useragent = strtolower(pnServerGetVar('HTTP_USER_AGENT'));
    $illegaluseragents = pnConfigGetVar('reg_Illegaluseragents');
    if (!empty($illegaluseragents)) {
        $disallowed_useragents = str_replace(', ', ',', $illegaluseragents);
        $checkdisallowed_useragents = explode(',', $disallowed_useragents);
        $count = count($checkdisallowed_useragents);
        $pregcondition = "/((";
        for ($i = 0;$i < $count;$i++) {
            if ($i != $count-1) {
                $pregcondition .= $checkdisallowed_useragents[$i] . ")|(";
            } else {
                $pregcondition .= $checkdisallowed_useragents[$i] . "))/iAD";
            }
        }
        if (preg_match($pregcondition, $useragent)) {
            $stop = _USERAGENTINVALID;
        }
    }

    // Check for legal module
    if (pnModAvailable('legal')) {
        // If legal var agreetoterms checkbox not checked, value is 0 and results in error
        if ($agreetoterms == 0) {
            $stop = _ERRORMUSTAGREE;
        }
    }

    // check for valid username
    if (!$uname || stristr($uname,'&') || preg_match("/[[:space:]]/", $uname) || strip_tags($uname) != $uname) {
error_log("UNAME $uname");
        $stop = _ERRORINVNICK;
    }

    // check for forbidden names
    $reg_illegalusername = trim(pnConfigGetVar('reg_Illegalusername'));
    if (!empty($reg_illegalusername)) {
        $usernames = explode(" ", $reg_illegalusername);
        $count = count($usernames);
        $pregcondition = "/((";
        for ($i = 0;$i < $count;$i++) {
            if ($i != $count-1) {
                $pregcondition .= $usernames[$i] . ")|(";
            } else {
                $pregcondition .= $usernames[$i] . "))/iAD";
            }
        }
        if (preg_match($pregcondition, $uname)) {
            $stop = _NAMERESERVED;
        }
    }

    // check if user already exists
    $column = &$pntable['users_column'];
    $existinguser =& $dbconn->Execute("SELECT $column[uname] FROM $pntable[users] WHERE $column[uname]='" . pnVarPrepForStore($uname) . "'");
    if (!$existinguser->EOF) {
        $stop = _EMAILTAKEN; //addax _NICKTAKEN;
    }
    $existinguser->Close();

    // check if email is unique (if wanted)
    if (pnConfigGetVar('reg_uniemail')) {
        $existingemail =& $dbconn->Execute("SELECT $column[email] FROM $pntable[users] WHERE $column[email]='" . pnVarPrepForStore($email) . "'");
        if (!$existingemail->EOF) {
            $stop = _EMAILREGISTERED;
        }
        $existingemail->Close();
    }

    return($stop);
}

function SaveDynadata($name, $value, $uid)
{
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    if (empty($name)) {
        return false;
    }

    if (empty($uid)) {
        return false;
    }

    $propertiestable = $pntable['user_property'];
    $datatable = $pntable['user_data'];
    $propcolumns = &$pntable['user_property_column'];
    $datacolumns = &$pntable['user_data_column'];

    // Confirm that this is a known value
    $query = "SELECT $propcolumns[prop_id],
                     $propcolumns[prop_dtype]
              FROM   $propertiestable
              WHERE  $propcolumns[prop_label] = '" . pnVarPrepForStore($name) ."'";

    //error_log("savedyna sql: $query");
    $result =& $dbconn->Execute($query);

    if ($result->EOF) {
        return false;
    }

    list ($id, $type) = $result->fields;
    // check for existence of the variable in user data
    $query = "SELECT $datacolumns[uda_id]
              FROM   $datatable
              WHERE  $datacolumns[uda_propid] = '" . (int)pnVarPrepForStore($id) ."'
              AND    $datacolumns[uda_uid]    = '" . (int)pnVarPrepForStore($uid) ."'";
    $result =& $dbconn->Execute($query);

    // jgm - this won't work in databases that care about typing
    // but this should get fixed when we move to the dynamic user
    // variables setup
    // TODO: do some checking with $type to maybe do conditional sql
    if ($result->EOF) {
       // record does not exist
       $query = "INSERT INTO $datatable
                            ($datacolumns[uda_propid],
                             $datacolumns[uda_uid],
                             $datacolumns[uda_value])
                 VALUES     ('".(int)pnVarPrepForStore($id)."',
                             '".(int)pnVarPrepForStore($uid)."',
                             '".pnVarPrepForStore($value)."')";

       $dbconn->Execute($query);

        if($dbconn->ErrorNo() != 0) {
            return false;
        }
    } else {
        // existing record
        $query = "UPDATE $datatable
                 SET     $datacolumns[uda_value]  = '" . pnVarPrepForStore($value) . "'
                 WHERE   $datacolumns[uda_propid] = '" . (int)pnVarPrepForStore($id) ."'
                 AND     $datacolumns[uda_uid]    = '" . (int)pnVarPrepForStore($uid) ."'";

        $dbconn->Execute($query);

        if($dbconn->ErrorNo() != 0) {
            return false;
        }
    }

    return true;

}
 
/**
 * Codifica una salida exitosa con JSON (para llamados por ajax)
 *ej: _AddaxNewUser_returnOK(pnVarPrepHTMLDisplay(_AQ_FORMVALIDATEERROR),$docdataval);
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxNewUser_returnOK($message,$data=false)
{
    global $browser;
    $resp = array('status' => _AQ_OK,
                  'message' => $message,
                  'data' => $data);
    if ($browser=="msie 6.0"){
        header("Content-Type: text/html; charset=UTF-8" );
    }
    //error_log('LOG ERROR RESP OK'.json_encode($resp));
    return json_encode($resp);
}

/**
 * Codifica una salida NO exitosa con JSON (para llamados por ajax)
 * ej: _AddaxNewUser_returnNOK(pnVarPrepHTMLDisplay($msg));
 * @param String mensaje de salida
 * @param array arreglo de datos adicionales (opcional)
 * @author kmarcos
 */
function _AddaxNewUser_returnNOK($message,$data=false)
{
    global $browser;
    $resp = array('status' => _AQ_NOK,
                  'message' => $message,
                  'data' => $data);
    if ($browser=="msie 6.0"){
        header("Content-Type: text/html; charset=UTF-8" );
    }
    //error_log('LOG ERROR RESP NOK'.json_encode($resp));
    return json_encode($resp);
}                                                                                                                                                                                                                                    
?>
