<?php
// ======================================================================
// AddaxNewUser by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Modulo: AddaxNewUser
 * Modulo de usuarios
 * 
 * API con las funciones de usuario.
 *
 * @package     PostNuke_Modules
 * @subpackage  AddaxNewUser
 * @author      addax
 * ======================================================================
 */
 
 /**
 * Retorna los campos básicos de información del usuario
 * @author  kmarcos
 * @return  array Propiedades básicas del usuario, cada elemento del arreglo es también un
 *          arreglo con los siguientes indices:
            $prop_id, $prop_label, $prop_dtype, $prop_length, $prop_weight, $prop_validation, $prop_values, $prop_value_cols, $prop_uvalue,
 */
function AddaxNewUser_userapi_getUserBasicData()
{
    // Get datbase setup
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    //Selecciona las propiedades básicas del usuario
    $propertytable = $pntable['user_property'];    
    $propertycolumn = &$pntable['user_property_column'];

    $sql = "SELECT $propertycolumn[prop_id] AS prop_id, $propertycolumn[prop_label] AS prop_label, $propertycolumn[prop_dtype] AS prop_dtype, $propertycolumn[prop_length] AS prop_length, $propertycolumn[prop_weight] AS prop_weight, $propertycolumn[prop_validation] AS prop_validation, $propertycolumn[prop_values] AS prop_values, $propertycolumn[prop_value_cols] AS prop_value_cols
    FROM   $propertytable
    WHERE  $propertycolumn[prop_id] BETWEEN 1 AND 16
    AND    $propertycolumn[prop_weight] !=0 ";
    //error_log($sql);
    
    $result =& $dbconn->Execute($sql);    

    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('errormsg', _ANU_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }
 
    $items = array();
    for (; !$result->EOF; $result->MoveNext()) {
        list( $prop_id, $prop_label, $prop_dtype, $prop_length, $prop_weight, $prop_validation, $prop_values,$prop_value_cols) = $result->fields;
        $items[] = array('prop_id' => $prop_id, 'prop_label' => $prop_label,
                         'prop_dtype'=> $prop_dtype,
                         'prop_length' => $prop_length, 'prop_weight'=> $prop_weight, 
                         'prop_validation' => $prop_validation, 'prop_values' => $prop_values,
                         'prop_value_cols'=> $prop_value_cols);
        //Agrega un nuevo campo de validación de password para desplegarlo en el formulario
        if ($prop_label == '_PASSWORD')
        {
            $items[] = array('prop_id' => $prop_id, 'prop_label' => '_PASSWDAGAIN', 
                             'prop_dtype'=> $prop_dtype, 'prop_length' => $prop_length, 
                             'prop_weight'=> $prop_weight, 'prop_validation' => $prop_validation, 
                             'prop_values' => $prop_values,
                             'prop_value_cols'=> $prop_value_cols);
        }
        //Agrega un nuevo campo de nickname para desplegarlo en el formulario
        if ($prop_label == '_XUREALNAME')
        {
            $items[] = array('prop_id' => $prop_id, 'prop_label' => '_NICKNAME',
                             'prop_dtype'=> $prop_dtype, 'prop_length' => $prop_length, 
                             'prop_weight'=> $prop_weight, 'prop_validation' => $prop_validation, 
                             'prop_values' => $prop_values,
                             'prop_value_cols'=> $prop_value_cols);
        }
    }
    return $items; 
}

 
 /**
 * Retorna los datos adicionales de la información de usuario
 * @author  gustavo
 * @author  kmarcos
 * @param   $labels (opc) Especifica labels particulares a desplegar, si no se indica, se despliegan todos.
 * @return  array   Propiedades
 */
function AddaxNewUser_userapi_getUserAditionalData($labels ='')
{
    // Get datbase setup
    $dbconn =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();

    //Selecciona las propiedades del usuario
    $propertytable = $pntable['user_property'];    
    $propertycolumn = &$pntable['user_property_column'];

    $sql = "SELECT $propertycolumn[prop_id] AS prop_id, $propertycolumn[prop_label] AS prop_label, $propertycolumn[prop_dtype] AS prop_dtype,   $propertycolumn[prop_length] AS prop_length, $propertycolumn[prop_weight] AS prop_weight, $propertycolumn[prop_validation] AS prop_validation, $propertycolumn[prop_values] AS prop_values, $propertycolumn[prop_value_cols] AS prop_value_cols
    FROM   $propertytable 
    WHERE  $propertycolumn[prop_weight] !=0 ";

    //Si se han especificado propiedades particulares, se restrige la consulta
    if(!empty($labels))
    {
        $sql .= " AND $propertycolumn[prop_label] IN ($labels) ";
    }
    
    //Se ordenan las propiedades por su peso
    $sql .= " ORDER BY " . $propertycolumn['prop_weight'];

    $result =& $dbconn->Execute($sql);
    //error_log($sql);

    // Check for an error with the database code, and if so set an appropriate
    // error message and return
    if ($dbconn->ErrorNo() != 0) {
        pnSessionSetVar('errormsg', _ANU_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }
 
    $items = array();
    for (; !$result->EOF; $result->MoveNext()) {
        list( $prop_id, $prop_label, $prop_dtype, $prop_length, $prop_weight, $prop_validation, $prop_values, $prop_value_cols) = $result->fields;
        $items[] = array('prop_id' => $prop_id, 'prop_label' => $prop_label,
                         'prop_dtype'=> $prop_dtype,
                         'prop_length' => $prop_length, 'prop_weight'=> $prop_weight, 
                         'prop_validation' => $prop_validation, 'prop_values' => $prop_values,
                         'prop_value_cols'=> $prop_value_cols);
    }
    return $items; 
}

/**
 * Actualiza la información del usuario
 * @author  gustavo
 * @return  boolean true (éxito) o false (falla)
 */
function AddaxNewUser_userapi_updateUserInfo()
{

    // NO sirve con AJAX revisa la autorización
//     if (!pnSecConfirmAuthKey()) {
//         pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_BADAUTHKEY));
//         return false;
//     }

    //Obtiene los valores de las propiedades del usuario
    list($uid,
        $uname,
        $name,
        $activated,
//         $url,
        $pass,
        $vpass,
        $email,
//         $femail,
//         $user_icq,
//         $user_aim,
//         $user_yim,
//         $user_msnm,
//         $user_from,
//         $user_occ,
//         $user_intrest,
//         $user_viewemail,
//         $user_sig,
//         $avatar,
//         $bio,
//         $access_permissions,
        $dynadata, $adminview) = pnVarCleanFromInput('uid',
        'uname',
        'realname',
        'activated',
//         'url',
        'pass',
        'vpass',
        'email',
//         'femail',
//         'user_icq',
//         'user_aim',
//         'user_yim',
//         'user_msnm',
//         'user_from',
//         'user_occ',
//         'user_intrest',
//         'user_viewemail',
//         'user_sig',
//         'user_avatar',
//         'bio',
//         'access_permissions',
        'dynadata','adminview');//ADDAX
	
    //Look for CHECKBOX VALUE HACK AND PROCESS IT TO CONFORM WITH POSTNUKE REGULAR DYNAMIC DATA
    $checkbox_properties = array();
    $fixeddynadata = array();
    if (!empty($dynadata) && is_array($dynadata)) 
    {
	foreach($dynadata as $key=>$value)
	{
	   //error_log("Key to analize: $key => $value");
	   if(ereg('-', $key))
	   {
		if(!empty($value) && isset($value))
		{
		  $key_values = split('-', $key);
		  if(!isset($fixeddynadata[$key_values[0]]) || empty($fixeddynadata[$key_values[0]]))
		  {
		      $fixeddynadata[$key_values[0]] = $key_values[1];
		  }
		  else
		  {
		      $fixeddynadata[$key_values[0]] .= "," . $key_values[1];
		  }
		}
	   }
	   else
	   {
		if(!empty($value) && isset($value))
		{
		  $fixeddynadata[$key] = $value;
		}
	   }
	}
    }
    
    $dbconn  =& pnDBGetConn(true);
    $pntable =& pnDBGetTables();
    $column = &$pntable['users_column'];
    $column = &$pntable['users_column'];

    //Valida el nombre
    if (!isset($name) || $name=="")
    {
        pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(REALNAMEREQUIRED));
        return false;
    }

        
    if (empty($user_viewemail)) {
        $user_viewemail = 1; //Como no se utiliza el fake email, por lo tanto se obliga a que se vea el email
    }    

    //Valida el correo si es diferente al anterior
    $old_email = pnUserGetVar('email', $uid);

    if ($old_email != $email){
        if (!isset($email) || $email=="")
        {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(CORRECTEMAIL));
            return false;
        }
        // check for valid email
        $res = pnVarValidate($email, 'email');
        if ($res == false) {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_ERRORINVEMAIL));
            return false;
        }
        // check for some e-mail domains.
        list($foo, $maildomain) = split('@', $email);
        $maildomain = strtolower($maildomain);
        // get the list of banned domains
        $domains = pnConfigGetVar('reg_Illegaldomains');
        // fix any text formatting and convert to an array
        $domains = str_replace(', ', ',', $domains);
        $checkdomains = explode(',', $domains);
        // check if our main domain is amonsgt the banned list
        if (in_array($maildomain, $checkdomains)) {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_EMAILINVALIDDOMAIN));
        }
        // check if email is unique (if wanted)
        if (pnConfigGetVar('reg_uniemail')) {
            $existingemail =& $dbconn->Execute("SELECT $column[email] FROM $pntable[users] WHERE $column[email]='" . pnVarPrepForStore($email) . "'");
            if (!$existingemail->EOF) {
                pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_EMAILREGISTERED));
                return false;
            }
        }
    }
    
    //Si el correo sera el mismo nombre de usuario
    $emailasuser = pnModGetVar('AddaxNewUser', 'emailasuser');
    if (isset($emailasuser) && $emailasuser){
        $uname = $email;
        
        //Valida el username si es diferente    
        if (!isset($uname) || $uname=="")
        {
            pnSessionSetVar('errormsg', pnVarPrepForDisplay(USERNAMEREQUIRED));
            return false;
        }
        $old_uname = pnUserGetVar('_NICKNAME',$uid);
        if ($old_uname != $uname){
            //Valida que sea único
            $sql="SELECT COUNT(*) FROM $pntable[users] WHERE $column[uname]='".mysql_real_escape_string($uname)."' AND $column[uid] <> $uid";
            $result =& $dbconn->Execute($sql);

            if ($dbconn->ErrorNo() <> 0) {
                pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_ANU_DATABASEERROR));
                return false;
            }
            else{
                list($count) = $result->fields;
                $result->Close();
            }

            if ($count>0){
                pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_EMAILTAKEN));
                return false;
            }
        }
    }

    /*else{            
        $result =& $dbconn->Execute("SELECT $column[uname]
                                    FROM   $pntable[users]
                                    WHERE  $column[uid] = '" . (int)pnVarPrepForStore($uid) . "'");    
        if (!$result->EOF) {
            list($old_uname) = $result->fields;
        } else {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_USERNOEXIST));
            return false;        
        }
        $result =& $dbconn->Execute("SELECT $column[uname]
                                    FROM   $pntable[users]
                                    WHERE  $column[uname] = '" . $uname . "'
                                    AND    $column[uid] != '" . (int)pnVarPrepForStore($uid) . "'");        
        if (!$result->EOF) {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_ANU_REPEATEDNICKNAME));
            return false;        
        } 
        
        //     if (!$uname || stristr($uname,'&') || preg_match("/[[:space:]]/", $uname) || 
        //         strip_tags($uname) != $uname) {
        //         pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay(_ERRORINVNICK));
        //         return false;           
        //     }

        // validate uname
        if (!pnVarValidate($uname, 'uname')) {
            $uname=$old_uname;
        }

    }   */           

    // Fix for wrong URL adress
    //     if (!pnVarValidate($url, 'url')) {
    //         $url="";
    //     }
    
    if (!empty($pass)){
        
        $minpass = pnConfigGetVar('minpass'); 

        if ("$pass" != "$vpass") {
            $stop = _PASSDIFFERENT;
        } elseif (($pass != "") && (strlen($pass) < $minpass)) {
            $stop = _YOURPASSMUSTBE . " $minpass " . _CHARLONG;
//         } elseif (empty($pass) ) {
//             $stop = _PASSWDNEEDED;
        } 
        if (!empty($stop))
        {
            pnSessionSetVar('errormsg', pnVarPrepHTMLDisplay($stop));
            return false;
        }
            
			
		/*Cambio mrojas*/	
		 // hash methods array
		$hashmethodsarray = pnModAPIFunc('Users', 'user', 'gethashmethods');

		// make password
		$hash_method = pnModGetVar('Users', 'hash_method');
		$hashmethod = $hashmethodsarray[$hash_method];
		
		$makepass = $pass;
        $cpass = DataUtil::hash($makepass,$hash_method);
			
		/*Fin cambio mrojas*/
		
        ////cambio mrojas-$cpass = md5($pass);
        //$passString = ", $column[plain_pass]='".pnVarPrepForStore($pass)."'";
        $passString .= ", $column[pass]='".pnVarPrepForStore($cpass)."'";
    }
    
    //Valida la direccion

    $updateActivated = "";
	if($adminview){
		$updateActivated = ", $column[activated]='". pnVarPrepForStore($activated). "' ";
	}
    $sql = "UPDATE $pntable[users] SET $column[uname]='". pnVarPrepForStore($name). "',
                                       $column[email]='". pnVarPrepForStore($email). "'".
									   $updateActivated.
                                       $passString.
            "WHERE $column[uid]='". (int)pnVarPrepForStore($uid). "'";
    error_log("UPDATIND SQL $sql");
    $result =& $dbconn->Execute($sql);
    /*$result =& $dbconn->Execute("UPDATE $pntable[users] 
                                 SET   $column[uname]='". pnVarPrepForStore($uname). "',
                                       $column[name]='". pnVarPrepForStore($name). "',
                                       $column[email]='". pnVarPrepForStore($email). "',
                                       $column[femail]='". pnVarPrepForStore($femail). "',
                                       $column[url]='". pnVarPrepForStore($url). "',
                                       $column[user_icq]='". pnVarPrepForStore($user_icq). "',
                                       $column[user_aim]='". pnVarPrepForStore($user_aim). "',
                                       $column[user_yim]='". pnVarPrepForStore($user_yim). "',
                                       $column[user_msnm]='". pnVarPrepForStore($user_msnm). "',
                                       $column[user_from]='". pnVarPrepForStore($user_from). "',
                                       $column[user_occ]='". pnVarPrepForStore($user_occ). "',
                                       $column[user_intrest]='". pnVarPrepForStore($user_intrest). "',
                                       $column[user_viewemail]='".pnVarPrepForStore($user_viewemail)."',
                                       $column[user_avatar]='". pnVarPrepForStore($avatar). "',
                                       $column[user_sig]='". pnVarPrepForStore($user_sig). "',
                                       $column[bio]='". pnVarPrepForStore($bio). "'".
                                       $passString.
                                "WHERE $column[uid]='". (int)pnVarPrepForStore($uid). "'");*/
    
    if ($dbconn->ErrorNo() <> 0) {
        pnSessionSetVar('errormsg', _ANU_DATABASEERROR);
        error_log("DB Error: ".$dbconn->ErrorMsg());
        return false;
    }    
    
    if (!empty($fixeddynadata) && is_array($fixeddynadata)) {
        while (list($key, $val) = each($fixeddynadata)) {
            if ($key == "_GRUPOSUSUARIO") $setgroup = true;
            error_log("actualizando: $key con $val a $uid");
            pnUserSetVar($key, $val, (int)pnVarPrepForStore($uid));
        }
    }
    $auth_editall =  pnSecAuthAction(0, 'AddaxNewUser::', 'admin:editAllInfo:', ACCESS_ADMIN);
    // Si es el usuario administrador el que hace la edición, también se actualizan los grupos
    if ($auth_editall && $adminview){
        if (!$setgroup){
            pnUserSetVar("_GRUPOSUSUARIO", "", (int)pnVarPrepForStore($uid));
        }
    
        //agrega a los otros grupos
        $grupoadmingral = pnModGetVar('AddaxNewUser','grupoadmingral');
        $grupofuncregcatastr = pnModGetVar('AddaxNewUser','grupofuncregcatastr');
		$gruporegente = pnModGetVar('AddaxNewUser','gruporegente');
        $column = &$pntable['group_membership_column'];
        $sqldel = "DELETE FROM $pntable[group_membership] WHERE ($column[uid] = $uid) AND ($column[gid] IN ($grupoadmingral,$grupofuncregcatastr))";
        $result =& $dbconn->Execute($sqldel);
        if ($dbconn->ErrorNo() <> 0) {
            error_log ($dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />');
        }
                
        
        $grupos = split(",",trim($fixeddynadata['_GRUPOSUSUARIO']));
        foreach ($grupos as $grupo){
            switch($grupo){
                case '_GRUPOADMINGRAL':$groupid=$grupoadmingral;break;
                case '_GRUPOFUNCREGCATASTR':$groupid=$grupofuncregcatastr;break;
                case '_GRUPOREGENTE':$groupid=$gruporegente;break;
                default: $groupid = -1;
            }
            if ($groupid != -1){
                //$column = &$pntable['group_membership_column'];
                $sqlins = "INSERT INTO $pntable[group_membership] ($column[gid], $column[uid])
                                        VALUES (" . (int)pnVarPrepForStore($groupid) . ", " . (int)pnVarPrepForStore($uid) . ")";
                $result =& $dbconn->Execute($sqlins);
                if ($dbconn->ErrorNo() <> 0) {
                    error_log ($dbconn->ErrorNo() . _CREATEGROUP . $dbconn->ErrorMsg() . '<br />');
                }
            }
    
        }
    }
    
    return true;
}

function AddaxNewUser_userapi_getUsersDatetime($args)
{
    extract($args);

    if (!isset($date)) {
        return ''; 
    }    
    if (!isset($datetimezone)) {
        $datetimezone='display'; 
    }

    $date_result = $date;
    /* @missing@ Cuando se trabajen las fechas de las cuentas debe validarse este codigo
    $date_result = '';

    //Configura ambiente Zend
    PlayerContests_userapi_configZendEnviroment();    
    Zend_Loader::loadClass('Addax_Fantasy_TZConverter');
    Zend_Loader::loadClass('Zend_Date');

    try{
        
        if ($datetimezone=='local'){
            $dtset = new Addax_Fantasy_TZConverter($date, Addax_Fantasy_TZConverter::GetDefaultLocalServerTimeZone());
        }
        elseif ($datetimezone=='display'){
            $dtset = new Addax_Fantasy_TZConverter($date, Addax_Fantasy_TZConverter::GetDefaultDisplayServerTimeZone());
        }
        elseif ($datetimezone=='storage'){
            $dtset = new Addax_Fantasy_TZConverter($date, Addax_Fantasy_TZConverter::GetDefaultStorageServerTimeZone());
        }
        else{
            $dtset = new Addax_Fantasy_TZConverter($datetime,$datetimezone);
        }
        
        $date_result = $dtset->GetStrLocalTZ();
    }
    catch(Zend_Date_Exception $e){
        return $e->getMessage();
    }*/
    return $date_result;
}

?>
