<?php
// ======================================================================
// Biblio Virtual by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** ===================================================================== 
 * Función de Smarty para desplegar los links del administrador
 *
 * Ejemplo: 
 * <!--[AddaxQueryadminlinks start="[" end="]" seperator="|" class="pn-menuitem-title"]-->
 *
 * @author       kmarcos
 * @param        array       $params      Arreglo que contiente todos los parametros de la función:   
 *                                        $start    Cadena de inicio
 *                                        $end      Cadena de finalización
 *                                        $seperator Separador de los links
 *                                        $class    Clase CSS
 * @param        object      &$smarty     Referencia al objeto Smarty
 * @return       string      Código HTML de despliegue.
 * ======================================================================
 */ 

function smarty_function_AddaxQueryadminlinks($params, &$smarty) 
{
    extract($params); 
    unset($params);

    // valores por defecto
    if (!isset($start)) {
            $start = '[';
    }
    if (!isset($end)) {
            $end = ']';
    }
    if (!isset($seperator)) {
            $seperator = '|';
    }
    if (!isset($class)) {
        $class = 'pn-menuitem-title';
    }

    $adminlinks = "<span class=\"$class\">$start ";
	
    if (pnSecAuthAction(0, 'AddaxQuery::', '::', ACCESS_ADMIN)) {
        $adminlinks .= "<a href=\"" . pnVarPrepHTMLDisplay(pnModURL('AddaxQuery', 'admin', 'modifyconfig')) . "\">" . _AQ_MODIFY_CONFIG . "</a> ";
    }    
    
    if (pnSecAuthAction(0, 'AddaxQuery::', '::', ACCESS_ADMIN)) {
        $adminlinks .= "$seperator <a href=\"" . pnVarPrepHTMLDisplay(pnModURL('AddaxQuery', 'admin', 'view')) . "\">" . _AQ_ADMIN_VIEW . "</a> ";
    }
    
    $adminlinks .= "$end</span>\n";

    return $adminlinks;
}

?>