<?php
// ======================================================================
// AddaxQuery by Addax (C) 2008.
// Todos los derechos estan reservados por Addax.
// ----------------------------------------------------------------------
// For POST-NUKE Content Management System
// Copyright (C) 2002 by the PostNuke Development Team.
// http://www.postnuke.com/
// ======================================================================

/** =====================================================================
 * Moulo: AddaxQuery
 * Consultas y reportes basicos
 * 
 * Activar/desactivar usuario
 *
 * Ejemplo: <!--[activatelink userid=3]-->
 *
 * @package      PostNuke_Modules
 * @subpackage   AddaxQuery
 * @author       kmarcos
 * @param        array  $params  Arreglo que contiente todos los parametros de la funcion:
 *                               $userid    id de usuario
 * @param        object      &$smarty     Referencia al objeto Smarty
 * @return       string      Codigo HTML de despliegue.
 *
 * ======================================================================
 */ 
function smarty_function_activatelink($params, &$smarty) 
{
    extract($params); 
    unset($params);

    // valores por defecto   
    if (!isset($userid) || !is_numeric($userid)) {
        return '';
    }
    
    //Obtiene la fecha de desactivacion
    $fechadesactivacion = pnUserGetVar('_FECHADESACTIVACION',$userid);
    
    if (empty($fechadesactivacion) || $fechadesactivacion == ''){
        $desactivado = false;
        $title = pnVarPrepForDisplay("Desactivar");
    }
    else{
        $todays_date = date("d/m/Y");             
        $today = strtotime($todays_date); 
        $desactivacion = strtotime($fechadesactivacion); 
        if ($desactivacion <= $today) 
        { 
            $desactivado = true; 
            $title = pnVarPrepForDisplay("Activar");
        } else { 
            $desactivado = false; 
            $title = pnVarPrepForDisplay("Desactivar");
        }        
    }
    
    $url = pnModPopupURL('AddaxNewUser','user','activateUser',array('userid'=>$userid,'activar'=>$desactivado));
    
    return " | <a rel='gb_page_center[500,350]' href='$url' title='$title'>$title</a>";
}

?>